/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http;

import java.net.PasswordAuthentication;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.sblim.wbem.http.BASE64Encoder;
import org.sblim.wbem.http.HttpClient;

public class AuthInfo {
    private Boolean proxy;
    private String addr;
    private int port;
    private String protocol;
    private String realm;
    private String scheme;
    private PasswordAuthentication credentials;
    long nc = 1L;
    String cnonce;
    String opaque;
    String algorithm;
    String uri;
    String nonce;
    String qop;
    String A1;
    String response;
    byte[] digest;

    public AuthInfo() {
    }

    public AuthInfo(Boolean proxy, String addr, int port, String protocol, String realm, String scheme) {
        this.addr = addr;
        this.port = port;
        this.protocol = protocol;
        this.realm = realm;
        this.scheme = scheme;
    }

    public void setOpaque(String opaque) {
        this.opaque = opaque;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public String getQop() {
        return this.qop;
    }

    public void setQop(String qop) {
        this.qop = qop;
    }

    public long getNc() {
        return this.nc;
    }

    public void setNc(long nc) {
        this.nc = nc;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setCnonce(String cnonce) {
        this.cnonce = cnonce;
    }

    public String getCnonce() {
        return this.cnonce;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getAlgorith() {
        return this.algorithm;
    }

    public String getA1() {
        return this.A1;
    }

    public void setA1(String A1) {
        this.A1 = A1;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public String getResponse() {
        return this.response;
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public void setCredentials(PasswordAuthentication credentials) {
        this.credentials = credentials;
    }

    public String getAddr() {
        return this.addr;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public PasswordAuthentication getCredentials() {
        return this.credentials;
    }

    public boolean match(Object obj) {
        boolean prot;
        if (obj == null || !(obj instanceof AuthInfo)) {
            return false;
        }
        AuthInfo that = (AuthInfo)obj;
        boolean prxt = this.proxy == null || that.proxy == null ? true : this.proxy.equals(that.proxy);
        boolean prmpt = this.realm == null || that.realm == null ? true : this.realm.equals(that.realm);
        boolean schm = this.scheme == null || that.scheme == null ? true : this.scheme.equals(that.scheme);
        boolean adr = this.addr == null || that.addr == null ? true : this.addr.equals(that.addr);
        boolean bl = prot = this.protocol == null || that.protocol == null ? true : this.protocol.equals(that.protocol);
        boolean prt = this.port <= 0 || that.port <= 0 ? true : this.port == that.port;
        return prmpt && schm && adr && prot && prt;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        String _nc = Long.toHexString(this.nc);
        if (this.scheme.equalsIgnoreCase("Digest")) {
            if (this.realm == null) {
                try {
                    MessageDigest messageDigest = null;
                    messageDigest = MessageDigest.getInstance("MD5");
                    messageDigest.update(HttpClient.getBytes(new String(this.credentials.getPassword()), "ASCII"));
                    String pass = HttpClient.convertToHexString(messageDigest.digest());
                    return "Digest username=" + this.credentials.getUserName() + ", response=" + pass;
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
            }
            result.append(this.scheme);
            result.append(" username=\"");
            result.append(this.credentials.getUserName());
            result.append("\"");
            if (this.realm != null) {
                result.append(", realm=\"");
                result.append(this.realm);
                result.append("\"");
            }
            if (this.nonce != null) {
                result.append(", nonce=\"");
                result.append(this.nonce);
                result.append("\"");
            }
            result.append(", uri=\"");
            result.append(this.uri);
            result.append("\", response=\"");
            result.append(this.response);
            result.append("\"");
            if (this.cnonce != null) {
                result.append(", cnonce=\"");
                result.append(this.cnonce);
                result.append("\"");
            }
            if (this.opaque != null) {
                result.append(", opaque=\"");
                result.append(this.opaque);
                result.append("\"");
            }
            if (this.qop != null) {
                result.append(", qop=");
                result.append(this.qop);
            }
            if (this.nc > -1L) {
                result.append(", nc=");
                result.append("00000000".substring(_nc.length()));
                result.append(_nc);
            }
        } else if (this.scheme.equalsIgnoreCase("Basic")) {
            StringBuffer tmp = new StringBuffer();
            tmp.append(this.credentials.getUserName());
            tmp.append(':');
            tmp.append(this.credentials.getPassword());
            result.append("Basic ");
            String s = BASE64Encoder.encode(HttpClient.getBytes(tmp.toString(), "ASCII"));
            result.append(s);
        }
        return result.toString();
    }
}

