/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http;

import java.io.UnsupportedEncodingException;

public final class BASE64Encoder {
    private static byte[] BASE64_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};

    private BASE64Encoder() {
    }

    public static String encode(byte[] plain) {
        String res;
        short val1;
        int totalEncoded;
        int totalBits = plain.length << 3;
        int remainder = totalBits % 24;
        int size = totalEncoded = totalBits / 24;
        if (remainder > 0) {
            ++size;
        }
        byte[] encoded = new byte[size << 2];
        short highBits = 0;
        short lowBits = 0;
        short byte1 = 0;
        short byte2 = 0;
        short byte3 = 0;
        int dest = 0;
        int source = 0;
        for (int i = 0; i < totalEncoded; ++i) {
            byte1 = (short)(plain[source++] & 0xFF);
            byte2 = (short)(plain[source++] & 0xFF);
            byte3 = (short)(plain[source++] & 0xFF);
            highBits = (short)(byte1 & 3);
            lowBits = (short)(byte2 & 0xF);
            short val12 = (short)(byte1 >> 2);
            short val2 = (short)(byte2 >> 4);
            short val3 = (short)(byte3 >> 6);
            encoded[dest++] = BASE64_ALPHABET[val12];
            encoded[dest++] = BASE64_ALPHABET[val2 | highBits << 4];
            encoded[dest++] = BASE64_ALPHABET[lowBits << 2 | val3];
            encoded[dest++] = BASE64_ALPHABET[byte3 & 0x3F];
        }
        if (remainder == 8) {
            byte1 = (short)(plain[source] & 0xFF);
            highBits = (short)(byte1 & 3);
            val1 = (short)(byte1 >> 2);
            encoded[dest++] = BASE64_ALPHABET[val1];
            encoded[dest++] = BASE64_ALPHABET[highBits << 4];
            encoded[dest++] = 61;
            encoded[dest++] = 61;
        } else if (remainder == 16) {
            byte1 = (short)(plain[source++] & 0xFF);
            byte2 = (short)(plain[source++] & 0xFF);
            highBits = (short)(byte1 & 3);
            lowBits = (short)(byte2 & 0xF);
            val1 = (short)(byte1 >> 2);
            short val2 = (short)(byte2 >> 4);
            encoded[dest++] = BASE64_ALPHABET[val1];
            encoded[dest++] = BASE64_ALPHABET[val2 | highBits << 4];
            encoded[dest++] = BASE64_ALPHABET[lowBits << 2];
            encoded[dest++] = 61;
        }
        try {
            res = new String(encoded, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            try {
                res = new String(encoded, "UTF-8");
            }
            catch (UnsupportedEncodingException e1) {
                res = new String(encoded);
            }
        }
        return res;
    }

    public static void main(String[] args) {
        byte[] bytes = new byte[]{-1, -123, 12, 127};
        System.out.println(BASE64Encoder.encode(bytes));
        try {
            sun.misc.BASE64Encoder encoder = (sun.misc.BASE64Encoder)Class.forName("sun.misc.BASE64Encoder").newInstance();
            System.out.println(encoder.encode(bytes));
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

