/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.PasswordAuthentication;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.sblim.wbem.cim.CIMTransportException;
import org.sblim.wbem.http.AuthInfo;
import org.sblim.wbem.http.AuthorizationHandler;
import org.sblim.wbem.http.Challenge;
import org.sblim.wbem.http.HttpClientMethod;
import org.sblim.wbem.http.HttpClientPool;
import org.sblim.wbem.http.HttpHeader;
import org.sblim.wbem.http.HttpParseException;
import org.sblim.wbem.http.HttpSocketFactory;
import org.sblim.wbem.http.io.ASCIIPrintStream;
import org.sblim.wbem.http.io.BoundedInputStream;
import org.sblim.wbem.http.io.ChunkedInputStream;
import org.sblim.wbem.http.io.KeepAliveInputStream;
import org.sblim.wbem.http.io.PersistentInputStream;
import org.sblim.wbem.util.GlobalProperties;
import sun.io.CharToByteConverter;
import sun.security.action.GetPropertyAction;

public class HttpClient
implements HandshakeCompletedListener {
    private static final String CLASSNAME = "org.sblim.wbem.http.HttpClient";
    String authorizationScheme;
    String authorizationAlgorithm;
    String authorizationRealm;
    String authorizationCNonce;
    String authorizationNonce;
    String authorizationQop;
    String HEntity;
    String authorizationNC = "";
    static String encoding;
    SSLSession session;
    AuthorizationHandler auth_handler;
    Logger logger = GlobalProperties.getLogger();
    boolean useHttp11 = true;
    private String protocol;
    private HttpClientMethod response;
    private String requestMethod = "POST";
    private HttpClientMethod method;
    private Socket socket;
    private InputStream istream;
    private OutputStream ostream;
    private ByteArrayOutputStream serverOutput;
    private InputStream serverInput;
    private HttpHeader requestHeaders = new HttpHeader();
    private HttpHeader responseHeaders = new HttpHeader();
    private boolean reset = true;
    private boolean connected = false;
    private boolean keepAlive = true;
    private URI url;
    private String responseMessage;
    private AuthInfo prevAuthInfo;
    private AuthInfo prevProxy;
    private HttpClientPool httpClientPool = new HttpClientPool();

    private static boolean isASCIISuperset(String charset) throws Exception {
        String asciiSuperSet = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_.!~*'();/?:@&=+$,";
        byte[] abyte0 = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 45, 95, 46, 33, 126, 42, 39, 40, 41, 59, 47, 63, 58, 64, 38, 61, 43, 36, 44};
        CharToByteConverter chartobyteconverter = CharToByteConverter.getConverter((String)charset);
        byte[] convertedArray = chartobyteconverter.convertAll(asciiSuperSet.toCharArray());
        return Arrays.equals(convertedArray, abyte0);
    }

    public HttpClient(URI url, HttpClientPool clientPool, AuthorizationHandler auth_handler) {
        this.url = url;
        this.auth_handler = auth_handler;
        this.httpClientPool = clientPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClient getClient(URI url, HttpClientPool clientPool, AuthorizationHandler auth_handler) {
        HttpClient client = null;
        Logger logger = GlobalProperties.getLogger();
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASSNAME, "getClient(URI, HttpClientPool, AuthorizationHandler)", new Object[]{url, clientPool, auth_handler});
        }
        HttpClientPool httpClientPool = clientPool;
        synchronized (httpClientPool) {
            HostPortPair hpp = new HostPortPair(url);
            int maxConn = GlobalProperties.getConnectionPoolSize();
            if (clientPool.getNumberOfAvailableConnections() > 0) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "[MaxPoolSize:" + maxConn + "] [PoolSize:" + clientPool.getNumberOfAvailableConnections() + "] [ReusingClient: " + hpp + "]");
                }
                client = clientPool.retrieveAvailableConnectionFromPool();
            } else {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "[MaxPoolSize:" + maxConn + "] [PoolSize:" + 0 + "] [New Client: " + hpp + "]");
                }
                if (maxConn < 0 || clientPool.getNumberOfAllConnections() < maxConn) {
                    client = new HttpClient(url, clientPool, auth_handler);
                } else {
                    throw new CIMTransportException("EXT_ERR_UNABLE_TO_CONNECT", "Max connection pool size reached: " + maxConn);
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASSNAME, "getClient(URI, HttpClientPool, AuthorizationHandler)", client);
        }
        return client;
    }

    public void streamFinished() {
        this.streamFinished(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamFinished(boolean keep) {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, "streamFinished(boolean)", new Boolean(keep));
        }
        HostPortPair hpp = new HostPortPair(this.url);
        HttpClientPool httpClientPool = this.httpClientPool;
        synchronized (httpClientPool) {
            boolean addToPool;
            int maxConn = GlobalProperties.getConnectionPoolSize();
            boolean bl = addToPool = maxConn < 0 || this.httpClientPool.getNumberOfAvailableConnections() < maxConn;
            if (keep && addToPool) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "[MaxSize:" + maxConn + "] [PoolSize:" + this.httpClientPool.getNumberOfAvailableConnections() + "] [Adding:  " + hpp + "]");
                }
                this.httpClientPool.returnAvailableConnectionToPool(this);
            } else {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "[MaxSize:" + maxConn + "] [PoolSize:" + this.httpClientPool.getNumberOfAvailableConnections() + "] [disconecting:" + hpp + "]");
                }
                this.httpClientPool.removeConnectionFromPool(this);
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(CLASSNAME, "streamFinished(boolean)");
        }
    }

    public void connect() throws IOException {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, "connect()");
        }
        this.reset = true;
        this.response = null;
        this.connected = true;
        this.serverOutput = null;
        this.resetSocket();
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(CLASSNAME, "connect()");
        }
    }

    public void handshakeCompleted(HandshakeCompletedEvent event) {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, "handshake completed... getting session");
        }
        this.session = event.getSession();
    }

    private void resetSocket() throws IOException {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, "resetSocket()");
        }
        if (!this.keepAlive) {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "KeepAlive=false, closing connection...");
            }
            this.closeConnection();
        }
        if (this.socket == null) {
            SocketFactory factory;
            SecurityManager sm;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "Socket=null, creating socket...");
            }
            if ((sm = System.getSecurityManager()) != null) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "Checking for permisions to connect to:" + this.url.getHost() + ":" + this.url.getPort());
                }
                sm.checkConnect(this.url.getHost(), this.url.getPort());
            }
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "Retrieving socket factory for scheme:" + this.url.getScheme());
            }
            if ((factory = HttpSocketFactory.getInstance().getSocketFactory(this.url.getScheme())) == null) {
                throw new IllegalStateException("Unable to load socket socket factory:" + this.url.getScheme());
            }
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "creating new socket connecting to: " + this.url.getHost() + ":" + this.url.getPort());
            }
            this.socket = factory.createSocket(this.url.getHost(), this.url.getPort());
            if (this.socket instanceof SSLSocket) {
                String[] ciphersuites;
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "Got instance of SSLSocket...");
                }
                SSLSocket sk = (SSLSocket)this.socket;
                String[] protocols = this.parseProperty("https.protocols");
                if (protocols != null) {
                    if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.log(Level.FINER, "Setting SSLSocket.setEnabledProtocols() from \"https.protocols\"=" + new Vector<String>(Arrays.asList(protocols)));
                    }
                    sk.setEnabledProtocols(protocols);
                }
                if ((ciphersuites = this.parseProperty("https.cipherSuites")) != null) {
                    if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.log(Level.FINER, "Setting SSLSocket.setEnableCipheSuites() from \"httpscipherSuites\"=" + new Vector<String>(Arrays.asList(ciphersuites)));
                    }
                    sk.setEnabledCipherSuites(ciphersuites);
                }
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "Starting handshake...");
                }
                sk.addHandshakeCompletedListener(this);
                sk.startHandshake();
            }
            this.socket.setKeepAlive(true);
            int timeout = GlobalProperties.getHttpTimeOut();
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "setting Socket.setSoTimeout(" + timeout + ")");
            }
            this.socket.setSoTimeout(timeout);
            this.istream = new BufferedInputStream(this.socket.getInputStream());
            this.ostream = new ASCIIPrintStream(new BufferedOutputStream(this.socket.getOutputStream(), 1024), false, encoding);
            this.serverInput = null;
        } else if (this.serverInput != null && !(this.serverInput instanceof KeepAliveInputStream)) {
            long total;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "Socket!=null, flushing the stream...");
            }
            long totalBytes = 0L;
            while ((total = (long)this.serverInput.available()) > 0L) {
                this.serverInput.skip(total);
                totalBytes += total;
            }
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "total bytes on the stream=" + totalBytes);
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(CLASSNAME, "resetSocket()");
        }
    }

    private void closeConnection() throws IOException {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, "closeConnection()");
        }
        if (this.socket != null) {
            block5: {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    if (!this.logger.isLoggable(Level.WARNING)) break block5;
                    this.logger.log(Level.WARNING, "Unexpected exception while closing the socket", e);
                }
            }
            this.socket = null;
            this.serverInput = null;
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(CLASSNAME, "closeConnection()");
        }
    }

    public synchronized void disconnect() {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, "disconnect()");
        }
        this.connected = false;
        if (this.socket != null) {
            block5: {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    if (!this.logger.isLoggable(Level.WARNING)) break block5;
                    this.logger.log(Level.WARNING, "Unexpected exception while closing the socket", e);
                }
            }
            this.socket = null;
            this.serverInput = null;
            this.reset = true;
            this.response = null;
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(CLASSNAME, "disconnect()");
        }
    }

    public String getCipherSuite() {
        return null;
    }

    public synchronized String getHeaderField(String name) {
        return this.responseHeaders.getField(name);
    }

    public synchronized String getHeaderFieldKey(int index) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        if (index == 0) {
            return null;
        }
        Iterator iterator = this.responseHeaders.iterator();
        while (iterator.hasNext() && --index >= 0) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (index != 0) continue;
            return entry.getKey().toString();
        }
        return null;
    }

    public synchronized String getHeaderField(int index) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        if (index == 0) {
            return this.response.toString();
        }
        Iterator iterator = this.responseHeaders.iterator();
        while (iterator.hasNext() && --index >= 0) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (index != 0) continue;
            return entry.getValue().toString();
        }
        return null;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.getResponseCode() < 500 && this.response != null && this.serverInput != null) {
            return this.serverInput;
        }
        throw new IOException("Failed to open an input stream from server: HTTPResponse " + this.getResponseCode());
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.serverOutput == null) {
            this.serverOutput = new ByteArrayOutputStream();
        }
        return this.serverOutput;
    }

    public String getRequestProperty(String key) {
        return this.requestHeaders.getField(key);
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public synchronized int getResponseCode() throws IOException {
        block47: {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.entering("org.sblim.wbem.http.HttpClient", "getResponseCode()");
            }
            delayedException /* !! */  = null;
            if (!this.reset || this.response != null) break block47;
            authFailed = false;
            retry = maxRetry = 1;
            do {
                block45: {
                    if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.log(Level.FINER, "Attempting request.. retry counter:" + retry);
                    }
                    this.resetSocket();
                    this.reset = false;
                    try {
                        block46: {
                            out = (ASCIIPrintStream)this.ostream;
                            if (out == null) {
                                throw new IOException("could not open output stream");
                            }
                            file = this.url.getPath();
                            if (file == null || file.length() == 0) {
                                file = "/";
                            }
                            if ((query = this.url.getQuery()) != null) {
                                file = file + '?' + query;
                            }
                            this.method = new HttpClientMethod(this.requestMethod, this.url.getPath(), 1, this.useHttp11 != false ? 1 : 0);
                            if (this.logger.isLoggable(Level.FINER)) {
                                this.logger.log(Level.FINER, "HTTP Operation= " + this.method);
                            }
                            this.method.write(out);
                            this.requestHeaders.addField("Host", this.url.getHost());
                            if (this.serverOutput != null) {
                                this.requestHeaders.addField("Content-length", "" + this.serverOutput.size());
                            } else {
                                this.requestHeaders.addField("Content-length", "0");
                            }
                            this.requestHeaders.addField("Connection", "Keep-alive");
                            if (this.prevAuthInfo != null) {
                                this.requestHeaders.addField("Authorization", this.prevAuthInfo.toString());
                            }
                            if (this.prevProxy != null) {
                                this.requestHeaders.addField("Proxy-authorization", this.prevProxy.toString());
                            }
                            this.requestHeaders.write(out);
                            if (this.logger.isLoggable(Level.FINER)) {
                                this.logger.log(Level.FINER, "HTTP Headers= " + this.requestHeaders);
                            }
                            if (out.checkError() != null) {
                                delayedException /* !! */  = out.checkError();
                                if (this.logger.isLoggable(Level.FINER)) {
                                    this.logger.log(Level.FINER, "Got exception while writting to the output stream", delayedException /* !! */ );
                                }
                                this.socket = null;
                                this.reset = true;
                                break block45;
                            }
                            if (this.serverOutput != null) {
                                this.serverOutput.writeTo(out);
                            }
                            out.flush();
                            if (this.logger.isLoggable(Level.FINER)) {
                                this.logger.log(Level.FINER, "Retrieving response...");
                            }
                            this.response = new HttpClientMethod(this.istream);
                            if (this.logger.isLoggable(Level.FINER)) {
                                this.logger.log(Level.FINER, "HTTP Response= " + this.response);
                            }
                            this.responseMessage = this.response.getResponseMessage();
                            this.responseHeaders = new HttpHeader(this.istream);
                            this.keepAlive = false;
                            if ("Keep-alive".equalsIgnoreCase(this.responseHeaders.getField("Connection")) || this.response.getMajorVersion() == 1 && this.response.getMinorVersion() == 1 || this.responseHeaders.getField("Keep-alive") != null) {
                                this.keepAlive = true;
                            }
                            this.serverInput = new PersistentInputStream(this.istream);
                            keepAliveHdr = this.responseHeaders.getField("Keep-Alive");
                            contentLength = this.responseHeaders.getField("Content-length");
                            length = -1L;
                            try {
                                if (contentLength != null && contentLength.length() > 0) {
                                    length = Long.parseLong(contentLength);
                                }
                            }
                            catch (Exception e) {
                                if (!this.logger.isLoggable(Level.WARNING)) break block46;
                                this.logger.log(Level.WARNING, "exception while parsing the content length of the response", e);
                            }
                        }
                        this.keepAlive = length >= 0L || this.response.getStatus() == 304 || this.response.getStatus() == 204;
                        transferEncoding = this.responseHeaders.getField("Transfer-encoding");
                        if (transferEncoding != null && transferEncoding.toLowerCase().endsWith("chunked")) {
                            this.serverInput = new ChunkedInputStream(this.serverInput);
                            this.keepAlive = true;
                        }
                        this.serverInput = new BoundedInputStream(this.serverInput, length);
                        if (this.logger.isLoggable(Level.FINER)) {
                            this.logger.log(Level.FINER, "KeepAlive", new Boolean(this.keepAlive));
                        }
                        if (this.keepAlive) {
                            this.serverInput = new KeepAliveInputStream(this.serverInput, this);
                            this.httpClientPool.addConnectionToPool(this);
                        }
                        switch (this.response.getStatus()) {
                            case 100: {
                                retry = maxRetry;
                                break;
                            }
                            case 200: {
                                authInfo = this.responseHeaders.getField("Authentication-Info");
                                HttpClient.handleRsp(authInfo, this.prevAuthInfo);
                                authInfo = this.responseHeaders.getField("Authentication-Proxy");
                                HttpClient.handleRsp(authInfo, this.prevProxy);
                                if (this.serverOutput != null) {
                                    this.serverOutput = null;
                                }
                                return 200;
                            }
                            case 401: {
                                authenticate = this.responseHeaders.getField("WWW-Authenticate");
                                try {
                                    this.prevAuthInfo = this.getAuthentication(false, this.prevAuthInfo, authenticate);
                                    if (this.prevAuthInfo != null) {
                                        this.requestHeaders.addField("Authorization", this.prevAuthInfo.toString());
                                    }
                                }
                                catch (NoSuchAlgorithmException e) {
                                    if (!this.logger.isLoggable(Level.SEVERE)) ** GOTO lbl104
                                    this.logger.log(Level.SEVERE, "error unable to find digest algorithm", e);
                                }
lbl104:
                                // 3 sources

                                if (!authFailed) {
                                    authFailed = true;
                                    if (this.logger.isLoggable(Level.INFO)) {
                                        this.logger.log(Level.INFO, "Authorization failed, retring with authorization info..");
                                    }
                                }
                                break;
                            }
                            case 407: {
                                if (this.logger.isLoggable(Level.SEVERE)) {
                                    this.logger.log(Level.SEVERE, "Proxy authentication required, but not supported");
                                }
                                break;
                            }
                            default: {
                                if (!this.keepAlive) {
                                    this.closeConnection();
                                } else {
                                    this.serverInput.close();
                                }
                                return this.response.getStatus();
                            }
                        }
                    }
                    catch (SocketTimeoutException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        if (this.logger.isLoggable(Level.WARNING)) {
                            this.logger.log(Level.WARNING, "exception while connection to server", e);
                        }
                        delayedException /* !! */  = e;
                        this.keepAlive = false;
                        this.reset = true;
                    }
                }
                v0 = ++retry;
                --retry;
            } while (v0 > 0);
        }
        if (this.response != null) {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting("org.sblim.wbem.http.HttpClient", "getResponseCode()", new Integer(this.response.getStatus()));
            }
            return this.response.getStatus();
        }
        throw (IOException)delayedException /* !! */ ;
    }

    public String getResponseMessage() {
        if (this.response != null) {
            return this.response.getResponseMessage();
        }
        return null;
    }

    public boolean usingProxy() {
        return false;
    }

    public void setRequestProperty(String key, String value) {
        this.requestHeaders.addField(key, value);
    }

    public void setRequestMethod(String method) {
        this.requestMethod = method;
    }

    public void reset() {
        this.requestHeaders.clear();
        this.responseHeaders.clear();
        this.response = null;
        this.reset = true;
    }

    protected AuthInfo getAuthentication(boolean proxy, AuthInfo prevAuthInfo, String authenticate) throws HttpParseException, NoSuchAlgorithmException {
        Challenge[] challenges = Challenge.parseChallenge(authenticate);
        prevAuthInfo = null;
        for (int cntr = 0; prevAuthInfo == null && cntr < challenges.length; ++cntr) {
            Challenge challenge = challenges[cntr];
            prevAuthInfo = this.auth_handler.getAuthorizationInfo(proxy ? Boolean.TRUE : Boolean.FALSE, this.url.getHost(), this.url.getPort(), this.url.getScheme(), challenge.getRealm(), challenge.getScheme());
            if (prevAuthInfo == null) continue;
            this.updateAuthenticationInfo(prevAuthInfo, challenge);
            return prevAuthInfo;
        }
        return null;
    }

    protected static void handleRsp(String authInfo, AuthInfo prevAuthInfo) throws IOException {
        if (authInfo != null) {
            HttpHeader params = HttpHeader.parse(authInfo);
            String nonce = params.getField("nextnonce");
            if (nonce != null) {
                prevAuthInfo.setNonce(nonce);
                prevAuthInfo.setNc(0L);
            } else {
                nonce = prevAuthInfo.getNonce();
            }
            String qop = params.getField("qop");
            if (qop != null) {
                if (!"auth".equalsIgnoreCase(qop) && !"auth-int".equalsIgnoreCase(qop)) {
                    throw new IOException("Authentication Digest with integrity check not supported");
                }
                String rspauthStr = HttpClient.dequote(params.getField("rspauth"));
                if (rspauthStr != null) {
                    byte[] rspauth = HttpClient.parseHex(rspauthStr);
                    String cnonce = HttpClient.dequote(params.getField("cnonce"));
                    if (cnonce != null && !cnonce.equals(prevAuthInfo.getCnonce())) {
                        throw new IOException("Digest authentication: Invalid nonce counter");
                    }
                    String ncStr = params.getField("nc");
                    if (ncStr != null) {
                        try {
                            long nc = Long.parseLong(ncStr, 16);
                            if (nc != prevAuthInfo.getNc()) {
                                throw new IOException();
                            }
                        }
                        catch (Exception e) {
                            throw new IOException("Digest authentication: Invalid nonce counter");
                        }
                    }
                    try {
                        MessageDigest md5 = MessageDigest.getInstance("MD5");
                        md5.reset();
                        byte[] bytes = prevAuthInfo.getA1().getBytes("ASCII");
                        md5.update(bytes);
                        String HA1 = HttpClient.convertToHexString(md5.digest());
                        if ("MD5-sess".equalsIgnoreCase(params.getField("algorithm"))) {
                            md5.reset();
                            md5.update((HA1 + ":" + nonce + ":" + cnonce).getBytes("ASCII"));
                            HA1 = HttpClient.convertToHexString(md5.digest());
                        }
                        String HA2 = ":" + prevAuthInfo.getURI();
                        if ("auth-int".equalsIgnoreCase(qop)) {
                            md5.reset();
                            md5.update(new byte[0]);
                            HA2 = HA2 + ":" + HttpClient.convertToHexString(md5.digest());
                        }
                        md5.reset();
                        md5.update(HA2.getBytes("ASCII"));
                        HA2 = HttpClient.convertToHexString(md5.digest());
                        md5.reset();
                        md5.update((HA1 + ":" + nonce + ":" + ncStr + ":" + cnonce + ":" + qop + ":" + HA2).getBytes("ASCII"));
                        String hsh = HttpClient.convertToHexString(md5.digest());
                        byte[] hash = HttpClient.parseHex(hsh);
                        if (!Arrays.equals(hash, rspauth)) {
                            throw new IOException("Digest Authentication failed!");
                        }
                    }
                    catch (NoSuchAlgorithmException e1) {
                        throw new IOException("Unable to validate Authentication response: NoSuchAlgorithmException");
                    }
                }
            }
        }
    }

    protected static String dequote(String str) {
        int len = str.length();
        if (len > 1 && str.charAt(0) == '\"' && str.charAt(len - 1) == '\"') {
            return str.substring(1, len - 1);
        }
        return str;
    }

    protected static byte[] parseHex(String hex) {
        byte[] value = new byte[hex.length() >> 1];
        int n = 0;
        for (int i = 0; i < value.length; ++i) {
            value[i] = (byte)(0xFF & Integer.parseInt(hex.substring(n, n + 1), 16));
            n += 2;
        }
        return value;
    }

    protected static byte[] getBytes(String str, String encoding) {
        byte[] bytes;
        try {
            bytes = str.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            bytes = str.getBytes();
        }
        return bytes;
    }

    protected void updateAuthenticationInfo(AuthInfo prevAuthInfo, Challenge challenge) throws NoSuchAlgorithmException {
        prevAuthInfo.setURI(this.url.getPath());
        HttpHeader params = challenge.getParams();
        String scheme = challenge.getScheme();
        prevAuthInfo.setScheme(challenge.getScheme());
        if (scheme.equalsIgnoreCase("Basic")) {
            return;
        }
        if (scheme.equalsIgnoreCase("Digest")) {
            String algorithm = params.getField("algorithm");
            String opaque = params.getField("opaque");
            String nonce = params.getField("nonce");
            String qop = params.getField("qop");
            String realm = params.getField("realm");
            if (nonce == null) {
                nonce = "";
            }
            prevAuthInfo.setRealm(realm);
            if (algorithm != null) {
                prevAuthInfo.setAlgorithm(algorithm);
            }
            if (opaque != null) {
                prevAuthInfo.setOpaque(opaque);
            }
            if (nonce != null) {
                prevAuthInfo.setNonce(nonce);
            }
            if (qop != null) {
                prevAuthInfo.setQop(qop);
            }
            MessageDigest messageDigest = null;
            messageDigest = MessageDigest.getInstance("MD5");
            if (qop != null || "md5-sess".equalsIgnoreCase(algorithm)) {
                long time = System.currentTimeMillis();
                byte[] b = new byte[]{(byte)(time >> 0 & 0xFFL), (byte)(time >> 8 & 0xFFL), (byte)(time >> 16 & 0xFFL), (byte)(time >> 24 & 0xFFL), (byte)(time >> 32 & 0xFFL), (byte)(time >> 40 & 0xFFL), (byte)(time >> 48 & 0xFFL), (byte)(time >> 56 & 0xFFL)};
                messageDigest.reset();
                messageDigest.update(b);
                String cnonce = HttpClient.convertToHexString(messageDigest.digest());
                prevAuthInfo.setCnonce(cnonce);
            }
            if (qop != null) {
                String[] list_qop = HttpClient.split(qop);
                for (int i = 0; i < list_qop.length; ++i) {
                    if (list_qop[i].equalsIgnoreCase("auth-int")) {
                        qop = "auth-int";
                        break;
                    }
                    if (!list_qop[i].equalsIgnoreCase("auth")) continue;
                    qop = "auth";
                }
                if (qop != null) {
                    prevAuthInfo.setQop(qop);
                }
            }
            String nc = params.getField("nc");
            long challengeNc = 1L;
            if (nc != null) {
                block21: {
                    try {
                        challengeNc = Long.parseLong(nc, 16);
                    }
                    catch (Exception e) {
                        if (!this.logger.isLoggable(Level.WARNING)) break block21;
                        this.logger.log(Level.WARNING, "exception while parsing challenge NC", e);
                    }
                }
                if (prevAuthInfo.getNc() == challengeNc) {
                    prevAuthInfo.setNc(++challengeNc);
                }
            } else {
                challengeNc = 1L;
                prevAuthInfo.setNc(1L);
            }
            messageDigest.reset();
            PasswordAuthentication credentials = prevAuthInfo.getCredentials();
            String A1 = credentials.getUserName() + ":" + prevAuthInfo.getRealm() + ":" + String.valueOf(credentials.getPassword());
            messageDigest.update(HttpClient.getBytes(A1, "ASCII"));
            prevAuthInfo.setA1(A1);
            if ("md5-sess".equalsIgnoreCase(algorithm)) {
                messageDigest.update(HttpClient.getBytes(":" + prevAuthInfo.getNonce() + ":" + prevAuthInfo.getCnonce(), "ASCII"));
            }
            byte[] digest = messageDigest.digest();
            String sessionKey = HttpClient.convertToHexString(digest);
            String method = this.requestMethod;
            String A2 = method + ":" + prevAuthInfo.getURI();
            if ("auth-int".equalsIgnoreCase(qop)) {
                messageDigest.reset();
                messageDigest.update(new byte[0]);
                A2 = A2 + ":" + HttpClient.convertToHexString(messageDigest.digest());
            }
            messageDigest.reset();
            messageDigest.update(HttpClient.getBytes(A2, "ASCII"));
            A2 = HttpClient.convertToHexString(messageDigest.digest());
            messageDigest.reset();
            if (qop == null) {
                messageDigest.update(HttpClient.getBytes(sessionKey + ":" + nonce + ":" + A2, "ASCII"));
            } else {
                String _nc = Long.toHexString(challengeNc);
                messageDigest.update(HttpClient.getBytes(sessionKey + ":" + nonce + ":" + "00000000".substring(_nc.length()) + _nc + ":" + prevAuthInfo.getCnonce() + ":" + qop + ":" + A2, "ASCII"));
            }
            String response = HttpClient.convertToHexString(messageDigest.digest());
            prevAuthInfo.setResponse(response);
        }
    }

    public static String convertToHexString(byte[] digest) {
        char[] hexDigit = "0123456789abcdef".toCharArray();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < digest.length; ++i) {
            byte b = digest[i];
            buf.append(hexDigit[b >> 4 & 0xF]);
            buf.append(hexDigit[b & 0xF]);
        }
        return buf.toString();
    }

    private static String[] split(String line) {
        int end;
        Vector<String> elem = new Vector<String>();
        int start = 0;
        while ((end = line.indexOf(44)) > -1) {
            elem.add(line.substring(start, end));
            start = end + 1;
        }
        if (end < line.length()) {
            elem.add(line.substring(start));
        }
        String[] result = new String[elem.size()];
        elem.toArray(result);
        return result;
    }

    private String[] parseProperty(String propertyName) {
        String[] as;
        String s = (String)AccessController.doPrivileged(new GetProperty(propertyName));
        if (s == null || s.length() == 0) {
            as = null;
        } else {
            Vector<Object> vector = new Vector<Object>();
            StringTokenizer stringtokenizer = new StringTokenizer(s, ",");
            while (stringtokenizer.hasMoreElements()) {
                vector.addElement(stringtokenizer.nextElement());
            }
            as = new String[vector.size()];
            for (int i1 = 0; i1 < as.length; ++i1) {
                as[i1] = (String)vector.elementAt(i1);
            }
        }
        return as;
    }

    public void useHttp11(boolean bool) {
        this.useHttp11 = bool;
    }

    public void finalize() {
        String methodName = "finalize()";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName);
        }
        this.disconnect();
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(CLASSNAME, methodName);
        }
    }

    static {
        try {
            encoding = AccessController.doPrivileged(new GetPropertyAction("file.encoding", "ISO8859_1"));
            if (!HttpClient.isASCIISuperset(encoding)) {
                encoding = "ISO8859_1";
            }
        }
        catch (Exception exception) {
            encoding = "ISO8859_1";
        }
    }

    private class GetProperty
    implements PrivilegedAction {
        String propertyName;

        GetProperty(String propertyName) {
            this.propertyName = propertyName;
        }

        public Object run() {
            return System.getProperty(this.propertyName);
        }
    }

    static class HostPortPair {
        String hostport;

        public HostPortPair(URI url) {
            this.hostport = url.getScheme().toLowerCase() + ':' + url.getHost().toLowerCase() + ':' + url.getPort();
        }

        public String toString() {
            return "HostPortPair=[+" + this.hostport + "]";
        }

        public boolean equals(Object o) {
            if (!(o instanceof HostPortPair)) {
                return false;
            }
            return this.hostport.equals(((HostPortPair)o).hostport);
        }

        public int hashCode() {
            return this.hostport.hashCode();
        }
    }
}

