/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http;

import java.util.Vector;

public class HttpHeaderParser {
    String raw;
    Vector nameValuePair;

    public HttpHeaderParser(String s) {
        this.raw = s;
        this.nameValuePair = new Vector();
        if (this.raw != null) {
            this.raw = this.raw.trim();
            char[] charArray = this.raw.toCharArray();
            int startPosValue = 0;
            int currentPos = 0;
            boolean isName = true;
            boolean withinQuote = false;
            int len = charArray.length;
            String[] nvp = new String[2];
            do {
                char c;
                if ((c = charArray[currentPos]) == '=') {
                    nvp[0] = new String(charArray, startPosValue, currentPos - startPosValue).toLowerCase();
                    isName = false;
                    startPosValue = ++currentPos;
                    continue;
                }
                if (c == '\"') {
                    if (withinQuote) {
                        nvp[1] = new String(charArray, startPosValue, currentPos - startPosValue);
                        this.nameValuePair.add(nvp);
                        nvp = new String[2];
                        withinQuote = false;
                        while (++currentPos < len && (charArray[currentPos] == ' ' || charArray[currentPos] == ',' || charArray[currentPos] == ';')) {
                        }
                        isName = true;
                        startPosValue = currentPos;
                        continue;
                    }
                    withinQuote = true;
                    startPosValue = ++currentPos;
                    continue;
                }
                if (c == ' ' || c == ',' || c == ';') {
                    if (withinQuote) {
                        ++currentPos;
                        continue;
                    }
                    if (isName) {
                        nvp[0] = new String(charArray, startPosValue, currentPos - startPosValue).toLowerCase();
                        this.nameValuePair.add(nvp);
                        nvp = new String[2];
                    } else {
                        nvp[1] = new String(charArray, startPosValue, currentPos - startPosValue);
                        this.nameValuePair.add(nvp);
                        nvp = new String[2];
                    }
                    while (++currentPos < len && (charArray[currentPos] == ' ' || charArray[currentPos] == ',' || charArray[currentPos] == ';')) {
                    }
                    isName = true;
                    startPosValue = currentPos;
                    continue;
                }
                ++currentPos;
            } while (currentPos < len);
            if (--currentPos > startPosValue) {
                if (!isName) {
                    if (charArray[currentPos] == '\"') {
                        nvp[1] = new String(charArray, startPosValue, currentPos - startPosValue);
                        this.nameValuePair.add(nvp);
                        nvp = new String[2];
                    } else {
                        nvp[1] = new String(charArray, startPosValue, currentPos - startPosValue + 1);
                        this.nameValuePair.add(nvp);
                        nvp = new String[2];
                    }
                } else {
                    nvp[0] = new String(charArray, startPosValue, currentPos - startPosValue + 1).toLowerCase();
                }
                this.nameValuePair.add(nvp);
            } else if (currentPos == startPosValue) {
                if (!isName) {
                    if (charArray[currentPos] == '\"') {
                        nvp[1] = String.valueOf(charArray[currentPos - 1]);
                        this.nameValuePair.add(nvp);
                        nvp = new String[2];
                    } else {
                        nvp[1] = String.valueOf(charArray[currentPos]);
                        this.nameValuePair.add(nvp);
                        nvp = new String[2];
                    }
                } else {
                    nvp[0] = String.valueOf(charArray[currentPos]).toLowerCase();
                }
                this.nameValuePair.add(nvp);
            }
        }
    }

    public String findKey(int i) {
        if (i < 0 || i > this.nameValuePair.size()) {
            return null;
        }
        return ((String[])this.nameValuePair.elementAt(i))[0];
    }

    public String findValue(int i) {
        if (i < 0 || i > this.nameValuePair.size()) {
            return null;
        }
        return ((String[])this.nameValuePair.elementAt(i))[1];
    }

    public String findValue(String s) {
        return this.findValue(s, null);
    }

    public String findValue(String name, String defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        name.toLowerCase();
        for (int i = 0; i < this.nameValuePair.size(); ++i) {
            if (((String[])this.nameValuePair.elementAt(i))[0] == null) {
                return defaultValue;
            }
            if (!name.equals(((String[])this.nameValuePair.elementAt(i))[0])) continue;
            return ((String[])this.nameValuePair.elementAt(i))[1];
        }
        return defaultValue;
    }

    public int findInt(String name, int defaultValue) {
        try {
            return Integer.parseInt(this.findValue(name, String.valueOf(defaultValue)));
        }
        catch (Throwable throwable) {
            return defaultValue;
        }
    }

    public String toString() {
        return "raw:" + this.raw;
    }

    public static void main(String[] args) {
        HttpHeaderParser parser = new HttpHeaderParser("a; c=\"8\"");
    }
}

