/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http.io;

import java.io.BufferedWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ASCIIPrintStream
extends FilterOutputStream {
    private static boolean ASCIIPlatform = true;
    private String eol;
    private boolean autoFlush = false;
    private Exception trouble = null;
    private BufferedWriter textOut;
    private OutputStreamWriter charOut;
    private boolean closing = false;

    private ASCIIPrintStream(boolean autoFlush, OutputStream out) {
        super(out);
        if (out == null) {
            throw new NullPointerException("Null output stream");
        }
        this.autoFlush = autoFlush;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ASCIIPlatform = System.getProperty("platform.notASCII", "false").equalsIgnoreCase("false");
                return null;
            }
        });
        this.eol = System.getProperty("line.separator");
    }

    public ASCIIPrintStream(OutputStream outputstream) {
        this(outputstream, false);
        this.init(new OutputStreamWriter(this));
    }

    public ASCIIPrintStream(OutputStream outputstream, boolean autoFlush) {
        this(autoFlush, outputstream);
        this.init(new OutputStreamWriter(this.out));
    }

    public ASCIIPrintStream(OutputStream outputstream, boolean autoFlush, String encoding) {
        this(outputstream, autoFlush);
    }

    private void init(OutputStreamWriter osw) {
        this.charOut = osw;
        this.textOut = new BufferedWriter(osw);
    }

    private void write(String str) {
        int stringLength = str.length();
        char[] charArray = new char[stringLength];
        byte[] asciiArray = new byte[stringLength];
        str.getChars(0, stringLength, charArray, 0);
        for (int i = 0; i < stringLength; ++i) {
            asciiArray[i] = (byte)(charArray[i] >= '\u0100' ? 63 : (byte)charArray[i]);
        }
        this.write(asciiArray, 0, stringLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _write(String s) {
        try {
            ASCIIPrintStream aSCIIPrintStream = this;
            synchronized (aSCIIPrintStream) {
                this.ensureOpen();
                this.textOut.write(s);
                if (this.autoFlush && s.indexOf(10) >= 0) {
                    this.out.flush();
                }
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = x;
        }
    }

    public void print(boolean flag) {
        this.write(flag ? "true" : "false");
    }

    public void print(char c) {
        this.write(String.valueOf(c));
    }

    public void print(int i) {
        this.write(String.valueOf(i));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(char[] ac) {
        this.write(String.valueOf(ac));
    }

    public void print(String s) {
        if (s == null) {
            s = "null";
        }
        this.write(s);
    }

    public void print(Object obj) {
        this.write(String.valueOf(obj));
    }

    public void println() {
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean flag) {
        ASCIIPrintStream aSCIIPrintStream = this;
        synchronized (aSCIIPrintStream) {
            this.print(flag);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char c) {
        ASCIIPrintStream aSCIIPrintStream = this;
        synchronized (aSCIIPrintStream) {
            this.print(c);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int i) {
        ASCIIPrintStream aSCIIPrintStream = this;
        synchronized (aSCIIPrintStream) {
            this.print(i);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long l) {
        ASCIIPrintStream aSCIIPrintStream = this;
        synchronized (aSCIIPrintStream) {
            this.print(l);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float f) {
        ASCIIPrintStream aSCIIPrintStream = this;
        synchronized (aSCIIPrintStream) {
            this.print(f);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double d) {
        ASCIIPrintStream aSCIIPrintStream = this;
        synchronized (aSCIIPrintStream) {
            this.print(d);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] ac) {
        ASCIIPrintStream aSCIIPrintStream = this;
        synchronized (aSCIIPrintStream) {
            this.print(ac);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String s) {
        ASCIIPrintStream aSCIIPrintStream = this;
        synchronized (aSCIIPrintStream) {
            this.print(s);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object obj) {
        ASCIIPrintStream aSCIIPrintStream = this;
        synchronized (aSCIIPrintStream) {
            this.print(obj);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newLine() {
        try {
            ASCIIPrintStream aSCIIPrintStream = this;
            synchronized (aSCIIPrintStream) {
                this.ensureOpen();
                this.textOut.newLine();
                if (this.autoFlush) {
                    this.out.flush();
                }
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(char[] buf) {
        try {
            ASCIIPrintStream aSCIIPrintStream = this;
            synchronized (aSCIIPrintStream) {
                this.ensureOpen();
                this.textOut.write(buf);
                this.textOut.flush();
                this.charOut.flush();
                if (this.autoFlush) {
                    this.out.flush();
                }
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] buf, int off, int len) {
        try {
            ASCIIPrintStream aSCIIPrintStream = this;
            synchronized (aSCIIPrintStream) {
                this.ensureOpen();
                this.out.write(buf, off, len);
                if (this.autoFlush) {
                    this.out.flush();
                }
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) {
        try {
            ASCIIPrintStream aSCIIPrintStream = this;
            synchronized (aSCIIPrintStream) {
                this.ensureOpen();
                this.out.write(b);
                if (b == 10 && this.autoFlush) {
                    this.out.flush();
                }
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = x;
        }
    }

    protected void setError() {
    }

    public Exception checkError() {
        if (this.out != null) {
            this.flush();
        }
        return this.trouble;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ASCIIPrintStream aSCIIPrintStream = this;
        synchronized (aSCIIPrintStream) {
            if (!this.closing) {
                this.closing = true;
                try {
                    this.textOut.close();
                    this.out.close();
                }
                catch (IOException x) {
                    this.trouble = x;
                }
                this.textOut = null;
                this.charOut = null;
                this.out = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        ASCIIPrintStream aSCIIPrintStream = this;
        synchronized (aSCIIPrintStream) {
            try {
                this.ensureOpen();
                this.out.flush();
            }
            catch (IOException x) {
                this.trouble = x;
            }
        }
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }
}

