/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.xml;

import java.util.Hashtable;
import org.w3c.dom.Document;

class CIMMessage {
    protected Document doc;
    protected Hashtable elements;
    protected String cimVersion;
    protected String dtdVersion;
    protected String id;
    protected String protocolVersion;
    protected String method;
    protected boolean isCIMExport = false;
    protected boolean isSimple = false;
    protected boolean isRequest = false;

    protected CIMMessage() {
    }

    public CIMMessage(String cimVersion, String dtdVersion, String method) {
        this.cimVersion = cimVersion;
        this.dtdVersion = dtdVersion;
        this.method = method;
    }

    public String getCIMVersion() {
        return this.cimVersion;
    }

    public String getDTDVersion() {
        return this.dtdVersion;
    }

    public boolean isCIMOperation() {
        return !this.isCIMExport;
    }

    public boolean isCIMExport() {
        return this.isCIMExport;
    }

    public void setMethod(String method) {
        this.method = method;
        this.isCIMExport = method.toUpperCase().endsWith("EXPREQ") || method.toUpperCase().endsWith("EXPRSP");
        this.isRequest = method.toUpperCase().endsWith("REQ");
        this.isSimple = method.toUpperCase().startsWith("SIMPLE");
    }

    public void setCIMVersion(String cimversion) {
        this.cimVersion = cimversion;
    }

    public void setDTDVersion(String dtdversion) {
        this.dtdVersion = dtdversion;
    }

    public void setIsRequest(boolean bool) {
        this.isRequest = bool;
    }

    public String getId() {
        return this.id;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }
}

