/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.compiler.mofc;

import java.io.File;
import java.util.Vector;
import org.wbemservices.wbem.compiler.mofc.BeanGenerator;
import org.wbemservices.wbem.compiler.mofc.BeanGeneratorConstants;
import org.wbemservices.wbem.compiler.mofc.I18N;
import org.wbemservices.wbem.compiler.mofc.JavaDocElement;

class BeanBaseWriter
implements BeanGeneratorConstants {
    private StringBuffer fileHeader = BeanGenerator.getFileHeader();
    private StringBuffer packageStatement = null;
    private JavaDocElement javaDocElement = null;
    private Vector vConstructorDoc = null;
    private Vector vGetCIMOMHandle = null;
    private Vector vSetCIMOMHandle = null;
    private Vector vGetCIMInstance = null;
    private Vector vSetCIMInstance = null;
    private Vector vUpdateDoc = null;
    private Vector vGetPropertyDoc = null;
    private Vector vGetArrayPropertyDoc = null;
    private Vector vGetAssociationPropertyDoc = null;
    private Vector vSetPropertyDoc = null;
    private Vector vSetArrayPropertyDoc = null;
    private Vector vObjPathDoc = null;
    private Vector vGetArrayIndex = null;
    private Vector vBeanKeysDoc = null;
    private Vector vVersionDoc = null;
    private Vector vStringDoc = null;

    public BeanBaseWriter(String beanPackage, File beanDir) {
        this.packageStatement = BeanGenerator.getPackageStatement(beanPackage);
        I18N.setResourceName("org.wbemservices.wbem.compiler.mofc.Compiler");
        this.initJavaDocElements();
        BeanGenerator.writeToFile(new StringBuffer("CIMBean"), this.getCIMBeanInterface(), beanDir);
        BeanGenerator.writeToFile(new StringBuffer("CIMBeanImpl"), this.getCIMBeanImplClass(), beanDir);
    }

    private void initJavaDocElements() {
        this.vConstructorDoc = new Vector(2);
        this.javaDocElement = new JavaDocElement("@param", new StringBuffer("CIMOMHandle"), I18N.loadString("CIMOM_PARAM_DESCRIPTION"));
        this.vConstructorDoc.addElement(this.javaDocElement);
        this.javaDocElement = new JavaDocElement("@param", new StringBuffer("CIMInstance"), I18N.loadString("INSTANCE_PARAM_DESCRIPTION"));
        this.vConstructorDoc.addElement(this.javaDocElement);
        this.vGetCIMOMHandle = new Vector(1);
        this.javaDocElement = new JavaDocElement("@return", new StringBuffer("CIMOMHandle"), I18N.loadString("CIMOM_PARAM_DESCRIPTION"));
        this.vGetCIMOMHandle.addElement(this.javaDocElement);
        this.vSetCIMOMHandle = new Vector(1);
        this.javaDocElement = new JavaDocElement("@param", new StringBuffer("CIMOMHandle"), I18N.loadString("CIMOM_PARAM_DESCRIPTION"));
        this.vSetCIMOMHandle.addElement(this.javaDocElement);
        this.vGetCIMInstance = new Vector(1);
        this.javaDocElement = new JavaDocElement("@return", new StringBuffer("CIMInstance"), I18N.loadString("INSTANCE_PARAM_DESCRIPTION"));
        this.vGetCIMInstance.addElement(this.javaDocElement);
        this.vSetCIMInstance = new Vector(1);
        this.javaDocElement = new JavaDocElement("@param", new StringBuffer("CIMInstance"), I18N.loadString("INSTANCE_PARAM_DESCRIPTION"));
        this.vSetCIMInstance.addElement(this.javaDocElement);
        this.vUpdateDoc = new Vector(2);
        this.javaDocElement = new JavaDocElement("@param", new StringBuffer("String"), I18N.loadString("UPDATE_STRINGPARAM_DESCRIPTION"));
        this.vUpdateDoc.addElement(this.javaDocElement);
        this.javaDocElement = new JavaDocElement("@param", new StringBuffer("Object"), I18N.loadString("UPDATE_OBJECTPARAM_DESCRIPTION"));
        this.vUpdateDoc.addElement(this.javaDocElement);
        this.vGetPropertyDoc = new Vector(2);
        this.javaDocElement = new JavaDocElement("@param", new StringBuffer("String"), I18N.loadString("GETPROPERTY_PARAM_DESCRIPTION"));
        this.vGetPropertyDoc.addElement(this.javaDocElement);
        this.javaDocElement = new JavaDocElement("@return", new StringBuffer("Object"), I18N.loadString("GETPROPERTY_RETURN_DESCRIPTION"));
        this.vGetPropertyDoc.addElement(this.javaDocElement);
        this.vGetArrayPropertyDoc = new Vector(4);
        this.javaDocElement = new JavaDocElement("@param", new StringBuffer("String"), I18N.loadString("ARRAYPROPERTY_STRPARAM_DESCRIPTION"));
        this.vGetArrayPropertyDoc.addElement(this.javaDocElement);
        this.javaDocElement = new JavaDocElement("@param", new StringBuffer("String[]"), I18N.loadString("ARRAYPROPERTY_STRARRPARAM_DESCRIPTION"));
        this.vGetArrayPropertyDoc.addElement(this.javaDocElement);
        this.javaDocElement = new JavaDocElement("@param", new StringBuffer("Object[]"), I18N.loadString("ARRAYPROPERTY_OBJARRPARAM_DESCRIPTION"));
        this.vGetArrayPropertyDoc.addElement(this.javaDocElement);
        this.javaDocElement = new JavaDocElement("@return", new StringBuffer("String[]"), I18N.loadString("GETARRAYPROPERTY_RETURN_DESCRIPTION"));
        this.vGetArrayPropertyDoc.addElement(this.javaDocElement);
        this.vGetAssociationPropertyDoc = new Vector(2);
        this.javaDocElement = new JavaDocElement("@param", new StringBuffer("CIMObjectPath"), I18N.loadString("GETOBJECTPATH_RETURN_DESCRIPTION"));
        this.vGetAssociationPropertyDoc.addElement(this.javaDocElement);
        this.javaDocElement = new JavaDocElement("@param", new StringBuffer("CIMBeanImpl"), I18N.loadString("GETASSOCPROPERTY_BEANPARAM_DESCRIPTION"));
        this.vGetAssociationPropertyDoc.addElement(this.javaDocElement);
        this.vSetPropertyDoc = new Vector(2);
        this.javaDocElement = new JavaDocElement("@param", new StringBuffer("String"), I18N.loadString("SETPROPERTY_STRINGPARAM_DESCRIPTION"));
        this.vSetPropertyDoc.addElement(this.javaDocElement);
        this.javaDocElement = new JavaDocElement("@param", new StringBuffer("Object"), I18N.loadString("SETPROPERTY_OBJECTPARAM_DESCRIPTION"));
        this.vSetPropertyDoc.addElement(this.javaDocElement);
        this.vSetArrayPropertyDoc = new Vector(4);
        this.javaDocElement = new JavaDocElement("@param", new StringBuffer("String"), I18N.loadString("ARRAYPROPERTY_STRPARAM_DESCRIPTION"));
        this.vSetArrayPropertyDoc.addElement(this.javaDocElement);
        this.javaDocElement = new JavaDocElement("@param", new StringBuffer("String[]"), I18N.loadString("ARRAYPROPERTY_STRARRPARAM_DESCRIPTION"));
        this.vSetArrayPropertyDoc.addElement(this.javaDocElement);
        this.javaDocElement = new JavaDocElement("@param", new StringBuffer("Object[]"), I18N.loadString("ARRAYPROPERTY_OBJARRPARAM_DESCRIPTION"));
        this.vSetArrayPropertyDoc.addElement(this.javaDocElement);
        this.javaDocElement = new JavaDocElement("@param", new StringBuffer("String[]"), I18N.loadString("SETARRAYPROPERTY_STRARR_DESCRIPTION"));
        this.vSetArrayPropertyDoc.addElement(this.javaDocElement);
        this.vBeanKeysDoc = new Vector(1);
        this.javaDocElement = new JavaDocElement("@return", new StringBuffer("String[]"), I18N.loadString("KEYS_RETURN_DESCRIPTION"));
        this.vBeanKeysDoc.addElement(this.javaDocElement);
        this.vObjPathDoc = new Vector(1);
        this.javaDocElement = new JavaDocElement("@return", new StringBuffer("CIMObjectPath"), I18N.loadString("GETOBJECTPATH_RETURN_DESCRIPTION"));
        this.vObjPathDoc.addElement(this.javaDocElement);
        this.vGetArrayIndex = new Vector(3);
        this.javaDocElement = new JavaDocElement("@param", new StringBuffer("Object[]"), I18N.loadString("GETARRINDEX_ARRAY_DESCRIPTION"));
        this.vGetArrayIndex.addElement(this.javaDocElement);
        this.javaDocElement = new JavaDocElement("@param", new StringBuffer("Object"), I18N.loadString("GETARRINDEX_OBJ_DESCRIPTION"));
        this.vGetArrayIndex.addElement(this.javaDocElement);
        this.javaDocElement = new JavaDocElement("@return", new StringBuffer("int"), I18N.loadString("GETARRINDEX_RETURN_DESCRIPTION"));
        this.vGetArrayIndex.addElement(this.javaDocElement);
        this.vVersionDoc = new Vector(1);
        this.javaDocElement = new JavaDocElement("@return", new StringBuffer("String"), I18N.loadString("VERSION_RETURN_DESCRIPTION"));
        this.vVersionDoc.addElement(this.javaDocElement);
        this.vStringDoc = new Vector(1);
        this.javaDocElement = new JavaDocElement("@return", new StringBuffer("String"), I18N.loadString("TOSTRING_RETURN_DESCRIPTION"));
        this.vStringDoc.addElement(this.javaDocElement);
    }

    private StringBuffer getCIMBeanInterface() {
        StringBuffer sb = new StringBuffer(this.fileHeader.toString());
        sb.append(this.packageStatement);
        sb.append("import javax.wbem.cim.CIMException;\nimport javax.wbem.client.CIMOMHandle;\nimport javax.wbem.cim.CIMInstance;\n").append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEAN_INTERFACE_JAVADOC"), new StringBuffer(), null, 0));
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("public interface {0}Bean ", "CIM") + "{\n" + "\n", 0));
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEAN_GETCIMOMHANDLE_JAVADOC"), new StringBuffer(), this.vGetCIMOMHandle, 1));
        sb.append(BeanGenerator.getSourceLine("public CIMOMHandle getCIMOMHandle();\n", 1)).append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEAN_SETCIMOMHANDLE_JAVADOC"), new StringBuffer(), this.vSetCIMOMHandle, 1));
        sb.append(BeanGenerator.getSourceLine("public void setCIMOMHandle(CIMOMHandle handle);\n", 1)).append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEAN_GETCIMINSTANCE_JAVADOC"), new StringBuffer(), this.vGetCIMInstance, 1));
        sb.append(BeanGenerator.getSourceLine("public CIMInstance getCIMInstance();\n", 1)).append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEAN_SETCIMINSTANCE_JAVADOC"), new StringBuffer(), this.vSetCIMInstance, 1));
        sb.append(BeanGenerator.getSourceLine("public void setCIMInstance(CIMInstance instance);\n", 1)).append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEAN_UPDATE_JAVADOC"), new StringBuffer(), null, 1));
        sb.append(BeanGenerator.getSourceLine("public void update() throws CIMException;\n", 1)).append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEAN_UPDATE2_JAVADOC"), new StringBuffer(), this.vUpdateDoc, 1));
        sb.append(BeanGenerator.getSourceLine("public void update(String propName, Object value) throws CIMException;\n", 1)).append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEAN_DELETE_JAVADOC"), new StringBuffer(), null, 1));
        sb.append(BeanGenerator.getSourceLine("public void delete() throws CIMException;\n", 1)).append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEAN_GETBEANKEYS_JAVADOC"), new StringBuffer(), this.vVersionDoc, 1));
        sb.append(BeanGenerator.getSourceLine("public String[] getBeanKeys();\n", 1)).append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEAN_GETVERSION_JAVADOC"), new StringBuffer(), this.vBeanKeysDoc, 1));
        sb.append(BeanGenerator.getSourceLine("public String getBeanVersion();\n", 1)).append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEAN_TOSTRING_JAVADOC"), new StringBuffer(), this.vStringDoc, 1));
        sb.append(BeanGenerator.getSourceLine("public String toString();\n", 1)).append("\n");
        sb.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // Interface {0}Bean", "CIM"), 0));
        return sb;
    }

    private StringBuffer getCIMBeanImplClass() {
        StringBuffer sb = new StringBuffer(this.fileHeader.toString());
        sb.append(this.packageStatement);
        sb.append("import java.io.Serializable;\nimport java.util.*;\nimport javax.wbem.client.CIMOMHandle;\nimport javax.wbem.cim.CIMException;\nimport javax.wbem.cim.CIMInstance;\nimport javax.wbem.cim.CIMObjectPath;\nimport javax.wbem.cim.CIMValue;\nimport javax.wbem.client.CIMOMHandle;\n").append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEANIMPL_CLASS_JAVADOC"), new StringBuffer(), null, 0));
        sb.append(BeanGenerator.getSourceLine("public class CIMBeanImpl implements CIMBean, Serializable {\n\n", 0));
        sb.append("    private CIMInstance\tcimInstance = null;\n    private CIMOMHandle\tcimomHandle = null;\n").append("\n");
        String constructorDesc = I18N.loadString("CIMBEANIMPL_DEFAULTCONSTRUCTOR_JAVADOC");
        sb.append(BeanGenerator.getJavaDoc(constructorDesc, new StringBuffer(), null, 1));
        sb.append("    public CIMBeanImpl() {\n\n\tsuper();\n\n    } // constructor\n").append("\n");
        constructorDesc = I18N.loadString("CIMBEANIMPL_FULLCONSTRUCTOR_JAVADOC");
        sb.append(BeanGenerator.getJavaDoc(constructorDesc, new StringBuffer(), this.vConstructorDoc, 1));
        sb.append("    public CIMBeanImpl(CIMOMHandle handle, CIMInstance instance) {\n\n\tsuper();\n\tcimomHandle = handle;\n\tcimInstance = instance;\n\n    } // constructor\n").append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEAN_GETCIMOMHANDLE_JAVADOC"), new StringBuffer(), this.vGetCIMOMHandle, 1));
        sb.append("    public CIMOMHandle getCIMOMHandle() {\n\n\treturn (cimomHandle);\n\n    } // getCIMOMHandle\n").append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEAN_SETCIMOMHANDLE_JAVADOC"), new StringBuffer(), this.vSetCIMOMHandle, 1));
        sb.append("    public void setCIMOMHandle(CIMOMHandle handle) {\n\n\tthis.cimomHandle = handle;\n\n    } // setCIMOMHandle\n").append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEAN_GETCIMINSTANCE_JAVADOC"), new StringBuffer(), this.vGetCIMInstance, 1));
        sb.append("    public CIMInstance getCIMInstance() {\n\n\treturn (cimInstance);\n\n    } // getCIMInstance\n").append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEAN_SETCIMINSTANCE_JAVADOC"), new StringBuffer(), this.vSetCIMInstance, 1));
        sb.append("    public void setCIMInstance(CIMInstance instance) {\n\n\tthis.cimInstance = instance;\n\n    } // setCIMInstance\n").append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEAN_UPDATE_JAVADOC"), new StringBuffer(), null, 1));
        sb.append("    public void update() throws CIMException {\n\n\tcimomHandle.setInstance(getObjectPath(), cimInstance);\n\n} // update\n").append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEAN_UPDATE2_JAVADOC"), new StringBuffer(), this.vUpdateDoc, 1));
        sb.append("    public void update(String propName, Object value) throws CIMException {\n\n\tcimomHandle.setProperty(getObjectPath(), propName, new CIMValue(value));\n\n    } // update\n").append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEAN_DELETE_JAVADOC"), new StringBuffer(), null, 1));
        sb.append("    public void delete() throws CIMException {\n\n\tcimomHandle.deleteInstance(getObjectPath());\n\n    } // delete\n").append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEANIMPL_GETPROPERTY_JAVADOC"), new StringBuffer(), this.vGetPropertyDoc, 1));
        sb.append("    protected Object getProperty(String propName) {\n\n\ttry {\n\n\t    return (cimInstance.getProperty(propName).getValue().getValue());\n\n\t} catch (NullPointerException npe) {\n\t}\n\treturn ((Object)null);\n\n    } // getProperty\n").append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEANIMPL_GETARRAYPROPERTY_JAVADOC"), new StringBuffer(), this.vGetArrayPropertyDoc, 1));
        sb.append("    protected String[] getArrayProperty(String propName, String[] valueArr,\n\tObject[] valueMapArr) {\n\n\tList propList = null;\n\ttry {\n\n\t    propList =\n\t\t((List)cimInstance.getProperty(propName).getValue().getValue());\n\n\t} catch (NullPointerException npe) {\n\t}\n\n\tif (propList != null) {\n\n\t    String[] returnArr;\n\t    returnArr = new String[propList.size()];\n\t    ListIterator listIterator = propList.listIterator();\n\t    int counter = 0;\n\t    while (listIterator.hasNext()) {\n\n\t\treturnArr[counter] = valueArr[getArrayIndex(valueMapArr,\n\t\t    listIterator.next())];\n\t\tcounter++;\n\n\t    }\n\t    return (returnArr);\n\n\t}\n\treturn ((String[])null);\n\n    } // getArrayProperty\n").append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEANIMPL_GETASSOCIATIONPROPERTY_JAVADOC"), new StringBuffer(), this.vGetAssociationPropertyDoc, 1));
        sb.append("    protected void getAssociationProperty(CIMObjectPath cop, CIMBeanImpl\n\tbean) throws CIMException {\n\n\tcop.setNameSpace(\"\");\n\tCIMInstance ci = cimomHandle.getInstance(cop, false, true, true,\n\t    (String[])null);\n\tbean.setCIMInstance(ci);\n\tbean.setCIMOMHandle(cimomHandle);\n\n    } // getAssociationProperty\n").append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEANIMPL_SETPROPERTY_JAVADOC"), new StringBuffer(), this.vSetPropertyDoc, 1));
        sb.append("    protected void setProperty(String propName, Object propValue)throws\n\tCIMException {\n\n\tcimInstance.setProperty(propName, new CIMValue(propValue));\n\n    } // setProperty\n").append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEANIMPL_SETARRAYPROPERTY_JAVADOC"), new StringBuffer(), this.vSetArrayPropertyDoc, 1));
        sb.append("    protected void setArrayProperty(String propName, String[] valueArr,\n\tObject[] valueMapArr, String[] propValues) throws CIMException {\n\n\tVector vPropValue = new Vector(propValues.length);\n\tfor (int i = 0; i < propValues.length; i++) {\n\n\t    vPropValue.addElement(valueMapArr[getArrayIndex(valueArr,\n\t\tpropValues[i])]);\n\n\t}\n\tsetProperty(propName, vPropValue);\n\n    } // setArrayProperty\n").append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEAN_GETBEANKEYS_JAVADOC"), new StringBuffer(), this.vBeanKeysDoc, 1));
        sb.append("    public String[] getBeanKeys() {\n\n\treturn ((String[])null);\n\n    } // getBeanKeys\n").append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEANIMPL_GETOBJPATH_JAVADOC"), new StringBuffer(), this.vObjPathDoc, 1));
        sb.append("    protected CIMObjectPath getObjectPath() {\n\n\tCIMObjectPath cop = new CIMObjectPath(cimInstance.getClassName());\n\tVector vKeys = cimInstance.getKeyValuePairs();\n\tif ((vKeys != null) && (vKeys.size() > 0)) {\n\n\t    cop.setKeys(vKeys);\n\n\t} else {\n\n\t    String[] keyArr = getBeanKeys();\n\t    if (keyArr != null) {\n\n\t\tString keyProperty;\n\t\tfor (int i = 0; i < keyArr.length; i++) {\n\n\t\t    keyProperty = keyArr[i];\n\t\t    cop.addKey(keyProperty,\n\t\t\t(cimInstance.getProperty(keyProperty)).getValue());\n\n\t\t}\n\n\t    }\n\n\t}\n\treturn (cop);\n\n    } // getObjectPath\n").append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEANIMPL_GETARRAYINDEX_JAVADOC"), new StringBuffer(), this.vGetArrayIndex, 1));
        sb.append("    protected int getArrayIndex(Object[] objArr, Object obj) {\n\n\tList arrList = Arrays.asList(objArr);\n\treturn (arrList.indexOf(obj));\n\n    } // getArrayIndex\n").append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEAN_GETVERSION_JAVADOC"), new StringBuffer(), this.vVersionDoc, 1));
        sb.append("    public String getBeanVersion() {\n\n\treturn (\"-1\");\n\n    } // getBeanVersion\n").append("\n");
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("CIMBEAN_TOSTRING_JAVADOC"), new StringBuffer(), this.vStringDoc, 1));
        sb.append("    public String toString() {\n\n\treturn (cimInstance.toString());\n\n    } // toString\n").append("\n");
        sb.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // Class {0}BeanImpl", "CIM"), 0));
        return sb;
    }
}

