/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.compiler.mofc;

import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMParameter;
import javax.wbem.cim.CIMProperty;
import org.wbemservices.wbem.compiler.mofc.BeanGenerator;
import org.wbemservices.wbem.compiler.mofc.BeanGeneratorConstants;
import org.wbemservices.wbem.compiler.mofc.I18N;
import org.wbemservices.wbem.compiler.mofc.JavaDocElement;

class BeanClassWriter
implements BeanGeneratorConstants {
    private CIMClass cimClass = null;
    private String versionStr = null;
    private boolean isAbstractClass = false;
    private Vector vProperties = null;
    private Vector vKeys = null;
    private Vector vMethods = null;
    private String superClass = null;
    private String className = null;
    private static final String invalidChars = "!@#$%^&*(-){[}}+=?/\"'<,>.:;\\| \t";

    public BeanClassWriter(CIMClass cimClass) {
        this.cimClass = cimClass;
        this.vProperties = cimClass.getProperties();
        this.isAbstractClass = BeanGenerator.hasQualifier(cimClass, "Abstract");
        I18N.setResourceName("org.wbemservices.wbem.compiler.mofc.Compiler");
        this.populateClassData();
        this.generateClass();
    }

    private void populateClassData() {
        this.superClass = BeanGenerator.getSuperClass(this.cimClass);
        this.className = BeanGenerator.getClassName(this.cimClass.getName());
        this.vKeys = this.cimClass.getKeys();
        this.vMethods = this.cimClass.getMethods();
    }

    private void generateClass() {
        StringBuffer nameBuffer = new StringBuffer(this.className);
        nameBuffer.append("BeanImpl");
        StringBuffer sb = new StringBuffer();
        sb.append(BeanGenerator.getFileHeader());
        sb.append(BeanGenerator.getPackageStatement());
        sb.append(BeanGenerator.getImportStatements());
        sb.append(this.getClassOpen());
        sb.append(this.getClassVariables());
        sb.append(this.getConstructor());
        if (BeanGenerator.hasQualifier(this.cimClass, "Version")) {
            sb.append(this.getVersionMethod());
        }
        if (BeanGenerator.hasContents(this.vKeys)) {
            sb.append(this.getBeanKeysMethod());
        }
        sb.append(this.getPropertyMethods());
        sb.append(this.getInvokeMethods());
        sb.append(this.getClassClose());
        BeanGenerator.writeToFile(nameBuffer, sb);
    }

    private StringBuffer getClassOpen() {
        StringBuffer sb = new StringBuffer();
        String beanDesc = I18N.loadStringFormat("BEAN_CLASS_JAVADOC", this.className);
        StringBuffer mofDesc = BeanGenerator.getClassDescription(this.cimClass);
        sb.append(BeanGenerator.getJavaDoc(beanDesc, mofDesc, null, 0));
        String formatStr = BeanGenerator.hasQualifier(this.cimClass, "Terminal") ? "public final class {0}BeanImpl extends {1}BeanImpl implements {0}Bean " : "public class {0}BeanImpl extends {1}BeanImpl implements {0}Bean ";
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format(formatStr, this.className, this.superClass) + "{\n" + "\n", 0));
        return sb;
    }

    private StringBuffer getClassVariables() {
        StringBuffer sb = BeanGenerator.getSourceLine("private CIMOMHandle cimomHandle = null;\n", 1);
        sb.append(BeanGenerator.getSourceLine("private CIMInstance cimInstance = null;\n", 1));
        String keysStr = "null";
        if (BeanGenerator.hasContents(this.vKeys)) {
            Enumeration eKeys = this.vKeys.elements();
            keysStr = "{";
            while (eKeys.hasMoreElements()) {
                CIMProperty cimProp = (CIMProperty)eKeys.nextElement();
                keysStr = keysStr + "\"" + cimProp.getName() + "\", ";
            }
            keysStr = keysStr.substring(0, keysStr.lastIndexOf(",")) + "}";
        }
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("private final static String[] keysArr = {0};\n", keysStr), 1));
        if (BeanGenerator.hasQualifier(this.cimClass, "Version")) {
            this.versionStr = BeanGenerator.getQualifier(this.cimClass, "Version");
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("private final String versionStr = \"{0}\";\n", this.versionStr), 1));
        }
        return sb.append("\n");
    }

    private StringBuffer getConstructor() {
        String constructorDesc = I18N.loadStringFormat("BEAN_CONSTRUCTOR_JAVADOC", this.className);
        StringBuffer mofDesc = BeanGenerator.getClassDescription(this.cimClass);
        Vector<JavaDocElement> vJavaDocElements = new Vector<JavaDocElement>(2);
        JavaDocElement javaDocElement = new JavaDocElement("@param", new StringBuffer("CIMOMHandle"), I18N.loadString("CIMOM_PARAM_DESCRIPTION"));
        vJavaDocElements.addElement(javaDocElement);
        javaDocElement = new JavaDocElement("@param", new StringBuffer("CIMInstance"), I18N.loadString("INSTANCE_PARAM_DESCRIPTION"));
        vJavaDocElements.addElement(javaDocElement);
        StringBuffer sb = BeanGenerator.getJavaDoc(constructorDesc, mofDesc, vJavaDocElements, 1);
        String constructorStr = "public {0}BeanImpl(CIMOMHandle handle, CIMInstance instance) ";
        if (this.isAbstractClass) {
            constructorStr = "protected {0}BeanImpl(CIMOMHandle handle, CIMInstance instance) ";
        }
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format(constructorStr, this.className) + "{\n" + "\n", 1));
        sb.append(BeanGenerator.getSourceLine("super(handle, instance);\n", 2)).append("\n");
        sb.append(BeanGenerator.getSourceLine("this.cimomHandle = handle;\n", 2));
        sb.append(BeanGenerator.getSourceLine("this.cimInstance = instance;\n", 2)).append("\n");
        sb.append(BeanGenerator.getSourceLine("} // constructor\n", 1));
        return sb.append("\n");
    }

    private StringBuffer getBeanKeysMethod() {
        String keysMethodDesc = I18N.loadString("BEAN_GETKEYS_JAVADOC");
        Vector<JavaDocElement> vJavaDocElements = new Vector<JavaDocElement>(1);
        JavaDocElement javaDocElement = new JavaDocElement("@return", new StringBuffer("String[]"), I18N.loadString("KEYS_RETURN_DESCRIPTION"));
        vJavaDocElements.addElement(javaDocElement);
        StringBuffer sb = BeanGenerator.getJavaDoc(keysMethodDesc, new StringBuffer(), vJavaDocElements, 1);
        return sb.append("    public String[] getBeanKeys() {\n\n\treturn keysArr;\n\n    } // getBeanKeys\n").append("\n");
    }

    private StringBuffer getVersionMethod() {
        String versionMethodDesc = I18N.loadStringFormat("BEAN_GETVERSION_JAVADOC", this.className);
        Vector<JavaDocElement> vJavaDocElements = new Vector<JavaDocElement>(1);
        JavaDocElement javaDocElement = new JavaDocElement("@return", new StringBuffer("String"), I18N.loadString("VERSION_RETURN_DESCRIPTION"));
        vJavaDocElements.addElement(javaDocElement);
        StringBuffer sb = BeanGenerator.getJavaDoc(versionMethodDesc, new StringBuffer(), vJavaDocElements, 1);
        return sb.append("    public String getBeanVersion() {\n\n\treturn versionStr;\n\n    } // getBeanVersion\n").append("\n");
    }

    private StringBuffer getBeanKeysClass() {
        JavaDocElement javaDocElement;
        CIMProperty cimProp;
        StringBuffer sb = new StringBuffer();
        sb.append(BeanGenerator.getFileHeader());
        sb.append(BeanGenerator.getPackageStatement());
        sb.append(BeanGenerator.getImportStatements());
        String beanKeysClassDesc = I18N.loadStringFormat("BEANKEYS_JAVADOC", this.className);
        sb.append(BeanGenerator.getJavaDoc(beanKeysClassDesc, new StringBuffer(), null, 0));
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("public class {0}BeanKeys implements CIMBeanKeys, Serializable ", this.className) + "{\n" + "\n", 0));
        Enumeration eKeys = this.vKeys.elements();
        while (eKeys.hasMoreElements()) {
            cimProp = (CIMProperty)eKeys.nextElement();
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("private {0} {1} = null;\n", BeanGenerator.getDataType(cimProp.getType()).toString(), BeanGenerator.getParameterName(cimProp.getName())), 1));
        }
        sb.append("\n");
        Vector<JavaDocElement> vJavaDocElements = new Vector<JavaDocElement>(this.vKeys.size());
        this.addPropsToVector(vJavaDocElements, this.vKeys);
        sb.append(BeanGenerator.getJavaDoc(I18N.loadStringFormat("BEANKEYS_CONSTRUCTOR_JAVADOC", this.className), new StringBuffer(), vJavaDocElements, 1));
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("public {0}BeanKeys({1}) ", this.className, this.getBeanKeysParameters()) + "{\n" + "\n", 1));
        sb.append(BeanGenerator.getSourceLine("super();\n", 2));
        eKeys = this.vKeys.elements();
        while (eKeys.hasMoreElements()) {
            cimProp = (CIMProperty)eKeys.nextElement();
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("this.{0} = {0};\n", BeanGenerator.getParameterName(cimProp.getName())), 2));
        }
        sb.append("\n");
        sb.append(BeanGenerator.getSourceLine("} // constructor\n\n", 1));
        eKeys = this.vKeys.elements();
        while (eKeys.hasMoreElements()) {
            cimProp = (CIMProperty)eKeys.nextElement();
            vJavaDocElements.removeAllElements();
            javaDocElement = new JavaDocElement("@return", BeanGenerator.getDataType(cimProp.getType()), I18N.loadString("ACCESSOR_RETURN_DESCRIPTION"));
            vJavaDocElements.addElement(javaDocElement);
            sb.append(BeanGenerator.getJavaDoc(I18N.loadStringFormat("BEANKEYS_ACCESSOR_JAVADOC", cimProp.getName()), new StringBuffer(), vJavaDocElements, 1));
            sb.append(this.getBeanKeysAccessor(cimProp));
        }
        vJavaDocElements.removeAllElements();
        javaDocElement = new JavaDocElement("@return", new StringBuffer("CIMObjectPath"), I18N.loadString("CIMOBJPATH_RETURN_DESCRIPTION"));
        vJavaDocElements.addElement(javaDocElement);
        sb.append(BeanGenerator.getJavaDoc(I18N.loadString("BEANKEYS_CIMOBJPATH_JAVADOC"), new StringBuffer(), vJavaDocElements, 1));
        sb.append(BeanGenerator.getSourceLine("public CIMObjectPath getCIMObjectPath() {\n\n", 1));
        sb.append(BeanGenerator.getSourceLine("Vector vKeys = new Vector()\n;", 2));
        eKeys = this.vKeys.elements();
        while (eKeys.hasMoreElements()) {
            cimProp = (CIMProperty)eKeys.nextElement();
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("vKeys.addElement(new CIMProperty(\"{0}\", new CIMValue({1})));\n", cimProp.getName(), BeanGenerator.getParameterName(cimProp.getName())), 2));
        }
        sb.append("\n");
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("return (new CIMObjectPath(\"{0}\", vKeys));\n", this.className), 2));
        sb.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // get{0}\n", "CIMObjectPath") + "\n", 1));
        sb.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // Class {0}BeanKeys\n", this.className), 0));
        return sb;
    }

    private StringBuffer getClassClose() {
        StringBuffer sb = new StringBuffer("}");
        sb.append(BeanGenerator.format(" // Class {0}BeanImpl", this.className));
        return sb;
    }

    private StringBuffer getPropertyMethods() {
        StringBuffer sb = new StringBuffer();
        if (!BeanGenerator.hasContents(this.vProperties)) {
            return sb;
        }
        Enumeration enumeration = this.vProperties.elements();
        while (enumeration.hasMoreElements()) {
            CIMProperty cimProp = (CIMProperty)enumeration.nextElement();
            sb.append(this.generatePropertyMethods(cimProp));
        }
        return sb.append("\n");
    }

    private StringBuffer generatePropertyMethods(CIMProperty cimProp) {
        StringBuffer tmpBuffer;
        boolean hasConstants = BeanGenerator.hasQualifier(cimProp, "ValueMap") || BeanGenerator.hasQualifier(cimProp, "Values");
        StringBuffer sb = new StringBuffer();
        cimProp.setOriginClass(this.className);
        if (!hasConstants) {
            sb.append(BeanGenerator.getAccessorDoc(cimProp));
            sb.append(this.getAccessor(cimProp));
            sb.append(BeanGenerator.getMutatorDoc(cimProp));
            sb.append(this.getMutator(cimProp));
        }
        if (BeanGenerator.hasContents(tmpBuffer = BeanGenerator.getUnitsDoc(cimProp))) {
            sb.append(tmpBuffer).append(this.getUnits(cimProp));
        }
        if (BeanGenerator.hasContents(tmpBuffer = BeanGenerator.getDisplayNameDoc(cimProp))) {
            sb.append(tmpBuffer).append(this.getDisplayName(cimProp));
        }
        if (hasConstants && !BeanGenerator.hasQualifier(cimProp, "Override")) {
            sb.append(this.getConstants(cimProp));
            sb.append(this.getConstantsMethods(cimProp));
        }
        return sb;
    }

    private StringBuffer getAccessor(CIMProperty cimProp) {
        String propName = BeanGenerator.firstCharUpper(cimProp.getName()).toString();
        StringBuffer dataType = BeanGenerator.getPropertyDataType(cimProp);
        if (BeanGenerator.hasQualifier(cimProp, "Override")) {
            dataType = BeanGenerator.getOverriddenDataType(this.cimClass, cimProp);
        }
        StringBuffer sb = BeanGenerator.getSourceLine(BeanGenerator.format("public {0} get{1}(){2} ", dataType.toString(), propName, BeanGenerator.getExceptions().toString()) + "{\n" + "\n", 1);
        if (BeanGenerator.isArrayType(BeanGenerator.getDataType(cimProp.getType()))) {
            if (dataType.toString().lastIndexOf("[]") > 0) {
                dataType = new StringBuffer(dataType.substring(0, dataType.length() - 2));
            }
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("Vector v = (Vector)getProperty(\"{0}\");\n", propName), 2));
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("{0}[] returnArr = null;\n", dataType.toString()), 2));
            sb.append(BeanGenerator.getSourceLine("if (v != null) {\n\n", 2));
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("returnArr = new {0}[v.size()];\n", dataType.toString()), 3));
            sb.append("\t    Enumeration enum = v.elements();\n\t    int counter = 0;\n\t    while (enum.hasMoreElements()) {\n\n");
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("returnArr[counter] = ({0})enum.nextElement();\n", dataType.toString()), 4));
            sb.append("\t\tcounter++;\n\n\t    }\n\n\t}\n\treturn (returnArr);\n\n");
        } else if (cimProp.isReference()) {
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("{0}Impl beanImpl = new {0}Impl(null, null);\n", dataType.toString()), 2));
            sb.append(BeanGenerator.getSourceLine("try {\n\n", 2));
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("getAssociationProperty((CIMObjectPath)getProperty(\"{0}\"), beanImpl);\n\n", propName), 3));
            sb.append(BeanGenerator.getSourceLine("} catch (CIMException cex) {\n\n", 2));
            sb.append(BeanGenerator.getSourceLine("}\n", 2));
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("return (({0})beanImpl);\n\n", dataType.toString()), 2));
        } else {
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("return ({0})getProperty(\"{1}\");\n", dataType.toString(), propName) + "\n", 2));
        }
        sb.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // get{0}\n", cimProp.getName()), 1));
        return sb.append("\n");
    }

    private StringBuffer getBeanKeysAccessor(CIMProperty cimProp) {
        String propName = BeanGenerator.firstCharUpper(cimProp.getName()).toString();
        StringBuffer sb = BeanGenerator.getSourceLine(BeanGenerator.format("public {0} get{1}() ", BeanGenerator.getDataType(cimProp.getType()).toString(), propName) + "{\n" + "\n", 1);
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("return this.{0};\n", BeanGenerator.getParameterName(propName)) + "\n", 2));
        sb.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // get{0}\n", propName), 1));
        return sb.append("\n");
    }

    private StringBuffer getMutator(CIMProperty cimProp) {
        String propName = BeanGenerator.firstCharUpper(cimProp.getName()).toString();
        String propVar = BeanGenerator.getParameterName(propName);
        StringBuffer dataType = BeanGenerator.getPropertyDataType(cimProp);
        if (BeanGenerator.hasQualifier(cimProp, "Override")) {
            dataType = BeanGenerator.getOverriddenDataType(this.cimClass, cimProp);
        }
        StringBuffer sb = BeanGenerator.getSourceLine(BeanGenerator.format("public void set{0}({1} {2}){3} ", propName, dataType.toString(), propVar, BeanGenerator.getExceptions().toString()) + "{\n" + "\n", 1);
        if (BeanGenerator.isArrayType(BeanGenerator.getDataType(cimProp.getType()))) {
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("Vector v = new Vector({0}.length);\n", propVar), 2));
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("for (int i = 0; i < {0}.length; i++) ", propVar) + "{\n", 2));
            sb.append("\n");
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("v.addElement({0}[i]);\n", propVar) + "\n", 3));
            sb.append(BeanGenerator.getSourceLine("}\n", 2));
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("setProperty(\"{0}\", v);\n", cimProp.getName(), propVar) + "\n", 2));
        } else {
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("setProperty(\"{0}\", {1});\n", cimProp.getName(), propVar) + "\n", 2));
        }
        sb.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // set{0}\n", cimProp.getName()), 1));
        return sb.append("\n");
    }

    private StringBuffer getUnits(CIMProperty cimProp) {
        StringBuffer sb = BeanGenerator.getSourceLine(BeanGenerator.format("public String get{0}Units(){1} ", cimProp.getName(), BeanGenerator.getExceptions().toString()) + "{\n" + "\n", 1);
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("return \"{0}\";\n", BeanGenerator.getQualifier(cimProp, "Units")) + "\n", 2));
        sb.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // get{0}Units\n", cimProp.getName()), 1));
        return sb.append("\n");
    }

    private StringBuffer getDisplayName(CIMProperty cimProp) {
        StringBuffer sb = BeanGenerator.getSourceLine(BeanGenerator.format("public String get{0}DisplayName(){1} ", BeanGenerator.firstCharUpper(cimProp.getName()).toString(), BeanGenerator.getExceptions().toString()) + "{\n" + "\n", 1);
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("return \"{0}\";\n", BeanGenerator.getQualifier(cimProp, "DisplayName")) + "\n", 2));
        sb.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // get{0}DisplayName\n", BeanGenerator.firstCharUpper(cimProp.getName()).toString()), 1));
        return sb.append("\n");
    }

    private StringBuffer getConstants(CIMProperty cimProp) {
        String constantName;
        StringBuffer sb = BeanGenerator.getJavaDoc(I18N.loadStringFormat("PROP_VALUEMAP_CONSTANTS_JAVADOC", cimProp.getName()), new StringBuffer(), null, 1);
        String prefix = cimProp.getName().toUpperCase() + "VALUEMAP_";
        String dataType = BeanGenerator.getPropertyDataType(cimProp).toString();
        Enumeration eConstantNames = BeanGenerator.getConstantNames(cimProp, prefix).elements();
        Enumeration eConstantValues = BeanGenerator.getValueMapConstantValues(cimProp).elements();
        while (eConstantNames.hasMoreElements()) {
            constantName = (String)eConstantNames.nextElement();
            String constantValue = (String)eConstantValues.nextElement();
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("final static {0} {1} = new {0}(\"{2}\");\n", dataType, constantName, constantValue), 1));
        }
        String arrayName = this.getValueMapArrayName(cimProp);
        StringBuffer arrayBuffer = new StringBuffer("{");
        eConstantNames = BeanGenerator.getConstantNames(cimProp, prefix).elements();
        while (eConstantNames.hasMoreElements()) {
            constantName = (String)eConstantNames.nextElement();
            arrayBuffer.append(constantName).append(", ");
        }
        String arrayStr = arrayBuffer.substring(0, arrayBuffer.toString().lastIndexOf(", ")) + "}";
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("private final {0}[] {1} = {2};\n", dataType, arrayName, arrayStr), 1));
        prefix = cimProp.getName().toUpperCase() + "VALUE_";
        arrayName = this.getValuesArrayName(cimProp);
        arrayBuffer = new StringBuffer("{");
        eConstantNames = BeanGenerator.getConstantNames(cimProp, prefix).elements();
        while (eConstantNames.hasMoreElements()) {
            constantName = (String)eConstantNames.nextElement();
            arrayBuffer.append(constantName).append(", ");
        }
        arrayStr = arrayBuffer.substring(0, arrayBuffer.toString().lastIndexOf(", ")) + "}";
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("private final String[] {0} = {1};\n", arrayName, arrayStr), 1));
        return sb.append("\n");
    }

    private StringBuffer getConstants(CIMParameter cimParam, String name) {
        String constantName;
        StringBuffer sb = BeanGenerator.getJavaDoc(I18N.loadStringFormat("PARAM_VALUEMAP_CONSTANTS_JAVADOC", cimParam.getName(), (Object)name), new StringBuffer(), null, 1);
        String prefix = name.toUpperCase() + "_" + cimParam.getName().toUpperCase() + "VALUEMAP_";
        CIMDataType type = cimParam.getType();
        if (type.isArrayType()) {
            type = CIMDataType.getPredefinedType((int)CIMDataType.findSimpleType((int)type.getType()));
        }
        String dataType = BeanGenerator.getDataType(type).toString();
        Enumeration eConstantNames = BeanGenerator.getConstantNames(cimParam, prefix).elements();
        Enumeration eConstantValues = BeanGenerator.getValueMapConstantValues(cimParam).elements();
        while (eConstantNames.hasMoreElements()) {
            constantName = (String)eConstantNames.nextElement();
            String constantValue = (String)eConstantValues.nextElement();
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("final static {0} {1} = new {0}(\"{2}\");\n", dataType, constantName, constantValue), 1));
        }
        String arrayName = this.getValueMapArrayName(cimParam, name);
        StringBuffer arrayBuffer = new StringBuffer("{");
        eConstantNames = BeanGenerator.getConstantNames(cimParam, prefix).elements();
        while (eConstantNames.hasMoreElements()) {
            constantName = (String)eConstantNames.nextElement();
            arrayBuffer.append(constantName).append(", ");
        }
        String arrayStr = arrayBuffer.substring(0, arrayBuffer.toString().lastIndexOf(", ")) + "}";
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("private final {0}[] {1} = {2};\n", dataType, arrayName, arrayStr), 1));
        prefix = name.toUpperCase() + "_" + cimParam.getName().toUpperCase() + "VALUE_";
        arrayName = this.getValuesArrayName(cimParam, name);
        arrayBuffer = new StringBuffer("{");
        eConstantNames = BeanGenerator.getConstantNames(cimParam, prefix).elements();
        while (eConstantNames.hasMoreElements()) {
            constantName = (String)eConstantNames.nextElement();
            arrayBuffer.append(constantName).append(", ");
        }
        arrayStr = arrayBuffer.substring(0, arrayBuffer.toString().lastIndexOf(", ")) + "}";
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("private final String[] {0} = {1};\n", arrayName, arrayStr), 1));
        return sb.append("\n");
    }

    private String getValueMapArrayName(CIMProperty cimProp) {
        String arrayName = BeanGenerator.format("{0}ValueMapArr", BeanGenerator.firstCharLower(cimProp.getName()).toString());
        return arrayName;
    }

    private String getValueMapArrayName(CIMParameter cimParam, String name) {
        String arrayName = BeanGenerator.format("{0}ValueMapArr", BeanGenerator.firstCharLower(name).toString() + "_" + BeanGenerator.firstCharUpper(cimParam.getName()).toString());
        return arrayName;
    }

    private String getValuesArrayName(CIMProperty cimProp) {
        String arrayName = BeanGenerator.format("{0}ValueArr", BeanGenerator.firstCharLower(cimProp.getName()).toString());
        return arrayName;
    }

    private String getValuesArrayName(CIMParameter cimParam, String name) {
        String arrayName = BeanGenerator.format("{0}ValueArr", BeanGenerator.firstCharLower(name).toString() + "_" + BeanGenerator.firstCharUpper(cimParam.getName()).toString());
        return arrayName;
    }

    private StringBuffer getConstantsMethods(CIMProperty cimProp) {
        boolean hasValues = BeanGenerator.hasQualifier(cimProp, "Values") || BeanGenerator.hasQualifier(cimProp, "ValueMap");
        StringBuffer dataType = new StringBuffer("String");
        StringBuffer realType = BeanGenerator.getDataType(cimProp.getType());
        boolean isArrayType = BeanGenerator.isArrayType(realType);
        if (isArrayType) {
            dataType = new StringBuffer("String[]");
        }
        String realDataType = BeanGenerator.getPropertyDataType(cimProp).toString();
        String propName = BeanGenerator.firstCharUpper(cimProp.getName()).toString();
        JavaDocElement javaDocElement = new JavaDocElement("@return", dataType, I18N.loadStringFormat("ACCESSOR_RETURN_DESCRIPTION", propName));
        Vector<JavaDocElement> vJavaDocElements = new Vector<JavaDocElement>(1);
        vJavaDocElements.addElement(javaDocElement);
        StringBuffer sb = BeanGenerator.getJavaDoc(I18N.loadStringFormat("BEAN_ACCESSOR_JAVADOC", this.className, (Object)cimProp.getName()), BeanGenerator.getPropertyDescription(cimProp), vJavaDocElements, 1);
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("public {0} get{1}(){2} ", dataType.toString(), propName, BeanGenerator.getExceptions().toString()), 1));
        sb.append("{\n").append("\n");
        if (isArrayType) {
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("return (getArrayProperty(\"{0}\", {1}, {2}));\n", propName, this.getValuesArrayName(cimProp), this.getValueMapArrayName(cimProp)), 2));
        } else {
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("int index = getArrayIndex({0}, ({1})getProperty(\"{2}\"));\n", this.getValueMapArrayName(cimProp), realDataType, cimProp.getName()), 2));
            sb.append("\tif (index < 0) {\n\n\t    return (null);\n\n\t}\n");
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("return ({0}[index]);\n", this.getValuesArrayName(cimProp)), 2));
        }
        sb.append("\n");
        sb.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // get{0}\n", propName), 1));
        sb.append("\n");
        javaDocElement = new JavaDocElement("@param", dataType, I18N.loadStringFormat("MUTATOR_PARAM_DESCRIPTION", propName));
        vJavaDocElements = new Vector(2);
        vJavaDocElements.addElement(javaDocElement);
        javaDocElement = new JavaDocElement("@exception", new StringBuffer("CIMException"), I18N.loadString("CIMEXCEPTION_DESCRIPTION"));
        vJavaDocElements.addElement(javaDocElement);
        sb.append(BeanGenerator.getJavaDoc(I18N.loadStringFormat("BEAN_MUTATOR_JAVADOC", this.className, (Object)cimProp.getName()), BeanGenerator.getPropertyDescription(cimProp), vJavaDocElements, 1));
        String propVar = BeanGenerator.getParameterName(propName);
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("public void set{0}({1} {2}){3} ", propName, dataType.toString(), propVar, "throws CIMException"), 1));
        sb.append("{\n").append("\n");
        if (isArrayType) {
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("setArrayProperty(\"{0}\", {1}, {2}, {3});\n", propName, this.getValuesArrayName(cimProp), this.getValueMapArrayName(cimProp), propVar), 2));
        } else {
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("int index = getArrayIndex({0}, {1});\n", this.getValuesArrayName(cimProp), propVar), 2));
            sb.append("\tif (index < 0) {\n\n\t    throw new IllegalArgumentException();\n\n\t}\n");
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("setProperty(\"{0}\", {1}[index]);\n", propName, this.getValueMapArrayName(cimProp)), 2));
        }
        sb.append("\n");
        sb.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // set{0}\n", propName), 1));
        sb.append("\n");
        if (hasValues) {
            javaDocElement = new JavaDocElement("@return", new StringBuffer("String[]"), I18N.loadString("VALUESACCESSOR_RETURN_DESCRIPTION"));
            vJavaDocElements = new Vector(1);
            vJavaDocElements.addElement(javaDocElement);
            sb.append(BeanGenerator.getJavaDoc(I18N.loadStringFormat("PROP_VALUES_ACCESSOR_JAVADOC", this.className, (Object)cimProp.getName()), new StringBuffer(), vJavaDocElements, 1));
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("public String[] get{0}Values()", propName) + " " + "{\n" + "\n", 1));
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("return ({0});\n", this.getValuesArrayName(cimProp)), 2));
            sb.append("\n");
            sb.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // get{0}Values\n", propName), 1));
        }
        return sb.append("\n");
    }

    private StringBuffer getConstantsMethod(CIMParameter cimParam, String methodName) {
        StringBuffer sb = new StringBuffer();
        StringBuffer dataType = new StringBuffer("String[]");
        String paramName = BeanGenerator.firstCharUpper(cimParam.getName()).toString();
        String name = BeanGenerator.firstCharUpper(methodName).toString() + "_" + paramName;
        JavaDocElement javaDocElement = new JavaDocElement("@return", dataType, I18N.loadString("VALUESACCESSOR_RETURN_DESCRIPTION"));
        Vector<JavaDocElement> vJavaDocElements = new Vector<JavaDocElement>(1);
        vJavaDocElements.addElement(javaDocElement);
        Object[] objArr = new Object[]{this.className, methodName, paramName};
        sb.append(BeanGenerator.getJavaDoc(I18N.loadStringFormat("PARAM_VALUES_ACCESSOR_JAVADOC", objArr), new StringBuffer(), vJavaDocElements, 1));
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("public String[] get{0}Values()", name) + " " + "{\n" + "\n", 1));
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("return ({0});\n", this.getValuesArrayName(cimParam, methodName)), 2));
        sb.append("\n");
        sb.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // get{0}Values\n", name), 1));
        return sb.append("\n");
    }

    private StringBuffer getInvokeMethods() {
        StringBuffer sb = new StringBuffer();
        if (!BeanGenerator.hasContents(this.vMethods)) {
            return sb;
        }
        Enumeration eMethods = this.vMethods.elements();
        while (eMethods.hasMoreElements()) {
            CIMMethod cimMethod = (CIMMethod)eMethods.nextElement();
            Vector vParams = cimMethod.getParameters();
            if (BeanGenerator.hasContents(vParams)) {
                Enumeration eParams = vParams.elements();
                while (eParams.hasMoreElements()) {
                    CIMParameter cimParam = (CIMParameter)eParams.nextElement();
                    if (!BeanGenerator.hasQualifier(cimParam, "Values") && !BeanGenerator.hasQualifier(cimParam, "ValueMap")) continue;
                    sb.append(this.getConstants(cimParam, cimMethod.getName()));
                    sb.append(this.getConstantsMethod(cimParam, cimMethod.getName()));
                }
            }
            cimMethod.setOriginClass(this.className);
            sb.append(BeanGenerator.getInvokeMethodDoc(cimMethod));
            sb.append(this.getInvokeMethod(cimMethod));
            if (!BeanGenerator.hasOutParameter(cimMethod)) continue;
            sb.append(this.getMethodOutputClass(cimMethod));
        }
        return new StringBuffer(sb.substring(0, sb.length() - 1));
    }

    private StringBuffer getInvokeMethod(CIMMethod cimMethod) {
        StringBuffer sb = new StringBuffer();
        String methodName = cimMethod.getName();
        StringBuffer dataType = BeanGenerator.getDataType(cimMethod.getType());
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("public {0} {1}({2}){3} ", dataType.toString(), methodName, BeanGenerator.getInvokeMethodParams(cimMethod).toString(), BeanGenerator.getInvokeMethodExceptions().toString()) + "{\n" + "\n", 1));
        Object[] inParams = BeanGenerator.getInParameters(cimMethod);
        CIMParameter[] outParams = BeanGenerator.getOutParameters(cimMethod);
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("CIMArgument[] inParams = new CIMArgument[{0}];\n", String.valueOf(inParams.length)), 2));
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("CIMArgument[] outParams = new CIMArgument[{0}];\n", String.valueOf(outParams.length)) + "\n", 2));
        if (BeanGenerator.hasContents(inParams)) {
            for (int i = 0; i < inParams.length; ++i) {
                String paramName;
                Object cimParam = inParams[i];
                boolean hasValues = BeanGenerator.hasQualifier((CIMParameter)cimParam, "Values") || BeanGenerator.hasQualifier((CIMParameter)cimParam, "ValueMap");
                String arg = paramName = BeanGenerator.getParameterName(cimParam.getName());
                if (hasValues) {
                    arg = BeanGenerator.format("{0}[getArrayIndex({1}, {2})]", this.getValueMapArrayName((CIMParameter)cimParam, methodName), this.getValuesArrayName((CIMParameter)cimParam, methodName), paramName);
                }
                sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("inParams[{0}] = new CIMArgument(\"{1}\", new CIMValue({2}));\n", String.valueOf(i), paramName, arg), 2));
            }
            sb.append("\n");
        }
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("CIMValue cv = cimomHandle.invokeMethod(cimInstance.getObjectPath(), \"{0}\", inParams, outParams);", methodName) + "\n", 2));
        if (BeanGenerator.hasContents(BeanGenerator.getOutParameters(cimMethod))) {
            sb.append(BeanGenerator.getSourceLine("if (outParams != null && outParams.length > 0) {\n\n", 2));
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("{0}[0] = ({1})(new {2}({3}));\n", BeanGenerator.getOutputParameterName(cimMethod).toString(), BeanGenerator.getOutputInterfaceName(cimMethod).toString(), BeanGenerator.getOutputClassName(cimMethod).toString(), this.getOutputParameters(cimMethod)) + "\n", 3));
            sb.append(BeanGenerator.getSourceLine("}\n", 2));
        }
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("return ({0})cv.getValue();\n", BeanGenerator.getDataType(cimMethod.getType()).toString()), 2));
        sb.append("\n" + BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // {0}\n", methodName), 1));
        return sb.append("\n").append("\n");
    }

    private StringBuffer getMethodOutputClass(CIMMethod cimMethod) {
        StringBuffer dataType;
        StringBuffer sb = new StringBuffer();
        String className = BeanGenerator.getOutputClassName(cimMethod).toString();
        sb.append(BeanGenerator.getJavaDoc(I18N.loadStringFormat("METHODOUTPUT_CLASS_JAVADOC", cimMethod.getOriginClass(), (Object)cimMethod.getName()), BeanGenerator.getMethodDescription(cimMethod), null, 1));
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("private class {0} implements {1} ", className, BeanGenerator.getOutputInterfaceName(cimMethod).toString()) + "{\n" + "\n", 1));
        Object[] outParams = BeanGenerator.getOutParameters(cimMethod);
        if (BeanGenerator.hasContents(outParams)) {
            for (int i = 0; i < outParams.length; ++i) {
                Object cimParam = outParams[i];
                dataType = BeanGenerator.getDataType(cimParam.getType());
                sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("private {0} {1} = null;\n", dataType.toString(), BeanGenerator.getParameterName(cimParam.getName())), 2));
            }
            sb.append("\n");
        }
        Vector<JavaDocElement> vJavaDocElements = new Vector<JavaDocElement>(outParams.length);
        this.addParamsToVector(vJavaDocElements, (CIMParameter[])outParams);
        sb.append(BeanGenerator.getJavaDoc(BeanGenerator.format(I18N.loadString("METHODOUTPUT_CONSTRUCTOR_JAVADOC"), className, cimMethod.getOriginClass(), cimMethod.getName()), new StringBuffer(), vJavaDocElements, 2));
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("public {0}({1}) ", className, this.getOutputConstructorParameters(cimMethod)) + "{\n" + "\n", 2));
        sb.append(BeanGenerator.getSourceLine("super();\n", 3));
        for (int i = 0; i < outParams.length; ++i) {
            Object cimParam = outParams[i];
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("this.{0} = {0};\n", BeanGenerator.getParameterName(cimParam.getName())), 3));
        }
        sb.append("\n");
        sb.append(BeanGenerator.getSourceLine("} // constructor\n\n", 2));
        for (int i = 0; i < outParams.length; ++i) {
            Object cimParam = outParams[i];
            String paramName = BeanGenerator.firstCharUpper(cimParam.getName()).toString();
            String paramVar = BeanGenerator.getParameterName(paramName);
            dataType = BeanGenerator.getDataType(cimParam.getType());
            vJavaDocElements.removeAllElements();
            vJavaDocElements.addElement(new JavaDocElement("@return", dataType, I18N.loadStringFormat("ACCESSOR_RETURN_DESCRIPTION", paramName)));
            sb.append(BeanGenerator.getJavaDoc(BeanGenerator.format(I18N.loadString("METHODOUTPUT_ACCESSOR_JAVADOC"), paramName, cimMethod.getOriginClass(), cimMethod.getName()), new StringBuffer(), vJavaDocElements, 2));
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("public {0} get{1}() ", dataType.toString(), paramName) + "{\n" + "\n", 2));
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("return this.{0};\n", paramVar) + "\n", 3));
            sb.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // get{0}\n", paramName) + "\n", 2));
        }
        sb.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // Class {0}\n", className) + "\n", 1));
        return sb.append("\n");
    }

    private String getOutputParameters(CIMMethod cimMethod) {
        String paramStr = "";
        int counter = 0;
        CIMParameter[] outParams = BeanGenerator.getOutParameters(cimMethod);
        for (int i = 0; i < outParams.length; ++i) {
            String formatStr;
            CIMParameter cimParam = outParams[i];
            StringBuffer dataType = BeanGenerator.getDataType(cimParam.getType());
            if (BeanGenerator.isArrayType(dataType)) {
                formatStr = "({0}[])((Vector)(((CIMArgument)(outParams[{1}])).getValue().getValue())).toArray(new {0}[0]), ";
                dataType = new StringBuffer(dataType.substring(0, dataType.toString().indexOf("[]")));
            } else {
                formatStr = "({0})((CIMArgument)(outParams[{1}])).getValue().getValue(), ";
            }
            paramStr = paramStr + BeanGenerator.format(formatStr, dataType.toString(), Integer.toString(counter));
            ++counter;
        }
        return paramStr.substring(0, paramStr.lastIndexOf(","));
    }

    private String getOutputConstructorParameters(CIMMethod cimMethod) {
        String paramStr = "";
        CIMParameter[] outParams = BeanGenerator.getOutParameters(cimMethod);
        for (int i = 0; i < outParams.length; ++i) {
            CIMParameter cimParam = outParams[i];
            StringBuffer dataType = BeanGenerator.getDataType(cimParam.getType());
            paramStr = paramStr + BeanGenerator.format("{0} {1}, ", dataType.toString(), BeanGenerator.getParameterName(cimParam.getName()));
        }
        return paramStr.substring(0, paramStr.lastIndexOf(","));
    }

    private String getBeanKeysParameters() {
        String paramStr = "";
        Enumeration eKeys = this.vKeys.elements();
        while (eKeys.hasMoreElements()) {
            CIMProperty cimProp = (CIMProperty)eKeys.nextElement();
            paramStr = paramStr + BeanGenerator.format("{0} {1}, ", BeanGenerator.getDataType(cimProp.getType()).toString(), BeanGenerator.getParameterName(cimProp.getName()));
        }
        return paramStr.substring(0, paramStr.lastIndexOf(","));
    }

    private void addPropsToVector(Vector vJavaDocElements, Vector vProps) {
        Enumeration eProps = vProps.elements();
        while (eProps.hasMoreElements()) {
            CIMProperty cimProp = (CIMProperty)eProps.nextElement();
            JavaDocElement javaDocElement = new JavaDocElement("@param", BeanGenerator.getDataType(cimProp.getType()), BeanGenerator.getPropertyDescription(cimProp).toString());
            vJavaDocElements.addElement(javaDocElement);
        }
    }

    private void addParamsToVector(Vector vJavaDocElements, CIMParameter[] params) {
        for (int i = 0; i < params.length; ++i) {
            CIMParameter cimParam = params[i];
            JavaDocElement javaDocElement = new JavaDocElement("@param", BeanGenerator.getDataType(cimParam.getType()), I18N.loadStringFormat("INVOKEMETHOD_PARAM_DESCRIPTION", cimParam.getName()));
            vJavaDocElements.addElement(javaDocElement);
        }
    }
}

