/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.compiler.mofc;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class I18N {
    private static String resourceBundleName = "";
    public static Locale locale = Locale.getDefault();

    public static void setResourceName(String fileName) {
        resourceBundleName = fileName;
    }

    public static String getResourceName() {
        return resourceBundleName;
    }

    public static String loadString(String id) {
        return I18N.loadString(id, resourceBundleName);
    }

    public static boolean isStringAvailable(String id) {
        return I18N.isStringAvailable(id, resourceBundleName);
    }

    public static boolean isStringAvailable(String id, String b) {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(b, locale);
        }
        catch (MissingResourceException e) {
            try {
                bundle = ResourceBundle.getBundle(b, Locale.ENGLISH);
            }
            catch (MissingResourceException ee) {
                return false;
            }
        }
        if (bundle == null) {
            return false;
        }
        try {
            bundle.getString(id);
        }
        catch (MissingResourceException e) {
            return false;
        }
        return true;
    }

    public static String loadString(String id, String b) {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(b, locale);
        }
        catch (MissingResourceException e) {
            try {
                bundle = ResourceBundle.getBundle(b, Locale.ENGLISH);
            }
            catch (MissingResourceException ee) {
                System.err.println("CRITICAL ERROR: Could not load resource bundle " + b);
                System.exit(-1);
            }
        }
        if (bundle == null) {
            System.err.println("CRITICAL ERROR: Could not load resource bundle " + b);
            System.exit(-1);
            return null;
        }
        try {
            return bundle.getString(id);
        }
        catch (MissingResourceException e) {
            System.err.println("CRITICAL ERROR: Could not load ID " + id + " resource bundle " + b);
            System.exit(-1);
            return null;
        }
    }

    public static String loadStringFormat(String id, Vector values, String b) {
        String msgString = I18N.loadString(id, b);
        int numItems = values.size();
        if (msgString != null) {
            Object[] arguments = new Object[numItems];
            for (int i = 0; i < numItems; ++i) {
                arguments[i] = values.elementAt(i);
            }
            return MessageFormat.format(msgString, arguments);
        }
        return null;
    }

    public static String loadStringFormat(String id, Vector values) {
        return I18N.loadStringFormat(id, values, resourceBundleName);
    }

    public static String loadStringFormat(String id, Object[] values, String b) {
        String msgString = I18N.loadString(id, b);
        if (msgString != null) {
            return MessageFormat.format(msgString, values);
        }
        return null;
    }

    public static String loadStringFormat(String id, Object[] values) {
        return I18N.loadStringFormat(id, values, resourceBundleName);
    }

    public static String loadStringFormat(String id, Object arg1) {
        Vector<Object> v = new Vector<Object>();
        v.addElement(arg1);
        return I18N.loadStringFormat(id, v);
    }

    public static String loadStringFormat(String id, Object arg1, Object arg2) {
        Vector<Object> v = new Vector<Object>();
        v.addElement(arg1);
        v.addElement(arg2);
        return I18N.loadStringFormat(id, v);
    }
}

