/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.cimom;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMClassException;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMInstanceException;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMMethodException;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMParameter;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMPropertyException;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMQualifierTypeException;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.CIMSecurityException;
import javax.wbem.client.Debug;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.CIMAssociatorProvider;
import javax.wbem.provider.CIMInstanceProvider;
import javax.wbem.provider.CIMMethodProvider;
import javax.wbem.provider.CIMProvider;
import javax.wbem.query.NonJoinExp;
import javax.wbem.query.QualifiedAttributeExp;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectExp;
import javax.wbem.query.SelectList;
import javax.wbem.query.WQLParser;
import org.wbemservices.wbem.cimom.CIMNSStaticMethods;
import org.wbemservices.wbem.cimom.CIMOMLogService;
import org.wbemservices.wbem.cimom.CIMOMProvider;
import org.wbemservices.wbem.cimom.CIMOMServer;
import org.wbemservices.wbem.cimom.CIMOMUtils;
import org.wbemservices.wbem.cimom.CIMOMVersion;
import org.wbemservices.wbem.cimom.CIMQtypeStaticMethods;
import org.wbemservices.wbem.cimom.ClassChecker;
import org.wbemservices.wbem.cimom.ClientProtocolAdapterService;
import org.wbemservices.wbem.cimom.EventService;
import org.wbemservices.wbem.cimom.I18N;
import org.wbemservices.wbem.cimom.InternalProviderAdapter;
import org.wbemservices.wbem.cimom.LogFile;
import org.wbemservices.wbem.cimom.Mofregistry;
import org.wbemservices.wbem.cimom.NamespaceInManagerProvider;
import org.wbemservices.wbem.cimom.NamespaceProvider;
import org.wbemservices.wbem.cimom.ProviderAdapterFactory;
import org.wbemservices.wbem.cimom.ProviderClient;
import org.wbemservices.wbem.cimom.ReadersWriter;
import org.wbemservices.wbem.cimom.ServerSecurity;
import org.wbemservices.wbem.cimom.ServiceRegistry;
import org.wbemservices.wbem.cimom.security.UserPasswordProvider;
import org.wbemservices.wbem.cimom.util.DynClassLoader;
import org.wbemservices.wbem.repository.PSRlogImpl;

class CIMOMImpl
implements CIMInstanceProvider,
CIMAssociatorProvider,
CIMMethodProvider,
CIMOMServer {
    static final String SYSTEMNS = "/root/system";
    private static final String SECURITYNS = "/root/security";
    static final String DEFAULTNS = "/root/cimv2";
    static final String INTEROPNS = "/interop";
    static final String READ = "read";
    private static final String WRITE = "write";
    private static final String OUTPARAM = "OUT";
    private static final String INPARAM = "IN";
    private static final String MODULENAME = "CIMOM";
    private static final String BUNDLENAME = "org.wbemservices.wbem.cimom.CIMOM";
    private Hashtable serviceClass;
    private String dbHost = "";
    static boolean verbose = false;
    static PSRlogImpl ps;
    private final ReadersWriter concurrentObj = new ReadersWriter();
    private ClassChecker classCheck = null;
    private CIMOMUtils cu = null;
    private boolean firstTime = true;
    private Object firstTimeSemaphore = new Object();
    private static boolean inBuild;
    private static final long MEMORY_THRESH = 1000000L;
    private final Runtime rt = Runtime.getRuntime();
    private UserPasswordProvider upp = null;
    private EventService eventService = null;
    private static ProviderAdapterFactory mProvFactory;
    private Mofregistry mofreg = null;
    static /* synthetic */ Class class$javax$wbem$client$CIMOMHandle;

    private void checkIndication(CIMClass cc) throws CIMException {
        CIMQualifier cqe = cc.getQualifier("indication");
        if (cqe != null && cqe.getValue().equals((Object)CIMValue.TRUE)) {
            throw new CIMClassException("CIM_ERR_FAILED", (Object)cc.getName(), (Object)"Indication");
        }
    }

    private void checkAbstractOrIndication(CIMClass cc) throws CIMException {
        this.checkIndication(cc);
        CIMQualifier cqe = cc.getQualifier("abstract");
        if (cqe != null && cqe.getValue().equals((Object)CIMValue.TRUE)) {
            throw new CIMClassException("ABSTRACT_INSTANCE", (Object)cc.getName());
        }
    }

    private String logMessage(String summaryMesgID, String detailedMesgID, String[] args, String data, boolean syslog_flag, int category, int severity) {
        CIMOMLogService ls = (CIMOMLogService)ServiceRegistry.getService("logservice");
        if (ls == null) {
            return null;
        }
        String logResult = null;
        try {
            logResult = ls.writeLog(MODULENAME, summaryMesgID, detailedMesgID, args, data, syslog_flag, category, severity, BUNDLENAME);
        }
        catch (Exception le) {
            Debug.trace2((String)"logging error", (Throwable)le);
        }
        return logResult;
    }

    private void checkMemory() throws CIMException {
        Debug.trace3((String)"CIMOMImpl checkMemory CALLED");
        Debug.trace3((String)("FREE MEMORY " + this.rt.freeMemory()));
        Debug.trace3((String)("TOTAL MEMORY " + this.rt.totalMemory()));
        if (this.rt.freeMemory() < 1000000L) {
            this.rt.gc();
            if (this.rt.freeMemory() < 1000000L) {
                Debug.trace3((String)"CIMOMImpl checkMemory CALLED");
                Debug.trace3((String)("FREE MEMORY " + this.rt.freeMemory()));
                Debug.trace3((String)("TOTAL MEMORY " + this.rt.totalMemory()));
                throw new CIMException("CIM_ERR_LOW_ON_MEMORY");
            }
        }
    }

    private Vector commonAssociators(CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        Vector tvops = null;
        tvops = ps.associators(assocName, objectName, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList);
        Vector<CIMInstance> tv = new Vector<CIMInstance>();
        CIMNameSpace tns = new CIMNameSpace("", "");
        Enumeration e1 = tvops.elements();
        while (e1.hasMoreElements()) {
            CIMObjectPath tvop = (CIMObjectPath)e1.nextElement();
            CIMInstance ci = this.intgetInstance(tns, tvop, false, includeQualifiers, includeClassOrigin, propertyList, true);
            ci = ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin);
            tv.addElement(ci);
        }
        return tv;
    }

    public CIMOMImpl(String[] args) throws Exception {
        if (System.getProperty("org.wbemservices.wbem.build") != null) {
            inBuild = true;
        }
        I18N.setResourceName(BUNDLENAME);
        this.parseCommandLine(args);
        this.initTrace();
        mProvFactory = new ProviderAdapterFactory(new ProviderClient(this));
        this.firstTimeInit();
    }

    public CIMOMImpl() throws Exception {
        if (System.getProperty("org.wbemservices.wbem.build") != null) {
            inBuild = true;
        }
        I18N.setResourceName(BUNDLENAME);
        try {
            ps = new PSRlogImpl(this.dbHost, this.concurrentObj);
            this.cu = new CIMOMUtils(ps);
            this.classCheck = new ClassChecker(this.cu);
            this.initTrace();
            mProvFactory = new ProviderAdapterFactory(new ProviderClient(this));
        }
        catch (Exception e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
    }

    private CIMObjectPath createObjectPath(String cns, CIMInstance ci) {
        CIMObjectPath cop = new CIMObjectPath();
        cop.setObjectName(ci.getClassName());
        cop.setKeys(ci.getKeys());
        cop.setNameSpace(cns);
        return cop;
    }

    private CIMObjectPath createObjectPath(CIMNameSpace cns, CIMObjectPath op) {
        CIMObjectPath cop = new CIMObjectPath();
        cop.setObjectName(op.getObjectName());
        cop.setKeys(op.getKeys());
        cop.setNameSpace(this.getNameSpace(cns, op));
        return cop;
    }

    void delayedCapabilityCheck(CIMMethod me, boolean providerCall, String operation, String namespace) throws CIMException {
        Authorizable cp;
        block6: {
            if (providerCall) {
                return;
            }
            cp = null;
            if (me != null) {
                try {
                    cp = CIMOMImpl.getProviderFactory().getAuthorizableProvider(namespace, me);
                }
                catch (CIMException ce) {
                    if (ce.getID().equals("NOT_AUTHORIZABLE_PROVIDER")) break block6;
                    throw ce;
                }
            }
        }
        if (cp != null) {
            return;
        }
        if (ServerSecurity.getRequestSession() == null) {
            new ServerSecurity("root", "", "cimom", new byte[4]);
        }
        this.verifyCapabilities((ServerSecurity)ServerSecurity.getRequestSession(), operation, namespace);
    }

    void delayedCapabilityCheck(CIMProperty pe, boolean providerCall, String operation, String namespace) throws CIMException {
        Authorizable cp;
        block6: {
            if (providerCall) {
                return;
            }
            cp = null;
            if (pe != null) {
                try {
                    cp = CIMOMImpl.getProviderFactory().getAuthorizableProvider(namespace, pe);
                }
                catch (CIMException ce) {
                    if (ce.getID().equals("NOT_AUTHORIZABLE_PROVIDER")) break block6;
                    throw ce;
                }
            }
        }
        if (cp != null) {
            return;
        }
        if (ServerSecurity.getRequestSession() == null) {
            new ServerSecurity("root", "", "cimom", new byte[4]);
        }
        this.verifyCapabilities((ServerSecurity)ServerSecurity.getRequestSession(), operation, namespace);
    }

    void delayedCapabilityCheck(CIMClass cc, boolean providerCall, String operation, String namespace) throws CIMException {
        Authorizable cp;
        block6: {
            if (providerCall) {
                return;
            }
            cp = null;
            if (cc != null) {
                try {
                    cp = CIMOMImpl.getProviderFactory().getAuthorizableProvider(namespace, cc);
                }
                catch (CIMException ce) {
                    if (ce.getID().equals("NOT_AUTHORIZABLE_PROVIDER")) break block6;
                    throw ce;
                }
            }
        }
        if (cp != null) {
            return;
        }
        if (ServerSecurity.getRequestSession() == null) {
            new ServerSecurity("root", "", "cimom", new byte[4]);
        }
        this.verifyCapabilities((ServerSecurity)ServerSecurity.getRequestSession(), operation, namespace);
    }

    private void verifyCapabilities(ServerSecurity ss, String rw, CIMNameSpace nameSpace) throws CIMException {
        CIMNameSpace validNS = new CIMNameSpace();
        validNS.setNameSpace(nameSpace.getNameSpace() + '/' + nameSpace.getNameSpace());
        String ns = validNS.getNameSpace().replace('\\', '/');
        String parentNS = ns.substring(0, ns.lastIndexOf(47));
        this.verifyCapabilities(ss, rw, parentNS);
    }

    public void verifyCapabilities(ServerSecurity ss, String operation, String namespace) throws CIMException {
        if (inBuild) {
            return;
        }
        CIMNameSpace cns = new CIMNameSpace();
        cns.setNameSpace('/' + namespace);
        namespace = cns.getNameSpace();
        namespace = namespace.substring(1, namespace.length());
        LogFile.methodEntry("verifyCapabilities");
        if (ss.getUserName().equals("root")) {
            LogFile.methodReturn("verifyCapabilities");
            return;
        }
        if (namespace.equals(ss.getCapabilityNS())) {
            this.checkReadWritePermission(operation, ss);
            LogFile.methodReturn("verifyCapabilities");
            return;
        }
        CIMClass nsAcl = ps.getClass(SECURITYNS, "solaris_namespaceacl");
        if (nsAcl == null) {
            this.setCapability("rw", namespace, ss);
            LogFile.methodReturn("verifyCapabilities");
            return;
        }
        CIMClass userAcl = ps.getClass(SECURITYNS, "solaris_useracl");
        if (userAcl == null) {
            this.setCapability("rw", namespace, ss);
            LogFile.methodReturn("verifyCapabilities");
            return;
        }
        CIMInstance nsAclInstance = nsAcl.newInstance();
        CIMInstance userAclInstance = userAcl.newInstance();
        CIMProperty nspace = new CIMProperty("nspace");
        CIMProperty username = new CIMProperty("username");
        LogFile.add(4, "DEBUG_VALUE", "namespace", namespace);
        LogFile.add(4, "DEBUG_VALUE", "username", ss.getUserName());
        LogFile.add(4, "DEBUG_VALUE", "operation", operation);
        nspace.setValue(new CIMValue((Object)namespace));
        username.setValue(new CIMValue((Object)ss.getUserName()));
        userAclInstance.updatePropertyValue(nspace);
        userAclInstance.updatePropertyValue(username);
        CIMInstance ci = ps.getInstance(this.createObjectPath(SECURITYNS, userAclInstance));
        if (ci != null) {
            CIMValue cv = ci.getProperty("capability").getValue();
            String cap = (String)cv.getValue();
            this.setCapability(cap, namespace, ss);
            LogFile.add(4, "DEBUG_VALUE", "user capability", cap);
            this.checkReadWritePermission(operation, ss);
            LogFile.methodReturn("verifyCapabilities");
            return;
        }
        nsAclInstance.updatePropertyValue(nspace);
        ci = ps.getInstance(this.createObjectPath(SECURITYNS, nsAclInstance));
        if (ci != null) {
            CIMValue cv = ci.getProperty("capability").getValue();
            String cap = (String)cv.getValue();
            this.setCapability(cap, namespace, ss);
            LogFile.add(4, "DEBUG_VALUE", "ns capability", cap);
            this.checkReadWritePermission(operation, ss);
            return;
        }
        this.setCapability("r", namespace, ss);
        if (!operation.equals(READ)) {
            throw new CIMSecurityException("CIM_ERR_ACCESS_DENIED");
        }
    }

    private void checkIPropertiesSanity(String namespace, CIMInstance ci) throws CIMException {
        String lcns = namespace.toLowerCase();
        Vector prt = ci.getProperties();
        CIMProperty[] props = new CIMProperty[prt.size()];
        prt.toArray(props);
        for (int i = 0; i < props.length; ++i) {
            CIMProperty pe = props[i];
            try {
                pe.setValue(this.cu.typeConvert(pe.getType(), pe.getValue()));
                continue;
            }
            catch (Exception e) {
                throw new CIMPropertyException("TYPE_ERROR", new Object[]{pe.getOriginClass() + "." + pe.getName(), ci.getClassName(), pe.getType(), pe.getValue().getType(), pe.getValue()});
            }
        }
    }

    void checkInstanceSanity(String namespace, CIMInstance ci, CIMClass cc) throws CIMException {
        CIMQualifier qe = cc.getQualifier("abstract");
        if (qe == null) {
            qe = this.cu.createDefaultQualifier(namespace, "abstract");
        }
        if (qe.getValue().equals((Object)CIMValue.TRUE)) {
            throw new CIMClassException("ABSTRACT_INSTANCE", (Object)cc.getName());
        }
        this.checkIPropertiesSanity(namespace, ci);
    }

    private Properties initializeSysEnvPaths() throws Exception {
        String libwbemPath = null;
        String instlogParent = "/var/sadm/wbem";
        Properties wbeminstaller = new Properties();
        try {
            File instfile = new File(System.getProperty("user.home") + File.separator + "wbemInstallDir.properties");
            if (instfile.exists()) {
                FileInputStream fin = new FileInputStream(instfile);
                wbeminstaller.load(fin);
                libwbemPath = (String)wbeminstaller.get("LIBWBEMPATH");
                instlogParent = (String)wbeminstaller.get("WBEMLOGPARENT");
                fin.close();
            }
        }
        catch (Exception ex) {
            Debug.trace2((String)"Got exception", (Throwable)ex);
        }
        if (libwbemPath == null) {
            libwbemPath = System.getProperty("propdir", "/usr/sadm/lib/wbem");
        }
        System.setProperty("libwbemdir", libwbemPath);
        String wbemLogParent = System.getProperty("logparent", instlogParent);
        String buildtimeLogdir = System.getProperty("logdir");
        if (buildtimeLogdir != null) {
            wbemLogParent = buildtimeLogdir + File.separator + "..";
        }
        System.setProperty("logparent", wbemLogParent);
        String pdpath = System.getProperty("propdir", libwbemPath);
        System.setProperty("propdir", pdpath);
        BufferedInputStream bin = new BufferedInputStream(new FileInputStream(pdpath + "/cimom.properties"));
        Properties p = new Properties();
        p.load(bin);
        String pwlibpath = p.getProperty("org.wbemservices.wbem.cimom.pswdprov");
        if (pwlibpath == null) {
            pwlibpath = "org.wbemservices.wbem.cimom.SolarisUserPasswordProvider";
        }
        System.setProperty("org.wbemservices.wbem.cimom.pswdprov", pwlibpath);
        return p;
    }

    private void getDatastore() throws Exception {
        String libwbemPath = System.getProperty("libwbemdir", "/usr/sadm/lib/wbem");
        String wbemlogPath = System.getProperty("logparent", "/var/sadm/wbem") + File.separator + "logr";
        try {
            RandomAccessFile fin1 = new RandomAccessFile(libwbemPath + File.separator + "Logfile.1", "r");
            RandomAccessFile fout1 = new RandomAccessFile(wbemlogPath + File.separator + "Logfile.1", "rw");
            CIMOMImpl.copyFile(fin1, fout1, fin1.length());
            fin1.close();
            fout1.close();
            RandomAccessFile fin2 = new RandomAccessFile(libwbemPath + File.separator + "Snapshot.1", "r");
            RandomAccessFile fout2 = new RandomAccessFile(wbemlogPath + File.separator + "Snapshot.1", "rw");
            CIMOMImpl.copyFile(fin2, fout2, fin2.length());
            fin2.close();
            fout2.close();
            RandomAccessFile fin3 = new RandomAccessFile(libwbemPath + File.separator + "Version_Number", "r");
            RandomAccessFile fout3 = new RandomAccessFile(wbemlogPath + File.separator + "Version_Number", "rw");
            CIMOMImpl.copyFile(fin3, fout3, fin3.length());
            fin3.close();
            fout3.close();
            RandomAccessFile fin4 = new RandomAccessFile(libwbemPath + File.separator + "store", "r");
            RandomAccessFile fout4 = new RandomAccessFile(wbemlogPath + File.separator + "store", "rw");
            CIMOMImpl.copyFile(fin4, fout4, fin4.length());
            fin4.close();
            fout4.close();
        }
        catch (Exception ex) {
            Debug.trace2((String)"Got exception", (Throwable)ex);
        }
    }

    private void firstTimeInit() throws Exception {
        if (this.firstTime) {
            File notFirsttimeDir;
            this.firstTime = false;
            Properties props = this.initializeSysEnvPaths();
            if (System.getProperty("logdir") == null && !(notFirsttimeDir = new File(System.getProperty("logparent", "/var/sadm/wbem") + File.separator + "logr" + File.separator + "notFirstTime")).exists()) {
                if (!notFirsttimeDir.mkdirs()) {
                    System.out.println("Could not create directory: " + notFirsttimeDir);
                }
                this.getDatastore();
            }
            try {
                ps = new PSRlogImpl(this.dbHost, this.concurrentObj);
                this.cu = new CIMOMUtils(ps);
                this.classCheck = new ClassChecker(this.cu);
                this.updateClasspath();
                mProvFactory.startAdapters();
                this.initializeServices(props);
            }
            catch (Exception e) {
                Debug.trace2((String)"Got exception", (Throwable)e);
                System.out.println(e);
                throw e;
            }
        }
    }

    public Vector enumerateClasses(String version, CIMNameSpace currNs, CIMObjectPath path, Boolean deep, Boolean localOnly, Boolean includeQualifiers, Boolean includeClassOrigin, ServerSecurity ss) throws CIMException {
        try {
            LogFile.methodEntry("enumerateClasses");
            this.verifyCapabilities(ss, READ, this.getNameSpace(currNs, path));
            Vector v = this.intenumClass(currNs, path, deep, localOnly);
            Enumeration e = v.elements();
            Vector<CIMClass> tv = new Vector<CIMClass>();
            while (e.hasMoreElements()) {
                CIMClass cc = (CIMClass)e.nextElement();
                tv.addElement(cc.filterProperties(null, includeQualifiers.booleanValue(), includeClassOrigin.booleanValue()));
            }
            LogFile.methodReturn("enumerateClasses");
            return tv;
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    public Vector enumerateClassNames(String version, CIMNameSpace currNs, CIMObjectPath path, Boolean deep, ServerSecurity ss) throws CIMException {
        try {
            LogFile.methodEntry("enumerateClassNames");
            this.verifyCapabilities(ss, READ, this.getNameSpace(currNs, path));
            Vector rt = this.intenumClass(currNs, path, deep);
            LogFile.methodReturn("enumerateClassNames");
            return rt;
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    private List getDynasty(CIMNameSpace ns, CIMObjectPath className) throws CIMException {
        ArrayList<String> l = new ArrayList<String>();
        CIMObjectPath tcn = new CIMObjectPath();
        tcn.setNameSpace(className.getNameSpace());
        tcn.setObjectName(className.getObjectName());
        while (true) {
            CIMClass cc;
            if ((cc = this.intgetClass(ns, tcn, true)) == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)className.getObjectName().toLowerCase());
            }
            l.add(cc.getName());
            if (cc.getSuperClass().length() == 0) break;
            tcn.setObjectName(cc.getSuperClass());
        }
        return l;
    }

    public Vector enumerateInstances(String version, CIMNameSpace currNs, CIMObjectPath path, Boolean deep, Boolean localOnly, Boolean includeQualifiers, Boolean includeClassOrigin, String[] propertyList, ServerSecurity ss) throws CIMException {
        try {
            LogFile.methodEntry("enumerateInstances");
            this.verifyCapabilities(ss, READ, this.getNameSpace(currNs, path));
            Vector v = this.intenumInstances(currNs, path, true, localOnly, false);
            Enumeration e = v.elements();
            Vector<CIMInstance> tv = new Vector<CIMInstance>();
            List classList = null;
            boolean deepValue = deep;
            if (!deepValue) {
                classList = this.getDynasty(currNs, path);
            }
            while (e.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)e.nextElement();
                if (localOnly.booleanValue()) {
                    ci = ci.localElements();
                }
                if (!deepValue) {
                    ci = ci.localElements(classList);
                }
                tv.addElement(ci.filterProperties(propertyList, includeQualifiers.booleanValue(), includeClassOrigin.booleanValue()));
            }
            LogFile.methodReturn("enumerateInstances");
            return tv;
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    public Vector enumerateInstanceNames(String version, CIMNameSpace currNs, CIMObjectPath path, ServerSecurity ss) throws CIMException {
        try {
            LogFile.methodEntry("enumerateInstanceNames");
            this.verifyCapabilities(ss, READ, this.getNameSpace(currNs, path));
            Vector rt = this.intenumInstances(currNs, path, true, false);
            LogFile.methodReturn("enumerateInstanceNames");
            return rt;
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    public CIMClass getClass(String version, CIMNameSpace currNs, CIMObjectPath path, Boolean localOnly, Boolean includeQualifiers, Boolean includeClassOrigin, String[] propertyList, ServerSecurity ss) throws CIMException {
        LogFile.methodEntry("getClass");
        this.verifyCapabilities(ss, READ, this.getNameSpace(currNs, path));
        CIMClass cc = this.intgetClass(currNs, path, localOnly);
        LogFile.methodReturn("getClass");
        if (cc == null) {
            throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)path.getObjectName());
        }
        return cc.filterProperties(propertyList, includeQualifiers.booleanValue(), includeClassOrigin.booleanValue());
    }

    public CIMInstance getInstance(String version, CIMNameSpace currNs, CIMObjectPath path, Boolean localOnly, Boolean includeQualifiers, Boolean includeClassOrigin, String[] propertyList, ServerSecurity ss) throws CIMException {
        try {
            LogFile.methodEntry("getInstance");
            CIMInstance ci = this.intgetInstance(currNs, path, localOnly, includeQualifiers, includeClassOrigin, propertyList, false);
            LogFile.methodReturn("getInstance");
            if (ci == null) {
                throw new CIMInstanceException("CIM_ERR_NOT_FOUND", (Object)path.toString());
            }
            return ci.filterProperties(propertyList, includeQualifiers.booleanValue(), includeClassOrigin.booleanValue());
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    public void close(String version, ServerSecurity ss) throws CIMException {
        LogFile.methodEntry("close");
        LogFile.methodReturn("close");
    }

    public void deleteNameSpace(String version, CIMNameSpace parent, CIMNameSpace nameSpace, ServerSecurity ss) throws CIMException {
        try {
            LogFile.methodEntry("secDeleteNameSpace");
            this.verifyCapabilities(ss, WRITE, parent);
            CIMNSStaticMethods.deleteNameSpace(parent, nameSpace);
            LogFile.methodReturn("secDeleteNameSpace");
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    public void createNameSpace(String version, CIMNameSpace parent, CIMNameSpace nameSpace, ServerSecurity ss) throws CIMException {
        try {
            this.verifyCapabilities(ss, WRITE, parent);
            this.checkMemory();
            LogFile.methodEntry("secCreateNameSpace");
            CIMNSStaticMethods.createNameSpace(parent, nameSpace);
            LogFile.methodReturn("secCreateNameSpace");
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    public void createQualifierType(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, CIMQualifierType qt, ServerSecurity ss) throws CIMException {
        try {
            this.verifyCapabilities(ss, WRITE, this.getNameSpace(nameSpace, objectName));
            this.checkMemory();
            LogFile.methodEntry("createQualiferType");
            CIMQtypeStaticMethods.addCIMElement(nameSpace, objectName, qt);
            LogFile.methodReturn("createQualifierType");
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    public void setQualifierType(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, CIMQualifierType qt, ServerSecurity ss) throws CIMException {
        try {
            this.verifyCapabilities(ss, WRITE, this.getNameSpace(nameSpace, objectName));
            this.checkMemory();
            LogFile.methodEntry("setQualifierType");
            CIMQtypeStaticMethods.setCIMElement(nameSpace, objectName, qt);
            LogFile.methodReturn("setQualifierType");
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    private void csClass(CIMNameSpace nameSpace, CIMObjectPath objectName, CIMClass cc, boolean set) throws CIMException {
        try {
            if (!set) {
                CIMObjectPath tpath = new CIMObjectPath();
                tpath.setNameSpace(objectName.getNameSpace());
                tpath.setObjectName(cc.getName());
                CIMClass icc = this.intgetClass(nameSpace, tpath, false);
                if (icc != null) {
                    throw new CIMClassException("CIM_ERR_ALREADY_EXISTS", (Object)cc.getName());
                }
                this.classCheck.checkClassSanity(this.getNameSpace(nameSpace, objectName), cc, null);
                ps.addCIMElement(this.getNameSpace(nameSpace, objectName), cc);
            } else {
                int i;
                CIMClass icc = this.intgetClass(nameSpace, objectName, false);
                if (icc == null) {
                    throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)cc.getName());
                }
                icc = icc.localElements();
                Vector v = this.intenumClass(nameSpace, objectName, false);
                if (v.size() > 0) {
                    throw new CIMClassException("CIM_ERR_CLASS_HAS_CHILDREN", (Object)cc.getName());
                }
                v = ps.enumerateInstances(this.createObjectPath(nameSpace, objectName), false);
                if (v.size() > 0) {
                    throw new CIMClassException("CIM_ERR_CLASS_HAS_INSTANCES", (Object)cc.getName());
                }
                v = cc.getQualifiers();
                CIMQualifier[] cqs = new CIMQualifier[v.size()];
                v.toArray(cqs);
                v = icc.getQualifiers();
                for (i = 0; i < cqs.length; ++i) {
                    v.removeElement(cqs[i]);
                    v.addElement(cqs[i]);
                }
                icc.setQualifiers(v);
                v = cc.getProperties();
                CIMProperty[] cps = new CIMProperty[v.size()];
                v.toArray(cps);
                v = icc.getProperties();
                for (i = 0; i < cps.length; ++i) {
                    CIMProperty cp = cps[i];
                    CIMProperty icp = icc.getProperty(cp.getName(), cp.getOriginClass());
                    if (icp == null) {
                        v.addElement(cp);
                        continue;
                    }
                    Vector qv = cp.getQualifiers();
                    CIMQualifier[] pcqs = new CIMQualifier[qv.size()];
                    qv.toArray(pcqs);
                    qv = icp.getQualifiers();
                    for (int j = 0; j < pcqs.length; ++j) {
                        CIMQualifier pcq = pcqs[j];
                        qv.removeElement(pcq);
                        qv.addElement(pcq);
                    }
                    cp.setQualifiers(qv);
                    v.removeElement(cp);
                    v.addElement(cp);
                }
                icc.setProperties(v);
                v = cc.getMethods();
                CIMMethod[] cms = new CIMMethod[v.size()];
                v.toArray(cms);
                v = icc.getMethods();
                for (i = 0; i < cms.length; ++i) {
                    CIMMethod cm = cms[i];
                    CIMMethod icm = icc.getMethod(cm.getName(), cm.getOriginClass());
                    if (icm == null) {
                        v.addElement(cm);
                        continue;
                    }
                    Vector qv = cm.getQualifiers();
                    CIMQualifier[] mcqs = new CIMQualifier[qv.size()];
                    qv.toArray(mcqs);
                    qv = icm.getQualifiers();
                    for (int j = 0; j < mcqs.length; ++j) {
                        CIMQualifier mcq = mcqs[j];
                        qv.removeElement(mcq);
                        qv.addElement(mcq);
                    }
                    cm.setQualifiers(qv);
                    v.removeElement(cm);
                    v.addElement(cm);
                }
                icc.setMethods(v);
                this.classCheck.checkClassSanity(this.getNameSpace(nameSpace, objectName), icc, null);
                ps.setClass(this.getNameSpace(nameSpace, objectName), icc);
                cc = icc;
            }
            LogFile.add(3, "ADD_CLASS_DEBUG", cc);
        }
        catch (CIMException e) {
            LogFile.add(4, "CAUGHT_EXCEPTION", e.toString());
            LogFile.methodReturn("addCIMElement(class)");
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            e.printStackTrace();
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
    }

    void intaddCIMElement(CIMNameSpace nameSpace, CIMObjectPath objectName, CIMClass cc) throws CIMException {
        nameSpace.setNameSpace('/' + nameSpace.getNameSpace());
        this.csClass(nameSpace, objectName, cc, false);
    }

    void intsetCIMElement(CIMNameSpace nameSpace, CIMObjectPath objectName, CIMClass cc) throws CIMException {
        nameSpace.setNameSpace('/' + nameSpace.getNameSpace());
        this.csClass(nameSpace, objectName, cc, true);
    }

    public void createClass(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, CIMClass cc, ServerSecurity ss) throws CIMException {
        try {
            this.checkMemory();
            LogFile.methodEntry("createClass");
            this.verifyCapabilities(ss, WRITE, this.getNameSpace(nameSpace, objectName));
            objectName.setObjectName(cc.getName());
            this.intaddCIMElement(nameSpace, objectName, cc);
            LogFile.methodReturn("createClass");
        }
        catch (ReadersWriter.ConcurrentLockException e) {
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    public void setClass(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, CIMClass cc, ServerSecurity ss) throws CIMException {
        try {
            this.checkMemory();
            LogFile.methodEntry("setClass");
            this.verifyCapabilities(ss, WRITE, this.getNameSpace(nameSpace, objectName));
            objectName.setObjectName(cc.getName());
            this.intsetCIMElement(nameSpace, objectName, cc);
            LogFile.methodReturn("setClass");
        }
        catch (ReadersWriter.ConcurrentLockException e) {
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    CIMObjectPath csInstance(CIMNameSpace nameSpace, CIMObjectPath objectName, CIMInstance ci, boolean set, boolean providerCall, boolean includeQualifiers, String[] propertyList, boolean checkForProvider) throws CIMException {
        CIMObjectPath retValue = null;
        try {
            CIMClass cc = this.intgetClass(nameSpace, objectName, false);
            if (cc == null) {
                throw new CIMInstanceException("CIM_ERR_INVALID_CLASS", (Object)objectName.getObjectName());
            }
            this.checkAbstractOrIndication(cc);
            CIMInstanceProvider ip = null;
            if (checkForProvider) {
                ip = CIMOMImpl.getProviderFactory().getInstanceProvider(this.getNameSpace(nameSpace, objectName), cc);
            }
            this.delayedCapabilityCheck(cc, providerCall, WRITE, this.getNameSpace(nameSpace, objectName));
            CIMInstance nci = cc.newInstance();
            nci.updatePropertyValues(ci.getProperties());
            objectName.setKeys(nci.getKeys());
            if (propertyList != null) {
                ArrayList<String> newPropList = new ArrayList<String>();
                for (int i = 0; i < propertyList.length; ++i) {
                    if (cc.getProperty(propertyList[i]) == null) {
                        throw new CIMPropertyException("CIM_ERR_NO_SUCH_PROPERTY", (Object)propertyList[i]);
                    }
                    if (ci.getProperty(propertyList[i]) == null) continue;
                    newPropList.add(propertyList[i]);
                }
                int newSize = newPropList.size();
                if (newSize != propertyList.length) {
                    propertyList = new String[newSize];
                    propertyList = newPropList.toArray(propertyList);
                }
            }
            this.checkInstanceSanity(this.getNameSpace(nameSpace, objectName), nci, cc);
            if (ip != null) {
                if (set) {
                    ip.setInstance(this.createObjectPath(this.getNameSpace(nameSpace, objectName), nci), nci, includeQualifiers, propertyList);
                } else {
                    retValue = ip.createInstance(this.createObjectPath(this.getNameSpace(nameSpace, objectName), nci), nci);
                }
                return retValue;
            }
            CIMInstance inci = checkForProvider ? this.intgetInstance(nameSpace, objectName, cc, false, includeQualifiers, true, propertyList, false) : ps.getInstance(this.createObjectPath(nameSpace, objectName));
            if (inci == null && set) {
                throw new CIMInstanceException("CIM_ERR_NOT_FOUND", (Object)objectName.toString());
            }
            if (inci != null && !set) {
                throw new CIMInstanceException("CIM_ERR_ALREADY_EXISTS", (Object)objectName.toString());
            }
            if (set) {
                this.repositorySetInstance(nameSpace, objectName, nci, inci, cc, includeQualifiers, propertyList, checkForProvider);
                return null;
            }
            Vector vProp = nci.getProperties();
            CIMProperty[] properties = new CIMProperty[vProp.size()];
            vProp.toArray(properties);
            retValue = new CIMObjectPath();
            retValue.setKeys(nci.getKeys());
            retValue.setNameSpace(this.getNameSpace(nameSpace, objectName));
            retValue.setObjectName(nci.getClassName());
            ps.addCIMElement(this.getNameSpace(nameSpace, objectName), nci);
            return retValue;
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    CIMObjectPath intaddCIMElement(CIMNameSpace nameSpace, CIMObjectPath objectName, CIMInstance ci, boolean providerCall) throws CIMException {
        nameSpace.setNameSpace('/' + nameSpace.getNameSpace());
        return this.csInstance(nameSpace, objectName, ci, false, providerCall, true, null, true);
    }

    void intsetCIMElement(CIMNameSpace nameSpace, CIMObjectPath objectName, CIMInstance ci, boolean providerCall, boolean includeQualifiers, String[] propertyList, boolean checkForProvider) throws CIMException {
        nameSpace.setNameSpace('/' + nameSpace.getNameSpace());
        this.csInstance(nameSpace, objectName, ci, true, providerCall, includeQualifiers, propertyList, checkForProvider);
    }

    public CIMObjectPath createInstance(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, CIMInstance ci, ServerSecurity ss) throws CIMException {
        String className = ci.getClassName();
        this.checkMemory();
        LogFile.methodEntry("createInstance");
        objectName.setObjectName(ci.getClassName().toLowerCase());
        LogFile.methodReturn("createInstance");
        CIMObjectPath op = this.intaddCIMElement(nameSpace, objectName, ci, false);
        return op;
    }

    public void setInstance(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, CIMInstance ci, ServerSecurity ss) throws CIMException {
        String className = ci.getClassName();
        this.checkMemory();
        LogFile.methodEntry("setInstance");
        objectName.setObjectName(ci.getClassName().toLowerCase());
        this.intsetCIMElement(nameSpace, objectName, ci, false, true, null, true);
        LogFile.methodReturn("setInstance");
    }

    public void setInstance(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, CIMInstance ci, boolean includeQualifiers, String[] propertyList, ServerSecurity ss) throws CIMException {
        String className = ci.getClassName();
        this.checkMemory();
        LogFile.methodEntry("setInstance");
        objectName.setObjectName(ci.getClassName().toLowerCase());
        this.intsetCIMElement(nameSpace, objectName, ci, false, includeQualifiers, propertyList, true);
        LogFile.methodReturn("setInstance");
    }

    void intsetProperty(CIMNameSpace nameSpace, CIMObjectPath objectName, String propertyName, CIMValue newValue, boolean providerCall) throws CIMException {
        try {
            CIMInstanceProvider ip;
            nameSpace.setNameSpace('/' + nameSpace.getNameSpace());
            if (objectName == null || objectName.getObjectName() == null) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            CIMClass cc = this.intgetClass(nameSpace, objectName, false);
            if (cc == null) {
                throw new CIMInstanceException("CIM_ERR_INVALID_CLASS", (Object)objectName.getObjectName());
            }
            this.checkAbstractOrIndication(cc);
            CIMProperty propElem = cc.getProperty(propertyName);
            if (propElem == null) {
                throw new CIMPropertyException("CIM_ERR_NOT_FOUND", (Object)propertyName);
            }
            propElem.setValue(newValue);
            CIMInstance nci = cc.newInstance();
            nci.updatePropertyValues(objectName.getKeys());
            nci.updatePropertyValue(propElem);
            objectName.setKeys(nci.getKeys());
            objectName.setObjectName(cc.getName());
            ProviderAdapterFactory factory = CIMOMImpl.getProviderFactory();
            boolean rightsChecked = false;
            if (!rightsChecked) {
                this.delayedCapabilityCheck(cc, providerCall, WRITE, this.getNameSpace(nameSpace, objectName));
            }
            if ((ip = factory.getInstanceProvider(this.getNameSpace(nameSpace, objectName), cc)) == null) {
                CIMInstance inci = null;
                inci = ps.getInstance(this.createObjectPath(this.getNameSpace(nameSpace, objectName), nci));
                if (inci != null) {
                    inci.updatePropertyValue(propElem);
                    this.checkInstanceSanity(this.getNameSpace(nameSpace, objectName), inci, cc);
                    ps.setInstance(this.getNameSpace(nameSpace, objectName), inci);
                    return;
                }
                throw new CIMInstanceException("CIM_ERR_NOT_FOUND", (Object)nci.getObjectPath());
            }
            String[] propertyList = new String[]{propertyName};
            ip.setInstance(this.createObjectPath(this.getNameSpace(nameSpace, objectName), nci), nci, true, propertyList);
        }
        catch (CIMException e) {
            LogFile.add(4, "CAUGHT_EXCEPTION", e.toString());
            LogFile.methodReturn("setProperty");
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    public void setProperty(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, String propertyName, CIMValue newValue, ServerSecurity ss) throws CIMException {
        this.checkMemory();
        LogFile.methodEntry("setProperty");
        this.intsetProperty(nameSpace, objectName, propertyName, newValue, false);
        LogFile.methodReturn("setProperty");
    }

    Vector intexecQuery(CIMNameSpace nameSpace, CIMObjectPath relNS, String query, String ql, boolean providerCall) throws CIMException {
        if (!ql.equalsIgnoreCase("WQL")) {
            throw new CIMException("CIM_ERR_QUERY_LANGUAGE_NOT_SUPPORTED", ql);
        }
        nameSpace.setNameSpace('/' + nameSpace.getNameSpace());
        String tnameSpace = this.getNameSpace(nameSpace, relNS);
        CIMObjectPath path = new CIMObjectPath();
        path.setNameSpace(tnameSpace);
        path.setKeys(relNS.getKeys());
        WQLParser parser = new WQLParser((InputStream)new ByteArrayInputStream(query.getBytes()));
        SelectExp exp = null;
        try {
            exp = (SelectExp)parser.querySpecification();
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_INVALID_QUERY", (Object)query, (Object)e.toString());
        }
        NonJoinExp nj = (NonJoinExp)exp.getFromClause();
        QualifiedAttributeExp aexp = nj.getAttribute();
        path.setObjectName(aexp.getAttrClassName());
        relNS.setObjectName(aexp.getAttrClassName());
        Vector v = new Vector();
        Vector<Object> fv = new Vector<Object>();
        v = this.intenumClass(nameSpace, relNS, true);
        String on = path.getObjectName();
        if (on != null && on.length() != 0 && !on.equals("top")) {
            v.insertElementAt(path, 0);
        }
        CIMObjectPath[] ops = new CIMObjectPath[v.size()];
        v.toArray(ops);
        for (int i = 0; i < ops.length; ++i) {
            CIMInstance[] tv;
            CIMObjectPath op = ops[i];
            op.setKeys(path.getKeys());
            LogFile.add(4, "DEBUG_VALUE", "op", op.getObjectName());
            String tns = nameSpace.getNameSpace();
            nameSpace.setNameSpace("");
            CIMClass cc = this.intgetClass(nameSpace, op, false);
            nameSpace.setNameSpace(tns);
            if (cc == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)op.getObjectName());
            }
            this.delayedCapabilityCheck(cc, providerCall, READ, tnameSpace);
            CIMInstanceProvider ip = CIMOMImpl.getProviderFactory().getInstanceProvider(nameSpace.getNameSpace(), cc);
            if (ip != null) {
                op.setObjectName(cc.getName());
                tv = ip.execQuery(op, query, ql, cc);
            } else {
                Vector tmpV = ps.execQuery(op, query, ql, cc);
                tv = new CIMInstance[tmpV.size()];
                tmpV.toArray(tv);
            }
            if (tv == null) continue;
            SelectList attrs = exp.getSelectList();
            if (tv.length != 0 && tv[0] == null) {
                QueryExp wc = exp.getWhereClause();
                for (int j = 1; j < tv.length; ++j) {
                    CIMInstance tci = tv[j];
                    if (wc != null && !wc.apply((CIMElement)tci)) continue;
                    fv.addElement(attrs.apply((CIMElement)tci));
                }
                continue;
            }
            for (int j = 0; j < tv.length; ++j) {
                fv.addElement(tv[j]);
            }
        }
        return fv;
    }

    public Vector execQuery(String version, CIMNameSpace nameSpace, CIMObjectPath relNS, String query, String ql, ServerSecurity ss) throws CIMException {
        try {
            LogFile.methodEntry("execQuery");
            Vector r = this.intexecQuery(nameSpace, relNS, query, ql, false);
            LogFile.methodReturn("execQuery");
            return r;
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    Vector intassociators(CIMNameSpace inpnameSpace, CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole, boolean biq, boolean bic, String[] propertyList, boolean providerCall) throws CIMException {
        if (objectName == null || objectName.getObjectName() == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        if (resultClass == null && propertyList != null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        boolean classOnly = objectName.getKeys() == null || objectName.getKeys().size() == 0;
        CIMNameSpace ns = new CIMNameSpace();
        ns.setNameSpace('/' + inpnameSpace.getNameSpace());
        String nameSpace = this.getNameSpace(ns, objectName);
        CIMObjectPath path = new CIMObjectPath();
        path.setNameSpace(nameSpace);
        path.setObjectName(objectName.getObjectName());
        path.setKeys(objectName.getKeys());
        CIMObjectPath assocPath = new CIMObjectPath();
        assocPath.setNameSpace(nameSpace);
        assocPath.setObjectName(assocClass);
        LogFile.add(4, "DEBUG_VALUE", "path", path);
        LogFile.add(4, "DEBUG_VALUE", "assocPath", assocPath);
        Vector v = new Vector();
        Vector fv = new Vector();
        CIMInstance[] tArray = null;
        v = ps.associatorsClass(path, assocClass, resultClass, role, resultRole, biq, bic, propertyList);
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            Object o;
            CIMClass cc = (CIMClass)e.nextElement();
            while (e.hasMoreElements() && (o = e.nextElement()) != null) {
                if (!classOnly) continue;
                fv.addElement(o);
            }
            if (classOnly) continue;
            this.delayedCapabilityCheck(cc, providerCall, READ, nameSpace);
            CIMAssociatorProvider ap = CIMOMImpl.getProviderFactory().getAssociatorProvider(nameSpace, cc);
            CIMObjectPath tempOp = new CIMObjectPath();
            tempOp.setObjectName(cc.getName());
            tempOp.setNameSpace(nameSpace);
            LogFile.add(4, "DEBUG_VALUE", "tempOp", tempOp);
            if (ap != null) {
                try {
                    tArray = ap.associators(tempOp, path, resultClass, role, resultRole, biq, bic, propertyList);
                }
                catch (CIMException ex) {
                    if (ex.getID().equals("CIM_ERR_NOT_FOUND")) {
                        tArray = null;
                    }
                    throw ex;
                }
            } else {
                if (CIMOMImpl.getProviderFactory().getInstanceProvider(nameSpace, cc) != null) continue;
                Vector tvops = null;
                try {
                    tvops = ps.associators(tempOp, path, resultClass, role, resultRole, biq, bic, propertyList);
                }
                catch (CIMException ex) {
                    if (ex.getID().equals("CIM_ERR_NOT_FOUND")) {
                        tvops = new Vector();
                    }
                    throw ex;
                }
                tArray = new CIMInstance[tvops.size()];
                CIMNameSpace tns = new CIMNameSpace("", "");
                Enumeration e1 = tvops.elements();
                int count = 0;
                while (e1.hasMoreElements()) {
                    CIMObjectPath tvop = (CIMObjectPath)e1.nextElement();
                    CIMInstance ci = this.intgetInstance(tns, tvop, false, true, true, propertyList, true);
                    tArray[count] = ci = ci.filterProperties(propertyList, biq, bic);
                    ++count;
                }
            }
            if (tArray == null) continue;
            for (int j = 0; j < tArray.length; ++j) {
                fv.addElement(tArray[j]);
            }
        }
        return fv;
    }

    public Vector associators(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole, Boolean includeQualifiers, Boolean includeClassOrigin, String[] propertyList, ServerSecurity ss) throws CIMException {
        try {
            LogFile.methodEntry("associators");
            Vector rt = this.intassociators(nameSpace, objectName, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList, false);
            LogFile.methodReturn("associators");
            return rt;
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    Vector intassociatorNames(CIMNameSpace inpnameSpace, CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole, boolean providerCall) throws CIMException {
        if (objectName == null || objectName.getObjectName() == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        boolean classOnly = objectName.getKeys() == null || objectName.getKeys().size() == 0;
        CIMNameSpace ns = new CIMNameSpace();
        ns.setNameSpace('/' + inpnameSpace.getNameSpace());
        String nameSpace = this.getNameSpace(ns, objectName);
        CIMObjectPath path = new CIMObjectPath();
        path.setNameSpace(nameSpace);
        path.setObjectName(objectName.getObjectName());
        path.setKeys(objectName.getKeys());
        CIMObjectPath assocPath = new CIMObjectPath();
        assocPath.setNameSpace(nameSpace);
        assocPath.setObjectName(assocClass);
        LogFile.add(4, "DEBUG_VALUE", "path", path);
        LogFile.add(4, "DEBUG_VALUE", "assocPath", assocPath);
        Vector v = new Vector();
        Vector fv = new Vector();
        CIMObjectPath[] tv = null;
        v = ps.associatorClassNames(path, assocClass, resultClass, role, resultRole);
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            Object o;
            CIMClass cc = (CIMClass)e.nextElement();
            while (e.hasMoreElements() && (o = e.nextElement()) != null) {
                if (!classOnly) continue;
                fv.addElement(o);
            }
            if (classOnly) continue;
            this.delayedCapabilityCheck(cc, providerCall, READ, nameSpace);
            CIMAssociatorProvider ap = CIMOMImpl.getProviderFactory().getAssociatorProvider(nameSpace, cc);
            CIMObjectPath tempOp = new CIMObjectPath();
            tempOp.setObjectName(cc.getName());
            tempOp.setNameSpace(nameSpace);
            LogFile.add(4, "DEBUG_VALUE", "tempOp", tempOp);
            if (ap != null) {
                try {
                    tv = ap.associatorNames(tempOp, path, resultClass, role, resultRole);
                }
                catch (CIMException ex) {
                    if (ex.getID().equals("CIM_ERR_NOT_FOUND")) {
                        tv = null;
                    }
                    throw ex;
                }
            } else {
                if (CIMOMImpl.getProviderFactory().getInstanceProvider(nameSpace, cc) != null) continue;
                try {
                    Vector tmpV = ps.associatorNames(tempOp, path, resultClass, role, resultRole);
                    tv = new CIMObjectPath[tmpV.size()];
                    tmpV.toArray(tv);
                }
                catch (CIMException ex) {
                    if (ex.getID().equals("CIM_ERR_NOT_FOUND")) {
                        tv = null;
                    }
                    throw ex;
                }
            }
            if (tv == null) continue;
            for (int j = 0; j < tv.length; ++j) {
                fv.addElement(tv[j]);
            }
        }
        return fv;
    }

    public Vector associatorNames(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole, ServerSecurity ss) throws CIMException {
        try {
            LogFile.methodEntry("associatorNames");
            Vector rt = this.intassociatorNames(nameSpace, objectName, assocClass, resultClass, role, resultRole, false);
            LogFile.methodReturn("associatorNames");
            return rt;
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    Vector intreferences(CIMNameSpace inpnameSpace, CIMObjectPath objectName, String assocClass, String role, boolean biq, boolean bic, String[] propertyList, boolean providerCall) throws CIMException {
        if (objectName == null || objectName.getObjectName() == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        if (assocClass == null && propertyList != null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        boolean classOnly = objectName.getKeys() == null || objectName.getKeys().size() == 0;
        CIMNameSpace ns = new CIMNameSpace();
        ns.setNameSpace('/' + inpnameSpace.getNameSpace());
        String nameSpace = this.getNameSpace(ns, objectName);
        CIMObjectPath path = new CIMObjectPath();
        path.setNameSpace(nameSpace);
        path.setObjectName(objectName.getObjectName());
        path.setKeys(objectName.getKeys());
        CIMObjectPath assocPath = new CIMObjectPath();
        assocPath.setNameSpace(nameSpace);
        assocPath.setObjectName(assocClass);
        LogFile.add(4, "DEBUG_VALUE", "path", path);
        LogFile.add(4, "DEBUG_VALUE", "assocPath", assocPath);
        Vector v = new Vector();
        Vector<Object> fv = new Vector<Object>();
        CIMInstance[] tArray = null;
        v = ps.reference(path, assocClass, role, biq, bic, propertyList);
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            CIMClass cc = (CIMClass)e.nextElement();
            e.nextElement();
            if (classOnly) {
                fv.addElement(cc.filterProperties(propertyList, biq, bic));
                continue;
            }
            this.delayedCapabilityCheck(cc, providerCall, READ, nameSpace);
            CIMAssociatorProvider ap = CIMOMImpl.getProviderFactory().getAssociatorProvider(nameSpace, cc);
            CIMObjectPath tempOp = new CIMObjectPath();
            tempOp.setObjectName(cc.getName());
            tempOp.setNameSpace(nameSpace);
            LogFile.add(4, "DEBUG_VALUE", "tempOp", tempOp);
            if (ap != null) {
                try {
                    tArray = ap.references(tempOp, path, role, biq, bic, propertyList);
                }
                catch (CIMException ex) {
                    if (ex.getID().equals("CIM_ERR_NOT_FOUND")) {
                        tArray = null;
                    }
                    throw ex;
                }
            } else {
                if (CIMOMImpl.getProviderFactory().getInstanceProvider(nameSpace, cc) != null) continue;
                try {
                    Vector tv = ps.reference(tempOp, path, role, biq, bic, propertyList);
                    tArray = new CIMInstance[tv.size()];
                    tArray = tv.toArray(tArray);
                }
                catch (CIMException ex) {
                    if (ex.getID().equals("CIM_ERR_NOT_FOUND")) {
                        tArray = null;
                    }
                    throw ex;
                }
            }
            if (tArray == null) continue;
            for (int j = 0; j < tArray.length; ++j) {
                fv.addElement(tArray[j]);
            }
        }
        return fv;
    }

    public Vector references(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, String resultClass, String role, Boolean includeQualifiers, Boolean includeClassOrigin, String[] propertyList, ServerSecurity ss) throws CIMException {
        try {
            LogFile.methodEntry("references");
            Vector rt = this.intreferences(nameSpace, objectName, resultClass, role, includeQualifiers, includeClassOrigin, propertyList, false);
            LogFile.methodReturn("references");
            return rt;
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    Vector intreferenceNames(CIMNameSpace inpnameSpace, CIMObjectPath objectName, String assocClass, String role, boolean providerCall) throws CIMException {
        if (objectName == null || objectName.getObjectName() == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        boolean classOnly = objectName.getKeys() == null || objectName.getKeys().size() == 0;
        CIMNameSpace ns = new CIMNameSpace();
        ns.setNameSpace('/' + inpnameSpace.getNameSpace());
        String nameSpace = this.getNameSpace(ns, objectName);
        CIMObjectPath path = new CIMObjectPath();
        path.setNameSpace(nameSpace);
        path.setObjectName(objectName.getObjectName());
        path.setKeys(objectName.getKeys());
        CIMObjectPath assocPath = new CIMObjectPath();
        assocPath.setNameSpace(nameSpace);
        assocPath.setObjectName(assocClass);
        LogFile.add(4, "DEBUG_VALUE", "path", path);
        LogFile.add(4, "DEBUG_VALUE", "assocPath", assocPath);
        Vector v = new Vector();
        Vector<CIMObjectPath> fv = new Vector<CIMObjectPath>();
        CIMObjectPath[] tv = null;
        v = ps.referenceNames(path, assocClass, role);
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            CIMClass cc = (CIMClass)e.nextElement();
            e.nextElement();
            if (classOnly) {
                CIMObjectPath rName = new CIMObjectPath();
                rName.setNameSpace(nameSpace);
                rName.setObjectName(cc.getName());
                fv.addElement(rName);
                continue;
            }
            this.delayedCapabilityCheck(cc, providerCall, READ, nameSpace);
            CIMAssociatorProvider ap = CIMOMImpl.getProviderFactory().getAssociatorProvider(nameSpace, cc);
            CIMObjectPath tempOp = new CIMObjectPath();
            tempOp.setObjectName(cc.getName());
            tempOp.setNameSpace(nameSpace);
            LogFile.add(4, "DEBUG_VALUE", "tempOp", tempOp);
            if (ap != null) {
                try {
                    tv = ap.referenceNames(tempOp, path, role);
                }
                catch (CIMException ex) {
                    if (ex.getID().equals("CIM_ERR_NOT_FOUND")) {
                        tv = null;
                    }
                    throw ex;
                }
            } else {
                if (CIMOMImpl.getProviderFactory().getInstanceProvider(nameSpace, cc) != null) continue;
                try {
                    Vector tmpV = ps.referenceNames(tempOp, path, role);
                    tv = new CIMObjectPath[tmpV.size()];
                    tmpV.toArray(tv);
                }
                catch (CIMException ex) {
                    if (ex.getID().equals("CIM_ERR_NOT_FOUND")) {
                        tv = null;
                    }
                    throw ex;
                }
            }
            if (tv == null) continue;
            for (int j = 0; j < tv.length; ++j) {
                fv.addElement(tv[j]);
            }
        }
        return fv;
    }

    public Vector referenceNames(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, String resultClass, String role, ServerSecurity ss) throws CIMException {
        try {
            Vector rt = this.intreferenceNames(nameSpace, objectName, resultClass, role, false);
            return rt;
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    private void repositorySetInstance(CIMNameSpace nameSpace, CIMObjectPath objectName, CIMInstance ci, CIMInstance oci, CIMClass cc, boolean includeQualifiers, String[] propertyList, boolean checkForProvider) throws CIMException {
        if (propertyList == null) {
            oci.updatePropertyValues(ci.getProperties());
        } else {
            for (int i = 0; i < propertyList.length; ++i) {
                CIMProperty cp = ci.getProperty(propertyList[i]);
                if (cp == null) continue;
                String originClass = cp.getOriginClass();
                if (originClass == null || originClass.length() == 0) {
                    oci.setProperty(cp.getName(), cp.getValue());
                    continue;
                }
                oci.updatePropertyValue(cp);
            }
        }
        this.checkInstanceSanity(this.getNameSpace(nameSpace, objectName), oci, cc);
        ps.setInstance(this.getNameSpace(nameSpace, objectName), oci);
        if (!checkForProvider) {
            return;
        }
    }

    CIMClass intgetClass(CIMNameSpace nameSpace, CIMObjectPath objectName, boolean localOnly) throws CIMException {
        nameSpace.setNameSpace('/' + nameSpace.getNameSpace());
        try {
            CIMClass cc = ps.getClass(this.getNameSpace(nameSpace, objectName), objectName.getObjectName().toLowerCase());
            if (cc == null) {
                return null;
            }
            if (localOnly) {
                return this.cu.getLocal(cc);
            }
            return cc;
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    private CIMInstance intgetInstance(CIMNameSpace nameSpace, CIMObjectPath objectName, CIMClass cc, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean providerCall) throws CIMException {
        LogFile.methodEntry("intgetInstance");
        nameSpace.setNameSpace('/' + nameSpace.getNameSpace());
        this.checkAbstractOrIndication(cc);
        CIMInstance nci = cc.newInstance();
        nci.updatePropertyValues(objectName.getKeys());
        CIMObjectPath tempOp = new CIMObjectPath();
        tempOp.setNameSpace(objectName.getNameSpace());
        tempOp.setObjectName(objectName.getObjectName());
        tempOp.setKeys(nci.getKeys());
        CIMInstance ci = null;
        boolean fromProvider = false;
        this.delayedCapabilityCheck(cc, providerCall, READ, this.getNameSpace(nameSpace, tempOp));
        CIMInstanceProvider ip = CIMOMImpl.getProviderFactory().getInstanceProvider(this.getNameSpace(nameSpace, tempOp), cc);
        if (ip != null) {
            tempOp.setObjectName(cc.getName());
            CIMObjectPath tempop = this.createObjectPath(nameSpace, tempOp);
            ci = ip.getInstance(tempop, localOnly, includeQualifiers, includeClassOrigin, propertyList, cc);
            fromProvider = true;
        } else {
            ci = ps.getInstance(this.createObjectPath(this.getNameSpace(nameSpace, tempOp), nci));
            if (ci != null) {
                ci = ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin);
            }
        }
        if (ci == null) {
            return null;
        }
        nci.updatePropertyValues(ci.getProperties());
        if (fromProvider) {
            this.checkInstanceSanity(this.getNameSpace(nameSpace, tempOp), nci, cc);
        }
        if (localOnly) {
            return this.cu.getLocal(nci);
        }
        return nci;
    }

    CIMInstance intgetInstance(CIMNameSpace nameSpace, CIMObjectPath objectName, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean providerCall) throws CIMException {
        LogFile.methodEntry("intgetInstance");
        nameSpace.setNameSpace('/' + nameSpace.getNameSpace());
        CIMClass cc = this.intgetClass(nameSpace, objectName, false);
        if (cc == null) {
            throw new CIMClassException("CIM_ERR_INVALID_CLASS", (Object)objectName.getObjectName());
        }
        return this.intgetInstance(nameSpace, objectName, cc, localOnly, includeQualifiers, includeClassOrigin, propertyList, false);
    }

    private boolean isTrueQual(CIMQualifier cq) {
        if (cq == null) {
            return false;
        }
        CIMValue cv = cq.getValue();
        if (cv == null) {
            return true;
        }
        Boolean b = (Boolean)cv.getValue();
        return b.equals(Boolean.TRUE);
    }

    Vector intinvokeMethod(CIMNameSpace nameSpace, CIMObjectPath objectName, String methodName, Vector inParams, CIMArgument[] inArgs, boolean providerCall) throws CIMException {
        nameSpace.setNameSpace('/' + nameSpace.getNameSpace());
        try {
            Iterator i;
            CIMMethod me;
            String MethodName;
            if (objectName == null || objectName.getObjectName() == null) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            String ns = this.getNameSpace(nameSpace, objectName);
            CIMClass cc = this.intgetClass(nameSpace, objectName, false);
            if (cc == null) {
                throw new CIMException("CIM_ERR_INVALID_CLASS", objectName.getObjectName());
            }
            int trenner = methodName.indexOf(".");
            String ClassName = null;
            String fullName = MethodName = methodName.substring(trenner + 1, methodName.length());
            if (trenner >= 0) {
                ClassName = methodName.substring(0, trenner);
                fullName = ClassName + "." + MethodName;
            }
            if ((me = cc.getMethod(MethodName, ClassName)) == null) {
                throw new CIMMethodException("NO_SUCH_METHOD", (Object)fullName, (Object)cc.getName());
            }
            int numOutParams = 0;
            boolean needValues = false;
            if (inParams != null) {
                needValues = true;
                i = me.getParameters().iterator();
                Iterator iInParams = inParams.iterator();
                ArrayList<CIMArgument> cimArgList = new ArrayList<CIMArgument>();
                while (i.hasNext()) {
                    CIMParameter cp = (CIMParameter)i.next();
                    if (this.isTrueQual(cp.getQualifier(INPARAM))) {
                        Object value = null;
                        if (iInParams.hasNext()) {
                            value = iInParams.next();
                        }
                        if (value != null && !(value instanceof CIMValue)) {
                            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"Not a CIM value", value);
                        }
                        CIMArgument ca = new CIMArgument(cp.getName());
                        ca.setValue((CIMValue)value);
                        cimArgList.add(ca);
                    }
                    if (!this.isTrueQual(cp.getQualifier(OUTPARAM))) continue;
                    ++numOutParams;
                }
                inArgs = new CIMArgument[cimArgList.size()];
                inArgs = cimArgList.toArray(inArgs);
            } else {
                i = me.getParameters().iterator();
                while (i.hasNext()) {
                    CIMParameter cp = (CIMParameter)i.next();
                    if (!this.isTrueQual(cp.getQualifier(OUTPARAM))) continue;
                    ++numOutParams;
                }
            }
            boolean rightsChecked = false;
            CIMMethodProvider mp = CIMOMImpl.getProviderFactory().getMethodProvider(ns, me, cc);
            if (mp == null) {
                mp = CIMOMImpl.getProviderFactory().getMethodProvider(ns, cc);
                if (mp == null) {
                    throw new CIMProviderException("NO_METHOD_PROVIDER", (Object)cc.getName(), (Object)me.getName());
                }
            } else {
                rightsChecked = true;
                this.delayedCapabilityCheck(me, providerCall, WRITE, ns);
            }
            if (!rightsChecked) {
                this.delayedCapabilityCheck(cc, providerCall, WRITE, this.getNameSpace(nameSpace, objectName));
            }
            Vector<Object> outParams = new Vector<Object>();
            CIMArgument[] outParamArray = new CIMArgument[numOutParams];
            CIMObjectPath tempop = new CIMObjectPath();
            tempop.setObjectName(cc.getName());
            tempop.setNameSpace(ns);
            tempop.setKeys(objectName.getKeys());
            CIMValue cv = mp.invokeMethod(tempop, methodName, inArgs, outParamArray);
            outParams.add(cv);
            for (int j = 0; j < outParamArray.length; ++j) {
                if (needValues) {
                    if (outParamArray[j] == null) {
                        throw new CIMException("CIM_ERR_INVALID_PARAMETER", "Null parameter being returned at index " + j);
                    }
                    outParams.add(outParamArray[j].getValue());
                    continue;
                }
                outParams.add(outParamArray[j]);
            }
            LogFile.methodReturn("invokeMethod");
            return outParams;
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    public Vector invokeMethod(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, String methodName, Vector inParams, ServerSecurity ss) throws CIMException {
        LogFile.methodEntry("invokeMethod");
        return this.intinvokeMethod(nameSpace, objectName, methodName, inParams, null, false);
    }

    public Vector invokeMethod(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, String methodName, CIMArgument[] inArgs, ServerSecurity ss) throws CIMException {
        LogFile.methodEntry("invokeMethod");
        return this.intinvokeMethod(nameSpace, objectName, methodName, null, inArgs, false);
    }

    public CIMInstance getInstance(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, boolean localOnly, ServerSecurity ss) throws CIMException {
        try {
            LogFile.methodEntry("getInstance");
            CIMInstance ci = this.intgetInstance(nameSpace, objectName, localOnly, true, true, null, false);
            LogFile.methodReturn("getInstance");
            if (ci == null) {
                throw new CIMInstanceException("CIM_ERR_NOT_FOUND", (Object)objectName.toString());
            }
            return ci;
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    CIMValue intgetProperty(CIMNameSpace nameSpace, CIMObjectPath objectName, String propertyName, boolean providerCall) throws CIMException {
        LogFile.methodEntry("intgetProperty");
        nameSpace.setNameSpace('/' + nameSpace.getNameSpace());
        CIMClass cc = this.intgetClass(nameSpace, objectName, false);
        if (cc == null) {
            throw new CIMClassException("CIM_ERR_INVALID_CLASS", (Object)objectName.getObjectName());
        }
        this.checkAbstractOrIndication(cc);
        CIMProperty propElem = cc.getProperty(propertyName);
        if (propElem == null) {
            throw new CIMPropertyException("CIM_ERR_NOT_FOUND", (Object)propertyName);
        }
        CIMInstance nci = cc.newInstance();
        nci.updatePropertyValues(objectName.getKeys());
        objectName.setKeys(nci.getKeys());
        objectName.setObjectName(cc.getName());
        CIMObjectPath tempop = this.createObjectPath(nameSpace, objectName);
        this.delayedCapabilityCheck(cc, providerCall, WRITE, this.getNameSpace(nameSpace, objectName));
        CIMInstance ci = null;
        CIMInstanceProvider ip = CIMOMImpl.getProviderFactory().getInstanceProvider(this.getNameSpace(nameSpace, objectName), cc);
        ci = ip != null ? ip.getInstance(tempop, false, false, false, null, cc) : ps.getInstance(this.createObjectPath(this.getNameSpace(nameSpace, objectName), nci));
        if (ci == null) {
            LogFile.methodReturn("intgetProperty");
            return null;
        }
        propElem = ci.getProperty(propertyName);
        if (propElem == null) {
            throw new CIMProviderException("CIM_ERR_NOT_FOUND", (Object)propertyName);
        }
        LogFile.methodReturn("intgetProperty");
        return propElem.getValue();
    }

    public CIMValue getProperty(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, String propertyName, ServerSecurity ss) throws CIMException {
        try {
            LogFile.methodEntry("getProperty");
            LogFile.methodReturn("getProperty");
            return this.intgetProperty(nameSpace, objectName, propertyName, false);
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    public CIMQualifierType getQualifierType(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, ServerSecurity ss) throws CIMException {
        try {
            CIMQualifierType qt = CIMQtypeStaticMethods.getQualifierType(nameSpace, objectName);
            if (qt == null) {
                throw new CIMQualifierTypeException("CIM_ERR_NOT_FOUND", (Object)objectName.getObjectName());
            }
            return qt;
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    private String getNameSpace(CIMNameSpace ns, CIMObjectPath op) {
        CIMNameSpace cns = new CIMNameSpace();
        if (ns != null) {
            StringBuffer s = new StringBuffer(ns.getNameSpace());
            s.append('/');
            if (op != null) {
                s.append(op.getNameSpace());
            }
            cns.setNameSpace(s.toString());
        }
        return cns.getNameSpace();
    }

    void intdeleteClass(CIMNameSpace ns, CIMObjectPath inpath) throws CIMException {
        ns.setNameSpace('/' + ns.getNameSpace());
        String nameSpace = this.getNameSpace(ns, inpath);
        CIMObjectPath path = new CIMObjectPath();
        path.setNameSpace(nameSpace);
        path.setObjectName(inpath.getObjectName());
        CIMClass cc = this.intgetClass(ns, inpath, false);
        String temp = path.getObjectName();
        if (temp == null || temp.equalsIgnoreCase("top")) {
            temp = "";
        }
        if (cc == null && temp.length() != 0 && !temp.equalsIgnoreCase("top")) {
            throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)path.getObjectName().toLowerCase());
        }
        Vector v1 = this.intenumClass(ns, inpath, false);
        if (v1.size() > 0) {
            throw new CIMClassException("CIM_ERR_CLASS_HAS_CHILDREN", (Object)cc.getName());
        }
        Vector tmpV = ps.enumerateInstances(path, false);
        if (tmpV.size() > 0) {
            throw new CIMClassException("CIM_ERR_CLASS_HAS_INSTANCES", (Object)cc.getName());
        }
        ps.deleteClass(path);
    }

    public void deleteClass(String version, CIMNameSpace ns, CIMObjectPath path, ServerSecurity ss) throws CIMException {
        try {
            LogFile.methodEntry("deleteClass");
            this.verifyCapabilities(ss, WRITE, this.getNameSpace(ns, path));
            this.intdeleteClass(ns, path);
            LogFile.methodReturn("deleteClass");
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    void intdeleteInstance(CIMNameSpace ns, CIMObjectPath inpath, boolean providerCall) throws CIMException {
        ns.setNameSpace('/' + ns.getNameSpace());
        String nameSpace = this.getNameSpace(ns, inpath);
        CIMObjectPath path = new CIMObjectPath();
        path.setNameSpace(nameSpace);
        path.setObjectName(inpath.getObjectName());
        path.setKeys(inpath.getKeys());
        CIMClass cc = this.intgetClass(ns, inpath, false);
        if (cc == null) {
            throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)path.getObjectName());
        }
        this.checkAbstractOrIndication(cc);
        this.delayedCapabilityCheck(cc, providerCall, WRITE, nameSpace);
        CIMInstanceProvider ip = CIMOMImpl.getProviderFactory().getInstanceProvider(nameSpace, cc);
        if (ip == null) {
            path.setObjectName(cc.getName());
            ps.deleteInstance(path);
        } else {
            ip.deleteInstance(path);
        }
    }

    public void deleteInstance(String version, CIMNameSpace ns, CIMObjectPath path, ServerSecurity ss) throws CIMException {
        try {
            LogFile.methodEntry("deleteInstance");
            this.intdeleteInstance(ns, path, false);
            LogFile.methodReturn("deleteInstance");
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    public void deleteQualifierType(String version, CIMNameSpace ns, CIMObjectPath path, ServerSecurity ss) throws CIMException {
        try {
            this.verifyCapabilities(ss, WRITE, this.getNameSpace(ns, path));
            this.checkMemory();
            LogFile.methodEntry("deleteQualifierType");
            CIMQtypeStaticMethods.removeCIMElement(ns, path);
            LogFile.methodReturn("deleteQualifiertype");
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    public Vector enumNameSpace(String version, CIMNameSpace ns, CIMObjectPath path, boolean deep, ServerSecurity ss) throws CIMException {
        try {
            LogFile.methodEntry("enumNameSpace");
            this.verifyCapabilities(ss, READ, this.getNameSpace(ns, path));
            Vector rt = CIMNSStaticMethods.enumNameSpace(ns, path, deep);
            LogFile.methodReturn("enumNameSpace");
            return rt;
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    Vector intenumClass(CIMNameSpace ns, CIMObjectPath inpath, boolean deep) throws CIMException {
        ns.setNameSpace('/' + ns.getNameSpace());
        String nameSpace = this.getNameSpace(ns, inpath);
        CIMObjectPath path = new CIMObjectPath();
        path.setNameSpace(nameSpace);
        if (inpath != null) {
            path.setObjectName(inpath.getObjectName());
        }
        return ps.enumerateClasses(path, deep);
    }

    Vector intenumClass(CIMNameSpace ns, CIMObjectPath inpath, boolean deep, boolean localOnly) throws CIMException {
        ns.setNameSpace('/' + ns.getNameSpace());
        String nameSpace = this.getNameSpace(ns, inpath);
        CIMObjectPath path = new CIMObjectPath();
        path.setNameSpace(nameSpace);
        if (inpath != null) {
            path.setObjectName(inpath.getObjectName());
        }
        return ps.enumerateClasses(path, deep, localOnly);
    }

    Vector intenumInstances(CIMNameSpace ns, CIMObjectPath inpath, boolean deep, boolean providerCall) throws CIMException {
        String on;
        ns.setNameSpace('/' + ns.getNameSpace());
        String nameSpace = this.getNameSpace(ns, inpath);
        CIMObjectPath path = new CIMObjectPath();
        path.setNameSpace(nameSpace);
        path.setObjectName(inpath.getObjectName());
        path.setKeys(inpath.getKeys());
        Vector v = new Vector();
        Vector<CIMObjectPath> fv = new Vector<CIMObjectPath>();
        if (deep) {
            v = this.intenumClass(ns, inpath, deep);
        }
        if ((on = path.getObjectName()) != null && on.length() != 0 && !on.equals("top")) {
            v.insertElementAt(path, 0);
        }
        CIMObjectPath[] ops = new CIMObjectPath[v.size()];
        v.toArray(ops);
        for (int i = 0; i < ops.length; ++i) {
            CIMObjectPath[] tv;
            CIMObjectPath op = ops[i];
            op.setKeys(path.getKeys());
            LogFile.add(4, "DEBUG_VALUE", "op", op.getObjectName());
            String tns = ns.getNameSpace();
            ns.setNameSpace("");
            CIMClass cc = this.intgetClass(ns, op, false);
            ns.setNameSpace(tns);
            if (cc == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)op.getObjectName());
            }
            this.checkIndication(cc);
            this.delayedCapabilityCheck(cc, providerCall, READ, nameSpace);
            CIMInstanceProvider ip = CIMOMImpl.getProviderFactory().getInstanceProvider(nameSpace, cc);
            if (ip != null) {
                op.setObjectName(cc.getName());
                tv = ip.enumerateInstanceNames(op, cc);
            } else {
                Vector tmpV = ps.enumerateInstances(op, false);
                tv = new CIMObjectPath[tmpV.size()];
                tmpV.toArray(tv);
            }
            if (tv == null) continue;
            for (int j = 0; j < tv.length; ++j) {
                fv.addElement(tv[j]);
            }
        }
        return fv;
    }

    public Vector enumInstances(String version, CIMNameSpace ns, CIMObjectPath path, boolean deep, ServerSecurity ss) throws CIMException {
        try {
            Boolean bln = deep ? Boolean.TRUE : Boolean.FALSE;
            return this.intenumInstances(ns, path, deep, false);
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    Vector intenumInstances(CIMNameSpace ns, CIMObjectPath inpath, boolean deep, boolean localOnly, boolean providerCall) throws CIMException {
        String on;
        ns.setNameSpace('/' + ns.getNameSpace());
        String nameSpace = this.getNameSpace(ns, inpath);
        CIMObjectPath path = new CIMObjectPath();
        path.setNameSpace(nameSpace);
        path.setObjectName(inpath.getObjectName());
        path.setKeys(inpath.getKeys());
        Vector v = new Vector();
        Vector<CIMInstance> fv = new Vector<CIMInstance>();
        CIMInstance[] tv = null;
        if (deep) {
            v = this.intenumClass(ns, inpath, deep);
        }
        if ((on = path.getObjectName()) != null && on.length() != 0 && !on.equals("top")) {
            v.insertElementAt(path, 0);
        }
        CIMObjectPath[] ops = new CIMObjectPath[v.size()];
        v.toArray(ops);
        for (int i = 0; i < ops.length; ++i) {
            CIMObjectPath op = ops[i];
            op.setKeys(path.getKeys());
            LogFile.add(4, "DEBUG_VALUE", "op", op.getObjectName());
            String tns = ns.getNameSpace();
            ns.setNameSpace("");
            CIMClass cc = this.intgetClass(ns, op, false);
            ns.setNameSpace(tns);
            if (cc == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)op.getObjectName());
            }
            this.checkIndication(cc);
            this.delayedCapabilityCheck(cc, providerCall, READ, nameSpace);
            CIMInstanceProvider ip = CIMOMImpl.getProviderFactory().getInstanceProvider(nameSpace, cc);
            if (ip != null) {
                op.setObjectName(cc.getName());
                tv = ip.enumerateInstances(op, localOnly, true, true, null, cc);
            } else {
                Vector tmpV = ps.enumerateInstances(op, false, localOnly);
                tv = new CIMInstance[tmpV.size()];
                tmpV.toArray(tv);
            }
            if (tv == null) continue;
            for (int j = 0; j < tv.length; ++j) {
                fv.addElement(tv[j]);
            }
        }
        return fv;
    }

    public Vector enumInstances(String version, CIMNameSpace ns, CIMObjectPath path, boolean deep, boolean localOnly, ServerSecurity ss) throws CIMException {
        try {
            Boolean bln = deep ? Boolean.TRUE : Boolean.FALSE;
            return this.intenumInstances(ns, path, deep, localOnly, false);
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    public Vector enumQualifierTypes(String version, CIMNameSpace ns, CIMObjectPath path, ServerSecurity ss) throws CIMException {
        try {
            LogFile.methodEntry("enumQualifierTypes");
            this.verifyCapabilities(ss, READ, this.getNameSpace(ns, path));
            Vector rt = CIMQtypeStaticMethods.enumQualifierTypes(ns, path);
            LogFile.methodReturn("enumQualifierTypes");
            return rt;
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    private void checkSubClassModification(CIMNameSpace ns, CIMObjectPath op, CIMClass cc, CIMClass parentClass, List modifiedClassList) throws CIMException {
        CIMObjectPath lop = new CIMObjectPath();
        lop.setNameSpace(op.getNameSpace());
        lop.setObjectName(cc.getName());
        this.classCheck.checkClassSanity(this.getNameSpace(ns, lop), cc, parentClass);
        Vector v = this.intenumClass(ns, lop, false, false);
        Enumeration subClasses = v.elements();
        modifiedClassList.add(cc);
        while (subClasses.hasMoreElements()) {
            CIMClass scc = (CIMClass)subClasses.nextElement();
            this.checkSubClassModification(ns, lop, scc.localElements(), cc, modifiedClassList);
        }
    }

    List determineUpdateProps(CIMClass newcc, CIMClass oldcc) {
        HashMap<String, CIMProperty> propMap = new HashMap<String, CIMProperty>();
        Enumeration e = oldcc.getProperties().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            String key = cp.getOriginClass().toLowerCase() + ":" + cp.getName();
            propMap.put(key, cp);
        }
        e = newcc.getProperties().elements();
        ArrayList<String> updateList = new ArrayList<String>();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            String key = cp.getOriginClass().toLowerCase() + ":" + cp.getName();
            CIMProperty oldcp = (CIMProperty)propMap.get(key);
            if (oldcp == null || !oldcp.getType().equals((Object)cp.getType())) continue;
            updateList.add(cp.getOriginClass());
            updateList.add(cp.getName());
        }
        return updateList;
    }

    private void updateModPropertyValues(CIMInstance newci, CIMInstance oldci, List updateList) {
        Iterator i = updateList.iterator();
        while (i.hasNext()) {
            String originClass = (String)i.next();
            String pName = (String)i.next();
            CIMProperty newcp = newci.getProperty(pName, originClass);
            newcp.setValue(oldci.getProperty(pName, originClass).getValue());
        }
    }

    private void updateInstances(CIMNameSpace ns, CIMObjectPath op, List modifiedClassList) throws CIMException {
        CIMObjectPath lop = new CIMObjectPath();
        lop.setNameSpace(this.getNameSpace(ns, op));
        for (int i = modifiedClassList.size() - 1; i >= 0; --i) {
            CIMClass cc = (CIMClass)modifiedClassList.get(i);
            lop.setObjectName(cc.getName());
            CIMClass oldcc = this.intgetClass(new CIMNameSpace("", ""), lop, false);
            List propsToUpdate = this.determineUpdateProps(cc, oldcc);
            ps.setClass(lop.getNameSpace(), cc);
            Enumeration instEnum = ps.enumerateInstances(lop, false).elements();
            while (instEnum.hasMoreElements()) {
                CIMInstance newci = cc.newInstance();
                CIMObjectPath oldip = (CIMObjectPath)instEnum.nextElement();
                CIMInstance oldci = ps.getInstance(oldip);
                this.updateModPropertyValues(newci, oldci, propsToUpdate);
                ps.setInstance(lop.getNameSpace(), newci);
            }
        }
    }

    void intModifyClass(CIMNameSpace nameSpace, CIMObjectPath objectName, CIMClass cc) throws CIMException {
        CIMNameSpace lns = new CIMNameSpace();
        lns.setNameSpace("//" + nameSpace.getNameSpace());
        CIMObjectPath lop = new CIMObjectPath();
        lop.setObjectName(cc.getName());
        lop.setNameSpace(objectName.getNameSpace());
        CIMClass icc = this.intgetClass(lns, lop, false);
        if (icc == null) {
            throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)cc.getName());
        }
        Vector oldKeys = icc.getKeys();
        this.classCheck.checkClassSanity(this.getNameSpace(lns, lop), cc, null);
        this.classCheck.compareKeys(oldKeys, cc.getKeys());
        Vector v = this.intenumClass(lns, lop, false, false);
        Enumeration subClasses = v.elements();
        ArrayList<CIMClass> modifiedClassList = new ArrayList<CIMClass>();
        modifiedClassList.add(cc);
        while (subClasses.hasMoreElements()) {
            CIMClass scc = (CIMClass)subClasses.nextElement();
            this.checkSubClassModification(lns, lop, scc.localElements(), cc, modifiedClassList);
        }
        this.updateInstances(lns, lop, modifiedClassList);
    }

    void intMofregRemoveClass(CIMNameSpace ns, CIMObjectPath inpath) throws CIMException {
        CIMNameSpace tns = new CIMNameSpace();
        tns.setNameSpace('/' + ns.getNameSpace());
        tns.setHost(ns.getHost());
        String nameSpace = this.getNameSpace(ns, inpath);
        CIMObjectPath path = new CIMObjectPath();
        path.setNameSpace(nameSpace);
        path.setObjectName(inpath.getObjectName());
        CIMClass cc = this.intgetClass(tns, inpath, false);
        String temp = path.getObjectName();
        if (temp == null || temp.equalsIgnoreCase("top")) {
            temp = "";
        }
        if (cc == null && temp.length() != 0 && !temp.equalsIgnoreCase("top")) {
            throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)path.getObjectName().toLowerCase());
        }
        Vector v1 = this.intenumClass(ns, inpath, false);
        if (v1.size() > 0) {
            throw new CIMClassException("CIM_ERR_CLASS_HAS_CHILDREN", (Object)cc.getName());
        }
        Enumeration instEnum = ps.enumerateInstances(path, false).elements();
        while (instEnum.hasMoreElements()) {
            CIMObjectPath ip = (CIMObjectPath)instEnum.nextElement();
            ps.deleteInstance(ip);
        }
        ps.deleteClass(path);
    }

    private void initTrace() {
        String level = System.getProperty("wbem.debug.level");
        String device = System.getProperty("wbem.debug.device");
        if (device != null && device.equalsIgnoreCase("file")) {
            device = "wbem_server";
        }
        Debug.traceOpen((String)level, (String)device);
        Debug.trace1((String)"Starting CIMOM server...");
    }

    private void initializeServices(Properties props) throws Exception {
        String libdir = System.getProperty("propdir", "/usr/sadm/lib/wbem");
        String basedir = libdir + File.separatorChar + ".." + File.separatorChar + ".." + File.separatorChar + ".." + File.separatorChar + "..";
        this.mofreg = Mofregistry.getMofregistry(this, basedir + File.separatorChar + "var" + File.separatorChar + "sadm" + File.separatorChar + "wbem" + File.separatorChar + "logr", "regDir", "unregDir", "failDir", "preReg", "preUnreg");
        LogFile.initialize(new ProviderClient(this));
        this.initLogService();
        StringBuffer sb = new StringBuffer();
        sb.append(1);
        sb.append(".");
        sb.append(0);
        sb.append(".");
        sb.append(0);
        String versionString = sb.toString();
        String[] logArgs = new String[]{versionString, "11/01/04:10:48"};
        this.logMessage("STARTMSG", "STARTMSGDETAIL", logArgs, null, false, 2, 0);
        Debug.trace1((String)("Starting CIMOM " + versionString));
        this.upp = ServerSecurity.getUserPasswordProvider();
        this.eventService = new EventService(ps, this.cu, this, new ProviderClient(this), props);
        ProviderAdapterFactory factory = CIMOMImpl.getProviderFactory();
        ClientProtocolAdapterService cpaService = new ClientProtocolAdapterService(new ProviderClient(this), this);
        InternalProviderAdapter ppa = new InternalProviderAdapter();
        ppa.serviceProviderArray = new InternalProviderAdapter.InternalServiceProvider[]{new CIMOMProviderHolder(), factory, this.eventService, cpaService};
        ppa.cimom = this;
        factory.RegisterProtocolProvider("internal", ppa, true);
        try {
            this.mofreg.mofReg();
        }
        catch (Exception e) {
            Debug.trace2((String)"Mofreg failure", (Throwable)e);
            this.mofreg.logException(e);
        }
        cpaService.startAdapters();
    }

    private void initLogService() {
        try {
            Class<?> c = Class.forName("org.wbemservices.wbem.utility.log.CIMOMLogUtil");
            Class[] paramTypes = new Class[]{class$javax$wbem$client$CIMOMHandle == null ? (class$javax$wbem$client$CIMOMHandle = CIMOMImpl.class$("javax.wbem.client.CIMOMHandle")) : class$javax$wbem$client$CIMOMHandle};
            Object[] paramList = new Object[]{new ProviderClient(this)};
            Method initMethod = c.getMethod("getInstance", paramTypes);
            CIMOMLogService ls = (CIMOMLogService)initMethod.invoke(null, paramList);
            ServiceRegistry.addService("logservice", ls);
        }
        catch (Throwable e) {
            Debug.trace1((String)"Log service init failed", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            CIMOMImpl cimom = new CIMOMImpl(args);
            String argsString = "";
            if (args.length > 0) {
                argsString = args[0];
            }
            for (int i = 1; i < args.length; ++i) {
                argsString = argsString.concat(" " + args[i]);
            }
            LogFile.add(2, "COMMAND_LINE_STR", argsString);
        }
        catch (Exception e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            System.out.println(e);
            System.exit(1);
        }
        catch (Error e) {
            Debug.trace2((String)"Got exception", (Throwable)e);
            System.out.println(e);
            System.exit(1);
        }
    }

    private void parseCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-help")) {
                System.out.println(I18N.loadString("COMMAND_LINE_ARGS"));
                System.exit(0);
            }
            if (args[i].equalsIgnoreCase("-l0")) {
                LogFile.setLevel(0);
                LogFile.start();
            }
            if (args[i].equalsIgnoreCase("-l1")) {
                LogFile.setLevel(1);
                LogFile.start();
            }
            if (args[i].equalsIgnoreCase("-l2")) {
                LogFile.setLevel(2);
                LogFile.start();
            }
            if (args[i].equalsIgnoreCase("-l3")) {
                LogFile.setLevel(3);
                LogFile.start();
            }
            if (args[i].equalsIgnoreCase("-lDev")) {
                LogFile.setLevel(4);
                verbose = true;
                PSRlogImpl.verbose = true;
                LogFile.start();
            }
            if (args[i].equalsIgnoreCase("-s")) {
                if (++i >= args.length) {
                    System.out.println(I18N.loadString("INVALID_ARG"));
                    System.out.println(I18N.loadString("COMMAND_LINE_ARGS"));
                    throw new IllegalArgumentException(I18N.loadString("INVALID_ARG") + "\n" + I18N.loadString("COMMAND_LINE_ARGS"));
                }
                this.dbHost = args[i];
            }
            if (!args[i].equalsIgnoreCase("-version")) continue;
            System.out.println(CIMOMVersion.getProductName() + " " + CIMOMVersion.getVersion() + " (" + CIMOMVersion.getBuildDate() + ")");
            System.exit(0);
        }
    }

    public void initialize(CIMOMHandle ch) throws CIMException {
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        Vector v = ps.enumerateInstances(op, false);
        CIMObjectPath[] copArray = new CIMObjectPath[v.size()];
        v.toArray(copArray);
        return copArray;
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        Vector v = ps.enumerateInstances(op, false, localOnly);
        int j = v.size();
        CIMInstance[] ciArray = new CIMInstance[j];
        for (int i = 0; i < j; ++i) {
            CIMInstance ci = (CIMInstance)v.elementAt(i);
            if (localOnly) {
                ci = ci.localElements();
            }
            ciArray[i] = ci = ci.filterProperties(propList, includeQualifiers, includeClassOrigin);
        }
        return ciArray;
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        CIMInstance ci;
        boolean solaris_useracl = op.getObjectName().equalsIgnoreCase("solaris_useracl");
        boolean solaris_namespaceacl = op.getObjectName().equalsIgnoreCase("solaris_namespaceacl");
        if (solaris_useracl || solaris_namespaceacl) {
            Enumeration e = op.getKeys().elements();
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (!cp.getName().equalsIgnoreCase("nspace")) continue;
                String namespace = (String)cp.getValue().getValue();
                CIMNameSpace tns = new CIMNameSpace("", '/' + namespace);
                namespace = tns.getNameSpace();
                namespace = namespace.substring(1, namespace.length());
                cp.setValue(new CIMValue((Object)namespace));
            }
        }
        if ((ci = ps.getInstance(op)) == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)op);
        }
        if (localOnly) {
            return this.cu.getLocal(ci);
        }
        return ci.filterProperties(propList, includeQualifiers, includeClassOrigin);
    }

    private void aclCheck(CIMInstance ci) throws CIMException {
        String username;
        boolean solaris_useracl = ci.getClassName().equalsIgnoreCase("solaris_useracl");
        boolean solaris_namespaceacl = ci.getClassName().equalsIgnoreCase("solaris_namespaceacl");
        if (solaris_useracl && this.upp.getEncryptedPassword(username = (String)ci.getProperty("username").getValue().getValue(), 0) == null) {
            throw new CIMSecurityException("NO_SUCH_PRINCIPAL", (Object)username);
        }
        if (solaris_useracl || solaris_namespaceacl) {
            String tnamespace = (String)ci.getProperty("nSpace").getValue().getValue();
            CIMNameSpace cns = new CIMNameSpace("", '/' + tnamespace);
            tnamespace = cns.getNameSpace();
            if ((tnamespace = tnamespace.substring(1, tnamespace.length())).equals(SECURITYNS)) {
                CIMValue cv;
                CIMProperty capProp = ci.getProperty("capability");
                String cap = null;
                if (capProp != null && (cv = capProp.getValue()) != null) {
                    cap = (String)cv.getValue();
                }
                if (cap == null) {
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER", tnamespace + ":" + cap);
                }
                if (!cap.equals("r") && !cap.equals("rw")) {
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER", tnamespace + ":" + cap);
                }
            }
            ci.setProperty("nSpace", new CIMValue((Object)tnamespace));
        }
    }

    public CIMValue invokeMethod(CIMObjectPath op, String methodName, CIMArgument[] inArgs, CIMArgument[] outArgs) throws CIMException {
        if (op.getNameSpace().equalsIgnoreCase(SYSTEMNS) && op.getObjectName().equalsIgnoreCase("Solaris_CIMOM")) {
            if (methodName.equalsIgnoreCase("registerMOF")) {
                Debug.trace2((String)"registerMOF method invoked");
                try {
                    this.mofreg.mofReg();
                }
                catch (CIMException ce) {
                    Debug.trace1((String)"registerMOF exception", (Throwable)ce);
                    throw ce;
                }
                catch (Exception e) {
                    Debug.trace1((String)"registerMOF exception", (Throwable)e);
                    throw new CIMException("CIM_ERR_FAILED", e.toString());
                }
                Debug.trace2((String)"registerMOF method completed");
                return new CIMValue((Object)new Byte(0));
            }
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        CIMOMImpl.this.concurrentObj.writeLock();
                        Thread.sleep(2000L);
                        System.exit(0);
                    }
                    catch (Exception e) {
                        System.out.println(e);
                    }
                    catch (Error e) {
                        System.out.println(e);
                    }
                    finally {
                        System.exit(1);
                    }
                }
            }.start();
            return new CIMValue((Object)new Byte(0));
        }
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        if (op.getNameSpace().equalsIgnoreCase(SYSTEMNS) && ci.getClassName().equalsIgnoreCase("Solaris_CIMOM")) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        this.aclCheck(ci);
        ps.addCIMElement(op.getNameSpace(), ci);
        return null;
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci, boolean includeQualifier, String[] propertyList) throws CIMException {
        if (op.getNameSpace().equalsIgnoreCase(SYSTEMNS) && ci.getClassName().equalsIgnoreCase("Solaris_CIMOM")) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        this.aclCheck(ci);
        if (propertyList != null || !includeQualifier) {
            this.intsetCIMElement(new CIMNameSpace("", ""), op, ci, true, includeQualifier, propertyList, false);
        } else {
            ps.setInstance(op.getNameSpace(), ci);
        }
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        if (op.getNameSpace().equalsIgnoreCase(SYSTEMNS) && op.getObjectName().equalsIgnoreCase("Solaris_CIMOM")) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        ps.deleteInstance(op);
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        Vector v = ps.execQuery(op, query, ql, cc);
        CIMInstance[] ciArray = new CIMInstance[v.size()];
        v.toArray(ciArray);
        return ciArray;
    }

    public CIMInstance[] associators(CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        if (objectName == null || objectName.getKeys() == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)objectName, (Object)"Need an instance name");
        }
        Vector v = this.commonAssociators(assocName, objectName, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList);
        CIMInstance[] ciArray = new CIMInstance[v.size()];
        return v.toArray(ciArray);
    }

    public CIMObjectPath[] associatorNames(CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole) throws CIMException {
        Vector v = ps.associatorNames(assocName, objectName, resultClass, role, resultRole);
        CIMObjectPath[] copArray = new CIMObjectPath[v.size()];
        v.toArray(copArray);
        return copArray;
    }

    public CIMInstance[] references(CIMObjectPath assocName, CIMObjectPath objectName, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        if (objectName == null || objectName.getKeys() == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)objectName, (Object)"Need an instance name");
        }
        Vector v = ps.reference(assocName, objectName, role, includeQualifiers, includeClassOrigin, propertyList);
        CIMInstance[] ciArray = new CIMInstance[v.size()];
        return v.toArray(ciArray);
    }

    public CIMObjectPath[] referenceNames(CIMObjectPath assocName, CIMObjectPath objectName, String role) throws CIMException {
        Vector v = ps.referenceNames(assocName, objectName, role);
        CIMObjectPath[] copArray = new CIMObjectPath[v.size()];
        v.toArray(copArray);
        return copArray;
    }

    private void checkReadWritePermission(String operation, ServerSecurity ss) throws CIMSecurityException {
        this.checkPermission(operation, ss, true);
        this.checkPermission(operation, ss, false);
    }

    private void checkPermission(String operation, ServerSecurity ss, boolean bRead) throws CIMSecurityException {
        String op = bRead ? READ : WRITE;
        String opCap = bRead ? "r" : "w";
        String cap = ss.getCapability();
        if (operation.equals(op) && !cap.equalsIgnoreCase(opCap) && !cap.equalsIgnoreCase("rw")) {
            throw new CIMSecurityException("CIM_ERR_ACCESS_DENIED");
        }
    }

    private void setCapability(String rw, String namespace, ServerSecurity ss) {
        ss.setCapability(rw);
        ss.setCapabilityNS(namespace);
    }

    public static final void copyFile(DataInput in, DataOutput out, long length) throws IOException {
        boolean fileCopyComplete = false;
        byte[] copyBuffer = new byte[5120];
        long totalBytesCopied = 0L;
        while (!fileCopyComplete) {
            int copySize = (int)(length - totalBytesCopied);
            if (copySize > copyBuffer.length) {
                copySize = copyBuffer.length;
            }
            in.readFully(copyBuffer, 0, copySize);
            out.write(copyBuffer, 0, copySize);
            fileCopyComplete = (totalBytesCopied += (long)copySize) >= length;
        }
    }

    static ProviderAdapterFactory getProviderFactory() {
        return mProvFactory;
    }

    private void updateClasspath() throws Exception {
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl instanceof DynClassLoader) {
            DynClassLoader dcl = (DynClassLoader)cl;
            CIMObjectPath provPath = new CIMObjectPath("WBEMServices_Classpath");
            provPath.setNameSpace(INTEROPNS);
            CIMObjectPath[] ops = this.enumerateInstanceNames(provPath, null);
            for (int i = 0; i < ops.length; ++i) {
                CIMObjectPath pathOp = ops[i];
                CIMProperty pathProp = (CIMProperty)pathOp.getKeys().elementAt(0);
                String url = (String)pathProp.getValue().getValue();
                dcl.addToClassPath(url);
            }
        } else {
            Debug.trace2((String)"DynClassLoader not used, will not search for CIMOM classpaths");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        inBuild = false;
        mProvFactory = null;
    }

    private class CIMOMProviderHolder
    implements InternalProviderAdapter.InternalServiceProvider {
        private static final String WBEMSERVICES_OBJECTMANAGER = "WBEMServices_ObjectManager";
        private static final String CIM_NAMESPACE = "CIM_Namespace";
        private static final String CIM_NS_IN_MANAGER = "CIM_NamespaceInManager";
        private CIMProvider cimomProvider;
        private CIMProvider namespaceProvider;
        private CIMProvider nsInManagerProvider;

        private CIMOMProviderHolder() {
            this.cimomProvider = new CIMOMProvider(CIMOMImpl.this.mofreg);
            this.namespaceProvider = new NamespaceProvider();
            this.nsInManagerProvider = new NamespaceInManagerProvider();
        }

        public String[] getProviderNames() {
            return new String[]{WBEMSERVICES_OBJECTMANAGER, CIM_NAMESPACE, CIM_NS_IN_MANAGER};
        }

        public CIMProvider getProvider(String providerName) throws CIMException {
            if (providerName.equalsIgnoreCase(CIM_NAMESPACE)) {
                return this.namespaceProvider;
            }
            if (providerName.equalsIgnoreCase(CIM_NS_IN_MANAGER)) {
                return this.nsInManagerProvider;
            }
            return this.cimomProvider;
        }
    }
}

