/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.cimom;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMPropertyException;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.Debug;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.CIMInstanceProvider;
import javax.wbem.provider.CIMMethodProvider;
import javax.wbem.provider.CIMProvider;
import org.wbemservices.wbem.cimom.CIMOMProvider;
import org.wbemservices.wbem.cimom.CIMOMServer;
import org.wbemservices.wbem.cimom.InternalProviderAdapter;
import org.wbemservices.wbem.cimom.OneToManyAssocProvider;
import org.wbemservices.wbem.cimom.adapter.client.ClientProtocolAdapterIF;
import org.wbemservices.wbem.cimom.util.DynClassLoader;

public class ClientProtocolAdapterService
implements InternalProviderAdapter.InternalServiceProvider {
    private static final String CPA_CIM_CLASS = "WBEMServices_ObjectManagerClientProtocolAdapter";
    private static final String CPA_ASSOC_CLASS = "WBEMServices_ClientProtocolAdapterForManager";
    private static final String COMMMECH_ASSOC_CLASS = "CIM_CommMechanismForManager";
    private static final String STARTSERVICE = "StartService";
    private static final String STOPSERVICE = "StopService";
    private static final String IMPLCLASS = "ImplClass";
    private static final String CLASSPATH = "classPath";
    private static final String PROTOCOLTYPE = "Name";
    private ProviderCIMOMHandle pch;
    private AdapterProvider ap;
    private AdapterAssocProvider assocProvider;
    private CIMProvider commMechAssocProvider;
    private CIMOMServer cimom;
    private Map adapterMap = Collections.synchronizedMap(new HashMap());

    public String[] getProviderNames() {
        return new String[]{CPA_CIM_CLASS, CPA_ASSOC_CLASS, COMMMECH_ASSOC_CLASS};
    }

    public CIMProvider getProvider(String className) throws CIMException {
        if (className.equals(CPA_CIM_CLASS)) {
            return this.ap;
        }
        if (className.equals(COMMMECH_ASSOC_CLASS)) {
            return this.commMechAssocProvider;
        }
        return this.assocProvider;
    }

    void startAdapters() throws Exception {
        try {
            CIMObjectPath cop = new CIMObjectPath(CPA_CIM_CLASS);
            cop.setNameSpace("/interop");
            Enumeration protocols = this.pch.enumerateInstances(cop, true, false, true, true, null);
            while (protocols.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)protocols.nextElement();
                try {
                    this.handleAdapterInstance(ci);
                }
                catch (Exception e) {
                    Debug.trace1((String)"Client adapter registration failed", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            System.err.println("!!!XXX: RegisterClientAdapter: Exception");
            Debug.trace1((String)"Client adapter registration failed", (Throwable)e);
            e.printStackTrace();
        }
    }

    ClientProtocolAdapterService(ProviderCIMOMHandle pch, CIMOMServer cimom) {
        this.pch = pch;
        this.ap = new AdapterProvider();
        this.assocProvider = new AdapterAssocProvider();
        this.commMechAssocProvider = new CommMechAssocProvider();
        this.cimom = cimom;
        CIMObjectPath classOp = new CIMObjectPath("CIM_ObjectManagerCommunicationMechanism", "/interop");
        try {
            Enumeration e = pch.enumerateInstanceNames(classOp);
            while (e.hasMoreElements()) {
                CIMObjectPath op = (CIMObjectPath)e.nextElement();
                try {
                    pch.deleteInstance(op);
                }
                catch (CIMException dce) {
                    Debug.trace2((String)"Exception deleting instance of CommMech", (Throwable)dce);
                }
            }
        }
        catch (CIMException ce) {
            Debug.trace2((String)"Exception getting instances of CommMech", (Throwable)ce);
        }
    }

    private void handleAdapterInstance(CIMInstance ci) throws CIMException {
        String protocolType;
        Debug.trace3((String)("Handling client protocol " + ci));
        ClientProtocolAdapterIF adapter = null;
        try {
            CIMProperty pathProp = ci.getProperty(CLASSPATH);
            CIMValue pathVal = pathProp.getValue();
            String[] path = new String[]{};
            if (pathVal != null && !pathVal.isNull() && pathVal.getType().getType() == 22) {
                Vector vec = (Vector)pathVal.getValue();
                path = vec.toArray(new String[vec.size()]);
            }
            DynClassLoader dcl = new DynClassLoader(path, this.getClass().getClassLoader());
            CIMProperty cp = ci.getProperty(IMPLCLASS);
            CIMValue cv = cp.getValue();
            String className = (String)cv.getValue();
            Class<?> cl = dcl.loadClass(className);
            adapter = (ClientProtocolAdapterIF)cl.newInstance();
        }
        catch (Exception e) {
            Debug.trace2((String)"Adapter instance failed", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
        try {
            protocolType = (String)ci.getProperty(PROTOCOLTYPE).getValue().getValue();
        }
        catch (NullPointerException ex) {
            throw new CIMPropertyException("CIM_ERR_INVALID_PARAMETER", (Object)PROTOCOLTYPE);
        }
        if (protocolType.trim().length() == 0) {
            throw new CIMPropertyException("CIM_ERR_INVALID_PARAMETER", (Object)PROTOCOLTYPE);
        }
        String automatic = "";
        try {
            automatic = (String)ci.getProperty("StartMode").getValue().getValue();
        }
        catch (Exception ex) {
            // empty catch block
        }
        adapter.initialize(this.cimom, (CIMOMHandle)this.pch);
        if (automatic.equalsIgnoreCase("Automatic")) {
            adapter.startService(ci);
        }
        this.adapterMap.put(protocolType, adapter);
    }

    private static class CommMechAssocProvider
    extends OneToManyAssocProvider {
        private static final CIMObjectPath COMMMECH_CLASS_OP = new CIMObjectPath("CIM_ObjectManagerCommunicationMechanism", "/interop");

        private CommMechAssocProvider() {
        }

        protected String getOneRole(CIMObjectPath assocName) {
            return "Antecedent";
        }

        protected String getManyRole(CIMObjectPath assocName) {
            return "Dependent";
        }

        protected CIMObjectPath getManyClass(CIMObjectPath assocName) {
            return COMMMECH_CLASS_OP;
        }

        protected CIMObjectPath getOneClass(CIMObjectPath assocName) {
            return CIMOMProvider.CLASSOP;
        }
    }

    private static class AdapterAssocProvider
    extends OneToManyAssocProvider {
        private static final CIMObjectPath CPA_CLASS_OP = new CIMObjectPath("WBEMServices_ObjectManagerClientProtocolAdapter", "/interop");

        private AdapterAssocProvider() {
        }

        protected String getOneRole(CIMObjectPath assocName) {
            return "Antecedent";
        }

        protected String getManyRole(CIMObjectPath assocName) {
            return "Dependent";
        }

        protected CIMObjectPath getManyClass(CIMObjectPath assocName) {
            return CPA_CLASS_OP;
        }

        protected CIMObjectPath getOneClass(CIMObjectPath assocName) {
            return CIMOMProvider.CLASSOP;
        }
    }

    private class AdapterProvider
    implements CIMInstanceProvider,
    CIMMethodProvider {
        CIMInstanceProvider internalProvider;

        public AdapterProvider() {
            this.internalProvider = ClientProtocolAdapterService.this.pch.getInternalCIMInstanceProvider();
        }

        public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
            return this.internalProvider.enumerateInstanceNames(op, cc);
        }

        public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
            return this.internalProvider.enumerateInstances(op, localOnly, includeQualifiers, includeClassOrigin, propList, cc);
        }

        public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
            return this.internalProvider.getInstance(op, localOnly, includeQualifiers, includeClassOrigin, propList, cc);
        }

        public synchronized CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
            CIMObjectPath retVal = this.internalProvider.createInstance(op, ci);
            try {
                ClientProtocolAdapterService.this.handleAdapterInstance(ci);
            }
            catch (CIMException e) {
                CIMObjectPath lop = new CIMObjectPath();
                lop.setNameSpace(op.getNameSpace());
                lop.setKeys(ci.getKeys());
                this.internalProvider.deleteInstance(lop);
                throw e;
            }
            return retVal;
        }

        public synchronized void setInstance(CIMObjectPath op, CIMInstance ci, boolean includeQualifier, String[] propertyList) throws CIMException {
            CIMProperty cp = ci.getProperty(ClientProtocolAdapterService.PROTOCOLTYPE);
            CIMValue cv = cp.getValue();
            String className = (String)cv.getValue();
            ClientProtocolAdapterIF adapter = (ClientProtocolAdapterIF)ClientProtocolAdapterService.this.adapterMap.get(className);
            this.internalProvider.setInstance(op, ci, includeQualifier, propertyList);
            CIMInstance newci = this.getInstance(op, false, false, false, null, null);
            if (adapter != null) {
                adapter.stopService();
                adapter.startService(newci);
            } else {
                try {
                    ClientProtocolAdapterService.this.handleAdapterInstance(newci);
                }
                catch (CIMException e) {
                    CIMObjectPath lop = new CIMObjectPath();
                    lop.setNameSpace(op.getNameSpace());
                    lop.setKeys(ci.getKeys());
                    this.internalProvider.deleteInstance(lop);
                    throw e;
                }
            }
        }

        public synchronized void deleteInstance(CIMObjectPath op) throws CIMException {
            CIMInstance ci = this.getInstance(op, false, false, false, null, null);
            CIMProperty cp = ci.getProperty(ClientProtocolAdapterService.PROTOCOLTYPE);
            CIMValue cv = cp.getValue();
            String className = (String)cv.getValue();
            ClientProtocolAdapterIF adapter = (ClientProtocolAdapterIF)ClientProtocolAdapterService.this.adapterMap.get(className);
            if (adapter != null) {
                adapter.stopService();
            }
            this.internalProvider.deleteInstance(op);
        }

        public void initialize(CIMOMHandle ch) {
        }

        public void cleanup() {
        }

        public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
            return this.internalProvider.execQuery(op, query, ql, cc);
        }

        public CIMValue invokeMethod(CIMObjectPath op, String methodName, CIMArgument[] inArgs, CIMArgument[] outArgs) throws CIMException {
            String name;
            CIMInstance ci = this.getInstance(op, false, false, false, null, null);
            try {
                name = (String)ci.getProperty(ClientProtocolAdapterService.PROTOCOLTYPE).getValue().getValue();
            }
            catch (NullPointerException e) {
                Debug.trace1((String)"Caught NullPointerException at ClientProtocolAdapterService.invokeMethod", (Throwable)e);
                return new CIMValue((Object)new Integer(2));
            }
            ClientProtocolAdapterIF adapter = (ClientProtocolAdapterIF)ClientProtocolAdapterService.this.adapterMap.get(name);
            if (adapter == null) {
                return new CIMValue((Object)new Integer(3));
            }
            if (methodName.equalsIgnoreCase(ClientProtocolAdapterService.STARTSERVICE)) {
                adapter.startService(ci);
            } else {
                adapter.stopService();
            }
            return new CIMValue((Object)new Integer(0));
        }
    }
}

