/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.cimom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.client.Debug;
import org.wbemservices.wbem.cimom.FilterActivation;

class IndicationRequestCollator {
    List subActList;
    Callback cb;

    IndicationRequestCollator(List subActList, Callback cb) {
        this.subActList = subActList;
        this.cb = cb;
    }

    Object[] processEventRequest() {
        Iterator i;
        List activationList;
        CIMException ce = null;
        Iterator subActivations = this.subActList.iterator();
        ArrayList<FilterActivation.SubActivation> finishedActivations = new ArrayList<FilterActivation.SubActivation>();
        HashMap<String, ArrayList<FilterActivation.SubActivation>> requestMap = new HashMap<String, ArrayList<FilterActivation.SubActivation>>();
        while (subActivations.hasNext()) {
            FilterActivation.SubActivation sa = (FilterActivation.SubActivation)subActivations.next();
            FilterActivation.EventProviderRequest request = null;
            try {
                request = this.cb.doSubActivationOperation(sa);
            }
            catch (Throwable th) {
                Debug.trace2((String)"Got an exception getting poll info", (Throwable)th);
                if (!(th instanceof CIMException)) {
                    ce = new CIMException("CIM_ERR_FAILED", th.toString());
                    break;
                }
                ce = (CIMException)th;
                break;
            }
            if (request == null) {
                finishedActivations.add(sa);
                continue;
            }
            request.getEventType();
            CIMObjectPath classPath = request.getClassPath();
            String mapKey = classPath.getObjectName() == null || classPath.getObjectName().length() == 0 ? classPath + ":" + request.getEventType() : classPath.toString();
            Debug.trace2((String)("Mapkey is " + mapKey));
            ArrayList<FilterActivation.SubActivation> activationList2 = (ArrayList<FilterActivation.SubActivation>)requestMap.get(mapKey);
            if (activationList2 == null) {
                activationList2 = new ArrayList<FilterActivation.SubActivation>();
                requestMap.put(mapKey, activationList2);
            }
            activationList2.add(sa);
            activationList2.add((FilterActivation.SubActivation)((Object)request));
        }
        Iterator activationLists = requestMap.values().iterator();
        while (ce == null && activationLists.hasNext()) {
            activationList = (List)activationLists.next();
            Debug.trace2((String)("The activation list is " + activationList));
            i = activationList.iterator();
            ArrayList<String> subFilterList = new ArrayList<String>();
            ArrayList<CIMObjectPath> cpList = new ArrayList<CIMObjectPath>();
            ArrayList<String> eventTypeList = new ArrayList<String>();
            ArrayList<FilterActivation.SubActivation> currentSubActs = new ArrayList<FilterActivation.SubActivation>();
            while (i.hasNext()) {
                FilterActivation.SubActivation sa = (FilterActivation.SubActivation)i.next();
                currentSubActs.add(sa);
                FilterActivation.EventProviderRequest request = (FilterActivation.EventProviderRequest)i.next();
                subFilterList.add(request.getFilter().toString());
                cpList.add(request.getClassPath());
                eventTypeList.add(request.getEventType());
                Debug.trace2((String)("sub filter list\n" + subFilterList));
            }
            try {
                String[] filters = subFilterList.toArray(new String[subFilterList.size()]);
                CIMObjectPath[] classPaths = cpList.toArray(new CIMObjectPath[cpList.size()]);
                String[] eventTypes = eventTypeList.toArray(new String[eventTypeList.size()]);
                Debug.trace2((String)"Issuing the request");
                Object actionResult = this.cb.doProviderOperation(filters, classPaths, eventTypes);
                Iterator csai = currentSubActs.iterator();
                while (csai.hasNext()) {
                    try {
                        FilterActivation.SubActivation csa = (FilterActivation.SubActivation)csai.next();
                        this.cb.processSingleResult(csa, actionResult);
                        finishedActivations.add(csa);
                    }
                    catch (Throwable th) {
                        Debug.trace2((String)"Got an exception getting poll info", (Throwable)th);
                        ce = !(th instanceof CIMException) ? new CIMException("CIM_ERR_FAILED", th.toString()) : (CIMException)th;
                        while (csai.hasNext()) {
                            FilterActivation.SubActivation csa = (FilterActivation.SubActivation)csai.next();
                            try {
                                this.cb.processSingleException(csa, ce);
                            }
                            catch (Throwable pth) {
                                Debug.trace2((String)"Got an exception", (Throwable)pth);
                            }
                        }
                        break;
                    }
                    if (ce == null) continue;
                }
                if (ce == null) continue;
                break;
            }
            catch (Throwable th) {
                Debug.trace2((String)"Got an exception getting poll info", (Throwable)th);
                ce = !(th instanceof CIMException) ? new CIMException("CIM_ERR_FAILED", th.toString()) : (CIMException)th;
                Iterator csai = currentSubActs.iterator();
                while (csai.hasNext()) {
                    FilterActivation.SubActivation csa = (FilterActivation.SubActivation)csai.next();
                    try {
                        this.cb.processSingleException(csa, ce);
                    }
                    catch (Throwable pseth) {
                        Debug.trace2((String)"Got an exception", (Throwable)th);
                    }
                }
                break block13;
            }
        }
        while (activationLists.hasNext()) {
            activationList = (List)activationLists.next();
            i = activationList.iterator();
            while (i.hasNext()) {
                FilterActivation.SubActivation sa = (FilterActivation.SubActivation)i.next();
                i.next();
                try {
                    this.cb.processSingleNoResult(sa);
                }
                catch (Throwable th) {
                    Debug.trace2((String)"Got an exception", (Throwable)th);
                }
            }
        }
        Object[] oArray = new Object[]{ce, finishedActivations};
        return oArray;
    }

    static interface Callback {
        public FilterActivation.EventProviderRequest doSubActivationOperation(FilterActivation.SubActivation var1) throws CIMException;

        public Object doProviderOperation(String[] var1, CIMObjectPath[] var2, String[] var3) throws CIMException;

        public void processSingleResult(FilterActivation.SubActivation var1, Object var2) throws CIMException;

        public void processSingleException(FilterActivation.SubActivation var1, CIMException var2) throws CIMException;

        public void processSingleNoResult(FilterActivation.SubActivation var1) throws CIMException;
    }
}

