/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.cimom;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMClassException;
import javax.wbem.cim.CIMException;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.Debug;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.CIMAssociatorProvider;
import javax.wbem.provider.CIMIndicationProvider;
import javax.wbem.provider.CIMInstanceProvider;
import javax.wbem.provider.CIMMethodProvider;
import javax.wbem.provider.CIMProvider;
import javax.wbem.provider.EventProvider;
import org.wbemservices.wbem.cimom.CIMOMImpl;
import org.wbemservices.wbem.cimom.adapter.provider.ProviderAdapterIF;
import org.wbemservices.wbem.cimom.adapter.provider.ProviderProtocolAdapterIF;

public class InternalProviderAdapter
implements ProviderProtocolAdapterIF {
    private static final String DESCRIPTION = "Internal class provider adapter";
    private static final String VENDOR = "Sun Microsystems Inc.";
    private static final int VERSION = 1;
    private boolean valid = false;
    private ProviderCIMOMHandle mCimom;
    private static Map internalProviders = Collections.synchronizedMap(new HashMap());
    CIMOMImpl cimom;
    InternalServiceProvider[] serviceProviderArray;

    InternalProviderAdapter() {
    }

    public void initialize(ProviderCIMOMHandle pCimom) {
        this.mCimom = pCimom;
        for (int count = 0; count < this.serviceProviderArray.length; ++count) {
            InternalServiceProvider sp = this.serviceProviderArray[count];
            String[] providerNames = sp.getProviderNames();
            for (int j = providerNames.length - 1; j >= 0; --j) {
                String pn = providerNames[j];
                try {
                    CIMProvider cp = sp.getProvider(pn);
                    cp.initialize((CIMOMHandle)pCimom);
                    internalProviders.put(pn, cp);
                    continue;
                }
                catch (Exception e) {
                    Debug.trace1((String)("Unable to add provider: " + pn), (Throwable)e);
                }
            }
        }
        internalProviders.put("cimom", this.cimom);
    }

    public void start() {
        this.valid = true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void stop() {
        this.valid = false;
    }

    public int getVersion() {
        return 1;
    }

    public String getVendor() {
        return VENDOR;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public static void putProvider(String name, CIMProvider cp) {
        internalProviders.put(name, cp);
    }

    public Object loadProvider(String pNamespace, String pName, String[] pParams, CIMClass pCimClass) throws ClassNotFoundException, CIMClassException {
        Object provider = null;
        provider = (CIMProvider)internalProviders.get(pName);
        if (provider == null) {
            provider = this.cimom;
        }
        if (provider instanceof ProviderAdapterIF) {
            return provider;
        }
        return new WrappedProviderAdapter((CIMProvider)provider);
    }

    public void unloadProvider(Object pUnique) throws CIMClassException {
    }

    public ProviderAdapterIF getProviderAdapter(Object pProvider) throws CIMClassException {
        if (pProvider instanceof ProviderAdapterIF) {
            return (ProviderAdapterIF)pProvider;
        }
        throw new CIMClassException("CIM_ERR_INVALID_CLASS", (Object)"Unrecognized object!");
    }

    public void terminate() {
    }

    public class WrappedProviderAdapter
    implements ProviderAdapterIF {
        private CIMProvider mWrapped = null;

        WrappedProviderAdapter(CIMProvider pWrapped) {
            this.mWrapped = pWrapped;
        }

        public boolean isInstanceProvider() {
            return this.mWrapped instanceof CIMInstanceProvider;
        }

        public boolean isMethodProvider() {
            return this.mWrapped instanceof CIMMethodProvider;
        }

        public boolean isCIMIndicationProvider() {
            return this.mWrapped instanceof CIMIndicationProvider;
        }

        public boolean isEventProvider() {
            return this.mWrapped instanceof EventProvider;
        }

        public boolean isAuthorizable() {
            return this.mWrapped instanceof Authorizable;
        }

        public boolean isAssociatorProvider() {
            return this.mWrapped instanceof CIMAssociatorProvider;
        }

        public CIMProvider getProvider() {
            return this.mWrapped;
        }
    }

    public static interface InternalServiceProvider {
        public String[] getProviderNames();

        public CIMProvider getProvider(String var1) throws CIMException;
    }
}

