/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.cimom;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.InetAddress;
import java.text.MessageFormat;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.Debug;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.CIMInstanceProvider;
import org.wbemservices.wbem.cimom.I18N;

public class LogFile {
    private static ProviderCIMOMHandle mCimom = null;
    private static CIMInstanceProvider logProvider = null;
    public static final int DEVELOPMENT = 4;
    public static final int DEBUG = 3;
    public static final int INFORMATIONAL = 2;
    public static final int WARNING = 1;
    public static final int CRITICAL = 0;
    private static final String newLine = "\n";
    private static boolean started = true;
    private static int logLevel = 1;
    private static DataOutputStream fStream;
    private static String fileName;
    private static File f;
    private static boolean verbose;
    private static final String LOGDIRPARENT = "/var/sadm/wbem";

    private static CIMInstance getLogInstance() {
        return null;
    }

    private static void setProperties(CIMInstance ci, String resourceID, int level) {
        try {
            ci.setProperty("SummaryMessage", new CIMValue((Object)resourceID));
            ci.setProperty("AppName", new CIMValue((Object)"CIMOM"));
            ci.setProperty("category", new CIMValue((Object)new Integer(0)));
            switch (level) {
                case 2: 
                case 3: 
                case 4: {
                    level = 0;
                    break;
                }
                case 1: {
                    level = 1;
                    break;
                }
                case 0: {
                    level = 2;
                }
            }
            ci.setProperty("severity", new CIMValue((Object)new Integer(level)));
            ci.setProperty("UserName", new CIMValue((Object)"CIMOM"));
            ci.setProperty("ClientMachineName", new CIMValue((Object)"<none>"));
            String hostName = ".";
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                // empty catch block
            }
            ci.setProperty("ServerMachineName", new CIMValue((Object)hostName));
            ci.setProperty("data", new CIMValue((Object)""));
            ci.setProperty("syslogflag", new CIMValue((Object)Boolean.FALSE));
        }
        catch (CIMException ex) {
            Debug.trace1((String)"Exception trying to setProperties", (Throwable)ex);
        }
    }

    public static void add(int level, String resourceID) throws CIMException {
        if (logLevel >= level) {
            CIMInstance ci = LogFile.getLogInstance();
            if (ci == null) {
                return;
            }
            ci.setProperty("DetailedMessage", new CIMValue((Object)I18N.loadString(resourceID)));
            LogFile.setProperties(ci, resourceID, level);
            if (logLevel < 3) {
                try {
                    logProvider.createInstance(new CIMObjectPath(ci.getClassName(), "/root/cimv2"), ci);
                }
                catch (CIMException e) {
                    System.out.println((Object)e);
                    throw e;
                }
            }
            LogFile.addInfo(ci.toString());
        }
    }

    public static void add(int level, String resourceID, Object[] obj) throws CIMException {
        if (logLevel >= level) {
            MessageFormat mf = new MessageFormat(I18N.loadString(resourceID));
            mf.setLocale(I18N.locale);
            CIMInstance ci = LogFile.getLogInstance();
            if (ci == null) {
                return;
            }
            ci.setProperty("DetailedMessage", new CIMValue((Object)mf.format(obj)));
            LogFile.setProperties(ci, resourceID, level);
            if (logLevel < 3) {
                try {
                    logProvider.createInstance(new CIMObjectPath(ci.getClassName(), "/root/cimv2"), ci);
                }
                catch (CIMException e) {
                    System.out.println((Object)e);
                    throw e;
                }
            }
            LogFile.addInfo(ci.toString());
        }
    }

    public static void add(int level, String resourceID, Object info1, Object info2, Object info3) throws CIMException {
        LogFile.add(level, resourceID, new Object[]{info1, info2, info3});
    }

    public static void add(int level, String resourceID, Object info1, Object info2) throws CIMException {
        LogFile.add(level, resourceID, new Object[]{info1, info2});
    }

    public static void add(int level, String resourceID, Object info) throws CIMException {
        LogFile.add(level, resourceID, new Object[]{info});
    }

    public static void methodEntry(String methodName) throws CIMException {
        LogFile.add(4, "METHOD_ENTRY", methodName);
    }

    public static void methodReturn(String methodName) throws CIMException {
        LogFile.add(4, "METHOD_RETURN", methodName);
    }

    public static String getFileName() {
        return fileName;
    }

    public static int getLevel() {
        return logLevel;
    }

    public static boolean getVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean b) {
        verbose = b;
    }

    public static void initialize(ProviderCIMOMHandle pCimom) throws CIMException {
        mCimom = pCimom;
        try {
            String logpath = System.getProperty("logdir", System.getProperty("logparent", LOGDIRPARENT) + File.separator + "logr");
            f = new File(logpath + File.separator + fileName);
            f.createNewFile();
            fStream = new DataOutputStream(new FileOutputStream(logpath + File.separator + fileName));
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void setLevel(int level) {
        logLevel = level;
    }

    public static void start() {
        started = true;
    }

    private static void addInfo(String info) {
        if (f.length() > 5000000L) {
            try {
                f.delete();
                f.createNewFile();
                fStream = new DataOutputStream(new FileOutputStream(f.getAbsolutePath()));
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        try {
            fStream.writeBytes(info);
            fStream.writeBytes(newLine);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        fileName = "cimom.log";
        f = null;
        verbose = false;
    }
}

