/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.cimom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class TaskManager {
    protected final ArrayList tasks = new ArrayList();
    protected int firstPending = 0;
    protected final List roTasks = Collections.unmodifiableList(this.tasks);
    protected final ArrayList threads = new ArrayList();
    protected final int maxThreads;
    protected final long timeout;
    protected final float loadFactor;

    public TaskManager() {
        this(10, 15000L, 3.0f);
    }

    public TaskManager(int maxThreads, long timeout, float loadFactor) {
        this.maxThreads = maxThreads;
        this.timeout = timeout;
        this.loadFactor = loadFactor;
    }

    public synchronized void addIfNew(Task t) {
        if (!this.tasks.contains(t)) {
            this.add(t);
        }
    }

    public synchronized void add(Task t) {
        this.tasks.add(t);
        this.pokeThread();
    }

    public synchronized void addAll(Collection c) {
        this.tasks.addAll(c);
        int i = c.size();
        while (--i >= 0) {
            this.pokeThread();
        }
    }

    private void pokeThread() {
        if (this.threads.size() < this.maxThreads && this.needThread()) {
            TaskThread th = new TaskThread();
            this.threads.add(th);
            th.start();
        } else {
            this.notify();
        }
    }

    protected boolean needThread() {
        return (float)this.tasks.size() > this.loadFactor * (float)this.threads.size();
    }

    public synchronized boolean removeIfPending(Task t) {
        return this.removeTask(t, this.firstPending);
    }

    public synchronized boolean remove(Task t) {
        return this.removeTask(t, 0);
    }

    private boolean removeTask(Task t, int min) {
        int i = this.tasks.size();
        while (--i >= min) {
            if (this.tasks.get(i) != t) continue;
            this.tasks.remove(i);
            if (i >= this.firstPending) {
                return true;
            }
            --this.firstPending;
            int j = this.threads.size();
            while (--j >= 0) {
                TaskThread thread = (TaskThread)this.threads.get(j);
                if (thread.task != t) continue;
                thread.interrupt();
                this.threads.remove(j);
                break;
            }
            if (this.firstPending > this.tasks.size()) {
                this.pokeThread();
            }
            return true;
        }
        return false;
    }

    public synchronized void terminate() {
        int i = this.threads.size();
        while (--i >= 0) {
            ((Thread)this.threads.get(i)).interrupt();
        }
    }

    public synchronized ArrayList getPending() {
        ArrayList tc = (ArrayList)this.tasks.clone();
        int i = this.firstPending;
        while (--i >= 0) {
            tc.remove(0);
        }
        return tc;
    }

    private class TaskThread
    extends Thread {
        public Task task = null;

        public TaskThread() {
            super("task");
            this.setDaemon(true);
        }

        private boolean takeTask() {
            int size = TaskManager.this.tasks.size();
            for (int i = TaskManager.this.firstPending; i < size; ++i) {
                Task t = (Task)TaskManager.this.tasks.get(i);
                if (t.runAfter(TaskManager.this.roTasks, i)) continue;
                if (i > TaskManager.this.firstPending) {
                    TaskManager.this.tasks.remove(i);
                    TaskManager.this.tasks.add(TaskManager.this.firstPending, t);
                }
                ++TaskManager.this.firstPending;
                this.task = t;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (true) {
                    TaskManager taskManager = TaskManager.this;
                    synchronized (taskManager) {
                        if (this.isInterrupted()) {
                            return;
                        }
                        if (this.task != null) {
                            int i = 0;
                            while (TaskManager.this.tasks.get(i) != this.task) {
                                ++i;
                            }
                            TaskManager.this.tasks.remove(i);
                            --TaskManager.this.firstPending;
                            this.task = null;
                        }
                        if (!this.takeTask()) {
                            TaskManager.this.wait(TaskManager.this.timeout);
                            if (!this.takeTask()) {
                                TaskManager.this.threads.remove(TaskManager.this.threads.indexOf(this));
                                return;
                            }
                        }
                    }
                    this.task.run();
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public static interface Task
    extends Runnable {
        public boolean runAfter(List var1, int var2);
    }
}

