/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.cimom;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.client.Debug;

class UnregHandler {
    OutputStream out;
    List opList = new ArrayList();

    UnregHandler(OutputStream out) {
        this.out = out;
    }

    public void createNameSpace(CIMNameSpace ns) throws CIMException {
    }

    public void createQualifierType(CIMObjectPath name, CIMQualifierType qt) throws CIMException {
    }

    public void setClass(CIMObjectPath name, CIMClass oldcc, CIMClass newcc) throws CIMException {
        this.opList.add(0, new SetClassOp(name, oldcc));
        Debug.trace3((String)"Added SetClassOp to list");
    }

    public void createClass(CIMObjectPath name, CIMClass cc) throws CIMException {
        this.opList.add(0, new CreateClassOp(name, cc));
    }

    public void setInstance(CIMObjectPath name, CIMInstance oldci, CIMInstance newci) throws CIMException {
        this.opList.add(0, new SetInstanceOp(name, oldci));
    }

    public void createInstance(CIMObjectPath name, CIMInstance ci) throws CIMException {
        this.opList.add(0, new CreateInstanceOp(name, ci));
        Debug.trace3((String)"Added CreateInstanceOp to list");
    }

    public void deleteInstance(CIMObjectPath path, CIMInstance oldci) throws CIMException {
        this.opList.add(0, new DeleteInstanceOp(path, oldci));
        Debug.trace3((String)"Added DeleteInstanceOp to list");
    }

    public void outputUnreg() {
        Iterator i = this.opList.iterator();
        UndoOperation prevOp = null;
        PrintStream pstream = new PrintStream(this.out);
        while (i.hasNext()) {
            UndoOperation uop = (UndoOperation)i.next();
            String outString = uop.undo(prevOp);
            pstream.print(outString);
            prevOp = uop;
        }
    }

    private static class SetInstanceOp
    extends UndoOperation {
        CIMInstance oldci;

        public String undo(UndoOperation previousOp) {
            StringBuffer sb = new StringBuffer("");
            sb.append(this.getDirectives(previousOp));
            sb.append("\n" + this.oldci);
            return sb.toString();
        }

        public SetInstanceOp(CIMObjectPath namespace, CIMInstance oldci) {
            super(namespace, 2);
            Debug.trace3((String)"Set instance op created");
            this.oldci = oldci;
        }
    }

    private static class DeleteInstanceOp
    extends UndoOperation {
        CIMInstance ci;

        public String undo(UndoOperation previousOp) {
            StringBuffer sb = new StringBuffer("");
            sb.append(this.getDirectives(previousOp));
            sb.append("\n" + this.ci);
            return sb.toString();
        }

        public DeleteInstanceOp(CIMObjectPath namespace, CIMInstance newInstance) {
            super(namespace, 3);
            Debug.trace3((String)"Delete instance op created");
            this.ci = newInstance;
        }
    }

    private static class CreateInstanceOp
    extends UndoOperation {
        CIMInstance ci;

        public String undo(UndoOperation previousOp) {
            StringBuffer sb = new StringBuffer("");
            sb.append(this.getDirectives(previousOp));
            sb.append("\n" + this.ci);
            return sb.toString();
        }

        public CreateInstanceOp(CIMObjectPath namespace, CIMInstance newInstance) {
            super(namespace, 1);
            Debug.trace3((String)"Create instance op created");
            this.ci = newInstance;
        }
    }

    private static class CreateClassOp
    extends UndoOperation {
        String cName;

        public String undo(UndoOperation previousOp) {
            StringBuffer sb = new StringBuffer("");
            sb.append(this.getDirectives(previousOp));
            sb.append("\n" + new CIMClass(this.cName));
            return sb.toString();
        }

        public CreateClassOp(CIMObjectPath namespace, CIMClass newClass) {
            super(namespace, 1);
            Debug.trace3((String)"Create class op created");
            this.cName = newClass.getName();
        }
    }

    private static class SetClassOp
    extends UndoOperation {
        CIMClass oldcc;

        public String undo(UndoOperation previousOp) {
            StringBuffer sb = new StringBuffer("");
            sb.append(this.getDirectives(previousOp));
            sb.append("\n" + this.oldcc);
            return sb.toString();
        }

        public SetClassOp(CIMObjectPath namespace, CIMClass oldcc) {
            super(namespace, 2);
            Debug.trace3((String)"Set class op created");
            this.oldcc = oldcc;
        }
    }

    private static abstract class UndoOperation {
        static final int DELETEMODE = 1;
        static final int SETMODE = 2;
        static final int CREATEMODE = 3;
        protected int mode = 0;
        protected CIMObjectPath nameSpace = null;

        int getMode() {
            return this.mode;
        }

        private String getModeString() {
            switch (this.mode) {
                case 1: {
                    return "__delete";
                }
                case 3: {
                    return "__create";
                }
                case 2: {
                    return "__modify";
                }
            }
            throw new IllegalArgumentException(this.mode + "");
        }

        void setMode(int mode) {
            this.mode = mode;
        }

        CIMObjectPath getNameSpace() {
            return this.nameSpace;
        }

        void setNameSpace(CIMObjectPath nameSpace) {
            this.nameSpace = nameSpace;
        }

        String getDirectives(UndoOperation previousOp) {
            StringBuffer directive = new StringBuffer("");
            String nsc = this.getNameSpace().getNameSpace();
            if (previousOp == null) {
                nsc = nsc.replace('\\', '/');
                directive.append("\n#pragma namespace(\"" + nsc + "\")");
                directive.append("\n#pragma namespace(\"" + this.getModeString() + "\")");
                return directive.toString();
            }
            String nsp = previousOp.getNameSpace().getNameSpace();
            if (!nsp.equals(nsc)) {
                nsc = nsc.replace('\\', '/');
                directive.append("\n#pragma namespace(\"" + nsc + "\")");
            }
            if (this.getMode() != previousOp.getMode()) {
                directive.append("\n#pragma namespace(\"" + this.getModeString() + "\")");
            }
            return directive.toString();
        }

        abstract String undo(UndoOperation var1);

        public UndoOperation(CIMObjectPath nameSpace, int mode) {
            this.setNameSpace(nameSpace);
            this.setMode(mode);
        }
    }
}

