/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.cimom.adapters.client.http;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cimxml.CIMXml;
import javax.wbem.cimxml.CIMXmlFactory;
import javax.wbem.client.CIMEvent;
import javax.wbem.client.CIMExport;
import javax.wbem.client.CIMExportIndication;
import javax.wbem.client.adapter.http.transport.HttpClientConnection;
import javax.wbem.client.adapter.http.transport.HttpClientSocketFactory;
import javax.wbem.client.adapter.http.transport.HttpSocketFactory;
import javax.wbem.client.adapter.http.transport.OutboundRequest;
import javax.wbem.provider.CIMProvider;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.wbemservices.wbem.cimom.CommonServerSecurityContext;
import org.wbemservices.wbem.cimom.EventService;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HttpIndicationHandler
implements EventService.IndicationHandler {
    private static final String ns = "http://www.dmtf.org/cim/mapping/http/v1.0";
    private static boolean useMPost = false;
    private Map connMap = new HashMap();
    private CIMXml xmlImpl = CIMXmlFactory.getCIMXmlImpl();
    private boolean debug = false;
    private String prefix = "";
    private static final String defaultScheme = "http";
    private static final String TRACEFILE = "CIMOMXML_Trace.txt";
    private FileOutputStream fout = null;
    private PrintStream psout = null;

    public CommonServerSecurityContext getSecurityContext(CIMInstance handlerInstance) {
        return null;
    }

    public void deliverEvent(CIMEvent e, CIMInstance handlerInstance) throws CIMException {
        URL dest = null;
        try {
            Document request = this.xmlImpl.getXmlRequest((CIMExport)new CIMExportIndication(e.getIndication()));
            String d = (String)handlerInstance.getProperty("Destination").getValue().getValue();
            try {
                dest = new URL(d);
            }
            catch (MalformedURLException me) {
                d = d.startsWith("//") ? "http:" + d : "http://" + d;
                dest = new URL(d);
            }
            try {
                this.deliverEventRequest(request, dest);
            }
            catch (Exception ex) {
                this.deliverEventRequest(request, dest);
            }
        }
        catch (Exception ex) {
            throw new CIMException("CIM_ERR_FAILED", (Object)ex);
        }
    }

    private void writeDocumentToOutputStream(Document request, PrintStream out) {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        try {
            String systemId;
            Transformer transformer = tFactory.newTransformer();
            DocumentType docType = request.getDoctype();
            if (docType != null && (systemId = docType.getSystemId()) != null) {
                String systemValue = new File(systemId).getName();
                transformer.setOutputProperty("doctype-system", systemValue);
            }
            DOMSource source = new DOMSource(request);
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    private synchronized void deliverEventRequest(Document request, URL url) throws CIMException, IOException {
        PrintStream out = null;
        String host = url.getHost();
        int port = url.getPort();
        HttpSocketFactory factory = new HttpSocketFactory(url.getProtocol());
        OutboundRequest outRequest = null;
        String key = host + ":" + port;
        HttpClientConnection conn = (HttpClientConnection)this.connMap.get(key);
        for (int i = 0; i < 2; ++i) {
            try {
                if (conn == null) {
                    conn = new HttpClientConnection(host, port, (HttpClientSocketFactory)factory, useMPost);
                    this.connMap.put(key, conn);
                }
                outRequest = conn.newRequest(url.getPath());
                out = new PrintStream(outRequest.getRequestOutputStream(), false, "UTF8");
                this.setRequestHeaders(outRequest, this.xmlImpl.getXmlRequestHeaders(request));
                outRequest.endWriteHeader();
                this.writeDocumentToOutputStream(request, out);
                out.flush();
                out.close();
                break;
            }
            catch (IOException e) {
                conn.shutdown(true);
                conn = null;
                this.connMap.put(key, conn);
                if (i != 1) continue;
                throw e;
            }
        }
        try {
            if (this.debug) {
                this.dumpRequest(request, outRequest);
            }
            Document resp = this.getResponse(outRequest);
            if (this.debug) {
                this.dumpResponse(resp, outRequest);
            }
        }
        catch (SAXException e) {
            if (useMPost) {
                if (conn != null) {
                    conn.shutdown(true);
                    conn = null;
                    this.connMap.put(key, conn);
                }
                useMPost = false;
                this.deliverEventRequest(request, url);
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    public void ping(CIMInstance handlerInstance) throws CIMException {
    }

    private void dumpRequest(Document request, OutboundRequest outRequest) throws IOException {
        this.fout = new FileOutputStream(TRACEFILE, true);
        this.psout = new PrintStream(this.fout);
        this.psout.println(">>>>>>>>>>>>>>>>>>>>>>> START OF REQUEST  >>>>>>>>>>>>>>>>>>>>>>>");
        outRequest.dumpOutHeader(this.psout);
        if (request != null) {
            this.writeDocumentToOutputStream(request, this.psout);
        }
        this.psout.println(">>>>>>>>>>>>>>>>>>>>>>> END OF REQUEST  >>>>>>>>>>>>>>>>>>>>>>>");
        this.fout.close();
        this.psout.close();
        System.out.println(">>>>>>>>>>>>>>>>>>>>>>> START OF REQUEST  >>>>>>>>>>>>>>>>>>>>>>>");
        outRequest.dumpOutHeader(System.out);
        if (request != null) {
            this.writeDocumentToOutputStream(request, System.out);
        }
        System.out.println(">>>>>>>>>>>>>>>>>>>>>>> END OF REQUEST  >>>>>>>>>>>>>>>>>>>>>>>");
    }

    private void dumpResponse(Document response, OutboundRequest outRequest) throws IOException {
        this.fout = new FileOutputStream(TRACEFILE, true);
        this.psout = new PrintStream(this.fout);
        this.psout.println("<<<<<<<<<<<<<<<<<<<<<<< START OF RESPONSE  <<<<<<<<<<<<<<<<<<<<<<<");
        outRequest.dumpInHeader(this.psout);
        this.psout.println("\n");
        if (response != null) {
            this.writeDocumentToOutputStream(response, this.psout);
        }
        this.psout.println("<<<<<<<<<<<<<<<<<<<<<<< END OF RESPONSE  <<<<<<<<<<<<<<<<<<<<<<<");
        this.fout.close();
        this.psout.close();
        System.out.println("<<<<<<<<<<<<<<<<<<<<<<< START OF RESPONSE  <<<<<<<<<<<<<<<<<<<<<<<");
        outRequest.dumpInHeader(System.out);
        System.out.println("\n");
        if (response != null) {
            this.writeDocumentToOutputStream(response, System.out);
        }
        System.out.println("<<<<<<<<<<<<<<<<<<<<<<< END OF RESPONSE  <<<<<<<<<<<<<<<<<<<<<<<");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getResponse(OutboundRequest outRequest) throws IOException, SAXException, ParserConfigurationException {
        Document d = null;
        InputStream contentInput = outRequest.getResponseInputStream();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            InputSource in = new InputSource();
            in.setByteStream(contentInput);
            d = builder.parse(in);
            if (outRequest.getResponseCode() >= 400) {
                throw new IOException();
            }
            Document document = d;
            return document;
        }
        finally {
            contentInput.close();
        }
    }

    private void setRequestHeaders(OutboundRequest outRequest, Map headers) throws CIMException {
        if (useMPost) {
            this.setPrefix();
            outRequest.addHeaderField("Man", "http://www.dmtf.org/cim/mapping/http/v1.0;ns=" + this.prefix);
            this.prefix = this.prefix + "-";
        } else {
            this.prefix = "";
        }
        Iterator it = headers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            outRequest.addHeaderField(this.prefix + (String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void setPrefix() {
        Random generator = new Random();
        int rand = Math.abs(generator.nextInt() % 100);
        this.prefix = Integer.toString(rand);
        this.prefix = this.prefix.length() == 1 ? "0" + this.prefix : this.prefix;
    }

    public String getClassName() {
        return "CIM_ListenerDestinationCIMXML";
    }

    public CIMProvider getCIMProvider() {
        return null;
    }
}

