/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.cimom.adapters.client.rmi;

import java.net.InetAddress;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.HashMap;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.client.CIMAssociatorNamesOp;
import javax.wbem.client.CIMAssociatorsOp;
import javax.wbem.client.CIMEnumClassNamesOp;
import javax.wbem.client.CIMEnumClassOp;
import javax.wbem.client.CIMEnumInstanceNamesOp;
import javax.wbem.client.CIMEnumInstancesOp;
import javax.wbem.client.CIMEvent;
import javax.wbem.client.CIMGetClassOp;
import javax.wbem.client.CIMGetInstanceOp;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMOperation;
import javax.wbem.client.CIMReferenceNamesOp;
import javax.wbem.client.CIMReferencesOp;
import javax.wbem.client.CIMSecurityException;
import javax.wbem.client.Debug;
import javax.wbem.security.SecurityMessage;
import javax.wbem.security.SecurityToken;
import javax.wbem.security.SecurityUtil;
import org.wbemservices.wbem.cimom.AssociatorNamesOperation;
import org.wbemservices.wbem.cimom.AssociatorsOperation;
import org.wbemservices.wbem.cimom.BatchOperationFactory;
import org.wbemservices.wbem.cimom.CIMOMOperation;
import org.wbemservices.wbem.cimom.CIMOMServer;
import org.wbemservices.wbem.cimom.CIMOMUtils;
import org.wbemservices.wbem.cimom.CommonServerSecurityContext;
import org.wbemservices.wbem.cimom.DeliveryHandler;
import org.wbemservices.wbem.cimom.EnumClassNamesOperation;
import org.wbemservices.wbem.cimom.EnumClassOperation;
import org.wbemservices.wbem.cimom.EnumInstanceNamesOperation;
import org.wbemservices.wbem.cimom.EnumInstancesOperation;
import org.wbemservices.wbem.cimom.EventService;
import org.wbemservices.wbem.cimom.GetClassOperation;
import org.wbemservices.wbem.cimom.GetInstanceOperation;
import org.wbemservices.wbem.cimom.ReferenceNamesOperation;
import org.wbemservices.wbem.cimom.ReferencesOperation;
import org.wbemservices.wbem.cimom.ServerSecurity;
import org.wbemservices.wbem.cimom.adapter.client.ClientProtocolAdapterIF;
import org.wbemservices.wbem.cimom.adapters.client.rmi.CIMOM_1Impl;
import org.wbemservices.wbem.client.adapter.rmi.CheckSumGen;
import org.wbemservices.wbem.client.adapter.rmi.RemoteCIMListener;

public class CIMOMRMIImpl
implements ClientProtocolAdapterIF {
    private HashMap sessionMap = new HashMap();
    private CheckSumGen csg = new CheckSumGen();
    private static final boolean verbose = false;
    private static final String READ = "read";
    private static final String WRITE = "write";
    private static final String PORT = "PortNumber";
    private static final String RMIPORT = "5987";
    private static final String RMIPORTPROP = "org.wbemservices.wbem.rmiport";
    CIMOMServer comp;

    public void initialize(CIMOMServer cimom, CIMOMHandle ch) {
        this.comp = cimom;
        DeliveryHandler.registerIndicationHandler("solaris_javaxrmidelivery", new RMIIndicationHandler());
    }

    public int startService(CIMInstance cpa) {
        int rmiport;
        try {
            CIMValue cv = cpa.getProperty(PORT).getValue();
            rmiport = ((UnsignedInt32)cv.getValue()).intValue();
        }
        catch (NullPointerException ex) {
            Debug.trace2((String)"Got exception getting the RMI port number", (Throwable)ex);
            rmiport = Integer.parseInt(System.getProperty(RMIPORTPROP, RMIPORT));
        }
        try {
            try {
                LocateRegistry.createRegistry(rmiport);
            }
            catch (RemoteException e) {
                Debug.trace2((String)"Ignoring createRegistry exception", (Throwable)e);
            }
            System.setSecurityManager(new RMISecurityManager());
            String hostAddress = InetAddress.getLocalHost().getHostAddress();
            for (int i = 1; i <= 2; ++i) {
                try {
                    Naming.rebind("rmi://" + hostAddress + ":" + rmiport + "/CIMOM_" + "1", new CIMOM_1Impl(this));
                    continue;
                }
                catch (Exception e) {
                    if (i == 1) {
                        hostAddress = InetAddress.getLocalHost().getHostName();
                        continue;
                    }
                    throw e;
                }
            }
        }
        catch (Exception e) {
            return -1;
        }
        return 0;
    }

    public int stopService() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityMessage hello(String version, SecurityMessage cm, String clientHost) throws CIMException {
        try {
            ServerSecurity ss = new ServerSecurity();
            ss.setClientHostName(clientHost);
            String us = CIMOMUtils.getUniqueString();
            SecurityMessage sm = ss.generateChallenge(version, cm, us.getBytes());
            HashMap hashMap = this.sessionMap;
            synchronized (hashMap) {
                this.sessionMap.put(us, ss);
            }
            return sm;
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    private byte[] convertTo16(byte[] sessionKey) {
        byte[] output = new byte[16];
        System.arraycopy(sessionKey, 0, output, 0, 5);
        System.arraycopy(sessionKey, 0, output, 5, 5);
        System.arraycopy(sessionKey, 0, output, 10, 5);
        output[15] = sessionKey[0];
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SecurityMessage credentials(String version, SecurityMessage cm, String clientHost) throws CIMException {
        SecurityMessage sm = null;
        ServerSecurity ss = this.getServerSecurity(new String(cm.getSessionId()));
        ss.setClientHostName(clientHost);
        ServerSecurity serverSecurity = ss;
        synchronized (serverSecurity) {
            byte[] sessionKey = new byte[5];
            SecurityUtil.secrand.nextBytes(sessionKey);
            sessionKey = this.convertTo16(sessionKey);
            try {
                sm = ss.validateResponse(ss.getChallenge(), ss.getShadow(), ss.getPublicKey(), sessionKey, cm);
            }
            catch (CIMException e) {
                HashMap hashMap = this.sessionMap;
                synchronized (hashMap) {
                    this.sessionMap.remove(new String(cm.getSessionId()));
                }
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("CIM_ERR_FAILED", (Object)e);
            }
            return sm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(String version, SecurityToken st) throws CIMException {
        ServerSecurity ss;
        String[] oarray = new String[]{version, "close"};
        try {
            ss = this.getServerSecurity(new String(st.getSessionId()));
        }
        catch (CIMSecurityException e) {
            return;
        }
        ServerSecurity serverSecurity = ss;
        synchronized (serverSecurity) {
            this.serverSecurityAuthInc(ss, oarray, st);
            HashMap hashMap = this.sessionMap;
            synchronized (hashMap) {
                this.sessionMap.remove(new String(st.getSessionId()));
            }
        }
        this.comp.close(version, ss);
    }

    void deleteNameSpace(String version, CIMNameSpace parent, CIMNameSpace nameSpace, SecurityToken st) throws CIMException {
        String[] oarray = new String[]{version, "deleteNameSpace", this.csg.toString(parent), this.csg.toString(nameSpace)};
        CIMNameSpace validNS = new CIMNameSpace();
        if (nameSpace == null) {
            nameSpace = new CIMNameSpace("", "");
        }
        validNS.setNameSpace(parent.getNameSpace() + '/' + nameSpace.getNameSpace());
        String ns = validNS.getNameSpace().replace('\\', '/');
        String parentNS = ns.substring(0, ns.lastIndexOf(47));
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, parentNS, true);
        this.comp.deleteNameSpace(version, parent, nameSpace, ss);
    }

    void createNameSpace(String version, CIMNameSpace parent, CIMNameSpace nameSpace, SecurityToken st) throws CIMException {
        String[] oarray = new String[]{version, "createNameSpace", this.csg.toString(parent), this.csg.toString(nameSpace)};
        CIMNameSpace validNS = new CIMNameSpace();
        if (nameSpace == null) {
            nameSpace = new CIMNameSpace("", "");
        }
        validNS.setNameSpace(parent.getNameSpace() + '/' + nameSpace.getNameSpace());
        String ns = validNS.getNameSpace().replace('\\', '/');
        String parentNS = ns.substring(0, ns.lastIndexOf(47));
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, parentNS, true);
        this.comp.createNameSpace(version, parent, nameSpace, ss);
    }

    void createQualifierType(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, CIMQualifierType qt, SecurityToken st) throws CIMException {
        String[] oarray = new String[]{version, "createQualifierType", this.csg.toString(nameSpace), this.csg.toString(objectName), this.csg.toString(qt)};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, this.getNameSpace(nameSpace, objectName), true);
        this.comp.createQualifierType(version, nameSpace, objectName, qt, ss);
    }

    void createClass(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, CIMClass cc, SecurityToken st) throws CIMException {
        String[] oarray = new String[]{version, "createClass", this.csg.toString(nameSpace), this.csg.toString(objectName), this.csg.toString(cc)};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, this.getNameSpace(nameSpace, objectName), true);
        this.comp.createClass(version, nameSpace, objectName, cc, ss);
    }

    CIMObjectPath createInstance(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, CIMInstance ci, SecurityToken st) throws CIMException {
        String[] oarray = new String[]{version, "createInstance", this.csg.toString(nameSpace), this.csg.toString(objectName), this.csg.toString(ci)};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, this.getNameSpace(nameSpace, objectName), false);
        return this.comp.createInstance(version, nameSpace, objectName, ci, ss);
    }

    void setQualifierType(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, CIMQualifierType qt, SecurityToken st) throws CIMException {
        String[] oarray = new String[]{version, "setQualifierType", this.csg.toString(nameSpace), this.csg.toString(objectName), this.csg.toString(qt)};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, this.getNameSpace(nameSpace, objectName), true);
        this.comp.setQualifierType(version, nameSpace, objectName, qt, ss);
    }

    void setClass(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, CIMClass cc, SecurityToken st) throws CIMException {
        String[] oarray = new String[]{version, "setClass", this.csg.toString(nameSpace), this.csg.toString(objectName), this.csg.toString(cc)};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, this.getNameSpace(nameSpace, objectName), true);
        this.comp.setClass(version, nameSpace, objectName, cc, ss);
    }

    void setInstance(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, CIMInstance ci, SecurityToken st) throws CIMException {
        String[] oarray = new String[]{version, "setInstance", this.csg.toString(nameSpace), this.csg.toString(objectName), this.csg.toString(ci)};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, this.getNameSpace(nameSpace, objectName), false);
        this.comp.setInstance(version, nameSpace, objectName, ci, ss);
    }

    void setInstance(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, CIMInstance ci, boolean includeQualifiers, String[] propertyList, SecurityToken st) throws CIMException {
        String[] oarray = new String[]{version, "setInstance", this.csg.toString(nameSpace), this.csg.toString(objectName), this.csg.toString(ci)};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, this.getNameSpace(nameSpace, objectName), false);
        this.comp.setInstance(version, nameSpace, objectName, ci, includeQualifiers, propertyList, ss);
    }

    void setProperty(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, String propertyName, CIMValue cv, SecurityToken st) throws CIMException {
        String[] oarray = new String[]{version, "setProperty", this.csg.toString(nameSpace), this.csg.toString(objectName), propertyName, this.csg.toString(cv)};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, this.getNameSpace(nameSpace, objectName), false);
        this.comp.setProperty(version, nameSpace, objectName, propertyName, cv, ss);
    }

    Vector execQuery(String version, CIMNameSpace nameSpace, CIMObjectPath relNS, String query, String ql, SecurityToken st) throws CIMException {
        String[] oarray = new String[]{version, "execQuery", this.csg.toString(nameSpace), this.csg.toString(relNS), query, ql + ""};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, READ, this.getNameSpace(nameSpace, relNS), false);
        return this.comp.execQuery(version, nameSpace, relNS, query, ql, ss);
    }

    Vector invokeMethod(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, String methodName, Vector inParams, SecurityToken st) throws CIMException {
        String[] oarray = new String[]{version, "invokeMethod", this.csg.toString(nameSpace), this.csg.toString(objectName), methodName, this.csg.toString(inParams)};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, this.getNameSpace(nameSpace, objectName), false);
        return this.comp.invokeMethod(version, nameSpace, objectName, methodName, inParams, ss);
    }

    Vector invokeMethod(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, String methodName, CIMArgument[] inArgs, SecurityToken st) throws CIMException {
        String[] oarray = new String[]{version, "invokeMethod", this.csg.toString(nameSpace), this.csg.toString(objectName), methodName};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, this.getNameSpace(nameSpace, objectName), false);
        return this.comp.invokeMethod(version, nameSpace, objectName, methodName, inArgs, ss);
    }

    CIMValue getProperty(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, String propertyName, SecurityToken st) throws CIMException {
        String[] oarray = new String[]{version, "getProperty", this.csg.toString(nameSpace), this.csg.toString(objectName), propertyName};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, READ, this.getNameSpace(nameSpace, objectName), false);
        return this.comp.getProperty(version, nameSpace, objectName, propertyName, ss);
    }

    CIMQualifierType getQualifierType(String version, CIMNameSpace nameSpace, CIMObjectPath objectName, SecurityToken st) throws CIMException {
        String[] oarray = new String[]{version, "getQualifierType", this.csg.toString(nameSpace), this.csg.toString(objectName)};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, READ, this.getNameSpace(nameSpace, objectName), true);
        return this.comp.getQualifierType(version, nameSpace, objectName, ss);
    }

    void deleteClass(String version, CIMNameSpace ns, CIMObjectPath path, SecurityToken st) throws CIMException {
        String[] oarray = new String[]{version, "deleteClass", this.csg.toString(ns), this.csg.toString(path)};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, this.getNameSpace(ns, path), true);
        this.comp.deleteClass(version, ns, path, ss);
    }

    void deleteInstance(String version, CIMNameSpace ns, CIMObjectPath path, SecurityToken st) throws CIMException {
        String[] oarray = new String[]{version, "deleteInstance", this.csg.toString(ns), this.csg.toString(path)};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, this.getNameSpace(ns, path), false);
        this.comp.deleteInstance(version, ns, path, ss);
    }

    void deleteQualifierType(String version, CIMNameSpace ns, CIMObjectPath path, SecurityToken st) throws CIMException {
        String[] oarray = new String[]{version, "deleteQualifierType", this.csg.toString(ns), this.csg.toString(path)};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, this.getNameSpace(ns, path), true);
        this.comp.deleteQualifierType(version, ns, path, ss);
    }

    Vector enumNameSpace(String version, CIMNameSpace ns, CIMObjectPath path, boolean deep, SecurityToken st) throws CIMException {
        Boolean bln = deep ? Boolean.TRUE : Boolean.FALSE;
        String[] oarray = new String[]{version, "enumNameSpace", this.csg.toString(ns), this.csg.toString(path), bln.toString()};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, READ, this.getNameSpace(ns, path), true);
        return this.comp.enumNameSpace(version, ns, path, deep, ss);
    }

    Vector enumQualifierTypes(String version, CIMNameSpace ns, CIMObjectPath path, SecurityToken st) throws CIMException {
        String[] oarray = new String[]{version, "enumQualifierTypes", this.csg.toString(ns), this.csg.toString(path)};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, READ, this.getNameSpace(ns, path), true);
        return this.comp.enumQualifierTypes(version, ns, path, ss);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerSecurity getServerSecurity(String s) throws CIMSecurityException {
        HashMap hashMap = this.sessionMap;
        synchronized (hashMap) {
            ServerSecurity ss = (ServerSecurity)this.sessionMap.get(s);
            if (ss == null) {
                throw new CIMSecurityException("NO_SUCH_SESSION", (Object)s);
            }
            return ss;
        }
    }

    private void serverSecurityAuthInc(ServerSecurity ss, String[] oarray, SecurityToken st) throws CIMException {
        ss.authenticateRequest(oarray, st);
        ss.incSessionKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerSecurity serverSecurityDo(String[] oarray, SecurityToken st, String rw, String nameSpace, boolean verify) throws CIMException {
        ServerSecurity ss;
        ServerSecurity serverSecurity = ss = this.getServerSecurity(new String(st.getSessionId()));
        synchronized (serverSecurity) {
            this.serverSecurityAuthInc(ss, oarray, st);
            return ss;
        }
    }

    private String getNameSpace(CIMNameSpace ns, CIMObjectPath op) {
        if (ns == null) {
            ns = new CIMNameSpace("", "");
        }
        if (op == null) {
            op = new CIMObjectPath();
        }
        String s = ns.getNameSpace() + '/' + op.getNameSpace();
        CIMNameSpace cns = new CIMNameSpace();
        cns.setNameSpace(s);
        return cns.getNameSpace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assumeRole(String version, String roleName, String rolePasswd, SecurityToken st) throws CIMException {
        try {
            ServerSecurity ss;
            String[] oarray = new String[]{version, "assumeRole", roleName, rolePasswd};
            ServerSecurity serverSecurity = ss = this.getServerSecurity(new String(st.getSessionId()));
            synchronized (serverSecurity) {
                ss.authenticateRequest(oarray, st);
                ss.incSessionKey();
                ss.assumeRole(roleName, rolePasswd);
            }
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    public Vector getVersion(String version, SecurityToken st) throws CIMException {
        Vector<Integer> outp = new Vector<Integer>();
        outp.addElement(new Integer(1));
        outp.addElement(new Integer(0));
        return outp;
    }

    public Vector performOperations(String version, CIMOperation[] batchedOps, SecurityToken st) throws CIMException {
        StringBuffer buff = new StringBuffer();
        Vector<Object> retObjs = new Vector<Object>();
        for (int i = 0; i < batchedOps.length; ++i) {
            buff.append(batchedOps[i].getClass().getName());
        }
        String[] oarray = new String[]{version, buff.toString()};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, READ, "", true);
        for (int i = 0; i < batchedOps.length; ++i) {
            CIMOperation op = batchedOps[i];
            CIMOMOperation cimomOp = BatchOperationFactory.getCIMOMOperation(this.comp, ss, op, version);
            cimomOp.run();
            retObjs.addElement(cimomOp.getResult());
        }
        return retObjs;
    }

    public Vector enumerateClasses(String version, CIMNameSpace nSpace, CIMObjectPath oPath, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, SecurityToken st) throws CIMException {
        CIMEnumClassOp cimop = null;
        EnumClassOperation oper = null;
        cimop = new CIMEnumClassOp(oPath, deep, localOnly, includeQualifiers, includeClassOrigin);
        cimop.setNameSpace(nSpace);
        CheckSumGen csg = new CheckSumGen();
        String[] oarray = new String[]{version, "enumerateClasses", csg.toString(nSpace), csg.toString(oPath), (deep ? Boolean.TRUE : Boolean.FALSE).toString()};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, READ, this.getNameSpace(nSpace, oPath), true);
        oper = new EnumClassOperation(this.comp, ss, cimop, version);
        oper.run();
        Object result = oper.getResult();
        if (result instanceof CIMException) {
            throw (CIMException)((Object)result);
        }
        if (result instanceof Exception) {
            throw new CIMException("CIM_ERR_FAILED", result);
        }
        return (Vector)result;
    }

    public Vector enumerateClassNames(String version, CIMNameSpace nSpace, CIMObjectPath oPath, boolean deep, SecurityToken st) throws CIMException {
        CIMEnumClassNamesOp cimop = null;
        EnumClassNamesOperation oper = null;
        cimop = new CIMEnumClassNamesOp(oPath, deep);
        cimop.setNameSpace(nSpace);
        CheckSumGen csg = new CheckSumGen();
        String[] oarray = new String[]{version, "enumerateClassNames", csg.toString(nSpace), csg.toString(oPath), (deep ? Boolean.TRUE : Boolean.FALSE).toString()};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, READ, this.getNameSpace(nSpace, oPath), true);
        oper = new EnumClassNamesOperation(this.comp, ss, cimop, version);
        oper.run();
        Object result = oper.getResult();
        if (result instanceof CIMException) {
            throw (CIMException)((Object)result);
        }
        if (result instanceof Exception) {
            throw new CIMException("CIM_ERR_FAILED", result);
        }
        return (Vector)result;
    }

    public Vector enumerateInstances(String version, CIMNameSpace nSpace, CIMObjectPath oPath, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, SecurityToken st) throws CIMException {
        CIMEnumInstancesOp cimop = null;
        EnumInstancesOperation oper = null;
        cimop = new CIMEnumInstancesOp(oPath, deep, localOnly, includeQualifiers, includeClassOrigin, propertyList);
        cimop.setNameSpace(nSpace);
        CheckSumGen csg = new CheckSumGen();
        String[] oarray = new String[]{version, "enumerateInstances", csg.toString(nSpace), csg.toString(oPath), (deep ? Boolean.TRUE : Boolean.FALSE).toString()};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, READ, this.getNameSpace(nSpace, oPath), true);
        oper = new EnumInstancesOperation(this.comp, ss, cimop, version);
        oper.run();
        Object result = oper.getResult();
        if (result instanceof CIMException) {
            throw (CIMException)((Object)result);
        }
        if (result instanceof Exception) {
            throw new CIMException("CIM_ERR_FAILED", result);
        }
        return (Vector)result;
    }

    public Vector enumerateInstanceNames(String version, CIMNameSpace nSpace, CIMObjectPath oPath, SecurityToken st) throws CIMException {
        EnumInstanceNamesOperation oper = null;
        CIMEnumInstanceNamesOp cimop = null;
        cimop = new CIMEnumInstanceNamesOp(oPath);
        cimop.setNameSpace(nSpace);
        CheckSumGen csg = new CheckSumGen();
        String[] oarray = new String[]{version, "enumerateInstanceNames", csg.toString(nSpace), csg.toString(oPath)};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, READ, this.getNameSpace(nSpace, oPath), true);
        oper = new EnumInstanceNamesOperation(this.comp, ss, cimop, version);
        oper.run();
        Object result = oper.getResult();
        if (result instanceof CIMException) {
            throw (CIMException)((Object)result);
        }
        if (result instanceof Exception) {
            throw new CIMException("CIM_ERR_FAILED", result);
        }
        return (Vector)result;
    }

    public CIMClass getClass(String version, CIMNameSpace nSpace, CIMObjectPath oPath, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, SecurityToken st) throws CIMException {
        GetClassOperation oper = null;
        CIMGetClassOp cimop = null;
        cimop = new CIMGetClassOp(oPath, localOnly, includeQualifiers, includeClassOrigin, propertyList);
        cimop.setNameSpace(nSpace);
        CheckSumGen csg = new CheckSumGen();
        String[] oarray = new String[]{version, "getClass", csg.toString(nSpace), csg.toString(oPath), (localOnly ? Boolean.TRUE : Boolean.FALSE).toString()};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, READ, this.getNameSpace(nSpace, oPath), true);
        oper = new GetClassOperation(this.comp, ss, cimop, version);
        oper.run();
        Object result = oper.getResult();
        if (result instanceof CIMException) {
            throw (CIMException)((Object)result);
        }
        if (result instanceof Exception) {
            throw new CIMException("CIM_ERR_FAILED", result);
        }
        return (CIMClass)result;
    }

    public CIMInstance getInstance(String version, CIMNameSpace nSpace, CIMObjectPath oPath, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, SecurityToken st) throws CIMException {
        GetInstanceOperation oper = null;
        CIMGetInstanceOp cimop = null;
        cimop = new CIMGetInstanceOp(oPath, localOnly, includeQualifiers, includeClassOrigin, propertyList);
        cimop.setNameSpace(nSpace);
        CheckSumGen csg = new CheckSumGen();
        String[] oarray = new String[]{version, "getInstance", csg.toString(nSpace), csg.toString(oPath), (localOnly ? Boolean.TRUE : Boolean.FALSE).toString()};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, READ, this.getNameSpace(nSpace, oPath), true);
        oper = new GetInstanceOperation(this.comp, ss, cimop, version);
        oper.run();
        Object result = oper.getResult();
        if (result instanceof CIMException) {
            throw (CIMException)((Object)result);
        }
        if (result instanceof Exception) {
            throw new CIMException("CIM_ERR_FAILED", result);
        }
        return (CIMInstance)result;
    }

    public Vector associators(String version, CIMNameSpace nSpace, CIMObjectPath oPath, String assocClass, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, SecurityToken st) throws CIMException {
        CIMAssociatorsOp cimop = null;
        AssociatorsOperation oper = null;
        cimop = new CIMAssociatorsOp(oPath, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList);
        cimop.setNameSpace(nSpace);
        CheckSumGen csg = new CheckSumGen();
        String[] oarray = new String[]{version, "associators", csg.toString(nSpace), csg.toString(oPath), assocClass, resultClass, role, resultRole};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, READ, this.getNameSpace(nSpace, oPath), true);
        oper = new AssociatorsOperation(this.comp, ss, cimop, version);
        oper.run();
        Object result = oper.getResult();
        if (result instanceof CIMException) {
            throw (CIMException)((Object)result);
        }
        if (result instanceof Exception) {
            throw new CIMException("CIM_ERR_FAILED", result);
        }
        return (Vector)result;
    }

    public Vector associatorNames(String version, CIMNameSpace nSpace, CIMObjectPath oPath, String assocClass, String resultClass, String role, String resultRole, SecurityToken st) throws CIMException {
        AssociatorNamesOperation oper = null;
        CIMAssociatorNamesOp cimop = null;
        cimop = new CIMAssociatorNamesOp(oPath, assocClass, resultClass, role, resultRole);
        cimop.setNameSpace(nSpace);
        CheckSumGen csg = new CheckSumGen();
        String[] oarray = new String[]{version, "associatorNames", csg.toString(nSpace), csg.toString(oPath), assocClass, resultClass, role, resultRole};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, READ, this.getNameSpace(nSpace, oPath), true);
        oper = new AssociatorNamesOperation(this.comp, ss, cimop, version);
        oper.run();
        Object result = oper.getResult();
        if (result instanceof CIMException) {
            throw (CIMException)((Object)result);
        }
        if (result instanceof Exception) {
            throw new CIMException("CIM_ERR_FAILED", result);
        }
        return (Vector)result;
    }

    public Vector references(String version, CIMNameSpace nSpace, CIMObjectPath oPath, String resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, SecurityToken st) throws CIMException {
        ReferencesOperation oper = null;
        CIMReferencesOp cimop = null;
        cimop = new CIMReferencesOp(oPath, resultClass, role, includeQualifiers, includeClassOrigin, propertyList);
        cimop.setNameSpace(nSpace);
        CheckSumGen csg = new CheckSumGen();
        String[] oarray = new String[]{version, "references", csg.toString(nSpace), csg.toString(oPath), resultClass, role};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, READ, this.getNameSpace(nSpace, oPath), true);
        oper = new ReferencesOperation(this.comp, ss, cimop, version);
        oper.run();
        Object result = oper.getResult();
        if (result instanceof CIMException) {
            throw (CIMException)((Object)result);
        }
        if (result instanceof Exception) {
            throw new CIMException("CIM_ERR_FAILED", result);
        }
        return (Vector)result;
    }

    public Vector referenceNames(String version, CIMNameSpace nSpace, CIMObjectPath oPath, String resultClass, String role, SecurityToken st) throws CIMException {
        ReferenceNamesOperation oper = null;
        CIMReferenceNamesOp cimop = null;
        cimop = new CIMReferenceNamesOp(oPath, resultClass, role);
        cimop.setNameSpace(nSpace);
        CheckSumGen csg = new CheckSumGen();
        String[] oarray = new String[]{version, "referenceNames", csg.toString(nSpace), csg.toString(oPath), resultClass, role};
        ServerSecurity ss = this.serverSecurityDo(oarray, st, READ, this.getNameSpace(nSpace, oPath), true);
        oper = new ReferenceNamesOperation(this.comp, ss, cimop, version);
        oper.run();
        Object result = oper.getResult();
        if (result instanceof CIMException) {
            throw (CIMException)((Object)result);
        }
        if (result instanceof Exception) {
            throw new CIMException("CIM_ERR_FAILED", result);
        }
        return (Vector)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListener(String version, RemoteCIMListener rl, SecurityToken st) throws CIMException {
        ServerSecurity ss = this.getServerSecurity(new String(st.getSessionId()));
        try {
            ServerSecurity serverSecurity = ss;
            synchronized (serverSecurity) {
                ss.setListener(rl);
            }
        }
        catch (Exception ex) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
    }

    class RMIIndicationHandler
    implements EventService.IndicationHandler {
        RMIIndicationHandler() {
        }

        private RemoteCIMListener getRemoteListener(CIMInstance handlerInstance) throws CIMException {
            String sessionID = (String)handlerInstance.getProperty("name").getValue().getValue();
            ServerSecurity ss = (ServerSecurity)CIMOMRMIImpl.this.sessionMap.get(sessionID);
            if (ss == null) {
                Debug.trace2((String)("No session " + sessionID));
                throw new CIMException("CIM_ERR_FAILED", (Object)"No session ", (Object)sessionID);
            }
            return ss.getListener();
        }

        public CommonServerSecurityContext getSecurityContext(CIMInstance handlerInstance) {
            String sessionID = (String)handlerInstance.getProperty("name").getValue().getValue();
            return (CommonServerSecurityContext)CIMOMRMIImpl.this.sessionMap.get(sessionID);
        }

        public void deliverEvent(CIMEvent e, CIMInstance handlerInstance) throws CIMException {
            RemoteCIMListener rl = this.getRemoteListener(handlerInstance);
            if (rl == null) {
                Debug.trace2((String)"No remote listener");
                throw new CIMException("CIM_ERR_FAILED", "No remote listener");
            }
            try {
                rl.indicationOccured(e, null);
            }
            catch (Exception ex) {
                throw new CIMException("CIM_ERR_FAILED", (Object)ex);
            }
        }

        public void ping(CIMInstance handlerInstance) throws CIMException {
            RemoteCIMListener rl = this.getRemoteListener(handlerInstance);
            if (rl == null) {
                Debug.trace2((String)"No remote listener");
                throw new CIMException("CIM_ERR_FAILED", "No remote listener");
            }
            try {
                rl.isAvailable();
            }
            catch (Exception ex) {
                throw new CIMException("CIM_ERR_FAILED", (Object)ex);
            }
        }
    }
}

