/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.cimom.adapters.provider.java;

import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMClassException;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.Debug;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.CIMAssociatorProvider;
import javax.wbem.provider.CIMIndicationProvider;
import javax.wbem.provider.CIMInstanceProvider;
import javax.wbem.provider.CIMMethodProvider;
import javax.wbem.provider.CIMProvider;
import javax.wbem.provider.EventProvider;
import org.wbemservices.wbem.cimom.adapter.provider.ProviderAdapterIF;
import org.wbemservices.wbem.cimom.adapter.provider.ProviderProtocolAdapterIF;
import org.wbemservices.wbem.cimom.util.DynClassLoader;

public class JavaProviderAdapter
implements ProviderProtocolAdapterIF,
CIMInstanceProvider {
    private static final String DESCRIPTION = "A Java class provider adapter";
    private static final String VENDOR = "Sun Microsystems Inc.";
    private static final int VERSION = 1;
    private static final String PROVIDERPATHCLASS = "solaris_providerpath";
    private static final String SYSTEMNS = "/root/system";
    private static final String PATHURLPROPERTY = "pathurl";
    private boolean valid = false;
    private ProviderCIMOMHandle mCimom;
    private DynClassLoader dcl = null;
    private boolean passAllCheck = false;
    private CIMInstanceProvider internalProvider;

    public JavaProviderAdapter() {
        ClassLoader cl = this.getClass().getClassLoader();
        this.dcl = cl instanceof DynClassLoader ? (DynClassLoader)cl : new DynClassLoader(this.getClass().getClassLoader());
    }

    void updatePath(String path) throws CIMException {
        try {
            this.dcl.addToClassPath(path);
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    public void initialize(ProviderCIMOMHandle pCimom) {
        this.mCimom = pCimom;
        String passAll = System.getProperty("passAllProviderCheck", "false");
        if (passAll != null) {
            this.passAllCheck = passAll.compareToIgnoreCase("true") == 0;
        }
        CIMObjectPath provPath = new CIMObjectPath(PROVIDERPATHCLASS);
        provPath.setNameSpace(SYSTEMNS);
        try {
            this.internalProvider = this.mCimom.getInternalCIMInstanceProvider();
            CIMObjectPath[] ops = this.internalProvider.enumerateInstanceNames(provPath, null);
            if (ops == null) {
                Debug.trace2((String)"Got a null return for enumerate");
                return;
            }
            for (int i = 0; i < ops.length; ++i) {
                CIMObjectPath pathOp = ops[i];
                CIMProperty pathProp = (CIMProperty)pathOp.getKeys().elementAt(0);
                try {
                    String url = (String)pathProp.getValue().getValue();
                    this.updatePath(url);
                    continue;
                }
                catch (Exception e1) {
                    Debug.trace1((String)"Failure updating the classpath", (Throwable)e1);
                }
            }
        }
        catch (Exception e) {
            Debug.trace1((String)"Problem enumerating path info", (Throwable)e);
        }
    }

    public void start() {
        this.valid = true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void stop() {
        this.valid = false;
    }

    public int getVersion() {
        return 1;
    }

    public String getVendor() {
        return VENDOR;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public Object loadProvider(String pNamespace, String pName, String[] pParams, CIMClass pCimClass) throws ClassNotFoundException, CIMClassException {
        try {
            Debug.trace3((String)("Need to load provider " + pName));
            Object obj = null;
            Class<?> c = this.dcl.loadClass(pName);
            Debug.trace3((String)("Loaded java class " + c.getName()));
            obj = c.newInstance();
            if (obj instanceof ProviderAdapterIF) {
                ProviderAdapterIF provider = obj;
                provider.getProvider().initialize((CIMOMHandle)this.mCimom);
                return provider;
            }
            if (obj instanceof CIMProvider) {
                Debug.trace3((String)(c.getName() + " is a new provider type"));
                CIMProvider provider = obj;
                WrappedProviderAdapter providerIF = new WrappedProviderAdapter(provider);
                providerIF.getProvider().initialize((CIMOMHandle)this.mCimom);
                return providerIF;
            }
        }
        catch (InstantiationException ie) {
            throw new ClassNotFoundException(ie.toString(), ie);
        }
        catch (IllegalAccessException iae) {
            throw new CIMClassException(iae.toString(), (Object)iae);
        }
        catch (CIMException ce) {
            throw new ClassNotFoundException(ce.toString(), ce);
        }
        throw new CIMClassException("CIM_ERR_INVALID_CLASS");
    }

    public void unloadProvider(Object pUnique) throws CIMClassException {
        if (pUnique == null) {
            throw new CIMClassException("CIM_ERR_FAILED", (Object)"Provider identifier is null");
        }
        CIMProvider prov = this.getProviderAdapter(pUnique).getProvider();
        try {
            prov.cleanup();
        }
        catch (CIMException ce) {
            throw new CIMClassException(ce.getID(), (Object)ce);
        }
    }

    public ProviderAdapterIF getProviderAdapter(Object pProvider) throws CIMClassException {
        if (pProvider instanceof ProviderAdapterIF) {
            return (ProviderAdapterIF)pProvider;
        }
        throw new CIMClassException("CIM_ERR_INVALID_CLASS", (Object)"Unrecognized object!");
    }

    public void terminate() {
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        return this.internalProvider.enumerateInstanceNames(op, cc);
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        return this.internalProvider.enumerateInstances(op, localOnly, includeQualifiers, includeClassOrigin, propertyList, cc);
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        return this.internalProvider.getInstance(op, localOnly, includeQualifiers, includeClassOrigin, propertyList, cc);
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        try {
            String url = (String)ci.getProperty(PATHURLPROPERTY).getValue().getValue();
            this.updatePath(url);
            return this.internalProvider.createInstance(op, ci);
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci, boolean includeQualifiers, String[] propertyList) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        this.internalProvider.deleteInstance(op);
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        return this.internalProvider.execQuery(op, query, ql, cc);
    }

    public void initialize(CIMOMHandle pCimom) {
    }

    public void cleanup() {
    }

    public class WrappedProviderAdapter
    implements ProviderAdapterIF {
        private CIMProvider mWrapped = null;
        private boolean isCIMInst = false;
        private boolean isCIMMethod = false;
        private boolean isCIMAssoc = false;
        private boolean isCIMIndication = false;
        private boolean isAuth = false;
        private boolean isEvent = false;

        WrappedProviderAdapter(CIMProvider pWrapped) {
            this.mWrapped = pWrapped;
            this.isCIMInst = pWrapped instanceof CIMInstanceProvider;
            this.isCIMMethod = pWrapped instanceof CIMMethodProvider;
            this.isCIMAssoc = pWrapped instanceof CIMAssociatorProvider;
            this.isCIMIndication = pWrapped instanceof CIMIndicationProvider;
            this.isAuth = pWrapped instanceof Authorizable;
            this.isEvent = pWrapped instanceof EventProvider;
        }

        public boolean isInstanceProvider() {
            return this.isCIMInst;
        }

        public boolean isMethodProvider() {
            return this.isCIMMethod;
        }

        public boolean isCIMIndicationProvider() {
            return this.isCIMIndication;
        }

        public boolean isEventProvider() {
            return this.isEvent;
        }

        public boolean isAuthorizable() {
            return this.isAuth;
        }

        public boolean isAssociatorProvider() {
            return this.isCIMAssoc;
        }

        public CIMProvider getProvider() {
            return this.mWrapped;
        }
    }
}

