/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.wbem.cim.CIMSimpleDateTime;
import org.sblim.wbem.util.GlobalProperties;

public class CIMDateTime
implements Serializable,
Cloneable {
    protected String s;
    protected Calendar calendar = null;
    protected boolean interval = false;
    protected int year;
    protected int month;
    protected int day;
    protected int hour;
    protected int minute;
    protected int second;
    protected int millisecond;
    protected int offsetminute;
    protected int presicion = 12;
    public static final int YEAR_PRESICION = 0;
    public static final int MONTH_PRESICION = 1;
    public static final int DAY_PRESICION = 2;
    public static final int HOUR_PRESICION = 3;
    public static final int MINUTE_PRESICION = 4;
    public static final int SECOND_PRESICION = 5;
    public static final int MILLI_ONE_DIGIT_PRESICION = 6;
    public static final int MILLI_TWO_DIGIT_PRESICION = 7;
    public static final int MILLI_THREE_DIGIT_PRESICION = 8;
    public static final int MILLI_FOUR_DIGIT_PRESICION = 9;
    public static final int MILLI_FIVE_DIGIT_PRESICION = 10;
    public static final int MILLI_SIX_DIGIT_PRESICION = 11;
    public static final int FULL_PRESICION = 12;

    public CIMDateTime(Calendar cal) {
        if (cal == null) {
            throw new IllegalArgumentException("null calendar argument");
        }
        Calendar calendar = (Calendar)cal.clone();
        this.offsetminute = calendar.get(15) / 60000;
        this.year = calendar.get(1);
        this.month = calendar.get(2) - calendar.getMinimum(2) + 1;
        this.day = calendar.get(5) - calendar.getMinimum(5) + 1;
        this.hour = calendar.get(11) - calendar.getMinimum(11);
        this.minute = calendar.get(12) - calendar.getMinimum(12);
        this.second = calendar.get(13) - calendar.getMinimum(13);
        this.millisecond = calendar.get(14) - calendar.getMinimum(14);
        this.presicion = 12;
    }

    public CIMDateTime(String dateStr) {
        char sign = dateStr.charAt(21);
        if (sign == ':') {
            this.interval = true;
        }
        CIMDateTime.valueOf(this, dateStr);
    }

    protected CIMDateTime() {
    }

    public Object clone() {
        CIMDateTime that = null;
        if (this instanceof CIMDateTime || this.interval) {
            that = new CIMDateTime();
        } else if (this instanceof CIMSimpleDateTime) {
            that = new CIMSimpleDateTime();
        }
        that.calendar = this.calendar;
        that.year = this.year;
        that.month = this.month;
        that.day = this.day;
        that.hour = this.hour;
        that.minute = this.minute;
        that.second = this.second;
        that.millisecond = this.millisecond;
        that.presicion = this.presicion;
        return this;
    }

    public static CIMDateTime valueOf(String dateStr) {
        CIMDateTime datetime = null;
        char sign = dateStr.charAt(21);
        if (sign == ':') {
            datetime = new CIMDateTime();
            datetime.interval = true;
        } else {
            datetime = new CIMSimpleDateTime();
        }
        return CIMDateTime.valueOf(datetime, dateStr);
    }

    protected static CIMDateTime valueOf(CIMDateTime datetime, String dateStr) {
        try {
            String _millisecond;
            int i;
            String _second;
            String _minute;
            char sign = dateStr.charAt(21);
            if (dateStr == null) {
                throw new IllegalArgumentException("null calendar argument");
            }
            datetime.s = dateStr;
            if (dateStr.length() != 25) {
                throw new IllegalArgumentException("Invalid length of cim date type: " + dateStr);
            }
            if (!datetime.interval) {
                String _day;
                datetime.presicion = 12;
                String _year = dateStr.substring(0, 4);
                if (_year.indexOf(42) > -1) {
                    datetime.presicion = 0;
                } else {
                    datetime.year = Integer.parseInt(_year);
                }
                String _month = dateStr.substring(4, 6);
                if (_month.indexOf(42) > -1) {
                    if (datetime.presicion == 12) {
                        datetime.presicion = 1;
                    }
                } else {
                    datetime.month = Integer.parseInt(_month);
                }
                if ((_day = dateStr.substring(6, 8)).indexOf(42) > -1) {
                    if (datetime.presicion == 12) {
                        datetime.presicion = 2;
                    }
                } else {
                    datetime.day = Integer.parseInt(_day);
                }
            } else {
                String _day = dateStr.substring(0, 8);
                if (_day.indexOf(42) > -1) {
                    if (datetime.presicion == 12) {
                        datetime.presicion = 2;
                    }
                } else {
                    datetime.day = Integer.parseInt(_day);
                }
            }
            String _hour = dateStr.substring(8, 10);
            if (_hour.indexOf(42) > -1) {
                if (datetime.presicion == 12) {
                    datetime.presicion = 3;
                }
            } else {
                datetime.hour = Integer.parseInt(_hour);
            }
            if ((_minute = dateStr.substring(10, 12)).indexOf(42) > -1) {
                if (datetime.presicion == 12) {
                    datetime.presicion = 4;
                }
            } else {
                datetime.minute = Integer.parseInt(_minute);
            }
            if ((_second = dateStr.substring(12, 14)).indexOf(42) > -1) {
                if (datetime.presicion == 12) {
                    datetime.presicion = 5;
                }
            } else {
                datetime.second = Integer.parseInt(_second);
            }
            if ((i = (_millisecond = dateStr.substring(15, 21)).indexOf(42)) > -1) {
                if (datetime.presicion == 12) {
                    datetime.presicion = i + 6;
                }
                datetime.millisecond = Integer.parseInt(_millisecond.replace('*', '0'));
            } else {
                datetime.millisecond = Integer.parseInt(_millisecond);
            }
            datetime.offsetminute = Integer.parseInt(dateStr.substring(22, 25));
            if (sign != ':') {
                if (sign == '-') {
                    datetime.offsetminute = -datetime.offsetminute;
                } else if (sign != '+') {
                    throw new IllegalArgumentException("Invalid cim date type:" + dateStr);
                }
            } else if (datetime.offsetminute > 0) {
                throw new IllegalArgumentException("Invalid offset minute of cim date time: " + dateStr);
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            Logger logger = GlobalProperties.getLogger();
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "error while parsing CIMDateTime value: " + dateStr, e);
            }
            throw new IllegalArgumentException("Invalid cim date type: " + dateStr);
        }
        return datetime;
    }

    public int hashCode() {
        int hashvalue = 31;
        if (this.interval) {
            return this.getCalendar().hashCode();
        }
        hashvalue *= this.day;
        hashvalue *= this.hour;
        hashvalue *= this.minute;
        hashvalue *= this.hour;
        hashvalue *= this.second;
        hashvalue *= this.millisecond;
        return hashvalue *= this.presicion;
    }

    public boolean after(CIMDateTime that) {
        if (that == null) {
            throw new IllegalArgumentException("null calendar argument");
        }
        if (this.interval || that.interval) {
            return false;
        }
        return this.getCalendar().after(that.getCalendar());
    }

    public boolean before(CIMDateTime that) {
        if (that == null) {
            throw new IllegalArgumentException("null calendar argument");
        }
        if (this.interval || that.interval) {
            return false;
        }
        return this.getCalendar().before(that.getCalendar());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CIMDateTime)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        CIMDateTime that = (CIMDateTime)o;
        if (this.interval == that.interval) {
            if (!this.interval) {
                return this.getCalendar().equals(that.getCalendar());
            }
            return this.day == that.day && this.hour == that.hour && this.second == that.second && this.millisecond == that.millisecond;
        }
        return false;
    }

    public boolean isInterval() {
        return this.interval;
    }

    public Calendar getCalendar() {
        if (this.calendar == null && !this.interval) {
            TimeZone timezone = TimeZone.getDefault();
            timezone.setRawOffset(this.offsetminute * 60 * 1000);
            this.calendar = Calendar.getInstance(timezone);
            this.calendar.set(this.year, this.month - 1 + this.calendar.getMinimum(2), this.day - 1 + this.calendar.getMinimum(5), this.hour + this.calendar.getMinimum(11), this.minute + this.calendar.getMinimum(12), this.second + this.calendar.getMinimum(13));
            this.calendar.set(14, this.millisecond);
        }
        return (Calendar)this.calendar.clone();
    }

    public String toMOF() {
        StringBuffer buf = new StringBuffer();
        if (!this.interval) {
            if (this.isYearPresicion()) {
                buf.append(this.zeroPadding(this.year, 4));
            } else {
                buf.append(this.starPadding(4));
            }
            if (this.isMonthPresicion()) {
                buf.append(this.zeroPadding(this.month, 2));
            } else {
                buf.append(this.starPadding(2));
            }
            if (this.isDayPresicion()) {
                buf.append(this.zeroPadding(this.day, 2));
            } else {
                buf.append(this.starPadding(2));
            }
        } else if (this.isDayPresicion()) {
            buf.append(this.zeroPadding(this.day, 8));
        } else {
            buf.append(this.starPadding(8));
        }
        if (this.isHourPresicion()) {
            buf.append(this.zeroPadding(this.hour, 2));
        } else {
            buf.append(this.starPadding(2));
        }
        if (this.isMinutePresicion()) {
            buf.append(this.zeroPadding(this.minute, 2));
        } else {
            buf.append(this.starPadding(2));
        }
        if (this.isSecondPresicion()) {
            buf.append(this.zeroPadding(this.second, 2));
        } else {
            buf.append(this.starPadding(2));
        }
        buf.append('.');
        int millisecodsPresicion = this.getMillisecodsPresicion();
        if (millisecodsPresicion < 6) {
            int _millis = this.millisecond;
            for (int n = 0; n < 6 - millisecodsPresicion; ++n) {
                _millis /= 10;
            }
            if (millisecodsPresicion > 0) {
                buf.append(this.zeroPadding(_millis, millisecodsPresicion));
            }
            buf.append(this.starPadding(6 - millisecodsPresicion));
        } else {
            buf.append(this.zeroPadding(this.millisecond, 6));
        }
        if (this.interval) {
            buf.append(":000");
        } else if (this.offsetminute > 0) {
            buf.append('+');
            buf.append(this.zeroPadding(this.offsetminute, 3));
        } else {
            buf.append('-');
            buf.append(this.zeroPadding(-this.offsetminute, 3));
        }
        return buf.toString();
    }

    protected String starPadding(int digits) {
        if (digits > 0) {
            return "**********".substring(0, digits);
        }
        return "";
    }

    protected String zeroPadding(int value, int digits) {
        String str = String.valueOf(value);
        if (digits - str.length() > 0) {
            return "00000000000".substring(0, digits - str.length()) + str;
        }
        return str;
    }

    public String toString() {
        return this.toMOF();
    }

    public int getMillisecond() {
        return this.millisecond;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getOffsetMinute() {
        return this.offsetminute;
    }

    public int getSeconds() {
        return this.second;
    }

    public void setHour(int hour) {
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("invalid value of hour [1-24]:" + hour);
        }
        this.calendar = null;
        this.hour = hour;
    }

    public void setMilliseconds(int millisecond) {
        if (millisecond < 0 || millisecond > 999999) {
            throw new IllegalArgumentException("invalid value of millisecond [0-999999]:" + millisecond);
        }
        this.calendar = null;
        this.millisecond = millisecond;
    }

    public void setMinute(int minute) {
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException("invalid value of minute:" + minute);
        }
        this.calendar = null;
        this.minute = minute;
    }

    public void setOffsetMinute(int offminutes) {
        if (offminutes < -999 || offminutes > 999) {
            throw new IllegalArgumentException("invalid value of offset minute:" + offminutes);
        }
        this.calendar = null;
        this.offsetminute = offminutes;
    }

    public void setSecond(int second) {
        if (second < 0 || second > 59) {
            throw new IllegalArgumentException("invalid value of second:" + second);
        }
        this.calendar = null;
        this.second = second;
    }

    public boolean isDayPresicion() {
        return this.presicion > 2;
    }

    public boolean isHourPresicion() {
        return this.presicion > 3;
    }

    public int getMillisecodsPresicion() {
        if (this.presicion > 5) {
            return this.presicion - 6;
        }
        return 0;
    }

    public boolean isMinutePresicion() {
        return this.presicion > 4;
    }

    public boolean isMonthPresicion() {
        return this.presicion > 1;
    }

    public boolean isSecondPresicion() {
        return this.presicion > 5;
    }

    public boolean isYearPresicion() {
        return this.presicion > 0;
    }

    public void setPresicion(int prec) {
        if (prec < 0 || prec > 12) {
            throw new IllegalArgumentException("precision argument out of range [0-11]:" + prec);
        }
        this.presicion = prec;
    }

    public int getPresicion() {
        return this.presicion;
    }

    public static void main(String[] args) {
        System.out.println(new CIMDateTime("12345678901234.567890:000"));
        System.out.println(new CIMDateTime("12345678901234.56789*:000"));
        System.out.println(new CIMDateTime("12345678901234.5678**:000"));
        System.out.println(new CIMDateTime("12345678901234.567***:000"));
        System.out.println(new CIMDateTime("12345678901234.56****:000"));
        System.out.println(new CIMDateTime("12345678901234.5*****:000"));
        System.out.println(new CIMDateTime("12345678901234.******:000"));
        System.out.println(new CIMDateTime("123456789012**.******:000"));
        System.out.println(new CIMDateTime("1234567890****.******:000"));
        System.out.println(new CIMDateTime("12345678******.******:000"));
        System.out.println(new CIMDateTime("1234**********.******+000"));
        System.out.println(new CIMDateTime("12*45678901234.567890+100"));
    }
}

