/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;

public class CIMException
extends RuntimeException
implements Serializable {
    public static final String CIM_ERR_FAILED = "CIM_ERR_FAILED";
    public static final String CIM_ERR_ACCESS_DENIED = "CIM_ERR_ACCESS_DENIED";
    public static final String CIM_ERR_INVALID_NAMESPACE = "CIM_ERR_INVALID_NAMESPACE";
    public static final String CIM_ERR_INVALID_PARAMETER = "CIM_ERR_INVALID_PARAMETER";
    public static final String CIM_ERR_INVALID_CLASS = "CIM_ERR_INVALID_CLASS";
    public static final String CIM_ERR_NOT_FOUND = "CIM_ERR_NOT_FOUND";
    public static final String CIM_ERR_NOT_SUPPORTED = "CIM_ERR_NOT_SUPPORTED";
    public static final String CIM_ERR_CLASS_HAS_CHILDREN = "CIM_ERR_CLASS_HAS_CHILDREN";
    public static final String CIM_ERR_CLASS_HAS_INSTANCES = "CIM_ERR_CLASS_HAS_INSTANCES";
    public static final String CIM_ERR_INVALID_SUPERCLASS = "CIM_ERR_INVALID_SUPERCLASS";
    public static final String CIM_ERR_ALREADY_EXISTS = "CIM_ERR_ALREADY_EXISTS";
    public static final String CIM_ERR_NO_SUCH_PROPERTY = "CIM_ERR_NO_SUCH_PROPERTY";
    public static final String CIM_ERR_TYPE_MISMATCH = "CIM_ERR_TYPE_MISMATCH";
    public static final String CIM_ERR_LOW_ON_MEMORY = "CIM_ERR_LOW_ON_MEMORY";
    public static final String CIM_ERR_QUERY_LANGUAGE_NOT_SUPPORTED = "CIM_ERR_QUERY_LANGUAGE_NOT_SUPPORTED";
    public static final String CIM_ERR_INVALID_QUERY = "CIM_ERR_INVALID_QUERY";
    public static final String CIM_ERR_METHOD_NOT_AVAILABLE = "CIM_ERR_METHOD_NOT_AVAILABLE";
    public static final String CIM_ERR_METHOD_NOT_FOUND = "CIM_ERR_METHOD_NOT_FOUND";
    public static final String CIM_ERR_NOT_IMPLEMENTED = "CIM_ERR_NOT_IMPLEMENTED";
    public static final String IBM_ERR_VER_ERROR = "IBM_ERR_VER_ERROR";
    public static final String IBM_ERR_TIMED_OUT = "IBM_ERR_TIMED_OUT";
    protected static final String[] cimErrorNames = new String[]{"CIM_ERR_FAILED", "CIM_ERR_ACCESS_DENIED", "CIM_ERR_INVALID_NAMESPACE", "CIM_ERR_INVALID_PARAMETER", "CIM_ERR_INVALID_CLASS", "CIM_ERR_NOT_FOUND", "CIM_ERR_NOT_SUPPORTED", "CIM_ERR_CLASS_HAS_CHILDREN", "CIM_ERR_CLASS_HAS_INSTANCES", "CIM_ERR_INVALID_SUPERCLASS", "CIM_ERR_ALREADY_EXISTS", "CIM_ERR_NO_SUCH_PROPERTY", "CIM_ERR_TYPE_MISMATCH", "CIM_ERR_QUERY_LANGUAGE_NOT_SUPPORTED", "CIM_ERR_INVALID_QUERY", "CIM_ERR_METHOD_NOT_AVAILABLE", "CIM_ERR_METHOD_NOT_FOUND"};
    private Throwable cause;
    private String reason;
    private String description;
    private Object[] extendedReason;

    public CIMException() {
        this((String)null, (Object[])null);
    }

    public CIMException(String reason) {
        this(reason, (Object[])null);
    }

    public CIMException(String reason, Object extendedReason) {
        this(reason, new Object[]{extendedReason});
    }

    public CIMException(String reason, Object extendedReason1, Object extendedReason2) {
        this(reason, new Object[]{extendedReason1, extendedReason2});
    }

    public CIMException(String reason, Object extendedReason1, Object extendedReason2, Object extendedReason3) {
        this(reason, new Object[]{extendedReason1, extendedReason2, extendedReason3});
    }

    public CIMException(String reason, Object[] extendedReason) {
        super(reason);
        if (extendedReason != null) {
            for (int i = 0; i < extendedReason.length; ++i) {
                if (!(extendedReason[i] instanceof Throwable)) continue;
                this.cause = (Throwable)extendedReason[i];
                break;
            }
        }
        this.reason = reason;
        this.extendedReason = extendedReason;
    }

    public CIMException(String reason, Throwable throwable) {
        super(reason);
        this.cause = throwable;
        this.reason = reason;
        this.extendedReason = null;
    }

    public synchronized Throwable initCause(Throwable cause) {
        if (this.cause != this) {
            throw new IllegalStateException("Can't overwrite cause");
        }
        if (cause == this) {
            throw new IllegalArgumentException("Self-causation not permitted");
        }
        this.cause = cause;
        return this;
    }

    public String getID() {
        return this.reason;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        if (this.description == null) {
            String rsn = this.reason;
            if (this.extendedReason != null) {
                int i;
                StringBuffer sb = new StringBuffer();
                boolean anyExtendedReason = false;
                sb.append('(');
                sb.append(this.reason);
                sb.append(": ");
                for (i = 0; i < this.extendedReason.length - 1; ++i) {
                    if (this.extendedReason[i] != null) {
                        sb.append(this.extendedReason[i].toString());
                    } else {
                        sb.append("null");
                    }
                    sb.append(',');
                }
                sb.append(this.extendedReason[i]);
                sb.append(')');
                sb.insert(0, this.reason);
                return sb.toString();
            }
            return this.reason;
        }
        return this.description;
    }

    public String toString() {
        String rsn = this.reason;
        if (this.extendedReason != null) {
            int i;
            StringBuffer sb = new StringBuffer();
            boolean anyExtendedReason = false;
            sb.append('(');
            for (i = 0; i < this.extendedReason.length - 1; ++i) {
                Object o = this.extendedReason[i];
                if (o != null && !(o instanceof Throwable)) {
                    sb.append(this.extendedReason[i].toString());
                } else {
                    sb.append("null");
                }
                sb.append(',');
            }
            sb.append(this.extendedReason[i]);
            sb.append(')');
            sb.insert(0, super.toString());
            return sb.toString();
        }
        return super.toString();
    }

    public int getStatusCode() {
        return CIMException.getStatusCode(this.reason);
    }

    public static int getStatusCode(String s) {
        if (s == null) {
            return -1;
        }
        for (int i = 0; i < cimErrorNames.length; ++i) {
            if (!s.equalsIgnoreCase(cimErrorNames[i])) continue;
            return i + 1;
        }
        return -1;
    }

    public static String getStatusFromCode(int i) {
        return cimErrorNames[i > 0 && i <= cimErrorNames.length ? i - 1 : 0];
    }

    public void setParams(Object[] param) {
        this.extendedReason = param;
    }

    public Object[] getParams() {
        return this.extendedReason;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CIMException)) {
            return false;
        }
        CIMException that = (CIMException)o;
        if (!(this.description == null && that.description == null || this.description != null && this.description.equals(that.description))) {
            return false;
        }
        if (!(this.reason == null && that.reason == null || this.reason != null && this.reason.equals(that.reason))) {
            return false;
        }
        return this.extendedReason == null && that.extendedReason == null || this.extendedReason != null && this.extendedReason.equals(that.extendedReason);
    }

    public int hashCode() {
        return super.hashCode() + (this.reason != null ? this.reason.hashCode() : 0) << 16 + (this.description != null ? this.description.hashCode() : 0) << 8 + (this.extendedReason != null ? this.extendedReason.hashCode() : 0);
    }

    public String getMessage() {
        if (this.cause == null) {
            return super.getMessage();
        }
        return super.getMessage() + "; nested exception is: \n\t" + this.cause.toString();
    }

    public Throwable getCause() {
        return this.cause == this ? null : this.cause;
    }
}

