/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMElement;
import org.sblim.wbem.cim.CIMFlavor;
import org.sblim.wbem.cim.CIMScope;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.util.Utils;

public class CIMQualifierType
extends CIMElement
implements Cloneable,
Comparable,
Serializable {
    private Vector flavors = new Vector(0);
    private Vector scopes = new Vector(0);
    private CIMDataType type = null;
    private CIMValue defaultValue;

    public CIMQualifierType() {
    }

    public CIMQualifierType(String name) {
        super(name);
    }

    public void addFlavor(CIMFlavor flavor) {
        if (flavor == null) {
            throw new IllegalArgumentException("null flavor argument");
        }
        Utils.addSorted(this.flavors, flavor);
    }

    public void addScope(CIMScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("null scope argument");
        }
        Utils.addSorted(this.scopes, scope);
    }

    public Object clone() {
        CIMQualifierType that = new CIMQualifierType(this.name);
        that.flavors = (Vector)this.flavors.clone();
        that.scopes = (Vector)this.scopes.clone();
        if (this.type != null) {
            that.type = (CIMDataType)this.type.clone();
        }
        if (this.defaultValue != null) {
            that.defaultValue = (CIMValue)this.defaultValue.clone();
        }
        return that;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CIMQualifierType)) {
            return false;
        }
        CIMQualifierType that = (CIMQualifierType)o;
        if (!this.flavors.equals(that.flavors) || !this.scopes.equals(that.scopes)) {
            return false;
        }
        if (!(this.type == null && that.type == null || this.type != null && this.type.equals(that.type))) {
            return false;
        }
        if (!(this.name == null && that.name == null || this.name != null && this.name.equalsIgnoreCase(that.name))) {
            return false;
        }
        return this.defaultValue == null && that.defaultValue == null || this.defaultValue != null && this.defaultValue.equals(that.defaultValue);
    }

    public int hashCode() {
        return this.flavors.hashCode() << 24 + this.scopes.hashCode() << 16 + (this.defaultValue != null ? this.defaultValue.hashCode() : 0) << 8 + (this.type != null ? this.type.hashCode() : 0);
    }

    public CIMValue getDefaultValue() {
        return this.defaultValue;
    }

    public Vector getFlavor() {
        return this.flavors;
    }

    public Vector getScope() {
        return this.scopes;
    }

    public CIMDataType getType() {
        return this.type;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public boolean hasFlavor(CIMFlavor flavor) {
        if (flavor == null) {
            throw new IllegalArgumentException("null flavor argument");
        }
        return Utils.hasValue(this.flavors, flavor);
    }

    public boolean hasScope(CIMScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("null scope argument");
        }
        Iterator iter = this.scopes.iterator();
        while (iter.hasNext()) {
            CIMScope scp = (CIMScope)iter.next();
            if (!scp.equals(scope) && scp.getScope() != 8) continue;
            return true;
        }
        return false;
    }

    public boolean isArrayValue() {
        if (this.type != null) {
            return this.type.isArrayType();
        }
        if (this.defaultValue != null && this.defaultValue.getType() != null) {
            return this.defaultValue.getType().isArrayType();
        }
        return false;
    }

    public void setDefaultValue(CIMValue value) {
        this.defaultValue = value;
    }

    public void setType(CIMDataType type) {
        this.type = type;
    }

    public String toMOF() {
        StringBuffer buf = new StringBuffer();
        buf.append("Qualifier ");
        buf.append(this.getName());
        buf.append(" : ");
        CIMDataType type = this.getType();
        if (type != null) {
            buf.append(type);
        }
        if (type != null && !type.isArrayType()) {
            buf.append(" = ");
            buf.append(this.getDefaultValue());
        }
        buf.append(",\n");
        if (this.scopes.size() > 0) {
            buf.append("\tScope(");
            buf.append(CIMQualifierType.vectorToMOFString(this.scopes));
            buf.append(")");
        }
        if (this.flavors.size() > 0) {
            buf.append(",\n\tFlavor(");
            buf.append(CIMQualifierType.vectorToMOFString(this.flavors));
            buf.append(")");
        }
        buf.append(";");
        return buf.toString();
    }

    public String toString() {
        return this.toMOF();
    }

    public int compareTo(Object o) {
        if (!(o instanceof CIMQualifierType)) {
            throw new IllegalArgumentException("Invalid object to compare with");
        }
        return this.name.toUpperCase().compareTo(((CIMQualifierType)o).name.toUpperCase());
    }
}

