/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.client;

import java.security.Principal;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.wbem.cim.CIMArgument;
import org.sblim.wbem.cim.CIMClass;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMQualifierType;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.client.BatchHandle;
import org.sblim.wbem.client.BatchResult;
import org.sblim.wbem.client.CIMClientFactory;
import org.sblim.wbem.client.CIMOMHandle;
import org.sblim.wbem.client.indications.CIMListener;
import org.sblim.wbem.util.Benchmark;
import org.sblim.wbem.util.GlobalProperties;

public class CIMClient {
    public static final String ITSANM_CIMXML = "ITSANM_CIMXML";
    public static final String ITSANM_SOAP = "ITSANM_SOAP";
    public static final String ITSANM_LOCAL = "ITSANM_LOCAL";
    public static final String CIM_XML = "CIM_XML";
    public static final String WQL = "WQL";
    public static final String CQL = "CQL";
    public static final String WQL1 = "WBEMSQL1";
    public static final String WQL2 = "WBEMSQL2";
    public static final String WQL3 = "WBEMSQL3";
    public static final String WQL4 = "WBEMSQL4";
    private CIMOMHandle client;

    public CIMClient(CIMNameSpace nameSpace, Principal principal, Object credential) throws CIMException {
        this(nameSpace, principal, credential, CIM_XML);
    }

    public CIMClient(CIMNameSpace nameSpace, Principal principal, Object credential, String protocol) throws CIMException {
        if (nameSpace == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", "Null namespace");
        }
        this.client = CIMClientFactory.getClient(nameSpace, principal, credential, protocol);
    }

    public CIMClient(CIMOMHandle cimomHandle) throws CIMException {
        if (cimomHandle == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", "null cimomHandler parameter");
        }
        this.client = cimomHandle;
    }

    private void preCheck() throws CIMException {
        if (this.client == null) {
            throw new CIMException("CIM_ERR_FAILED", "CIMClient is not bounded to a CIMOM");
        }
    }

    public synchronized Enumeration associatorNames(CIMObjectPath objectPath, String assocClass, String resultClass, String role, String resultRole) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        Enumeration enumeration = this.client.associatorNames(objectPath, assocClass, resultClass, role, resultRole);
        Benchmark.stopTimer();
        return enumeration;
    }

    public synchronized Enumeration associatorNames(CIMObjectPath objectPath) throws CIMException {
        return this.associatorNames(objectPath, null, null, null, null);
    }

    public synchronized Enumeration associators(CIMObjectPath objectPath, String assocClass, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        Enumeration enumeration = this.client.associators(objectPath, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList);
        Benchmark.stopTimer();
        return enumeration;
    }

    public synchronized void deleteInstance(CIMObjectPath instancePath) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        this.client.deleteInstance(instancePath);
        Benchmark.stopTimer();
    }

    public synchronized Enumeration enumInstances(CIMObjectPath classPath, boolean deepInheritance) throws CIMException {
        return this.enumerateInstances(classPath, deepInheritance, false, false, false, null);
    }

    public synchronized Enumeration enumInstances(CIMObjectPath classPath, boolean deepInheritance, boolean localOnly) throws CIMException {
        return this.enumerateInstances(classPath, deepInheritance, localOnly, false, false, null);
    }

    public synchronized Enumeration enumerateInstances(CIMObjectPath classPath, boolean deepInheritance, boolean localOnly) throws CIMException {
        return this.enumerateInstances(classPath, deepInheritance, localOnly, false, false, null);
    }

    public synchronized Enumeration enumerateInstances(CIMObjectPath classPath, boolean deepInheritance, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        Enumeration enumeration = this.client.enumerateInstances(classPath, deepInheritance, localOnly, includeQualifiers, includeClassOrigin, propertyList);
        Benchmark.stopTimer();
        return enumeration;
    }

    public synchronized Enumeration enumerateInstances(CIMObjectPath classPath) throws CIMException {
        return this.enumerateInstances(classPath, true, true, false, false, null);
    }

    public synchronized Enumeration enumerateInstances(CIMObjectPath classPath, boolean deepInheritance) throws CIMException {
        return this.enumerateInstances(classPath, deepInheritance, false, false, false, null);
    }

    public synchronized Enumeration enumerateInstances(CIMObjectPath classPath, boolean deepInheritance, boolean localOnly, boolean includeQualifiers) throws CIMException {
        return this.enumerateInstances(classPath, deepInheritance, localOnly, includeQualifiers, false, null);
    }

    public synchronized Enumeration enumerateInstances(CIMObjectPath classPath, boolean deepInheritance, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws CIMException {
        return this.enumerateInstances(classPath, deepInheritance, localOnly, includeQualifiers, includeClassOrigin, null);
    }

    public synchronized Enumeration enumerateInstanceNames(CIMObjectPath classPath) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        Enumeration enumeration = this.client.enumerateInstanceNames(classPath);
        Benchmark.stopTimer();
        return enumeration;
    }

    public synchronized CIMInstance getInstance(CIMObjectPath instancePath) throws CIMException {
        return this.getInstance(instancePath, true, false, false, null);
    }

    public synchronized CIMInstance getInstance(CIMObjectPath instancePath, boolean localOnly) throws CIMException {
        return this.getInstance(instancePath, localOnly, false, false, null);
    }

    public synchronized CIMInstance getInstance(CIMObjectPath instancePath, boolean localOnly, boolean includeQualifiers) throws CIMException {
        return this.getInstance(instancePath, localOnly, includeQualifiers, false, null);
    }

    public synchronized CIMInstance getInstance(CIMObjectPath instancePath, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws CIMException {
        return this.getInstance(instancePath, localOnly, includeQualifiers, includeClassOrigin, null);
    }

    public synchronized CIMInstance getInstance(CIMObjectPath instancePath, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        CIMInstance inst = this.client.getInstance(instancePath, localOnly, includeQualifiers, includeClassOrigin, propertyList);
        Benchmark.stopTimer();
        return inst;
    }

    public synchronized void createClass(CIMObjectPath classPath, CIMClass newClass) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        this.client.createClass(classPath, newClass);
        Benchmark.stopTimer();
    }

    public synchronized CIMObjectPath createInstance(CIMObjectPath namespacePath, CIMInstance newInstance) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        CIMObjectPath newInstancePath = this.client.createInstance(namespacePath, newInstance);
        Benchmark.startTimer();
        return newInstancePath;
    }

    public synchronized void createQualifierType(CIMObjectPath namespacePath, CIMQualifierType qualifierType) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        this.client.createQualifierType(namespacePath, qualifierType);
        Benchmark.stopTimer();
    }

    public synchronized void deleteClass(CIMObjectPath classPath) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        this.client.deleteClass(classPath);
        Benchmark.stopTimer();
    }

    public synchronized void deleteQualifierType(CIMObjectPath qualifierPath) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        this.client.deleteQualifierType(qualifierPath);
        Benchmark.stopTimer();
    }

    public synchronized CIMClass getClass(CIMObjectPath classPath) throws CIMException {
        return this.getClass(classPath, true, true, false, null);
    }

    public synchronized CIMClass getClass(CIMObjectPath classPath, boolean localOnly) throws CIMException {
        return this.getClass(classPath, localOnly, true, false, null);
    }

    public synchronized CIMClass getClass(CIMObjectPath objectPath, boolean localOnly, boolean includeQualifiers) throws CIMException {
        return this.getClass(objectPath, localOnly, includeQualifiers, false, null);
    }

    public synchronized CIMClass getClass(CIMObjectPath classPath, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        CIMClass clazz = this.client.getClass(classPath, localOnly, includeQualifiers, includeClassOrigin, null);
        Benchmark.startTimer();
        return clazz;
    }

    public synchronized CIMClass getClass(CIMObjectPath classPath, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        CIMClass clazz = this.client.getClass(classPath, localOnly, includeQualifiers, includeClassOrigin, propertyList);
        Benchmark.startTimer();
        return clazz;
    }

    public synchronized CIMValue getProperty(CIMObjectPath instancePath, String propertyName) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        CIMValue value = this.client.getProperty(instancePath, propertyName);
        Benchmark.startTimer();
        return value;
    }

    public synchronized CIMValue invokeMethod(CIMObjectPath objectPath, String methodName, Vector inArgs, Vector outArgs) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        if (inArgs != null) {
            Iterator iter = inArgs.iterator();
            int i = 0;
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!(o instanceof CIMArgument)) {
                    throw new IllegalArgumentException("Invalid input arguments at position: " + i + " CIMArgument type expected. \n" + o);
                }
                ++i;
            }
        }
        CIMValue value = this.client.invokeMethod(objectPath, methodName, inArgs, outArgs);
        Benchmark.stopTimer();
        return value;
    }

    public synchronized CIMValue invokeMethod(CIMObjectPath objectPath, String methodName, CIMArgument[] inArgs, CIMArgument[] outArgs) throws CIMException {
        Vector out = new Vector();
        Vector<Object> in = new Vector<Object>();
        if (inArgs != null) {
            in.addAll(Arrays.asList((Object[])inArgs));
        }
        CIMValue value = this.invokeMethod(objectPath, methodName, in, out);
        if (outArgs != null && outArgs.length > 0) {
            int totalArgs = outArgs.length;
            if (out.size() < totalArgs) {
                totalArgs = out.size();
            }
            for (int i = 0; i < totalArgs; ++i) {
                outArgs[i] = (CIMArgument)out.elementAt(i);
            }
        }
        return value;
    }

    public synchronized void addCIMListener(CIMListener listener) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        this.client.addCIMListener(listener);
        Benchmark.stopTimer();
    }

    public synchronized void removeCIMListener(CIMListener listener) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        this.client.removeCIMListener(listener);
        Benchmark.startTimer();
    }

    public synchronized CIMInstance getIndicationListener(CIMListener listener) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        CIMInstance instance = this.client.getIndicationListener(listener);
        Benchmark.startTimer();
        return instance;
    }

    public synchronized CIMInstance getIndicationHandler(CIMListener listener) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        CIMInstance inst = this.client.getIndicationHandler(listener);
        Benchmark.stopTimer();
        return inst;
    }

    public synchronized void close() throws CIMException {
        if (this.client == null) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        this.client.close();
        this.client = null;
    }

    public synchronized void createNameSpace(CIMNameSpace nameSpace) throws CIMException {
        this.preCheck();
        this.client.createNameSpace(nameSpace);
    }

    public synchronized void deleteNameSpace(CIMNameSpace nameSpace) throws CIMException {
        this.preCheck();
        this.client.deleteNameSpace(nameSpace);
    }

    public synchronized Enumeration enumQualifierTypes(CIMObjectPath namespacePath) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        Enumeration enumeration = this.client.enumQualifierTypes(namespacePath);
        Benchmark.stopTimer();
        return enumeration;
    }

    public synchronized Enumeration enumClass(CIMObjectPath classPath) throws CIMException {
        return this.enumerateClasses(classPath, false, true, true, false);
    }

    public synchronized Enumeration enumClass(CIMObjectPath classPath, boolean deepInheritance) throws CIMException {
        return this.enumerateClasses(classPath, deepInheritance, true, true, false);
    }

    public synchronized Enumeration enumClass(CIMObjectPath classPath, boolean deepInheritance, boolean localOnly) throws CIMException {
        return this.enumerateClasses(classPath, deepInheritance, localOnly, true, false);
    }

    public synchronized Enumeration enumerateClasses() throws CIMException {
        return this.enumerateClasses(null, false, true, true, false);
    }

    public synchronized Enumeration enumerateClasses(CIMObjectPath classPath) throws CIMException {
        return this.enumerateClasses(classPath, false, true, true, false);
    }

    public synchronized Enumeration enumerateClasses(CIMObjectPath classPath, boolean deepInheritance) throws CIMException {
        return this.enumerateClasses(classPath, deepInheritance, true, true, false);
    }

    public synchronized Enumeration enumerateClasses(CIMObjectPath classPath, boolean deepInheritance, boolean localOnly) throws CIMException {
        return this.enumerateClasses(classPath, deepInheritance, localOnly, true, false);
    }

    public synchronized Enumeration enumerateClasses(CIMObjectPath classPath, boolean deepInheritance, boolean localOnly, boolean includeQualifiers) throws CIMException {
        return this.enumerateClasses(classPath, deepInheritance, localOnly, includeQualifiers, false);
    }

    public synchronized Enumeration enumerateClasses(CIMObjectPath classPath, boolean deepInheritance, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        if (classPath == null) {
            classPath = new CIMObjectPath();
        }
        Enumeration enumeration = this.client.enumerateClasses(classPath, deepInheritance, localOnly, includeQualifiers, includeClassOrigin);
        Benchmark.stopTimer();
        return enumeration;
    }

    public synchronized Enumeration enumerateClassNames() throws CIMException {
        return this.enumerateClassNames(null, false);
    }

    public synchronized Enumeration enumerateClassNames(CIMObjectPath classPath) throws CIMException {
        return this.enumerateClassNames(classPath, false);
    }

    public synchronized Enumeration enumerateClassNames(CIMObjectPath classPath, boolean deepInheritance) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        if (classPath == null) {
            classPath = new CIMObjectPath();
        }
        Enumeration enumeration = this.client.enumerateClassNames(classPath, false);
        Benchmark.stopTimer();
        return enumeration;
    }

    public synchronized Enumeration enumNameSpace(CIMObjectPath namespacePath, boolean deep) throws CIMException {
        this.preCheck();
        Enumeration enumeration = this.client.enumNameSpace(namespacePath, deep);
        return enumeration;
    }

    public synchronized Enumeration execQuery(CIMObjectPath namespacePath, String query, String queryLanguage) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        Enumeration enumeration = this.client.execQuery(namespacePath, query, queryLanguage);
        Benchmark.stopTimer();
        return enumeration;
    }

    public synchronized CIMQualifierType getQualifierType(CIMObjectPath qualifierPath) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        CIMQualifierType qualifierType = this.client.getQualifierType(qualifierPath);
        Benchmark.stopTimer();
        return qualifierType;
    }

    public synchronized BatchResult performBatchOperations(BatchHandle batchHandle) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        BatchResult res = this.client.performBatchOperations(batchHandle);
        Benchmark.stopTimer();
        return res;
    }

    public synchronized Enumeration referenceNames(CIMObjectPath objectPath) throws CIMException {
        return this.referenceNames(objectPath, null, null);
    }

    public synchronized Enumeration referenceNames(CIMObjectPath objectPath, String resultClass, String role) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        Enumeration enumeration = this.client.referenceNames(objectPath, resultClass, role);
        Benchmark.stopTimer();
        return enumeration;
    }

    public synchronized Enumeration references(CIMObjectPath objectPath) throws CIMException {
        return this.references(objectPath, null, null, true, true, null);
    }

    public synchronized Enumeration references(CIMObjectPath objectPath, String resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        Enumeration enumeration = this.client.references(objectPath, resultClass, role, includeQualifiers, includeClassOrigin, propertyList);
        Benchmark.stopTimer();
        return enumeration;
    }

    public synchronized void setProperty(CIMObjectPath instancePath, String propertyName) throws CIMException {
        this.setProperty(instancePath, propertyName, null);
    }

    public synchronized void setProperty(CIMObjectPath instancePath, String propertyName, CIMValue newValue) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        this.client.setProperty(instancePath, propertyName, newValue);
        Benchmark.stopTimer();
    }

    public synchronized void setClass(CIMObjectPath classPath, CIMClass modifiedClass) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        this.client.setClass(classPath, modifiedClass);
        Benchmark.stopTimer();
    }

    public synchronized void setInstance(CIMObjectPath instancePath, CIMInstance modifiedInstance) throws CIMException {
        this.setInstance(instancePath, modifiedInstance, true, null);
    }

    public synchronized void setInstance(CIMObjectPath instancePath, CIMInstance modifiedInstance, boolean includeQualifiers, String[] propertyList) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        this.client.setInstance(instancePath, modifiedInstance, includeQualifiers, propertyList);
        Benchmark.stopTimer();
    }

    public synchronized void setQualifierType(CIMObjectPath namespacePath, CIMQualifierType qualifierType) throws CIMException {
        Benchmark.startTimer();
        this.preCheck();
        this.client.setQualifierType(namespacePath, qualifierType);
        Benchmark.stopTimer();
    }

    public synchronized void useMPost(boolean bool) {
        this.preCheck();
        this.client.useMPost(bool);
    }

    public synchronized void useHttp11(boolean bool) {
        this.preCheck();
        this.client.useHttp11(bool);
    }

    public synchronized CIMNameSpace getNameSpace() {
        this.preCheck();
        return this.client.getNameSpace();
    }

    public synchronized void setLocale(Locale newLocale) {
        this.preCheck();
        this.client.setLocale(newLocale);
    }

    public synchronized Locale getLocale() {
        this.preCheck();
        return this.client.getLocale();
    }

    static {
        block2: {
            try {
                GlobalProperties.getLogger();
            }
            catch (RuntimeException e) {
                Logger logger = GlobalProperties.getLogger();
                if (!logger.isLoggable(Level.WARNING)) break block2;
                logger.log(Level.WARNING, "Some error while loading properties", e);
            }
        }
    }
}

