/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.wbem.http.HttpMethod;
import org.sblim.wbem.http.io.ASCIIPrintStream;
import org.sblim.wbem.util.GlobalProperties;

public class HttpHeader {
    static BitSet dontNeedEncoding;
    static final String hexStr = "0123456789ABCDEF";
    static String dfltEncName;
    private InputStreamReader reader;
    private Hashtable fields = new Hashtable();

    public HttpHeader() {
    }

    public HttpHeader(InputStream reader) throws IOException {
        String line = null;
        while ((line = HttpMethod.readLine(reader)) != null && line.length() > 0) {
            Logger logger;
            try {
                int separator = line.indexOf(58);
                if (separator > -1) {
                    String header = line.substring(0, separator);
                    String value = line.substring(separator + 1);
                    if (value.length() > 0 && value.startsWith(" ")) {
                        this.addField(header, value.substring(1));
                        continue;
                    }
                    this.addField(header, value);
                    continue;
                }
                logger = GlobalProperties.getLogger();
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "invalid HTTP Header \"" + line + "\"");
            }
            catch (Exception e) {
                logger = GlobalProperties.getLogger();
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "exception while closing the socket");
            }
        }
    }

    public void addField(String header, String value) {
        if (header == null || header.length() == 0) {
            return;
        }
        if (value != null) {
            this.fields.put(new HeaderEntry(header), value);
        } else {
            this.fields.remove(new HeaderEntry(header));
        }
    }

    public void clear() {
        this.fields.clear();
    }

    public Iterator iterator() {
        return this.fields.entrySet().iterator();
    }

    public static HttpHeader parse(String line) {
        int prev = 0;
        int next = 0;
        HttpHeader header = new HttpHeader();
        if (line != null && line.length() > 0) {
            int separator;
            String hdr;
            next = line.indexOf(44);
            while (next > -1) {
                hdr = line.substring(prev, next);
                separator = hdr.indexOf(61);
                if (separator > -1) {
                    String key = hdr.substring(0, separator);
                    String value = hdr.substring(separator + 1);
                    header.addField(key, value);
                }
                prev = next + 1;
                while (Character.isSpaceChar(line.charAt(prev))) {
                    ++prev;
                }
                next = line.indexOf(44, prev);
            }
            hdr = line.substring(prev);
            separator = hdr.indexOf(61);
            if (separator > -1) {
                header.addField(hdr.substring(0, separator), hdr.substring(separator + 1));
            }
        }
        return header;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        Iterator iterator = this.fields.entrySet().iterator();
        while (iterator.hasNext()) {
            if (i++ > 0) {
                buf.append(',');
            }
            Map.Entry entry = iterator.next();
            buf.append(entry.getKey().toString());
            buf.append('=');
            buf.append(entry.getValue().toString());
        }
        return buf.toString();
    }

    public void removeField(String header) {
        this.fields.remove(new HeaderEntry(header));
    }

    public String getField(String header) {
        return (String)this.fields.get(new HeaderEntry(header));
    }

    public void write(ASCIIPrintStream writer) throws IOException {
        Iterator iterator = this.fields.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            writer.print(entry.getKey().toString());
            writer.print(": ");
            writer.print(entry.getValue().toString());
            writer.print("\r\n");
        }
        writer.print("\r\n");
    }

    public static synchronized String encode(byte[] byteArray) {
        String str = null;
        try {
            if (dfltEncName == null) {
                dfltEncName = (String)AccessController.doPrivileged(new GetProperty("file.encoding"));
            }
            str = HttpHeader.encode(byteArray, dfltEncName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return str;
    }

    public static String encode(byte[] byteArray, String enc) throws UnsupportedEncodingException {
        boolean needToChange = false;
        boolean wroteUnencodedChar = false;
        int maxBytesPerChar = 10;
        StringBuffer out = new StringBuffer(byteArray.length);
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)buf, enc));
        for (int i = 0; i < byteArray.length; ++i) {
            int c = byteArray[i] & 0xFF;
            if (dontNeedEncoding.get(c)) {
                if (c == 32) {
                    out.append("%20");
                    continue;
                }
                out.append((char)c);
                continue;
            }
            out.append('%');
            out.append(hexStr.charAt(c >> 4 & 0xF));
            out.append(hexStr.charAt(c & 0xF));
        }
        return out.toString();
    }

    public static String encode(String s, String source, String dest) throws UnsupportedEncodingException {
        return HttpHeader.encode(s.getBytes(source), dest);
    }

    static {
        int i;
        dfltEncName = null;
        dontNeedEncoding = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            dontNeedEncoding.set(i);
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(47);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
    }

    static class GetProperty
    implements PrivilegedAction {
        String propertyName;

        GetProperty(String propertyName) {
            this.propertyName = propertyName;
        }

        public Object run() {
            return System.getProperty(this.propertyName);
        }
    }

    class HeaderEntry {
        String header;
        int hashcode;

        public HeaderEntry(String header) {
            this.header = header;
            this.hashcode = header.toUpperCase().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof HeaderEntry)) {
                return false;
            }
            return this.header.equalsIgnoreCase(((HeaderEntry)obj).header);
        }

        public String toString() {
            return this.header;
        }

        public int hashCode() {
            return this.hashcode;
        }
    }
}

