/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.sblim.wbem.http.HttpHeader;
import org.sblim.wbem.http.HttpServerMethod;
import org.sblim.wbem.http.io.ASCIIPrintStream;
import org.sblim.wbem.http.io.ChunkedOutputStream;
import org.sblim.wbem.http.io.PersistentOutputStream;

public class MessageWriter {
    HttpHeader header = null;
    HttpServerMethod method = null;
    HttpHeader trailer = null;
    boolean chunked = false;
    boolean persistent = false;
    ASCIIPrintStream realOS;
    ASCIIPrintStream clientOS;
    ByteArrayOutputStream bufferedOS;

    public MessageWriter(OutputStream ros, boolean persistent, boolean chunked) {
        this.realOS = new ASCIIPrintStream(ros);
        this.chunked = chunked;
        this.persistent = persistent;
        this.bufferedOS = new ByteArrayOutputStream();
        this.clientOS = chunked ? new ASCIIPrintStream(new ChunkedOutputStream(new PersistentOutputStream(this.bufferedOS, persistent), 512)) : new ASCIIPrintStream(new PersistentOutputStream(this.bufferedOS, persistent));
        this.header = new HttpHeader();
        this.method = new HttpServerMethod(1, 1, 200, "OK");
    }

    public void reset() {
        this.bufferedOS.reset();
    }

    public void setHeader(HttpHeader header) {
        this.header = header;
    }

    public void setMethod(HttpServerMethod method) {
        this.method = method;
    }

    public HttpHeader getHeader() {
        return this.header;
    }

    public HttpServerMethod getMethod() {
        return this.method;
    }

    public ASCIIPrintStream getOutputStream() {
        return this.clientOS;
    }

    public void close() throws IOException {
        this.method.write(this.realOS);
        this.realOS.flush();
        if (!this.chunked) {
            this.header.removeField("Transfer-Encoding");
        } else {
            this.header.addField("Transfer-Encoding", "chunked");
        }
        if (this.persistent) {
            this.header.addField("Connection", "Keep-alive");
        } else {
            this.header.addField("Connection", "close");
        }
        this.header.addField("Content-Type", "application/xml;charset=\"utf-8\"");
        if (!this.chunked) {
            this.header.addField("Content-length", Integer.toString(this.bufferedOS.size()));
        }
        this.header.write(this.realOS);
        this.realOS.flush();
        this.bufferedOS.writeTo(this.realOS);
        if (this.chunked && this.trailer != null) {
            this.trailer.write(this.realOS);
        }
        this.realOS.flush();
    }

    public void setTrailer(HttpHeader trailer) {
        this.trailer = trailer;
    }
}

