/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ChunkedOutputStream
extends OutputStream {
    DataOutputStream os;
    byte[] buffer;
    int used;

    public ChunkedOutputStream(OutputStream os, int buflen) {
        this.os = new DataOutputStream(os);
        this.buffer = new byte[buflen];
        this.used = 0;
    }

    public void close() throws IOException {
        this.flush();
        this.os.writeChars("0\r\n");
        this.os.flush();
    }

    public void flush() throws IOException {
        if (this.used > 0) {
            this.os.writeBytes(Integer.toHexString(this.used) + "\r\n");
            this.os.write(this.buffer, 0, this.used);
            this.os.writeBytes("\r\n");
            this.os.flush();
        }
        this.used = 0;
    }

    public void write(byte[] source, int offset, int len) throws IOException {
        int copied = 0;
        while (len > 0) {
            int total;
            int n = total = this.buffer.length - this.used < len ? this.buffer.length - this.used : len;
            if (total > 0) {
                System.arraycopy(source, copied, this.buffer, this.used, total);
                len -= total;
                this.used += total;
                copied += total;
            }
            if (this.used != this.buffer.length) continue;
            this.flush();
        }
    }

    public void write(int i) throws IOException {
        if (this.buffer.length == this.used) {
            this.flush();
        }
        this.buffer[this.used++] = (byte)(0xFF & i);
    }
}

