/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.xml.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.wbem.util.GlobalProperties;
import org.sblim.wbem.xml.CIMResponse;
import org.sblim.wbem.xml.XMLDefaultHandlerImpl;
import org.sblim.wbem.xml.parser.XMLPullParserException;
import org.xml.sax.Attributes;

public class XMLPullParser {
    Reader instream;
    byte[] buffer;
    char nextChar;
    int finish;
    int start;
    public static final int START_ELEMENT = 1;
    public static final int END_ELEMENT = 2;
    public static final int PROCESSING_INSTRUCTION = 3;
    public static final int CHARACTERS = 4;
    public static final int COMMENT = 5;
    public static final int SPACE = 6;
    public static final int START_DOCUMENT = 7;
    public static final int END_DOCUMENT = 8;
    public static final int ENTITY_REFERENCE = 9;
    public static final int ATTRIBUTE = 10;
    public static final int DTD = 11;
    public static final int CDATA = 12;
    public static final int NAMESPACE = 13;
    public static final int NOTATION_DECLARATION = 14;
    public static final int ENTITY_DECLARATION = 15;
    char[] bufferChar = null;
    int finishChar = 0;
    int lineNumber = 1;
    int colNumber = 1;
    int currentPos = 0;
    int currentState = 0;
    boolean seenProlog;
    boolean seenEpilog;
    boolean closingElementNamePending;
    String elementName;
    Vector elementNames = new Vector();
    Vector attributeNames = new Vector();
    Vector attributeValues = new Vector();
    int totalAttributes;
    Attributes attributes;
    XMLAttributeValue characters;
    int startCharacters;
    int endCharacters;
    public static final String EMPTY = "";

    public XMLPullParser(Reader in) {
        this.instream = in;
        this.reset();
    }

    public void reset() {
        this.seenProlog = true;
        this.currentState = 0;
        this.closingElementNamePending = false;
        this.colNumber = 1;
        this.lineNumber = 1;
        this.elementName = null;
        this.elementNames.setSize(0);
        this.attributeNames.setSize(0);
        this.attributeValues.setSize(0);
        this.attributes = null;
        this.startCharacters = 0;
        this.endCharacters = 0;
        this.totalAttributes = 0;
        this.seenProlog = false;
        this.seenEpilog = false;
    }

    protected void resetAttributes() {
        this.totalAttributes = 0;
    }

    protected void addAttribute(int begName, int lenName, int begValue, int lenValue, int hashname, int hashvalue) {
        if (this.attributeNames.size() > this.totalAttributes) {
            XMLAttributeValue attribute = (XMLAttributeValue)this.attributeValues.elementAt(this.totalAttributes);
            XMLAttributeValue name = (XMLAttributeValue)this.attributeNames.elementAt(this.totalAttributes);
            ++this.totalAttributes;
            attribute.init(begValue, lenValue);
            attribute.setTranslate(true, hashvalue);
            name.init(begName, lenName);
            name.setTranslate(false, hashname);
        } else {
            XMLAttributeValue attribute = new XMLAttributeValue(begValue, lenValue, hashvalue);
            XMLAttributeValue name = new XMLAttributeValue(begName, lenName, false, hashname);
            ++this.totalAttributes;
            this.attributeNames.add(name);
            this.attributeValues.add(attribute);
        }
    }

    public String getElementName() {
        return this.elementName;
    }

    public Vector getElementNames() {
        return this.elementNames;
    }

    public boolean hasNext() {
        return this.currentState != 8;
    }

    protected void goBack() {
        --this.currentPos;
        if (this.colNumber > 1) {
            --this.colNumber;
        }
    }

    public int next() throws IOException {
        int hash;
        this.resetAttributes();
        this.ensureCapacity();
        if (this.closingElementNamePending) {
            this.closingElementNamePending = false;
            this.elementNames.remove(this.elementNames.size() - 1);
            this.currentState = 2;
            return this.currentState;
        }
        while (true) {
            char ch;
            if ((ch = (char)this.getNextCharCheckingEOF()) == '<') {
                ch = (char)this.getNextChar();
                if (ch == '?') {
                    if (this.seenProlog) {
                        throw new XMLPullParserException("The processing instruction target matching \"[xX][mM][lL]\" is not allowed.");
                    }
                    this.seenProlog = true;
                    this.parsePI();
                    ch = (char)this.getNextChar();
                    ch = this.skipOptionalSpaces(ch);
                    if (ch != '<') {
                        throw new XMLPullParserException(this, "Content is not allowed in prolog.");
                    }
                    this.goBack();
                    this.currentState = 7;
                    return this.currentState;
                }
                if (ch == '!') {
                    ch = (char)this.getNextChar();
                    if (ch == '-') {
                        this.parseComment();
                        this.currentState = 5;
                        return this.currentState;
                    }
                    if (ch == '[') {
                        this.parseCDATA();
                        this.currentState = 4;
                        return this.currentState;
                    }
                    throw new XMLPullParserException(this, "unexpected char " + this.escape(ch));
                }
                if (ch == '/') {
                    this.parseEndElement();
                    this.currentState = 2;
                    return this.currentState;
                }
                if (ch == '&') {
                    this.parseUnknown();
                    continue;
                }
                if (this.isValidStartElementNameChar(ch)) {
                    if (!this.seenProlog) {
                        this.seenProlog = true;
                        this.currentState = 7;
                        this.goBack();
                        this.goBack();
                        return this.currentState;
                    }
                    this.parseStartElement(ch);
                    this.currentState = 1;
                    return this.currentState;
                }
                throw new XMLPullParserException(this, "unexpected char " + this.escape(ch));
            }
            this.startCharacters = this.currentPos - 1;
            boolean amp = false;
            hash = 0;
            do {
                if ((ch = (char)this.getNextCharCheckingEOF()) == '\uffff') {
                    if (this.elementNames.size() != 0) {
                        throw new XMLPullParserException(this, "unexpected EOF ");
                    }
                    this.currentState = 8;
                    return this.currentState;
                }
                if (ch != '\r' && ch != '\n' && !this.isSpace(ch) && ch != '<' && this.elementNames.size() == 0) {
                    if (!this.seenProlog) {
                        throw new XMLPullParserException(this, "Content is not allowed in trailing section.");
                    }
                    throw new XMLPullParserException(this, "Content is not allowed in trailing section.");
                }
                amp = false;
                if (ch != '&') continue;
                amp = true;
                int i = this.parseReference();
                ch = (char)(i & 0xFFFF);
            } while (ch != '<' || amp);
            this.endCharacters = this.currentPos;
            this.goBack();
            if (this.elementNames.size() > 0) break;
        }
        if (this.characters == null) {
            this.characters = new XMLAttributeValue(this.startCharacters, this.endCharacters - this.startCharacters - 1, hash);
        } else {
            this.characters.init(this.startCharacters, this.endCharacters - this.startCharacters - 1);
            this.characters.setTranslate(true, hash);
        }
        this.currentState = 4;
        return this.currentState;
    }

    public String getText() {
        String result = null;
        if (this.currentState == 4 && this.characters != null) {
            return this.characters.getText();
        }
        return result;
    }

    public int getLevel() {
        return this.elementNames.size();
    }

    protected int parseCDATA() throws IOException {
        int startCharacter;
        block9: {
            char ch = (char)this.getNextChar();
            if (ch != 'C') {
                throw new XMLPullParserException("CDATA must start with \"<![CDATA[\".");
            }
            ch = (char)this.getNextChar();
            if (ch != 'D') {
                throw new XMLPullParserException("CDATA must start with \"<![CDATA[\".");
            }
            ch = (char)this.getNextChar();
            if (ch != 'A') {
                throw new XMLPullParserException("CDATA must start with \"<![CDATA[\".");
            }
            ch = (char)this.getNextChar();
            if (ch != 'T') {
                throw new XMLPullParserException("CDATA must start with \"<![CDATA[\".");
            }
            ch = (char)this.getNextChar();
            if (ch != 'A') {
                throw new XMLPullParserException("CDATA must start with \"<![CDATA[\".");
            }
            ch = (char)this.getNextChar();
            if (ch != '[') {
                throw new XMLPullParserException("CDATA must start with \"<![CDATA[\".");
            }
            boolean braketFound = false;
            boolean doubleBraket = false;
            startCharacter = this.currentPos;
            do {
                if ((ch = (char)this.getNextCharCheckingEOF()) == ']') {
                    if (braketFound) {
                        doubleBraket = true;
                    }
                    braketFound = true;
                    continue;
                }
                if (ch == '>' && doubleBraket) break block9;
                braketFound = false;
                doubleBraket = false;
            } while (ch != '\uffff');
            throw new XMLPullParserException("XML document structures must start and end within the same entity.");
        }
        int endCharacter = this.currentPos - 1;
        this.characters.setTranslate(false, 0);
        this.characters.init(startCharacter, endCharacter - startCharacter);
        return -1;
    }

    protected int parsePI() throws IOException {
        block2: {
            char ch = (char)this.getNextChar();
            boolean dashFound = false;
            do {
                if ((ch = (char)this.getNextCharCheckingEOF()) == '?') {
                    dashFound = true;
                    continue;
                }
                if (ch == '>' && dashFound) break block2;
                dashFound = false;
            } while (ch != '\uffff');
            throw new XMLPullParserException("XML document structures must start and end within the same entity.");
        }
        return -1;
    }

    protected int parseComment() throws IOException {
        block4: {
            char ch = (char)this.getNextChar();
            if (ch != '-') {
                throw new XMLPullParserException("Comment must start with \"<!--\".");
            }
            boolean dashFound = false;
            boolean doubleDash = false;
            do {
                if ((ch = (char)this.getNextCharCheckingEOF()) == '-') {
                    if (dashFound) {
                        doubleDash = true;
                    }
                    dashFound = true;
                    continue;
                }
                if (ch == '>' && doubleDash) break block4;
                dashFound = false;
                doubleDash = false;
            } while (ch != '\uffff');
            throw new XMLPullParserException("XML document structures must start and end within the same entity.");
        }
        return -1;
    }

    public Attributes getAttributes() {
        if (this.currentState != 1) {
            return null;
        }
        if (this.attributes == null) {
            this.attributes = new XMLAttributes();
        }
        return this.attributes;
    }

    protected int parseStartElement(char ch) throws IOException {
        this.resetAttributes();
        int startElementName = this.currentPos - 1;
        boolean hash = false;
        boolean n = false;
        while (this.isValidElementNameChar(ch = (char)this.getNextChar())) {
        }
        int endElementName = this.currentPos;
        this.elementName = new String(this.bufferChar, startElementName, endElementName - startElementName - 1);
        this.elementNames.add(this.elementName.toUpperCase());
        while ((ch = this.skipOptionalSpaces(ch)) != '>') {
            if (ch == '/') {
                ch = (char)this.getNextChar();
                if (ch != '>') {
                    throw new XMLPullParserException(this, "'=' was expected, but '" + this.escape(ch) + "' was found instead");
                }
                this.closingElementNamePending = true;
                continue;
            }
            if (this.isValidStartElementNameChar(ch)) {
                this.parseAttribute(ch);
                ch = (char)this.getNextChar();
                continue;
            }
            throw new XMLPullParserException(this, "Element type \"CIM\" must be followed by either attribute specifications, \">\" or \"/>\".");
        }
        return -1;
    }

    protected void parseEndElement() throws IOException {
        char ch;
        int startElementName = this.currentPos;
        while (this.isValidElementNameChar(ch = (char)this.getNextChar())) {
        }
        int endElementName = this.currentPos;
        this.elementName = new String(this.bufferChar, startElementName, endElementName - startElementName - 1);
        if (!this.elementNames.lastElement().equals(this.elementName.toUpperCase())) {
            throw new XMLPullParserException(this, "The content of elements must consist of well-formed character data or markup.");
        }
        this.elementNames.remove(this.elementNames.size() - 1);
        ch = this.skipOptionalSpaces(ch);
        if (ch != '>') {
            throw new XMLPullParserException(this, "'=' was expected, but '" + this.escape(ch) + "' was found instead");
        }
        if (this.elementNames.size() == 0) {
            this.seenEpilog = true;
        }
    }

    protected void parseAttribute(char ch) throws IOException {
        int startAttributeName = this.currentPos - 1;
        int hash = 0;
        while (this.isValidElementNameChar(ch = (char)this.getNextChar())) {
        }
        int endAttributeName = this.currentPos;
        if ((ch = this.skipOptionalSpaces(ch)) != '=') {
            throw new XMLPullParserException(this, "missing chacter '='instead " + this.escape(ch) + " was found ");
        }
        ch = (char)this.getNextChar();
        if ((ch = this.skipOptionalSpaces(ch)) != '\"' && ch != '\'') {
            throw new XMLPullParserException(this, "missing chacter '\"' or ''' instead " + this.escape(ch) + " was found ");
        }
        char delimiter = ch;
        int startAttributeValue = this.currentPos;
        char prevCh = '\u0000';
        int hashvalue = 0;
        while ((ch = (char)this.getNextChar()) != delimiter) {
            if (ch == '<' || ch == '>') {
                throw new XMLPullParserException(this, "illegal character " + this.escape(ch));
            }
            if (ch == '&') {
                int ref = this.parseReference();
                ch = (char)(ref & 0xFFFF);
            } else if (ch != '\t' && ch != '\r' && ch != '\n' || ch != '\n' || prevCh != '\r') {
                // empty if block
            }
            prevCh = ch;
        }
        int endAttributeValue = this.currentPos;
        this.addAttribute(startAttributeName, endAttributeName - startAttributeName - 1, startAttributeValue, endAttributeValue - startAttributeValue - 1, hash, hashvalue);
    }

    protected int parseReference() throws IOException {
        int pos = this.currentPos;
        char ch1 = (char)this.getNextChar();
        if (ch1 == '#') {
            ch1 = (char)this.getNextChar();
            if (ch1 == 'x') {
                int value = 0;
                while (true) {
                    if ((ch1 = (char)this.getNextChar()) >= '0' && ch1 <= '9') {
                        value = value * 16 + (ch1 - 48);
                        continue;
                    }
                    if ((ch1 < 'A' || ch1 > 'F') && (ch1 < 'a' || ch1 > 'z')) break;
                    value = value * 16 + (Character.toUpperCase(ch1) - 65 + 10);
                }
                if (ch1 != ';') {
                    throw new XMLPullParserException(this, "invalid character while parsing hex encoded number " + this.escape(ch1));
                }
                return (char)value;
            }
            int value = 0;
            if (ch1 >= '0' && ch1 <= '9') {
                while (ch1 >= '0' && ch1 <= '9') {
                    value = value * 10 + (ch1 - 48);
                    ch1 = (char)this.getNextChar();
                }
                if (ch1 != ';') {
                    throw new XMLPullParserException(this, "invalid character while parsing decinal encoded character: " + this.escape(ch1));
                }
                return (char)value;
            }
            throw new XMLPullParserException(this, "invalid number format");
        }
        int startPos = this.currentPos - 1;
        if (this.isValidStartElementNameChar(ch1)) {
            while ((ch1 = (char)this.getNextChar()) != ';') {
                if (this.isValidElementNameChar(ch1)) continue;
                throw new XMLPullParserException("invalid reference character " + this.escape(ch1));
            }
        } else {
            throw new XMLPullParserException(this, "expected valid name start character for value reference");
        }
        this.goBack();
        ch1 = this.bufferChar[startPos];
        char ch2 = this.bufferChar[startPos + 1];
        char ch3 = this.bufferChar[startPos + 2];
        if (ch1 == 'l' && ch2 == 't' && ch3 == ';') {
            return 60;
        }
        if (ch1 == 'g' && ch2 == 't' && ch3 == ';') {
            return 62;
        }
        char ch4 = this.bufferChar[startPos + 3];
        if (ch1 == 'a' && ch2 == 'm' && ch3 == 'p' && ch4 == ';') {
            return 38;
        }
        char ch5 = this.bufferChar[startPos + 4];
        if (ch1 == 'a' && ch2 == 'p' && ch3 == 'o' && ch4 == 's' && ch5 == ';') {
            return 39;
        }
        if (ch1 == 'q' && ch2 == 'u' && ch3 == 'o' && ch4 == 't' && ch5 == ';') {
            return 34;
        }
        return -1;
    }

    protected void parseUnknown() throws IOException {
        char ch;
        do {
            if ((ch = (char)this.getNextChar()) != '<') continue;
            throw new XMLPullParserException("The must end with a '>' delimiter.");
        } while (ch != '>');
    }

    protected char skipRequiredSpaces(char ch) throws IOException {
        if (!this.isSpace(ch)) {
            throw new XMLPullParserException(this, "space spected");
        }
        while (this.isSpace(ch = (char)this.getNextChar())) {
        }
        return ch;
    }

    protected char skipOptionalSpaces(char ch) throws IOException {
        while (this.isSpace(ch)) {
            ch = (char)this.getNextChar();
        }
        return ch;
    }

    protected boolean isValidStartElementNameChar(char ch) {
        return ch < '\u0100' && (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch == '_' || ch == ':') || ch >= '\u00c0' && ch <= '\u02ff' || ch >= '\u0370' && ch <= '\u037d' || ch >= '\u037f' && ch <= '\u0400' || ch >= '\u0400' && ch <= '\u2027' || ch >= '\u202a' && ch <= '\u218f' || ch >= '\u2800' && ch <= '\uffef';
    }

    protected boolean isValidElementNameChar(char ch) {
        return ch < '\u0100' && (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch == '_' || ch == ':' || ch == '-' || ch == '.' || ch >= '0' && ch <= '9' || ch == '\u00b7') || ch >= '\u00c0' && ch <= '\u02ff' || ch >= '\u0370' && ch <= '\u037d' || ch >= '\u0300' && ch <= '\u036f' || ch >= '\u037f' && ch <= '\u2027' || ch >= '\u202a' && ch <= '\u218f' || ch >= '\u2800' && ch <= '\uffef';
    }

    protected boolean isSpace(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t';
    }

    protected int getNextChar() throws IOException {
        int ch = this.finishChar <= this.currentPos ? this.getChar() : this.bufferChar[this.currentPos++];
        if (ch == -1) {
            throw new XMLPullParserException(this, "unexpected end of document");
        }
        if (ch == 10) {
            ++this.lineNumber;
            this.colNumber = 1;
        } else {
            ++this.colNumber;
        }
        return (char)ch;
    }

    protected int getNextCharCheckingEOF() throws IOException {
        int ch = this.finishChar <= this.currentPos ? this.getChar() : this.bufferChar[this.currentPos++];
        if (ch == 10) {
            ++this.lineNumber;
            this.colNumber = 1;
        } else {
            ++this.colNumber;
        }
        return (char)ch;
    }

    protected char _getNextChar() {
        return '\uffff';
    }

    protected String escape(char ch) {
        String result;
        if (ch == '\n') {
            result = "'\\n'";
        }
        if (ch == '\r') {
            result = "'\\r'";
        }
        if (ch == '\t') {
            result = "'\\t'";
        }
        if (ch == '\'') {
            result = "'\\''";
        }
        result = ch > '\u007f' || ch < ' ' ? "'\\u" + Integer.toHexString(ch) + "'" : "'" + ch + "'";
        return result;
    }

    protected void ensureCapacity() {
        if (this.bufferChar == null) {
            this.bufferChar = new char[1024];
        }
        if (this.currentPos >= 8 * this.bufferChar.length / 10) {
            System.arraycopy(this.bufferChar, this.currentPos, this.bufferChar, 0, this.finishChar - this.currentPos);
            this.finishChar -= this.currentPos;
            this.currentPos = 0;
        }
    }

    protected int getChar() throws IOException {
        if (this.finishChar <= this.currentPos) {
            int finish = this.bufferChar.length;
            if (this.bufferChar == null) {
                this.bufferChar = new char[1024];
            } else if (this.finishChar >= this.bufferChar.length) {
                char[] tmp = this.bufferChar;
                this.bufferChar = new char[this.bufferChar.length << 1];
                System.arraycopy(tmp, 0, this.bufferChar, 0, tmp.length);
            }
            int total = this.instream.read(this.bufferChar, this.finishChar, this.bufferChar.length - this.finishChar);
            if (total <= 0) {
                return -1;
            }
            this.finishChar += total;
        }
        return this.bufferChar[this.currentPos++];
    }

    public void close() {
    }

    public String toString() {
        switch (this.currentState) {
            case 1: {
                String s = "START ELEM: <" + this.elementName;
                if (this.attributeNames.size() > 0) {
                    s = s + " ";
                    for (int i = 0; i < this.attributeNames.size(); ++i) {
                        s = s + this.attributeNames.elementAt(i) + "=\"" + this.attributeValues.elementAt(i) + "\" ";
                    }
                }
                s = s + ">";
                return s;
            }
            case 2: {
                String s = "END ELEM: </" + this.elementName + ">";
                return s;
            }
            case 4: {
                return "CHARACTERS: \"" + this.getText();
            }
        }
        return "UNKOWN";
    }

    public static boolean next(XMLPullParser reader, XMLDefaultHandlerImpl parserHdlr) throws Exception {
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    parserHdlr.startElement(EMPTY, EMPTY, reader.getElementName(), reader.getAttributes());
                    break;
                }
                case 2: {
                    parserHdlr.endElement(EMPTY, EMPTY, reader.getElementName());
                    String lastElementName = null;
                    if (reader.getElementNames().size() > 0) {
                        lastElementName = (String)reader.getElementNames().lastElement();
                    }
                    if (lastElementName == null || !lastElementName.equalsIgnoreCase("IRETURNVALUE")) break;
                    return true;
                }
                case 4: {
                    char[] buf = reader.getText().toCharArray();
                    parserHdlr.characters(buf, 0, buf.length);
                    break;
                }
                case 8: {
                    return false;
                }
            }
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            File[] xmlFiles = XMLDefaultHandlerImpl.listAllXml(new File("c:\\code\\cimxml\\"));
            xmlFiles = new File[]{new File("c:\\code\\cimxml\\Response_EnumerateInstances_Brocade_PortInSwitch.xml")};
            for (int i = 0; i < xmlFiles.length; ++i) {
                XMLDefaultHandlerImpl parserHdlr = new XMLDefaultHandlerImpl(false);
                System.out.println("\n" + i + " - " + xmlFiles[i].getAbsolutePath());
                XMLPullParser reader = new XMLPullParser(new InputStreamReader(new FileInputStream(xmlFiles[i])));
                try {
                    while (XMLPullParser.next(reader, parserHdlr)) {
                        Vector v;
                        Vector o = parserHdlr.getObjects();
                        CIMResponse response = (CIMResponse)o.elementAt(0);
                        try {
                            response.checkError();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if ((v = response.getFirstReturnValue()).size() <= 0) continue;
                        System.out.println(v.remove(0));
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    parserHdlr = new XMLDefaultHandlerImpl(true);
                    System.out.println("\n" + i + " - " + xmlFiles[i].getAbsolutePath());
                    reader = new XMLPullParser(new InputStreamReader(new FileInputStream(xmlFiles[i])));
                    while (reader.hasNext()) {
                        int event = reader.next();
                        switch (event) {
                            case 1: {
                                parserHdlr.startElement(EMPTY, EMPTY, reader.getElementName(), reader.getAttributes());
                                break;
                            }
                            case 2: {
                                parserHdlr.endElement(EMPTY, EMPTY, reader.getElementName());
                                break;
                            }
                            case 4: {
                                char[] buf = reader.getText().toCharArray();
                                parserHdlr.characters(buf, 0, buf.length);
                            }
                        }
                    }
                    CIMResponse response = (CIMResponse)parserHdlr.getObjects().elementAt(0);
                    System.out.println("done\n" + response.getFirstReturnValue());
                    e.printStackTrace();
                    return;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class XMLAttributes
    implements Attributes {
        XMLAttributes() {
        }

        public int getLength() {
            return XMLPullParser.this.totalAttributes;
        }

        public String getURI(int index) {
            return XMLPullParser.EMPTY;
        }

        public String getLocalName(int index) {
            return XMLPullParser.EMPTY;
        }

        public String getQName(int index) {
            return ((XMLAttributeValue)XMLPullParser.this.attributeNames.elementAt(index)).getText();
        }

        public String getType(int index) {
            return XMLPullParser.EMPTY;
        }

        public String getValue(int index) {
            return ((XMLAttributeValue)XMLPullParser.this.attributeValues.elementAt(index)).getText();
        }

        public int getIndex(String uri, String localName) {
            return 0;
        }

        public int getIndex(String qName) {
            return XMLPullParser.this.attributeNames.indexOf(qName);
        }

        public String getType(String uri, String localName) {
            return XMLPullParser.EMPTY;
        }

        public String getType(String qName) {
            return XMLPullParser.EMPTY;
        }

        public String getValue(String uri, String localName) {
            return XMLPullParser.EMPTY;
        }

        public String getValue(String qName) {
            return ((XMLAttributeValue)XMLPullParser.this.attributeValues.elementAt(XMLPullParser.this.attributeNames.indexOf(qName))).getText();
        }
    }

    class CharString {
        private char[] value;
        private int offset;
        private int count;
        private int hash;
        private String str;

        public CharString(char[] value, int begin, int count) {
            this(value, begin, count, null);
        }

        public CharString(char[] value, int begin, int count, String str) {
            this.value = value;
            this.offset = begin;
            this.count = count;
            this.hash = 0;
            this.str = str;
        }

        public void init(char[] value, int begin, int count, String str) {
            this.value = value;
            this.offset = begin;
            this.count = count;
            this.hash = 0;
            this.str = str;
        }

        public int quickHash() {
            int length = this.value.length;
            if (this.hash == 0 && this.value != null && length > 0) {
                this.hash = this.value[0] * 37 + this.value[length - 1] * 31 + this.value[length >> 1] * 7;
            }
            return this.hash;
        }

        public int hashCode() {
            int h = this.hash;
            if (h == 0) {
                int off = this.offset;
                char[] val = this.value;
                int len = this.count;
                for (int i = 0; i < len; ++i) {
                    h = 31 * h + val[off++];
                }
                this.hash = h;
            }
            return h;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CharString)) {
                return false;
            }
            String s = (String)o;
            int pos = this.offset;
            for (int i = 0; i < this.count; ++i) {
                if (this.value[pos] != s.charAt(i)) {
                    return false;
                }
                ++pos;
            }
            return true;
        }
    }

    class XMLAttributeValue {
        int begin;
        int len;
        String text;
        private boolean translate;
        int _currentPos;
        int hash;

        public XMLAttributeValue(int begin, int len, int hash) {
            this.begin = begin;
            this.len = len;
            this.translate = true;
            this.hash = hash;
        }

        public XMLAttributeValue(int begin, int len, boolean translate, int hash) {
            this.begin = begin;
            this.len = len;
            this.translate = translate;
            this.hash = hash;
        }

        public void setTranslate(boolean translate, int hash) {
            this.translate = translate;
            this.hash = hash;
        }

        public String getText() {
            if (this.text == null) {
                if (this.translate) {
                    try {
                        this.text = this._getChars();
                    }
                    catch (Exception e) {
                        Logger logger = GlobalProperties.getLogger();
                        if (logger.isLoggable(Level.WARNING)) {
                            logger.log(Level.WARNING, "exception while decoding CHARACTERS XML", e);
                        }
                        this.text = new String(XMLPullParser.this.bufferChar, this.begin, this.len);
                    }
                } else {
                    this.text = new String(XMLPullParser.this.bufferChar, this.begin, this.len);
                }
                this.hash = 0;
            }
            return this.text;
        }

        protected String _getChars() throws XMLPullParserException {
            StringBuffer attributeValue = new StringBuffer();
            int last = this.begin + this.len;
            this._currentPos = this.begin;
            while (this._currentPos < last) {
                char ch = XMLPullParser.this.bufferChar[this._currentPos];
                if (ch == '&') {
                    int ref = this.parseReference();
                    if (ref > -1) {
                        attributeValue.append((char)ref);
                    }
                } else {
                    attributeValue.append(ch);
                }
                ++this._currentPos;
            }
            return attributeValue.toString();
        }

        public void init(int begin, int len) {
            this.begin = begin;
            this.len = len;
            this.text = null;
        }

        protected int parseReference() throws XMLPullParserException {
            char ch1;
            int pos = this._currentPos++;
            if ((ch1 = XMLPullParser.this.bufferChar[this._currentPos++]) == '#') {
                if ((ch1 = XMLPullParser.this.bufferChar[this._currentPos++]) == 'x') {
                    int value = 0;
                    while (true) {
                        if ((ch1 = XMLPullParser.this.bufferChar[this._currentPos++]) >= '0' && ch1 <= '9') {
                            value = value * 16 + (ch1 - 48);
                            continue;
                        }
                        if ((ch1 < 'A' || ch1 > 'F') && (ch1 < 'a' || ch1 > 'z')) break;
                        value = value * 16 + (Character.toUpperCase(ch1) - 65 + 10);
                    }
                    if (ch1 != ';') {
                        throw new XMLPullParserException("invalid character while parsing hex encoded number " + XMLPullParser.this.escape(ch1));
                    }
                    --this._currentPos;
                    return (char)value;
                }
                int value = 0;
                if (ch1 >= '0' && ch1 <= '9') {
                    while (ch1 >= '0' && ch1 <= '9') {
                        value = value * 10 + (ch1 - 48);
                        ch1 = XMLPullParser.this.bufferChar[this._currentPos++];
                    }
                    if (ch1 != ';') {
                        throw new XMLPullParserException("invalid character while parsing decinal encoded character: " + XMLPullParser.this.escape(ch1));
                    }
                    --this._currentPos;
                    return (char)value;
                }
                throw new XMLPullParserException("invalid number format");
            }
            int startPos = this._currentPos - 1;
            if (XMLPullParser.this.isValidStartElementNameChar(ch1)) {
                while ((ch1 = XMLPullParser.this.bufferChar[this._currentPos++]) != ';') {
                    if (XMLPullParser.this.isValidElementNameChar(ch1)) continue;
                    throw new XMLPullParserException("invalid reference character " + XMLPullParser.this.escape(ch1));
                }
            } else {
                throw new XMLPullParserException("expected valid name start character for value reference");
            }
            --this._currentPos;
            ch1 = XMLPullParser.this.bufferChar[startPos];
            char ch2 = XMLPullParser.this.bufferChar[startPos + 1];
            char ch3 = XMLPullParser.this.bufferChar[startPos + 2];
            if (ch1 == 'l' && ch2 == 't' && ch3 == ';') {
                return 60;
            }
            if (ch1 == 'g' && ch2 == 't' && ch3 == ';') {
                return 62;
            }
            char ch4 = XMLPullParser.this.bufferChar[startPos + 3];
            if (ch1 == 'a' && ch2 == 'm' && ch3 == 'p' && ch4 == ';') {
                return 38;
            }
            char ch5 = XMLPullParser.this.bufferChar[startPos + 4];
            if (ch1 == 'a' && ch2 == 'p' && ch3 == 'o' && ch4 == 's' && ch5 == ';') {
                return 39;
            }
            if (ch1 == 'q' && ch2 == 'u' && ch3 == 'o' && ch4 == 't' && ch5 == ';') {
                return 34;
            }
            return -1;
        }

        public String toString() {
            return this.getText();
        }
    }

    class FastStringHash {
        int hash;
        String str;

        public FastStringHash(String str, int hash) {
            this.str = str;
            this.hash = hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FastStringHash)) {
                return false;
            }
            return this.hash == ((FastStringHash)o).hash;
        }
    }
}

