/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.DS4K;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.wbem.cim.CIMInstance;
import org.eclipse.aperi.simulator.cimom.common.DatabaseManager;
import org.eclipse.aperi.simulator.cimom.common.generator.DataGeneratorResponse;
import org.eclipse.aperi.simulator.cimom.common.generator.DeviceDataGenerator;
import org.eclipse.aperi.simulator.cimom.common.generator.SimAssociationClass;
import org.eclipse.aperi.simulator.cimom.common.generator.SimClass;

public class DS4KCimomDataGenerator {
    private static final String INTEROP_XML = "XML\\Storage\\IBM\\DS4K\\DS4K_interop.xml";
    private static final String ROOT_LSISSI11_XML = "XML\\Storage\\IBM\\DS4K\\DS4K_LSISSI_11.xml";
    private static final String ROOT_LSISSI_XML = "XML\\Storage\\IBM\\DS4K\\DS4K_LSISSI.xml";
    private static final String NAMESPACE_INTEROP = "/interop";
    private static final String NAMESPACE_ROOT_LSISSI11 = "/root/lsissi11";
    private static final String NAMESPACE_ROOT_LSISSI = "/root/lsissi";
    private String configFile = "conf/DS4K-requirement.config";

    private DataGeneratorResponse generateDataForInterop(DataGeneratorResponse lsissiResponse, DataGeneratorResponse lsissi11Response) throws Exception {
        DeviceDataGenerator dataGenerator = new DeviceDataGenerator(INTEROP_XML, this.configFile);
        DataGeneratorResponse response = dataGenerator.generateData(NAMESPACE_INTEROP);
        Iterator iter = response.getRemainingClassList().iterator();
        SimClass simClass = null;
        while (iter.hasNext()) {
            simClass = (SimClass)iter.next();
            if (simClass.getName().equalsIgnoreCase("LSISSI_ElementConformsToProfile")) break;
        }
        List instances = new ArrayList();
        instances.addAll(dataGenerator.getCreator().createAssociationInstances(simClass, ((List)response.getInstanceMap().get("/interop:LSISSI_RegisteredProfile")).toArray(), (CIMInstance)lsissi11Response.getInstanceMap().get("/root/lsissi11:LSISSI_StorageSystem")));
        ((SimAssociationClass)simClass).setDependentNS(NAMESPACE_ROOT_LSISSI11);
        instances.addAll(dataGenerator.getCreator().createAssociationInstances(simClass, ((List)response.getInstanceMap().get("/interop:LSISSI_RegisteredProfile")).toArray(), (CIMInstance)lsissi11Response.getInstanceMap().get("/root/lsissi11:LSISSI_StorageSystem")));
        response.addInstances("/interop:LSISSI_ElementConformsToProfile", instances);
        iter = response.getRemainingClassList().iterator();
        while (iter.hasNext()) {
            simClass = (SimClass)iter.next();
            if (simClass.getName().equalsIgnoreCase("LSISSI_ObjectManagerElementConformsToProfile")) break;
        }
        instances = dataGenerator.getCreator().createAssociationInstances(simClass, ((List)response.getInstanceMap().get("/interop:LSISSI_ServerRegisteredProfile")).toArray(), (CIMInstance)response.getInstanceMap().get("/interop:LSISSI_StorageManagementSystem"));
        instances.addAll(dataGenerator.getCreator().createAssociationInstances(simClass, ((List)response.getInstanceMap().get("/interop:LSISSI_ServerRegisteredProfile")).toArray(), (CIMInstance)response.getInstanceMap().get("/interop:LSISSI_ObjectManager")));
        response.addInstances("/interop:LSISSI_ObjectManagerElementConformsToProfile", instances);
        return response;
    }

    private DataGeneratorResponse generateDataForLSISSI11() throws Exception {
        DeviceDataGenerator dataGenerator = new DeviceDataGenerator(ROOT_LSISSI11_XML, this.configFile);
        DataGeneratorResponse response = dataGenerator.generateData(NAMESPACE_ROOT_LSISSI11);
        Properties properties = new Properties();
        properties.load(new FileInputStream("conf/classlist.properties"));
        String[] classArray = properties.getProperty("STORAGE_POOL_LIST").split(",");
        LinkedList classList = new LinkedList();
        Collections.addAll(classList, classArray);
        classArray = properties.getProperty("STORAGE_VOLUME_LIST").split(",");
        Collections.addAll(classList, classArray);
        classArray = properties.getProperty("STORAGE_EXTENT_LIST").split(",");
        Collections.addAll(classList, classArray);
        Properties confProperties = new Properties();
        confProperties.load(new FileInputStream(this.configFile));
        int numberOfStoragePool = Integer.parseInt(confProperties.getProperty("NUMBER_OF_STORAGE_POOL"));
        String[] volumeData = confProperties.getProperty("MAPPING_POOL_TO_VOLUME").split(" ");
        String[] extentData = confProperties.getProperty("MAPPING_DISK_TO_POOL").split(" ");
        int i = 0;
        while (i < numberOfStoragePool) {
            dataGenerator.getConfProperties().setProperty("NUMBER_OF_STORAGE_POOL", "1");
            dataGenerator.getConfProperties().setProperty("NUMBER_OF_DISK", extentData[i]);
            dataGenerator.getConfProperties().setProperty("NUMBER_OF_VOLUMES", volumeData[i]);
            dataGenerator.generateData(classList, response);
            ++i;
        }
        return response;
    }

    private DataGeneratorResponse generateDataForLSISSI(DataGeneratorResponse rootResponse) {
        DeviceDataGenerator dataGenerator = new DeviceDataGenerator(ROOT_LSISSI_XML, this.configFile);
        DataGeneratorResponse response = dataGenerator.generateData(NAMESPACE_ROOT_LSISSI);
        return response;
    }

    private void persistInstances(int nsID, DataGeneratorResponse response) throws Exception {
        DatabaseManager dbManager = DatabaseManager.getDbManager();
        Map instanceMap = response.getInstanceMap();
        Set keySet = instanceMap.keySet();
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            String simClass = (String)iter.next();
            String classname = simClass.substring(simClass.indexOf(58) + 1);
            dbManager.insert_CIM_CLASS(nsID, classname);
            int cimClassMaxCnt = dbManager.getMaxID("SIM.CIM_CLASS");
            Object instance = instanceMap.get(simClass);
            if (instance == null) continue;
            if (instance instanceof List) {
                Iterator tempIter = ((List)instance).iterator();
                while (tempIter.hasNext()) {
                    CIMInstance element = (CIMInstance)tempIter.next();
                    dbManager.insert_CIM_DATA(cimClassMaxCnt, element);
                }
                continue;
            }
            dbManager.insert_CIM_DATA(cimClassMaxCnt, (CIMInstance)instance);
        }
    }

    public void generateData(String confFile) {
        if (confFile != null) {
            this.configFile = confFile;
        }
        DatabaseManager dbManager = DatabaseManager.getDbManager();
        try {
            dbManager.insert_CIMOM_INFO(1, "Sun Java WBEM CIMOM", "9.182.185.190", NAMESPACE_INTEROP, "administrator", "san46pass");
            int cimomId = dbManager.getMaxID("SIM.CIMOM_INFO");
            dbManager.insert_NS_INFO(cimomId, NAMESPACE_INTEROP);
            int interopNsID = dbManager.getMaxID("SIM.NS_INFO");
            dbManager.insert_NS_INFO(cimomId, NAMESPACE_ROOT_LSISSI);
            int lsissisNsID = dbManager.getMaxID("SIM.NS_INFO");
            dbManager.insert_NS_INFO(cimomId, NAMESPACE_ROOT_LSISSI11);
            int lsissi11NsID = dbManager.getMaxID("SIM.NS_INFO");
            DataGeneratorResponse lsissi11Response = this.generateDataForLSISSI11();
            DataGeneratorResponse lsissiResponse = this.generateDataForLSISSI(lsissi11Response);
            DataGeneratorResponse interopResponse = this.generateDataForInterop(lsissiResponse, lsissi11Response);
            this.persistInstances(interopNsID, interopResponse);
            this.persistInstances(lsissisNsID, lsissiResponse);
            this.persistInstances(lsissi11NsID, lsissi11Response);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

