/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.DS6K;

import java.io.FileInputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt64;
import org.eclipse.aperi.simulator.cimom.common.DatabaseManager;
import org.eclipse.aperi.simulator.cimom.common.generator.DataGeneratorResponse;
import org.eclipse.aperi.simulator.cimom.common.generator.DeviceDataGenerator;
import org.eclipse.aperi.simulator.cimom.sunwbem.provider.methods.DS6kExtrinsicMethods;

public class DS6KCimomDataGenerator {
    private static final String ROOT_IBM_XML = "XML\\Storage\\IBM\\DS6K\\DS6K_Root_IBM.xml";
    private static final String NAMESPACE_ROOT_IBM = "/root/ibm";
    private String configFile = "conf/DS6K-requirement.config";
    private static final String STANDARD_POOL_SIZE = "10737418240";
    private static final String STANDARD_VOL_SIZE = "1073741824";

    public void generateData(String confFile) {
        if (confFile != null) {
            this.configFile = confFile;
        }
        DatabaseManager dbManager = DatabaseManager.getDbManager();
        try {
            dbManager.insert_CIMOM_INFO(1, "Sun Java WBEM CIMOM", "9.182.185.190", NAMESPACE_ROOT_IBM, "administrator", "san46pass");
            int cimomId = dbManager.getMaxID("SIM.CIMOM_INFO");
            dbManager.insert_NS_INFO(cimomId, NAMESPACE_ROOT_IBM);
            int root_ibm_NsID = dbManager.getMaxID("SIM.NS_INFO");
            DeviceDataGenerator dataGenerator = new DeviceDataGenerator(ROOT_IBM_XML, this.configFile);
            DataGeneratorResponse root_ibm_Response = dataGenerator.generateData(NAMESPACE_ROOT_IBM);
            dbManager.persistInstances(root_ibm_NsID, root_ibm_Response.getInstanceMap(), dataGenerator.getParserResponse().getClassMap());
            List configServList = DatabaseManager.getDbManager().enumerateInstanceNames(NAMESPACE_ROOT_IBM, "IBMTSESS_StorageConfigurationService");
            Iterator iter = configServList.iterator();
            CIMObjectPath configServOp = null;
            while (iter.hasNext()) {
                configServOp = (CIMObjectPath)iter.next();
            }
            Properties confProperties = new Properties();
            confProperties.load(new FileInputStream(this.configFile));
            int numberOfStoragePool = Integer.parseInt(confProperties.getProperty("NUMBER_OF_POOLS"));
            String[] extentData = confProperties.getProperty("MAPPING_DISK_TO_POOL").split(" ");
            String[] volData = confProperties.getProperty("MAPPING_POOL_TO_VOLUME").split(" ");
            List extents = DatabaseManager.getDbManager().enumerateInstanceNames(NAMESPACE_ROOT_IBM, "IBMTSESS_StorageExtent");
            Iterator extentIter = extents.iterator();
            int i = 0;
            while (i < numberOfStoragePool) {
                Vector<CIMArgument> inArgsPool = new Vector<CIMArgument>();
                Vector<CIMArgument> outArgsPool = new Vector<CIMArgument>();
                String poolName = "pool-" + i;
                CIMArgument inArg1Pool = new CIMArgument("ElementName");
                inArg1Pool.setValue(new CIMValue((Object)poolName, CIMDataType.getPredefinedType((int)8)));
                inArgsPool.add(inArg1Pool);
                CIMArgument inArg2Pool = new CIMArgument("Goal");
                inArgsPool.add(inArg2Pool);
                CIMArgument inArg3Pool = new CIMArgument("InExtents");
                Vector<String> inputExtent = new Vector<String>();
                int j = 0;
                while (j < new Integer(extentData[i])) {
                    inputExtent.add(extentIter.next().toString());
                    ++j;
                }
                inArg3Pool.setValue(new CIMValue(inputExtent, CIMDataType.getPredefinedType((int)22)));
                inArgsPool.add(inArg3Pool);
                CIMArgument inArg4Pool = new CIMArgument("InPools");
                inArgsPool.add(inArg4Pool);
                CIMArgument inArg5Pool = new CIMArgument("Pool");
                inArgsPool.add(inArg5Pool);
                UnsignedInt64 inArg6ParamPool = new UnsignedInt64(STANDARD_POOL_SIZE);
                CIMArgument inArg6Pool = new CIMArgument("Size");
                inArg6Pool.setValue(new CIMValue((Object)inArg6ParamPool, CIMDataType.getPredefinedType((int)6)));
                inArgsPool.add(inArg6Pool);
                CIMArgument outArg1Pool = new CIMArgument("Job");
                outArgsPool.add(outArg1Pool);
                outArgsPool.add(inArg5Pool);
                outArgsPool.add(inArg6Pool);
                CIMArgument[] inArrayPool = new CIMArgument[inArgsPool.size()];
                inArgsPool.toArray(inArrayPool);
                CIMArgument[] outArrayPool = new CIMArgument[outArgsPool.size()];
                outArgsPool.toArray(outArrayPool);
                CIMValue ret = DS6kExtrinsicMethods.createOrModifyStoragePool(configServOp, inArrayPool, outArrayPool);
                if (((UnsignedInt16)ret.getValue()).intValue() == 0) {
                    CIMObjectPath poolOp = (CIMObjectPath)outArrayPool[1].getValue().getValue();
                    int j2 = 0;
                    while (j2 < new Integer(volData[i])) {
                        Vector<CIMArgument> inArgsVol = new Vector<CIMArgument>();
                        Vector<CIMArgument> outArgsVol = new Vector<CIMArgument>();
                        String volumeName = "pool" + i + "vol" + j2;
                        CIMArgument intArg1Vol = new CIMArgument("ElementName");
                        intArg1Vol.setValue(new CIMValue((Object)volumeName, CIMDataType.getPredefinedType((int)8)));
                        inArgsVol.add(intArg1Vol);
                        UnsignedInt16 inArg2ParamVol = new UnsignedInt16(2);
                        CIMArgument inArg2Vol = new CIMArgument("ElementType");
                        inArg2Vol.setValue(new CIMValue((Object)inArg2ParamVol, CIMDataType.getPredefinedType((int)2)));
                        inArgsVol.add(inArg2Vol);
                        CIMArgument inArg3Vol = new CIMArgument("Goal");
                        inArgsVol.add(inArg3Vol);
                        CIMArgument inArg4Vol = new CIMArgument("InPool");
                        inArg4Vol.setValue(new CIMValue((Object)poolOp, new CIMDataType(poolOp.getObjectName())));
                        inArgsVol.add(inArg4Vol);
                        UnsignedInt64 inArg5ParamVol = new UnsignedInt64(STANDARD_VOL_SIZE);
                        CIMArgument inArg5Vol = new CIMArgument("Size");
                        inArg5Vol.setValue(new CIMValue((Object)inArg5ParamVol, CIMDataType.getPredefinedType((int)6)));
                        inArgsVol.add(inArg5Vol);
                        CIMArgument outArg1Vol = new CIMArgument("Job");
                        outArgsVol.add(outArg1Vol);
                        outArgsVol.add(inArg5Vol);
                        CIMArgument outArg2Vol = new CIMArgument("TheElement");
                        outArg2Vol.setType(CIMDataType.getPredefinedType((int)29));
                        outArgsVol.add(outArg2Vol);
                        CIMArgument[] inArrayVol = new CIMArgument[inArgsVol.size()];
                        inArgsVol.toArray(inArrayVol);
                        CIMArgument[] outArrayVol = new CIMArgument[outArgsVol.size()];
                        outArgsVol.toArray(outArrayVol);
                        DS6kExtrinsicMethods.createOrModifyElementFromStoragePool(configServOp, inArrayVol, outArrayVol);
                        ++j2;
                    }
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

