/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.common.base;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.eclipse.aperi.simulator.SimulatorConfig;
import org.eclipse.aperi.simulator.SimulatorException;
import org.eclipse.aperi.simulator.cimom.common.CIMOM;

public abstract class BaseSnapshotMaker
extends Thread {
    protected CIMOM cimom;
    protected Connection con;

    static {
        try {
            Class.forName(SimulatorConfig.dbDriverName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BaseSnapshotMaker(CIMOM cimom) throws SimulatorException {
        this.cimom = cimom;
        try {
            this.con = DriverManager.getConnection(SimulatorConfig.dbUrl);
        }
        catch (Exception e) {
            throw new SimulatorException("", "", e);
        }
    }

    public void takeSnapshot() throws SimulatorException {
        try {
            this.start();
        }
        catch (Exception e) {
            throw new SimulatorException(e.getMessage(), "", e);
        }
    }

    public abstract void run();

    protected synchronized void insert_CIMOM_INFO(int type, String details, String url, String namespace, String user, String password) throws Exception {
        String CIMOM_INFO_INSERT = "INSERT INTO SIM.CIMOM_INFO (CIMOM_TYPE, DETAILS, URL, INTOP_NS, USERID, PWDID) VALUES (?, ?, ?, ?, ?, ?)";
        PreparedStatement ps_cimom_info_insert = this.con.prepareStatement(CIMOM_INFO_INSERT);
        ps_cimom_info_insert.setInt(1, 1);
        ps_cimom_info_insert.setString(2, "SUN WBEM CIMOM");
        ps_cimom_info_insert.setString(3, url);
        ps_cimom_info_insert.setString(4, namespace);
        if (user != null) {
            ps_cimom_info_insert.setString(5, user);
        } else {
            ps_cimom_info_insert.setNull(5, 12);
        }
        if (password != null) {
            ps_cimom_info_insert.setString(6, password);
        } else {
            ps_cimom_info_insert.setNull(6, 12);
        }
        ps_cimom_info_insert.executeUpdate();
        this.con.commit();
        ps_cimom_info_insert.close();
    }

    protected synchronized void insert_NS_INFO(int cimomInfoID, String namespace) throws Exception {
        String NS_INFO_INSERT = "INSERT INTO SIM.NS_INFO(CIMOM_INFO_ID, NAMESPACE) VALUES (?, ?)";
        PreparedStatement ps_ns_info_insert = this.con.prepareStatement(NS_INFO_INSERT);
        ps_ns_info_insert.setInt(1, cimomInfoID);
        ps_ns_info_insert.setString(2, namespace);
        ps_ns_info_insert.executeUpdate();
        this.con.commit();
        ps_ns_info_insert.close();
    }

    protected synchronized void insert_CIM_CLASS(int nsInfoCnt, String className) throws Exception {
        String CIM_CLASS_INSERT = "INSERT INTO SIM.CIM_CLASS(NS_INFO_ID, CLASS_NAME) VALUES (?, ?)";
        PreparedStatement ps_cim_class_insert = this.con.prepareStatement(CIM_CLASS_INSERT);
        ps_cim_class_insert.setInt(1, nsInfoCnt);
        ps_cim_class_insert.setString(2, className);
        ps_cim_class_insert.executeUpdate();
        this.con.commit();
        ps_cim_class_insert.close();
    }

    protected int getMaxID(String tableName) throws Exception {
        int maxCnt = -1;
        String qry = "SELECT MAX(ID) FROM " + tableName;
        PreparedStatement ps = this.con.prepareStatement(qry);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            maxCnt = rs.getInt(1);
        }
        rs.close();
        ps.close();
        return maxCnt;
    }

    protected synchronized void snapshotClassInstances(String className, int nsInfoCnt) throws Exception {
    }

    protected synchronized void snapshotClasses(String namespace, int nsInfoCnt) throws Exception {
    }

    protected synchronized void insert_CIM_ASSOC(int assocID, int fromID, int toID) throws Exception {
        String CIM_ASSOC_INSERT = "INSERT INTO SIM.CIM_ASC(CIM_DATA_ASC_ID, CIM_DATA_FRM_ID, CIM_DATA_TO_ID) VALUES (?, ?, ?)";
        PreparedStatement ps_cim_assoc_insert = this.con.prepareStatement(CIM_ASSOC_INSERT);
        ps_cim_assoc_insert.setInt(1, assocID);
        ps_cim_assoc_insert.setInt(2, fromID);
        ps_cim_assoc_insert.setInt(3, toID);
        ps_cim_assoc_insert.executeUpdate();
        this.con.commit();
        ps_cim_assoc_insert.close();
    }
}

