/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.common.generator;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.wbem.cim.CIMInstance;
import org.eclipse.aperi.simulator.cimom.common.generator.ClassXMLParser;
import org.eclipse.aperi.simulator.cimom.common.generator.DataGeneratorResponse;
import org.eclipse.aperi.simulator.cimom.common.generator.InstanceCreator;
import org.eclipse.aperi.simulator.cimom.common.generator.ParserRespose;
import org.eclipse.aperi.simulator.cimom.common.generator.SimAssociationClass;
import org.eclipse.aperi.simulator.cimom.common.generator.SimClass;
import org.eclipse.aperi.simulator.cimom.common.generator.SimMapping;
import org.eclipse.aperi.simulator.cimom.common.generator.SimUnitMap;

public class DeviceDataGenerator {
    private static final String NAMESPACE_CLASSNAME_SEPERATOR = ":";
    private String xmlFileName;
    private String configurationFile;
    private InstanceCreator creator;
    private Properties confProperties;
    private ParserRespose parserResponse;

    public DeviceDataGenerator(String xmlFileName, String confFileName) {
        this.xmlFileName = xmlFileName;
        this.configurationFile = confFileName;
        this.creator = new InstanceCreator();
        this.confProperties = new Properties();
        try {
            this.confProperties.load(new FileInputStream(this.configurationFile));
            this.creator.setConfProperties(this.confProperties);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private ParserRespose initGenerator(String namespace) {
        try {
            ClassXMLParser parser = new ClassXMLParser();
            this.parserResponse = parser.parse(this.xmlFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        this.creator.setNamespace(namespace);
        return this.parserResponse;
    }

    public DataGeneratorResponse generateData(String namespace) {
        DataGeneratorResponse response = new DataGeneratorResponse();
        this.initGenerator(namespace);
        Iterator iter = this.parserResponse.getClassList().iterator();
        while (iter.hasNext()) {
            SimClass simClass = (SimClass)iter.next();
            if (simClass.isAutoGenerate()) {
                Object instance;
                if (simClass.isConfiguration()) {
                    simClass.parseConfExp(this.confProperties);
                }
                if ((instance = !simClass.isAssociation() ? this.handleClass(response, simClass) : this.handleAssociationClass((SimAssociationClass)simClass, response)) != null) {
                    this.addInstancesToResponse(response, simClass, instance);
                    continue;
                }
                response.addRemainingClass(simClass);
                continue;
            }
            response.addRemainingClass(simClass);
        }
        return response;
    }

    public DataGeneratorResponse generateData(List classNames, DataGeneratorResponse response) {
        DataGeneratorResponse tempResponse = new DataGeneratorResponse();
        Iterator oldResponse = response.getInstanceMap().keySet().iterator();
        while (oldResponse.hasNext()) {
            String entryClass = (String)oldResponse.next();
            String classname = entryClass.substring(entryClass.indexOf(58) + 1);
            Iterator iter = classNames.iterator();
            boolean addClass = true;
            while (iter.hasNext()) {
                String next = (String)iter.next();
                if (next.indexOf(91) != -1) {
                    next = this.extractSimClassName(next).getName();
                }
                if (!next.trim().equalsIgnoreCase(classname)) continue;
                addClass = false;
                break;
            }
            if (!addClass) continue;
            tempResponse.addInstances(entryClass, response.getInstanceMap().get(entryClass));
        }
        Iterator iter = classNames.iterator();
        while (iter.hasNext()) {
            Object instance;
            String simClassName = (String)iter.next();
            SimClass simClass = null;
            simClass = simClassName.indexOf(91) != -1 ? this.extractSimClassName(simClassName) : (SimClass)this.parserResponse.getClassMap().get(simClassName);
            if (simClass.isConfiguration()) {
                simClass.parseConfExp(this.confProperties);
            }
            if ((instance = !simClass.isAssociation() ? this.handleClass(tempResponse, simClass) : this.handleAssociationClass((SimAssociationClass)simClass, tempResponse)) == null) continue;
            this.addInstancesToResponse(tempResponse, simClass, instance);
            this.addInstancesToResponse(response, simClass, instance);
        }
        tempResponse.getInstanceMap().clear();
        return response;
    }

    private SimClass extractSimClassName(String simClassName) {
        SimClass simClass = (SimClass)this.parserResponse.getClassMap().get(simClassName.substring(0, simClassName.indexOf(91)));
        String temp = simClassName.substring(simClassName.indexOf(91) + 1);
        String antecedentName = temp.substring(0, temp.indexOf("->"));
        String dependentName = temp.substring(temp.indexOf("->") + 2, temp.indexOf(93));
        if (simClass.isAssociation()) {
            ((SimAssociationClass)simClass).setAntecedentClassName(antecedentName);
            ((SimAssociationClass)simClass).setDependentClassName(dependentName);
        }
        return simClass;
    }

    public Object handleClass(DataGeneratorResponse response, SimClass simClass) {
        int noi = 0;
        List instance = null;
        System.out.println("Going to generate for : " + simClass.getName());
        if (simClass.getNumberOfInstances() != 0) {
            if (simClass.getNumberOfInstances() > 1) {
                instance = this.creator.createInstances(simClass, response.getInstanceMap());
                noi = instance.size();
            } else {
                noi = 1;
                instance = this.creator.createInstance(simClass, response.getInstanceMap());
            }
        }
        System.out.println("NOI for class : " + simClass.getName() + " : " + noi);
        return instance;
    }

    public Object handleAssociationClass(SimAssociationClass simClass, DataGeneratorResponse response) {
        int noi = 0;
        Object antecedent = response.getInstanceMap().get(String.valueOf(simClass.getNamespace()) + NAMESPACE_CLASSNAME_SEPERATOR + simClass.getAntecedentClassName());
        Object dependent = response.getInstanceMap().get(String.valueOf(simClass.getNamespace()) + NAMESPACE_CLASSNAME_SEPERATOR + simClass.getDependentClassName());
        Object retVal = null;
        if (antecedent == null || dependent == null) {
            noi = 0;
            System.err.println("Null association class " + simClass.getName() + " with A = " + simClass.getAntecedentClassName() + " D = " + simClass.getDependentClassName());
            return retVal;
        }
        SimMapping mapping = simClass.getMapping();
        retVal = mapping != null ? (mapping.getMappingType().equalsIgnoreCase("Generic") ? this.handleGenericMapping(simClass, antecedent, dependent) : (mapping.getMappingType().equalsIgnoreCase("Custom") ? this.handleCustomMapping(simClass, antecedent, dependent) : this.handleNormalMapping(simClass, antecedent, dependent))) : this.handleNormalMapping(simClass, antecedent, dependent);
        noi = retVal != null ? (retVal instanceof List ? ((List)retVal).size() : 1) : 0;
        System.out.println("NOI for class : " + simClass.getName() + " : " + noi);
        return retVal;
    }

    private List handleGenericMapping(SimAssociationClass simClass, Object antecedent, Object dependent) {
        ArrayList retVal = new ArrayList();
        SimMapping mapping = simClass.getMapping();
        SimUnitMap map = (SimUnitMap)mapping.getMapList().get(0);
        if (-1 != map.getAntecedentNumber()) {
            int numOfAntecedent = map.getAntecedentNumber();
            int numOfDependent = Integer.parseInt(map.getMapValue());
            if (antecedent instanceof CIMInstance) {
                retVal.addAll(this.creator.createAssociationInstances((SimClass)simClass, (CIMInstance)antecedent, ((List)dependent).subList(0, numOfDependent).toArray()));
            } else {
                int totalAntecedent = ((List)antecedent).size();
                int i = 0;
                while (i < totalAntecedent) {
                    retVal.addAll(this.creator.createAssociationInstances((SimClass)simClass, (CIMInstance)((List)antecedent).get(i), ((List)dependent).subList(i * numOfDependent, (i + 1) * numOfDependent).toArray()));
                    i += numOfAntecedent;
                }
            }
        } else {
            int numOfAntecedent = Integer.parseInt(map.getMapValue());
            int numOfDependent = map.getDependentNumber();
            if (dependent instanceof CIMInstance) {
                retVal.addAll(this.creator.createAssociationInstances((SimClass)simClass, ((List)antecedent).subList(0, numOfAntecedent).toArray(), (CIMInstance)dependent));
            } else {
                int totalDependent = ((List)dependent).size();
                int i = 0;
                while (i < totalDependent) {
                    retVal.addAll(this.creator.createAssociationInstances((SimClass)simClass, ((List)antecedent).subList(i * numOfAntecedent, (i + 1) * numOfAntecedent).toArray(), (CIMInstance)((List)dependent).get(i)));
                    i += numOfDependent;
                }
            }
        }
        return retVal;
    }

    private List handleCustomMapping(SimAssociationClass simClass, Object antecedent, Object dependent) {
        ArrayList<CIMInstance> retVal = new ArrayList<CIMInstance>();
        List mapList = simClass.getMapping().getMapList();
        Iterator iter = mapList.iterator();
        while (iter.hasNext()) {
            int endIndex;
            int i;
            SimUnitMap map = (SimUnitMap)iter.next();
            String mapValue = map.getMapValue();
            if (-1 != map.getAntecedentNumber()) {
                List tempDependent = null;
                if (mapValue.indexOf(44) != -1) {
                    int[] dependentNumbers = this.parseMapString(mapValue);
                    tempDependent = new ArrayList();
                    i = 0;
                    while (i < dependentNumbers.length) {
                        if (dependentNumbers[i] != -1) {
                            tempDependent.add(((List)dependent).get(dependentNumbers[i] - 1));
                        }
                        ++i;
                    }
                } else if (mapValue.indexOf(45) != -1) {
                    int startIndex = Integer.parseInt(mapValue.substring(0, mapValue.indexOf(45)));
                    endIndex = Integer.parseInt(mapValue.substring(mapValue.indexOf(45) + 1));
                    tempDependent = ((List)dependent).subList(startIndex - 1, endIndex);
                } else {
                    int index = Integer.parseInt(mapValue);
                    if (dependent instanceof CIMInstance) {
                        retVal.add(this.creator.createAssociationInstance((SimClass)simClass, (CIMInstance)((List)antecedent).get(map.getAntecedentNumber() - 1), (CIMInstance)dependent));
                        continue;
                    }
                    if (antecedent instanceof List) {
                        retVal.add(this.creator.createAssociationInstance((SimClass)simClass, (CIMInstance)((List)antecedent).get(map.getAntecedentNumber() - 1), (CIMInstance)((List)dependent).get(index)));
                        continue;
                    }
                    retVal.add(this.creator.createAssociationInstance((SimClass)simClass, (CIMInstance)antecedent, (CIMInstance)((List)dependent).get(index)));
                    continue;
                }
                retVal.addAll(this.creator.createAssociationInstances((SimClass)simClass, (CIMInstance)((List)antecedent).get(map.getAntecedentNumber() - 1), tempDependent.toArray()));
                continue;
            }
            List tempAntecedent = null;
            if (mapValue.indexOf(44) != -1) {
                int[] antecedentNumbers = this.parseMapString(mapValue);
                tempAntecedent = new ArrayList();
                i = 0;
                while (i < antecedentNumbers.length) {
                    if (antecedentNumbers[i] != -1) {
                        tempAntecedent.add(((List)antecedent).get(antecedentNumbers[i] - 1));
                    }
                    ++i;
                }
            } else if (mapValue.indexOf(45) != -1) {
                int startIndex = Integer.parseInt(mapValue.substring(0, mapValue.indexOf(45)));
                endIndex = Integer.parseInt(mapValue.substring(mapValue.indexOf(45) + 1));
                tempAntecedent = ((List)antecedent).subList(startIndex - 1, endIndex);
            } else {
                int index = Integer.parseInt(mapValue);
                retVal.add(this.creator.createAssociationInstance((SimClass)simClass, (CIMInstance)((List)antecedent).get(index), (CIMInstance)((List)dependent).get(map.getDependentNumber() - 1)));
                continue;
            }
            retVal.addAll(this.creator.createAssociationInstances((SimClass)simClass, tempAntecedent.toArray(), (CIMInstance)((List)dependent).get(map.getDependentNumber() - 1)));
        }
        return retVal;
    }

    private Object handleNormalMapping(SimAssociationClass simClass, Object antecedent, Object dependent) {
        Object retVal = antecedent instanceof List ? (dependent instanceof List ? this.creator.createAssociationInstances((SimClass)simClass, ((List)antecedent).toArray(), ((List)dependent).toArray()) : this.creator.createAssociationInstances((SimClass)simClass, ((List)antecedent).toArray(), (CIMInstance)dependent)) : (dependent instanceof List ? this.creator.createAssociationInstances((SimClass)simClass, (CIMInstance)antecedent, ((List)dependent).toArray()) : this.creator.createAssociationInstance((SimClass)simClass, (CIMInstance)antecedent, (CIMInstance)dependent));
        return retVal;
    }

    public void addInstancesToResponse(DataGeneratorResponse response, SimClass simClass, Object instances) {
        Object previousInstance = response.getInstanceMap().get(String.valueOf(simClass.getNamespace()) + NAMESPACE_CLASSNAME_SEPERATOR + simClass.getName());
        if (previousInstance != null) {
            if (previousInstance instanceof List) {
                if (instances instanceof List) {
                    ((List)previousInstance).addAll((List)instances);
                } else {
                    ((List)previousInstance).add(instances);
                }
            } else {
                ArrayList<Object> instancesList = new ArrayList<Object>();
                if (instances instanceof List) {
                    instancesList.add(0, previousInstance);
                    instancesList.addAll((List)instances);
                } else {
                    instancesList.add(instances);
                    instancesList.add(previousInstance);
                }
                response.addInstances(String.valueOf(simClass.getNamespace()) + NAMESPACE_CLASSNAME_SEPERATOR + simClass.getName(), instancesList);
            }
        } else {
            response.addInstances(String.valueOf(simClass.getNamespace()) + NAMESPACE_CLASSNAME_SEPERATOR + simClass.getName(), instances);
        }
    }

    private int[] parseMapString(String mapValue) {
        String[] array = mapValue.split(",");
        int[] retVal = new int[array.length];
        int i = 0;
        while (i < array.length) {
            retVal[i] = !array[i].trim().equalsIgnoreCase("") ? Integer.parseInt(array[i]) : -1;
            ++i;
        }
        return retVal;
    }

    public Properties getConfProperties() {
        return this.confProperties;
    }

    public void setConfProperties(Properties confProperties) {
        this.confProperties = confProperties;
    }

    public String getXmlFileName() {
        return this.xmlFileName;
    }

    public void setXmlFileName(String xmlFileName) {
        this.xmlFileName = xmlFileName;
    }

    public InstanceCreator getCreator() {
        return this.creator;
    }

    public ParserRespose getParserResponse() {
        return this.parserResponse;
    }
}

