/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.common.generator;

import java.io.IOException;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PropertyParser
extends DefaultHandler {
    private static final String XML_ELEMENT_CLASS = "Class";
    private static final String XML_ELEMENT_PROPERTY = "Property";
    private static final String XML_ATTRIBUTE_NAME = "Name";
    private static final String XML_ATTRIBUTE_D = "D";
    private static final String XML_ATTRIBUTE_A = "A";
    private boolean isAssociation = false;
    private Properties response = new Properties();
    private StringBuffer propertyValue = new StringBuffer();
    private String propertyName;
    private String antecedent;
    private String dependent;
    private boolean isClass = false;

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equalsIgnoreCase(XML_ELEMENT_PROPERTY)) {
            this.propertyValue.setLength(0);
            this.propertyName = attributes.getValue(XML_ATTRIBUTE_NAME);
        } else if (qName.equalsIgnoreCase(XML_ELEMENT_CLASS)) {
            this.isClass = true;
            if (attributes.getLength() > 0) {
                this.isAssociation = true;
                int i = 0;
                while (i < attributes.getLength()) {
                    String attribute = attributes.getQName(i);
                    if (attribute.equalsIgnoreCase(XML_ATTRIBUTE_A)) {
                        this.antecedent = attributes.getValue(i);
                    } else if (attribute.equalsIgnoreCase(XML_ATTRIBUTE_D)) {
                        this.dependent = attributes.getValue(i);
                    }
                    ++i;
                }
            } else {
                this.isAssociation = false;
            }
        }
    }

    public void characters(char[] ch, int start, int length) {
        String value = new String(ch, start, length);
        if (!(value = value.trim()).equalsIgnoreCase("") && this.isClass) {
            this.propertyValue.append(value);
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if (qName.equalsIgnoreCase(XML_ELEMENT_PROPERTY)) {
            this.response.setProperty(this.propertyName, this.propertyValue.toString());
        } else if (qName.equalsIgnoreCase(XML_ELEMENT_CLASS)) {
            if (this.isAssociation) {
                this.propertyValue.append("[" + this.antecedent + "->" + this.dependent + "]");
            }
            this.propertyValue.append(",");
            this.isClass = false;
        }
    }

    public Properties parse(String fileName) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(fileName, (DefaultHandler)this);
        return this.response;
    }

    public static void main(String[] args) throws ParserConfigurationException, SAXException, IOException {
        System.out.println("Jai Baberi");
        PropertyParser parser = new PropertyParser();
        System.out.println(parser.parse("ClassList.xml"));
    }
}

