/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.common.generator;

import java.util.ArrayList;
import java.util.List;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.cim.UnsignedInt8;
import org.eclipse.aperi.simulator.cimom.common.generator.SimValue;

public class SimProperty {
    private String name;
    private String dataType;
    private Object value;
    private List values;
    private boolean isRandom;
    private boolean isMultiple;
    private boolean isKey;
    private boolean isRefer;
    private int incremental = 0;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String type) {
        this.dataType = type;
    }

    public Object getValue() {
        if (this.value != null && !(this.value instanceof SimValue)) {
            return SimProperty.getTypedValue(this.value, this.dataType);
        }
        return this.value;
    }

    public List getValues() {
        return this.values;
    }

    public Object getValues(int index) {
        Object val = this.values.get(index);
        if (val != null) {
            val = SimProperty.getTypedValue(val, this.dataType);
        }
        return val;
    }

    public static Object getTypedValue(Object val, String dataType) {
        if (dataType.equals("uint8") || dataType.equals("uint8[]")) {
            UnsignedInt8 propVal;
            try {
                propVal = new UnsignedInt8((String)val);
            }
            catch (NumberFormatException e) {
                return val;
            }
            return propVal;
        }
        if (dataType.equals("uint16") || dataType.equals("uint16[]")) {
            UnsignedInt16 propVal;
            try {
                propVal = new UnsignedInt16((String)val);
            }
            catch (NumberFormatException e) {
                return val;
            }
            return propVal;
        }
        if (dataType.equals("uint32") || dataType.equals("uint32[]")) {
            UnsignedInt32 propVal;
            try {
                propVal = new UnsignedInt32((String)val);
            }
            catch (NumberFormatException e) {
                return val;
            }
            return propVal;
        }
        if (dataType.equals("uint64") || dataType.equals("uint64[]")) {
            UnsignedInt64 propVal;
            try {
                propVal = new UnsignedInt64((String)val);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return val;
            }
            return propVal;
        }
        if (dataType.equals("boolean") || dataType.equals("boolean[]")) {
            Boolean propVal = new Boolean((String)val);
            return propVal;
        }
        return val;
    }

    public void setValues(List values) {
        this.values = values;
    }

    public void addValue(Object propValue) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        this.values.add(propValue);
    }

    public boolean isRandom() {
        return this.isRandom;
    }

    public void setRandom(boolean isRandom) {
        this.isRandom = isRandom;
    }

    public boolean isMultiple() {
        return this.isMultiple;
    }

    public void setMultiple(boolean isMultiple) {
        this.isMultiple = isMultiple;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public void setKey(boolean isKey) {
        this.isKey = isKey;
    }

    public boolean isRefer() {
        return this.isRefer;
    }

    public void setRefer(boolean isRefer) {
        this.isRefer = isRefer;
    }

    public int getIncremental() {
        return this.incremental;
    }

    public void setIncremental(int incremental) {
        this.incremental = incremental;
    }

    public boolean isIncremental() {
        return this.incremental > 0;
    }

    public CIMDataType getCIMDataType() {
        if (this.dataType.equalsIgnoreCase("string")) {
            return new CIMDataType(8);
        }
        if (this.dataType.equalsIgnoreCase("REF")) {
            return new CIMDataType(28);
        }
        if (this.dataType.equalsIgnoreCase("uint8")) {
            return new CIMDataType(0);
        }
        if (this.dataType.equalsIgnoreCase("uint16")) {
            return new CIMDataType(2);
        }
        if (this.dataType.equalsIgnoreCase("uint32")) {
            return new CIMDataType(4);
        }
        if (this.dataType.equalsIgnoreCase("uint64")) {
            return new CIMDataType(6);
        }
        if (this.dataType.equalsIgnoreCase("sint8")) {
            return new CIMDataType(1);
        }
        if (this.dataType.equalsIgnoreCase("sint16")) {
            return new CIMDataType(3);
        }
        if (this.dataType.equalsIgnoreCase("sint32")) {
            return new CIMDataType(5);
        }
        if (this.dataType.equalsIgnoreCase("sint64")) {
            return new CIMDataType(7);
        }
        if (this.dataType.equalsIgnoreCase("real32")) {
            return new CIMDataType(10);
        }
        if (this.dataType.equalsIgnoreCase("real64")) {
            return new CIMDataType(11);
        }
        if (this.dataType.equalsIgnoreCase("boolean")) {
            return new CIMDataType(9);
        }
        if (this.dataType.equalsIgnoreCase("datetime")) {
            return new CIMDataType(12);
        }
        if (this.dataType.equalsIgnoreCase("string[]")) {
            return new CIMDataType(22);
        }
        if (this.dataType.equalsIgnoreCase("REF[]")) {
            return new CIMDataType(42);
        }
        if (this.dataType.equalsIgnoreCase("uint8[]")) {
            return new CIMDataType(14);
        }
        if (this.dataType.equalsIgnoreCase("uint16[]")) {
            return new CIMDataType(16);
        }
        if (this.dataType.equalsIgnoreCase("uint32[]")) {
            return new CIMDataType(18);
        }
        if (this.dataType.equalsIgnoreCase("uint64[]")) {
            return new CIMDataType(20);
        }
        if (this.dataType.equalsIgnoreCase("sint8[]")) {
            return new CIMDataType(15);
        }
        if (this.dataType.equalsIgnoreCase("sint16[]")) {
            return new CIMDataType(17);
        }
        if (this.dataType.equalsIgnoreCase("sint32[]")) {
            return new CIMDataType(19);
        }
        if (this.dataType.equalsIgnoreCase("sint64[]")) {
            return new CIMDataType(21);
        }
        if (this.dataType.equalsIgnoreCase("real32[]")) {
            return new CIMDataType(24);
        }
        if (this.dataType.equalsIgnoreCase("real64[]")) {
            return new CIMDataType(25);
        }
        if (this.dataType.equalsIgnoreCase("boolean[]")) {
            return new CIMDataType(23);
        }
        if (this.dataType.equalsIgnoreCase("datetime[]")) {
            return new CIMDataType(26);
        }
        return null;
    }
}

