/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.connection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMValue;
import org.eclipse.aperi.simulator.cimom.common.DatabaseManager;
import org.eclipse.aperi.simulator.cimom.connection.ConnectionConfig;
import org.eclipse.aperi.simulator.cimom.connection.TargetDevcieConnection;

public class TargetDeviceDBClient
implements TargetDevcieConnection {
    Connection connection;
    private static String storageDevicecategory;

    public void configTargetDevcieDB() {
        String dbUrl = ConnectionConfig.getProperty("TARGET_DEVICE_DB_URL");
        String dbName = ConnectionConfig.getProperty("TARGET_DEVICE_DB_NAME");
        String dbUsername = ConnectionConfig.getProperty("TARGET_DEVICE_DB_USERNAME");
        String dbPassword = ConnectionConfig.getProperty("TARGET_DEVICE_DB_PASSWORD");
        if (dbUsername.equalsIgnoreCase("Default") || dbPassword.equalsIgnoreCase("Default")) {
            String DB_URL = "jdbc:db2:" + dbName;
            try {
                Class.forName("com.ibm.db2.jcc.DB2Driver");
                this.connection = DriverManager.getConnection(DB_URL);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            String DB_URL = "jdbc:db2://" + dbUrl + ":50000/" + dbName;
            try {
                Class.forName("com.ibm.db2.jcc.DB2Driver");
                this.connection = DriverManager.getConnection(DB_URL, dbUsername, dbPassword);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void init() {
        this.configTargetDevcieDB();
        storageDevicecategory = ConnectionConfig.getProperty("STORAGE_DEVICE_CATEGORY");
    }

    public CIMValue getDeviceID(int destPort, String storageArrayName) throws CIMException {
        CIMInstance instance = null;
        boolean flag = false;
        List fcPortClassList = new ArrayList();
        try {
            if (storageDevicecategory.equals("DS4K")) {
                fcPortClassList = DatabaseManager.getDbManager().enumerateInstances(this.connection, "/root/lsissi11", "LSISSI_FCPort");
            } else if (storageDevicecategory.equals("DS6K")) {
                fcPortClassList = DatabaseManager.getDbManager().enumerateInstances(this.connection, "/root/ibm", "IBMTSESS_FCPort");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Iterator portIterator = fcPortClassList.iterator();
        while (portIterator.hasNext()) {
            CIMValue portNo;
            instance = (CIMInstance)portIterator.next();
            CIMValue systemname = instance.getProperty("ElementName").getValue();
            if (!systemname.getValue().equals(storageArrayName) || Integer.parseInt((portNo = instance.getProperty("PortNumber").getValue()).toString()) != destPort) continue;
            flag = true;
            break;
        }
        if (flag) {
            CIMValue deviceId = instance.getProperty("DeviceID").getValue();
            return deviceId;
        }
        return null;
    }
}

