/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.cim.UnsignedInt8;
import org.wbemservices.wbem.apps.cimworkshop.CIMTypes;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.AdminDialog;
import org.wbemservices.wbem.apps.common.CancelObject;
import org.wbemservices.wbem.apps.common.ColumnLayout;
import org.wbemservices.wbem.apps.common.ContextHelpListener;
import org.wbemservices.wbem.apps.common.GenInfoPanel;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.LAYOUT_ALIGNMENT;
import org.wbemservices.wbem.apps.common.TextFieldFocusListener;

public class CIMEditDialog
extends AdminDialog
implements DocumentListener {
    private JButton okBtn;
    private JButton cancelBtn;
    private GenInfoPanel infoPanel = super.getInfoPanel();
    protected JTextField nameField;
    protected JTextField valueField;
    protected String returnString = null;
    protected String nameString = null;
    protected Object returnObject = null;
    protected String dataType;
    protected int cimType;
    protected CIMTypes cimTypes;
    protected boolean isEditable = true;
    private JPanel mainPanel;

    public CIMEditDialog(Frame parent) {
        this(parent, "", "", true);
    }

    public CIMEditDialog(Frame parent, String name, String type) {
        this(parent, name, type, true);
    }

    public CIMEditDialog(Frame parent, String name, String type, boolean editable) {
        super(parent, I18N.loadString("TTL_DLG_CIM_WORKSHOP"), false);
        this.isEditable = editable;
        this.cancelBtn = this.getCancelBtn();
        this.cancelBtn.addActionListener(new OKCancelButtonListener());
        this.okBtn = this.getOKBtn();
        if (this.isEditable) {
            this.okBtn.addActionListener(new OKCancelButtonListener());
            this.setTitle(I18N.loadStringFormat("TTL_SET_VALUE", name));
        } else {
            JPanel bPanel = this.getbuttonPanel();
            bPanel.remove(this.okBtn);
            this.cancelBtn.setText(I18N.loadString("LBL_CLOSE", "org.wbemservices.wbem.apps.common.common"));
            this.setTitle(I18N.loadStringFormat("TTL_SHOW_VALUE", name));
        }
        this.mainPanel = this.getRightPanel();
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(25, 15, 15, 15));
        this.mainPanel.setLayout(new ColumnLayout(LAYOUT_ALIGNMENT.EXPAND));
        this.dataType = type;
        this.cimTypes = new CIMTypes();
        this.cimType = this.cimTypes.getCIMType(type);
        ActionString asType = new ActionString("LBL_TYPE");
        JLabel typeLabel = new JLabel(asType.getString() + ":  " + type);
        if (name == null) {
            this.nameField = new JTextField();
            if (this.isEditable) {
                this.nameField.getDocument().addDocumentListener(this);
                this.nameField.addFocusListener(new TextFieldFocusListener());
            } else {
                this.nameField.setEnabled(false);
            }
            this.mainPanel.add(this.nameField);
        } else {
            ActionString asName = new ActionString("LBL_NAME", "org.wbemservices.wbem.apps.common.common");
            JLabel nameLabel = new JLabel(asName.getString() + ":  " + name);
            this.mainPanel.add(nameLabel);
            this.nameString = name;
        }
        this.mainPanel.add(typeLabel);
        this.setOKEnabled();
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    protected void setDefaultHelp(String helpFile) {
        GenInfoPanel infoPanel = this.getInfoPanel();
        this.setDefaultFocusListener(new ContextHelpListener(infoPanel, "cimworkshop", helpFile), true);
        if (this.okBtn != null) {
            this.okBtn.addFocusListener(new ContextHelpListener(infoPanel, "cimworkshop", helpFile));
        }
        if (this.cancelBtn != null) {
            this.cancelBtn.addFocusListener(new ContextHelpListener(infoPanel, "cimworkshop", helpFile));
        }
    }

    public GenInfoPanel getInfoPanel() {
        return this.infoPanel;
    }

    public void okClicked() {
        if (this.valueField != null) {
            this.returnString = this.valueField.getText().trim();
        }
        if (this.nameField != null) {
            this.nameString = this.nameField.getText().trim();
        }
        if (this.setReturnObject()) {
            this.dispose();
        }
    }

    public void cancelClicked() {
        this.returnString = null;
        this.returnObject = new CancelObject();
        this.nameString = null;
        this.dispose();
    }

    public Object getValueObject() {
        return this.returnObject;
    }

    public String getValueString() {
        return this.returnString;
    }

    public String getNameString() {
        return this.nameString;
    }

    public void windowOpened(WindowEvent evt) {
        if (!this.isEditable) {
            this.cancelBtn.requestFocus();
        } else if (this.nameField != null) {
            this.nameField.requestFocus();
        } else if (this.valueField != null) {
            this.valueField.requestFocus();
        } else {
            this.okBtn.requestFocus();
        }
    }

    public void changedUpdate(DocumentEvent evt) {
        this.setOKEnabled();
    }

    public void insertUpdate(DocumentEvent evt) {
        this.setOKEnabled();
    }

    public void removeUpdate(DocumentEvent evt) {
        this.setOKEnabled();
    }

    public void setOKEnabled() {
        boolean b = true;
        if (!this.isEditable) {
            return;
        }
        if (this.nameField != null) {
            b = this.nameField.getText().trim().length() != 0;
        }
        this.okBtn.setEnabled(b);
    }

    public void setOKEnabled(boolean b) {
        this.okBtn.setEnabled(b);
    }

    public boolean setReturnObject() {
        if (this.returnString == null) {
            this.returnObject = null;
            return false;
        }
        if (this.returnString.length() == 0) {
            this.returnObject = null;
            return true;
        }
        try {
            switch (this.cimType) {
                case 1: {
                    this.returnObject = new Byte(this.returnString);
                    break;
                }
                case 3: {
                    this.returnObject = new Short(this.returnString);
                    break;
                }
                case 5: {
                    this.returnObject = new Integer(this.returnString);
                    break;
                }
                case 7: {
                    this.returnObject = new Long(this.returnString);
                    break;
                }
                case 0: {
                    this.returnObject = new UnsignedInt8(this.returnString);
                    break;
                }
                case 2: {
                    this.returnObject = new UnsignedInt16(this.returnString);
                    break;
                }
                case 4: {
                    this.returnObject = new UnsignedInt32(this.returnString);
                    break;
                }
                case 6: {
                    this.returnObject = new UnsignedInt64(this.returnString);
                    break;
                }
                case 8: {
                    this.returnObject = this.returnString;
                    break;
                }
                case 9: {
                    ActionString asTrue = new ActionString("LBL_TRUE", "org.wbemservices.wbem.apps.common.common");
                    boolean b = this.returnString.equals(asTrue.getString());
                    this.returnObject = new Boolean(b);
                    break;
                }
                case 10: {
                    this.returnObject = new Float(this.returnString);
                    break;
                }
                case 11: {
                    this.returnObject = new Double(this.returnString);
                    break;
                }
                case 12: {
                    this.returnObject = new CIMDateTime(this.returnString);
                    break;
                }
                case 13: {
                    this.returnObject = new Character(this.returnString.charAt(0));
                    break;
                }
                default: {
                    this.returnObject = this.returnString;
                    break;
                }
            }
        }
        catch (NumberFormatException exc) {
            JOptionPane.showMessageDialog(this, I18N.loadStringFormat("ERR_INVALID_VALUE_TYPE", this.returnString, (Object)this.dataType), I18N.loadString("TTL_CIM_ERROR"), 0);
            return false;
        }
        catch (IllegalArgumentException exc) {
            JOptionPane.showMessageDialog(this, I18N.loadString("ERR_INVALID_DATETIME_STRING"), I18N.loadString("TTL_CIM_ERROR"), 0);
            return false;
        }
        return true;
    }

    class OKCancelButtonListener
    implements ActionListener {
        OKCancelButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == CIMEditDialog.this.cancelBtn) {
                CIMEditDialog.this.cancelClicked();
            } else if (e.getSource() == CIMEditDialog.this.okBtn) {
                CIMEditDialog.this.okClicked();
            }
        }
    }
}

