/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.client.CIMClient;
import org.wbemservices.wbem.apps.cimworkshop.CIMEventsPanel;
import org.wbemservices.wbem.apps.cimworkshop.CIMMethodsPanel;
import org.wbemservices.wbem.apps.cimworkshop.CIMPropertiesPanel;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.I18N;

public class CIMTableTabbedPane
extends JTabbedPane {
    protected CIMPropertiesPanel propertiesPanel;
    protected CIMMethodsPanel methodsPanel;
    protected CIMEventsPanel eventsPanel;
    protected Vector cimProperties = null;
    protected Vector cimMethods = null;
    protected ActionString asProps = new ActionString("LBL_PROPERTIES");
    protected ActionString asMethods = new ActionString("LBL_METHODS");
    protected ActionString asEvents = new ActionString("LBL_EVENTS");

    public CIMTableTabbedPane() {
        this(false);
    }

    public CIMTableTabbedPane(boolean nElement) {
        this.addPropertiesTab(nElement);
        this.addMethodsTab(nElement);
        this.setSelectedIndex(0);
    }

    public void removePropertiesTab() {
        this.removeTab(this.asProps.getString());
    }

    public void removeMethodsTab() {
        this.removeTab(this.asMethods.getString());
    }

    public void removeEventsTab() {
        this.removeTab(this.asEvents.getString());
    }

    protected void removeTab(String title) {
        int index = this.indexOfTab(title);
        if (index >= 0) {
            this.removeTabAt(index);
        }
    }

    public void addPropertiesTab(boolean nElement) {
        if (this.propertiesPanel == null) {
            this.propertiesPanel = new CIMPropertiesPanel(nElement);
        }
        this.addTab(this.asProps.getString(), this.propertiesPanel);
    }

    public void addMethodsTab(boolean nElement) {
        if (this.methodsPanel == null) {
            this.methodsPanel = new CIMMethodsPanel(nElement);
        }
        this.addTab(this.asMethods.getString(), this.methodsPanel);
    }

    public void addEventsTab() {
        if (this.eventsPanel == null) {
            this.eventsPanel = new CIMEventsPanel();
        }
        this.addTab(this.asEvents.getString(), this.eventsPanel);
    }

    protected void addTab(String title, JPanel panel) {
        if (this.indexOfTab(title) < 0) {
            this.addTab(title, panel);
        }
    }

    public void initializeEvents(CIMObjectPath iHandler, CIMClient cClient) {
        if (this.eventsPanel != null) {
            this.eventsPanel.initializeEvents(iHandler, cClient);
        }
    }

    public void deleteEventSubscriptions() {
        if (this.eventsPanel != null) {
            this.eventsPanel.deleteEventSubscriptions();
        }
    }

    public void populateTables(CIMClient cc, CIMElement pElement) {
        this.propertiesPanel.populateTable(cc, pElement);
        this.methodsPanel.populateList(cc, pElement);
        if (this.eventsPanel != null) {
            this.eventsPanel.setEventsSelection((CIMClass)pElement);
        }
    }

    public void addPropertyTableModelListener(TableModelListener tml) {
        this.propertiesPanel.addTableModelListener(tml);
    }

    public void addListSelectionListener(ListSelectionListener lsl) {
        this.propertiesPanel.addListSelectionListener(lsl);
    }

    public CIMPropertiesPanel getPropertiesTable() {
        return this.propertiesPanel;
    }

    public CIMMethodsPanel getMethodsTable() {
        return this.methodsPanel;
    }

    public CIMEventsPanel getEventPanel() {
        return this.eventsPanel;
    }

    public Vector getProperties() {
        return this.propertiesPanel.getProperties();
    }

    public void setUneditableProperties(Vector v) {
        this.propertiesPanel.setUneditableRows(v);
    }

    public boolean isPropertySelected() {
        return this.propertiesPanel != null && !this.propertiesPanel.isSelectionEmpty();
    }

    public boolean isMethodSelected() {
        return this.methodsPanel != null && !this.methodsPanel.isSelectionEmpty();
    }

    public void invokeMethod() {
        if (this.isMethodSelected()) {
            this.methodsPanel.invokeMethod();
        } else {
            JOptionPane.showMessageDialog(this, I18N.loadString("ERR_NO_METHOD_SELECTED"), I18N.loadString("TTL_CIM_ERROR"), 0);
        }
    }

    public void showQualifiers() {
        if (this.getSelectedIndex() == this.indexOfTab(this.asMethods.getString())) {
            this.showMethodQualifiers();
        } else if (this.getSelectedIndex() == this.indexOfTab(this.asProps.getString())) {
            this.showPropertyQualifiers();
        }
    }

    public void showMethodQualifiers() {
        if (this.isMethodSelected()) {
            this.methodsPanel.showQualifiers();
        } else {
            JOptionPane.showMessageDialog(this, I18N.loadString("ERR_NO_METHOD_SELECTED"), I18N.loadString("TTL_CIM_ERROR"), 0);
        }
    }

    public void showPropertyQualifiers() {
        if (this.isPropertySelected()) {
            this.propertiesPanel.showQualifiers();
        } else {
            JOptionPane.showMessageDialog(this, I18N.loadString("ERR_NO_PROPERTY_SELECTED"), I18N.loadString("TTL_CIM_ERROR"), 0);
        }
    }

    public void showPropertyValue() {
        if (this.isPropertySelected()) {
            this.propertiesPanel.showValue();
        } else {
            JOptionPane.showMessageDialog(this, I18N.loadString("ERR_NO_PROPERTY_SELECTED"), I18N.loadString("TTL_CIM_ERROR"), 0);
        }
    }
}

