/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.wbemservices.wbem.apps.cimworkshop.ClassTreePane;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.AdminDialog;
import org.wbemservices.wbem.apps.common.ColumnLayout;
import org.wbemservices.wbem.apps.common.ContextHelpListener;
import org.wbemservices.wbem.apps.common.GenInfoPanel;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.LAYOUT_ALIGNMENT;
import org.wbemservices.wbem.apps.common.Util;

public class ClassSelectionDialog
extends AdminDialog
implements TreeSelectionListener {
    private JButton okBtn;
    private JButton cancelBtn;
    private JButton findBtn;
    protected String className = "";
    private JPanel mainPanel;
    private ClassTreePane treePane = new ClassTreePane();

    public ClassSelectionDialog(Frame parent) {
        super(parent, I18N.loadString("TTL_CLASS_SELECTION"), false);
        this.treePane.addTreeSelectionListener(this);
        this.okBtn = this.getOKBtn();
        this.okBtn.addActionListener(new OKCancelButtonListener());
        this.cancelBtn = this.getCancelBtn();
        this.cancelBtn.addActionListener(new OKCancelButtonListener());
        ActionString asFind = new ActionString("TIP_FIND_CLASS");
        this.findBtn = new JButton(asFind.getString());
        this.findBtn.setMnemonic(asFind.getMnemonic());
        this.findBtn.setActionCommand("FIND_CLASS");
        this.findBtn.addActionListener(this.treePane);
        JPanel btnPanel = this.getbuttonPanel();
        btnPanel.add(this.findBtn);
        this.mainPanel = this.getRightPanel();
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(25, 15, 15, 15));
        this.mainPanel.setLayout(new ColumnLayout(LAYOUT_ALIGNMENT.EXPAND));
        this.mainPanel.add(this.treePane);
        GenInfoPanel infoPanel = this.getInfoPanel();
        this.setDefaultFocusListener(new ContextHelpListener(infoPanel, "cimworkshop", "ClassSelection_000.htm"), true);
        this.okBtn.setEnabled(!this.treePane.isRootSelected());
        this.treePane.refreshTree();
        this.pack();
        this.setLocation(Util.getCenterPoint(parent, this));
        this.setVisible(true);
    }

    public void okClicked() {
        this.className = this.treePane.getSelectedNodeString();
        if (this.className == null) {
            JOptionPane.showMessageDialog(this, I18N.loadString("ERR_NO_CLASS_SELECTED"), I18N.loadString("TTL_CIM_ERROR"), 0);
            return;
        }
        this.dispose();
    }

    public void cancelClicked() {
        this.className = "";
        this.dispose();
    }

    public void valueChanged(TreeSelectionEvent e) {
        this.okBtn.setEnabled(!this.treePane.isRootSelected());
    }

    public String getClassName() {
        return this.className;
    }

    class OKCancelButtonListener
    implements ActionListener {
        OKCancelButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ClassSelectionDialog.this.cancelBtn) {
                ClassSelectionDialog.this.cancelClicked();
            } else if (e.getSource() == ClassSelectionDialog.this.okBtn) {
                ClassSelectionDialog.this.okClicked();
            }
        }
    }
}

