/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMObjectPath;
import org.wbemservices.wbem.apps.cimworkshop.AddClassDialog;
import org.wbemservices.wbem.apps.cimworkshop.AddQualifierTypeDialog;
import org.wbemservices.wbem.apps.cimworkshop.CIMTableTabbedPane;
import org.wbemservices.wbem.apps.cimworkshop.CWSLoginDialog;
import org.wbemservices.wbem.apps.cimworkshop.ClassTreePane;
import org.wbemservices.wbem.apps.cimworkshop.InstanceFrame;
import org.wbemservices.wbem.apps.cimworkshop.ObjectTreeFrame;
import org.wbemservices.wbem.apps.cimworkshop.QualifierWindow;
import org.wbemservices.wbem.apps.cimworkshop.QueryFrame;
import org.wbemservices.wbem.apps.cimworkshop.QueryInputDialog;
import org.wbemservices.wbem.apps.cimworkshop.ReferenceTraversalDialog;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.CIMClientObject;
import org.wbemservices.wbem.apps.common.CIMErrorDialog;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.Util;
import org.wbemservices.wbem.apps.common.WaitDialog;

public class ClassTreeActionPane
extends ClassTreePane {
    private CIMTableTabbedPane tablePane;
    private ObjectTreeFrame parentFrame;
    private CWSLoginDialog loginDialog;
    private Vector instanceFrameList = new Vector();
    private JMenuItem instanceMenuItem;
    private JMenuItem addClassMenuItem;
    private JMenuItem rootAddClassMenuItem;
    private JMenuItem addQualifierType;

    public ClassTreeActionPane(ObjectTreeFrame parent, CIMTableTabbedPane tp) {
        this.parentFrame = parent;
        this.tablePane = tp;
        ActionString asAdd = new ActionString("MNU_ADD_CLASS");
        ActionString asInstances = new ActionString("MNU_INSTANCES");
        ActionString asQualifiers = new ActionString("MNU_QUALIFIERS");
        ActionString asRefresh = new ActionString("MNU_REFRESH_CLASS");
        ActionString asQualifierType = new ActionString("MNU_ADD_QUALIFIER_TYPE");
        this.addClassMenuItem = this.popupMenu.add(new JMenuItem(asAdd.getString()));
        this.addClassMenuItem.setActionCommand("ADD_CLASS");
        this.addClassMenuItem.addActionListener(this);
        this.instanceMenuItem = this.popupMenu.add(new JMenuItem(asInstances.getString()));
        this.instanceMenuItem.setActionCommand("INSTANCES");
        this.instanceMenuItem.addActionListener(this);
        JMenuItem popupMenuItem = this.popupMenu.add(new JMenuItem(asQualifiers.getString()));
        popupMenuItem.setActionCommand("QUALIFIERS");
        popupMenuItem.addActionListener(this);
        this.popupMenu.addSeparator();
        popupMenuItem = this.popupMenu.add(new JMenuItem(asRefresh.getString()));
        popupMenuItem.setActionCommand("REFRESH");
        popupMenuItem.addActionListener(this);
        this.rootAddClassMenuItem = this.rootPopupMenu.add(new JMenuItem(asAdd.getString()));
        this.rootAddClassMenuItem.setActionCommand("ADD_CLASS");
        this.rootAddClassMenuItem.addActionListener(this);
        this.addQualifierType = this.rootPopupMenu.add(new JMenuItem(asQualifierType.getString()));
        this.addQualifierType.setActionCommand("ADD_QUALIFIER_TYPE");
        this.addQualifierType.addActionListener(this);
        this.rootPopupMenu.addSeparator();
        popupMenuItem = this.rootPopupMenu.add(new JMenuItem(asRefresh.getString()));
        popupMenuItem.setActionCommand("REFRESH");
        popupMenuItem.addActionListener(this);
    }

    public void enableInstanceMenuItem(boolean b) {
        this.instanceMenuItem.setEnabled(b);
    }

    public void actionPerformed(ActionEvent e) {
        block30: {
            Util.setWaitCursor(this);
            String action = e.getActionCommand();
            if (action.equals("hostDialog")) {
                this.getHostInfo();
            } else if (this.getSelectedNodeString() == null) {
                JOptionPane.showMessageDialog(this, I18N.loadString("ERR_NO_CLASS_SELECTED"), I18N.loadString("TTL_CIM_ERROR"), 0);
            } else if (action.equals("INSTANCES")) {
                String classNameString = this.getSelectedNodeString();
                CIMObjectPath op = new CIMObjectPath(classNameString);
                try {
                    CIMClass cimClass = this.cimClient.getClass(op, false, true, true, null);
                    if (!cimClass.isKeyed()) {
                        JOptionPane.showMessageDialog(this, I18N.loadStringFormat("MSG_NOT_KEYED_CLASS", classNameString), I18N.loadString("TTL_DLG_CIM_WORKSHOP"), 1);
                        break block30;
                    }
                    InstanceFrame instanceFrame = new InstanceFrame(this.parentFrame, this.cimClient, cimClass, true);
                    this.instanceFrameList.addElement(instanceFrame);
                }
                catch (CIMException exc) {
                    CIMErrorDialog.display(this, exc);
                }
            } else if (action.equals("QUALIFIERS")) {
                String classNameString = this.getSelectedNodeString();
                CIMObjectPath op = new CIMObjectPath(classNameString);
                try {
                    CIMClass cimClass = this.cimClient.getClass(op, false, true, true, null);
                    if (cimClass.getQualifiers().size() > 0) {
                        QualifierWindow qualifierWindow = new QualifierWindow((Frame)this.parentFrame, this.cimClient, (CIMElement)cimClass, false);
                        break block30;
                    }
                    JOptionPane.showMessageDialog(this, I18N.loadStringFormat("ERR_NO_QUALIFIERS", classNameString), I18N.loadString("TTL_CIM_ERROR"), 0);
                }
                catch (CIMException exc) {
                    CIMErrorDialog.display(this, exc);
                }
            } else if (action.equals("ASSOC_TRAVERSAL")) {
                String classNameString = this.getSelectedNodeString();
                CIMObjectPath op = new CIMObjectPath(classNameString);
                ReferenceTraversalDialog refDialog = new ReferenceTraversalDialog((Frame)this.parentFrame, op, this.cimClient);
            } else if (action.equals("ADD_CLASS")) {
                AddClassDialog dlg;
                String className;
                Util.setWaitCursor(this);
                String currentClass = this.getSelectedNodeString();
                if (this.isRootSelected()) {
                    currentClass = "";
                }
                if ((className = (dlg = new AddClassDialog((Frame)this.parentFrame, currentClass)).getClassName()) != null) {
                    ClassTreePane.ClassTreeNode newNode = new ClassTreePane.ClassTreeNode(this, new CIMObjectPath(className));
                    this.addNodeToSelected(newNode);
                    TreePath path = new TreePath(newNode.getPath());
                    this.tree.expandPath(path);
                    this.tree.setSelectionPath(path);
                }
            } else if (action.equals("DELETE_CLASS")) {
                String classNameString = this.getSelectedNodeString();
                int option = JOptionPane.showConfirmDialog(this, I18N.loadStringFormat("ASK_DELETE_CLASS", classNameString), I18N.loadString("TTL_DLG_CIM_WORKSHOP"), 2, 3);
                if (option == 0) {
                    try {
                        this.cimClient.deleteClass(new CIMObjectPath(classNameString));
                        this.deleteSelectedNode();
                    }
                    catch (CIMException exc) {
                        CIMErrorDialog.display(this, exc);
                    }
                }
            } else if (action.equals("ADD_QUALIFIER_TYPE")) {
                AddQualifierTypeDialog aqtDialog = new AddQualifierTypeDialog(this.parentFrame);
            } else if (action.equals("EXEC_QUERY")) {
                QueryInputDialog queryInputDialog = new QueryInputDialog(this.parentFrame);
                String queryString = queryInputDialog.getQueryString();
                if (queryString != null) {
                    QueryFrame queryFrame = new QueryFrame(this.parentFrame, this.cimClient, queryString);
                    this.instanceFrameList.add(queryFrame);
                }
            } else {
                super.actionPerformed(e);
            }
        }
        Util.setDefaultCursor(this);
    }

    public boolean getHostInfo() {
        this.loginDialog = new CWSLoginDialog(this.parentFrame);
        boolean loggedOn = this.loginDialog.getLoggedIn();
        if (loggedOn) {
            boolean userCanWrite = CIMClientObject.userHasWritePermission();
            this.addClassMenuItem.setEnabled(userCanWrite);
            this.rootAddClassMenuItem.setEnabled(userCanWrite);
            this.addQualifierType.setEnabled(userCanWrite);
            this.parentFrame.initializeNewHost();
        }
        return loggedOn;
    }

    public void initializeClassTree() {
        WaitDialog waitDialog = new WaitDialog((Frame)this.parentFrame, I18N.loadString("LBL_WAIT", "org.wbemservices.wbem.apps.common.common"), I18N.loadString("MSG_ENUM_CLASSES"));
        waitDialog.setLocation(Util.getCenterPoint(this.parentFrame, waitDialog));
        waitDialog.start();
        this.refreshTree();
        waitDialog.stop();
        this.closeOpenInstanceFrames();
    }

    public void closeOpenInstanceFrames() {
        Enumeration e = this.instanceFrameList.elements();
        while (e.hasMoreElements()) {
            JFrame frame = (JFrame)e.nextElement();
            frame.dispose();
        }
        this.instanceFrameList.removeAllElements();
    }

    protected void populateTables(CIMClass cimClass) {
        this.tablePane.populateTables(this.cimClient, (CIMElement)cimClass);
    }
}

