/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.CardLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.GregorianCalendar;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.wbemservices.wbem.apps.cimworkshop.CIMEditDialog;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.ColumnLayout;
import org.wbemservices.wbem.apps.common.ContextHelpListener;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.JIntSpinBox;
import org.wbemservices.wbem.apps.common.LAYOUT_ALIGNMENT;
import org.wbemservices.wbem.apps.common.RowLayout;
import org.wbemservices.wbem.apps.common.Util;

class DateTimeDialog
extends CIMEditDialog
implements DocumentListener {
    JIntSpinBox sbYear;
    JIntSpinBox sbMonth;
    JIntSpinBox sbDay;
    JIntSpinBox sbDays;
    JIntSpinBox sbHour;
    JIntSpinBox sbMin;
    JIntSpinBox sbSec;
    JIntSpinBox sbMicroSec;
    JIntSpinBox sbUTC;
    JComboBox cbUTC;
    JRadioButton rbDate;
    JRadioButton rbInterval;
    JRadioButton rbNoValue;
    JRadioButton rbTmp;
    JPanel pDate;
    JPanel pDays;
    JPanel pDateDays;
    private CardLayout card = new CardLayout();

    public DateTimeDialog(Frame parent, String name, String type, String value) {
        this(parent, name, type, value, true);
    }

    public DateTimeDialog(Frame parent, String name, String type, String value, boolean enabled) {
        super(parent, name, type, enabled);
        String tmpValue = value;
        if (tmpValue == null) {
            tmpValue = "";
        }
        JPanel frontPane = this.getFrontPane(tmpValue, enabled);
        String defaultHelp = "ShowValue_000.htm";
        if (this.isEditable) {
            defaultHelp = "DateTime_000.htm";
        }
        this.setDefaultHelp(defaultHelp);
        this.setSpinBoxHelp(this.sbYear, "DateTime_010.htm");
        this.setSpinBoxHelp(this.sbMonth, "DateTime_020.htm");
        this.setSpinBoxHelp(this.sbDay, "DateTime_030.htm");
        this.setSpinBoxHelp(this.sbHour, "DateTime_040.htm");
        this.setSpinBoxHelp(this.sbMin, "DateTime_050.htm");
        this.setSpinBoxHelp(this.sbSec, "DateTime_060.htm");
        this.setSpinBoxHelp(this.sbMicroSec, "DateTime_070.htm");
        this.setSpinBoxHelp(this.sbUTC, "DateTime_080.htm");
        this.setSpinBoxHelp(this.sbDays, "DateTime_090.htm");
        JPanel mainPanel = this.getMainPanel();
        mainPanel.add(frontPane);
        this.setOKEnabled();
        this.pack();
        this.setLocation(Util.getCenterPoint(parent, this));
        this.setVisible(true);
    }

    protected JPanel getFrontPane(String value, boolean enabled) {
        JPanel pane = new JPanel();
        ActionString asDate = new ActionString("LBL_DATE");
        ActionString asInterval = new ActionString("LBL_INTERVAL");
        ActionString asNoValue = new ActionString("LBL_NO_VALUE", "org.wbemservices.wbem.apps.common.common");
        ActionString asYear = new ActionString("LBL_YEAR");
        ActionString asMonth = new ActionString("LBL_MONTH");
        ActionString asDay = new ActionString("LBL_DAY");
        ActionString asDays = new ActionString("LBL_DAYS");
        ActionString asHour = new ActionString("LBL_HOUR");
        ActionString asMin = new ActionString("LBL_MINUTES");
        ActionString asSec = new ActionString("LBL_SECONDS");
        ActionString asMicroSec = new ActionString("LBL_MICRO_SECONDS");
        ActionString asUTC = new ActionString("LBL_UTC");
        ButtonGroup group = new ButtonGroup();
        this.rbDate = new JRadioButton(asDate.getString());
        this.rbDate.setMnemonic(asDate.getMnemonic());
        this.rbDate.addActionListener(new RadioButtonListener());
        this.rbInterval = new JRadioButton(asInterval.getString());
        this.rbInterval.setMnemonic(asInterval.getMnemonic());
        this.rbInterval.addActionListener(new RadioButtonListener());
        this.rbNoValue = new JRadioButton(asNoValue.getString());
        this.rbNoValue.setMnemonic(asNoValue.getMnemonic());
        this.rbNoValue.addActionListener(new RadioButtonListener());
        group.add(this.rbNoValue);
        group.add(this.rbDate);
        group.add(this.rbInterval);
        JPanel rbPanel = new JPanel(new ColumnLayout());
        rbPanel.add(this.rbNoValue);
        rbPanel.add(this.rbDate);
        rbPanel.add(this.rbInterval);
        pane.add(rbPanel);
        pane.setLayout(new ColumnLayout(LAYOUT_ALIGNMENT.LEFT));
        this.sbYear = new JIntSpinBox(4, 0, 9999);
        this.sbYear.setIntValue(2001);
        this.sbYear.addDocumentListener(this);
        JLabel lbYear = new JLabel(asYear.getString(), 4);
        lbYear.setDisplayedMnemonic(asYear.getMnemonic());
        lbYear.setLabelFor(this.sbYear.getTextField());
        JPanel pYear = new JPanel(new ColumnLayout(LAYOUT_ALIGNMENT.LEFT, 0, 0));
        pYear.add(lbYear);
        pYear.add(this.sbYear);
        this.sbMonth = new JIntSpinBox(2, 1, 12);
        this.sbMonth.setIntValue(1);
        this.sbMonth.addDocumentListener(this);
        JLabel lbMonth = new JLabel(asMonth.getString(), 4);
        lbMonth.setDisplayedMnemonic(asMonth.getMnemonic());
        lbMonth.setLabelFor(this.sbMonth.getTextField());
        JPanel pMonth = new JPanel(new ColumnLayout(LAYOUT_ALIGNMENT.LEFT, 0, 0));
        pMonth.add(lbMonth);
        pMonth.add(this.sbMonth);
        this.sbDay = new JIntSpinBox(2, 1, 31);
        this.sbDay.setIntValue(1);
        this.sbDay.addDocumentListener(this);
        JLabel lbDay = new JLabel(asDay.getString(), 4);
        lbDay.setDisplayedMnemonic(asDay.getMnemonic());
        lbDay.setLabelFor(this.sbDay.getTextField());
        JPanel pDay = new JPanel(new ColumnLayout(LAYOUT_ALIGNMENT.LEFT, 0, 0));
        pDay.add(lbDay);
        pDay.add(this.sbDay);
        this.pDate = new JPanel(new RowLayout(LAYOUT_ALIGNMENT.LEFT));
        this.pDate.add(pYear);
        this.pDate.add(Box.createVerticalStrut(20));
        this.pDate.add(pMonth);
        this.pDate.add(Box.createVerticalStrut(20));
        this.pDate.add(pDay);
        this.pDateDays = new JPanel();
        this.pDateDays.setLayout(this.card);
        this.sbDays = new JIntSpinBox(8, 0, 99999999);
        this.sbDays.setIntValue(0);
        this.sbDays.addDocumentListener(this);
        JLabel lbDays = new JLabel(asDays.getString(), 4);
        lbDays.setDisplayedMnemonic(asDays.getMnemonic());
        lbDays.setLabelFor(this.sbDays.getTextField());
        this.pDays = new JPanel(new ColumnLayout(LAYOUT_ALIGNMENT.LEFT));
        this.pDays.add(lbDays);
        this.pDays.add(this.sbDays);
        this.pDateDays.add("date", this.pDate);
        this.pDateDays.add("days", this.pDays);
        this.sbHour = new JIntSpinBox(2, 0, 24);
        this.sbHour.setIntValue(0);
        this.sbHour.addDocumentListener(this);
        JLabel lbHour = new JLabel(asHour.getString(), 4);
        lbHour.setDisplayedMnemonic(asHour.getMnemonic());
        lbHour.setLabelFor(this.sbHour.getTextField());
        JPanel pHour = new JPanel(new ColumnLayout(LAYOUT_ALIGNMENT.LEFT, 0, 0));
        pHour.add(lbHour);
        pHour.add(this.sbHour);
        this.sbMin = new JIntSpinBox(2, 0, 60);
        this.sbMin.setIntValue(0);
        this.sbMin.addDocumentListener(this);
        JLabel lbMin = new JLabel(asMin.getString(), 4);
        lbMin.setDisplayedMnemonic(asMin.getMnemonic());
        lbMin.setLabelFor(this.sbMin.getTextField());
        JPanel pMin = new JPanel(new ColumnLayout(LAYOUT_ALIGNMENT.LEFT, 0, 0));
        pMin.add(lbMin);
        pMin.add(this.sbMin);
        this.sbSec = new JIntSpinBox(2, 0, 60);
        this.sbSec.setIntValue(0);
        this.sbSec.addDocumentListener(this);
        JLabel lbSec = new JLabel(asSec.getString(), 4);
        lbSec.setDisplayedMnemonic(asSec.getMnemonic());
        lbSec.setLabelFor(this.sbSec.getTextField());
        JPanel pSec = new JPanel(new ColumnLayout(LAYOUT_ALIGNMENT.LEFT, 0, 0));
        pSec.add(lbSec);
        pSec.add(this.sbSec);
        JPanel pTime = new JPanel(new RowLayout(LAYOUT_ALIGNMENT.LEFT));
        pTime.add(pHour);
        pTime.add(Box.createVerticalStrut(20));
        pTime.add(pMin);
        pTime.add(Box.createVerticalStrut(20));
        pTime.add(pSec);
        this.sbMicroSec = new JIntSpinBox(6, 0, 999999);
        this.sbMicroSec.setIntValue(0);
        this.sbMicroSec.addDocumentListener(this);
        JLabel lbMicroSec = new JLabel(asMicroSec.getString(), 4);
        lbMicroSec.setDisplayedMnemonic(asMicroSec.getMnemonic());
        lbMicroSec.setLabelFor(this.sbMicroSec.getTextField());
        JPanel pMicroSec = new JPanel(new ColumnLayout(LAYOUT_ALIGNMENT.LEFT, 0, 0));
        pMicroSec.add(lbMicroSec);
        pMicroSec.add(this.sbMicroSec);
        this.sbUTC = new JIntSpinBox(3, 0, 720);
        this.sbUTC.setIntValue(0);
        this.sbUTC.addDocumentListener(this);
        JLabel lbUTC = new JLabel(asUTC.getString(), 4);
        lbUTC.setDisplayedMnemonic(asUTC.getMnemonic());
        lbUTC.setLabelFor(this.sbUTC.getTextField());
        JPanel pUTC = new JPanel(new ColumnLayout(LAYOUT_ALIGNMENT.LEFT, 0, 0));
        pUTC.add(lbUTC);
        JPanel pUTC1 = new JPanel(new ColumnLayout(LAYOUT_ALIGNMENT.LEFT, 0, 0));
        pUTC1.setLayout(new RowLayout());
        this.cbUTC = new JComboBox<String>(new String[]{"+", "-"});
        pUTC1.add(this.cbUTC);
        pUTC1.add(this.sbUTC);
        pUTC.add(pUTC1);
        pane.add(this.pDateDays);
        pane.add(pTime);
        pane.add(pMicroSec);
        pane.add(pUTC);
        if (value.length() == 25) {
            try {
                if (value.substring(21, 22).equals(":")) {
                    this.sbDay.setIntValue(Integer.parseInt(value.substring(0, 8)));
                    this.rbInterval.doClick();
                } else {
                    this.sbYear.setIntValue(Integer.parseInt(value.substring(0, 4)));
                    this.sbMonth.setIntValue(Integer.parseInt(value.substring(4, 6)));
                    this.sbDay.setIntValue(Integer.parseInt(value.substring(6, 8)));
                    this.rbDate.doClick();
                    this.cbUTC.setSelectedItem(value.substring(21, 22));
                }
                this.sbHour.setIntValue(Integer.parseInt(value.substring(8, 10)));
                this.sbMin.setIntValue(Integer.parseInt(value.substring(10, 12)));
                this.sbSec.setIntValue(Integer.parseInt(value.substring(12, 14)));
                this.sbMicroSec.setIntValue(Integer.parseInt(value.substring(15, 21)));
                this.sbUTC.setIntValue(Integer.parseInt(value.substring(22, 25)));
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, I18N.loadStringFormat("ERR_INVALID_DATETIME_STRING", this.sbDay.getStringValue(), (Object)this.sbMonth.getStringValue()), I18N.loadString("TTL_CIM_ERROR"), 0);
                return pane;
            }
        } else if (value.trim().length() == 0) {
            GregorianCalendar cal = new GregorianCalendar();
            this.sbYear.setIntValue(cal.get(1));
            this.sbMonth.setIntValue(cal.get(2) + 1);
            this.sbDay.setIntValue(cal.get(5));
            this.sbHour.setIntValue(cal.get(11));
            this.sbMin.setIntValue(cal.get(12));
            this.sbSec.setIntValue(cal.get(13));
            this.sbMicroSec.setIntValue(cal.get(14));
            int offset = cal.get(15);
            if (offset != 0) {
                if (offset > 0) {
                    this.cbUTC.setSelectedItem("+");
                } else {
                    this.cbUTC.setSelectedItem("-");
                }
                offset = Math.abs(offset / 60000);
            }
            this.sbUTC.setIntValue(offset);
            this.rbNoValue.doClick();
        } else {
            this.rbDate.doClick();
        }
        if (!enabled) {
            this.rbDate.setEnabled(false);
            this.rbInterval.setEnabled(false);
            this.rbNoValue.setEnabled(false);
            this.enableEditFields(false);
        }
        return pane;
    }

    private void setSpinBoxHelp(JIntSpinBox sb, String helpFile) {
        sb.getTextField().addFocusListener(new ContextHelpListener(this.getInfoPanel(), "cimworkshop", helpFile));
        sb.getUpButton().addFocusListener(new ContextHelpListener(this.getInfoPanel(), "cimworkshop", helpFile));
        sb.getDownButton().addFocusListener(new ContextHelpListener(this.getInfoPanel(), "cimworkshop", helpFile));
    }

    public void okClicked() {
        StringBuffer buf = new StringBuffer("");
        if (!this.validDate()) {
            return;
        }
        if (!this.rbNoValue.isSelected()) {
            if (this.rbDate.isSelected()) {
                buf.append(this.padNumber(this.sbYear.getStringValue(), 4));
                buf.append(this.padNumber(this.sbMonth.getStringValue(), 2));
                buf.append(this.padNumber(this.sbDay.getStringValue(), 2));
            } else {
                buf.append(this.padNumber(this.sbDays.getStringValue(), 8));
            }
            buf.append(this.padNumber(this.sbHour.getStringValue(), 2));
            buf.append(this.padNumber(this.sbMin.getStringValue(), 2));
            buf.append(this.padNumber(this.sbSec.getStringValue(), 2));
            buf.append(".");
            buf.append(this.padNumber(this.sbMicroSec.getStringValue(), 6));
            if (this.rbDate.isSelected()) {
                buf.append((String)this.cbUTC.getSelectedItem());
                buf.append(this.padNumber(this.sbUTC.getStringValue(), 3));
            } else {
                buf.append(":000");
            }
        }
        this.returnString = buf.toString();
        if (this.setReturnObject()) {
            this.dispose();
        }
    }

    private boolean validDate() {
        boolean retVal = true;
        if (this.rbDate.isSelected()) {
            try {
                int day = this.sbDay.getIntValue();
                int month = this.sbMonth.getIntValue();
                if (month == 2 && day > 28 || (month == 4 || month == 6 || month == 9 || month == 11) & day > 30 || day > 31) {
                    JOptionPane.showMessageDialog(this, I18N.loadStringFormat("ERR_INVALID_DAYMONTH", this.sbDay.getStringValue(), (Object)this.sbMonth.getStringValue()), I18N.loadString("TTL_CIM_ERROR"), 0);
                    retVal = false;
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, I18N.loadStringFormat("ERR_INVALID_DATETIME_STRING", this.sbDay.getStringValue(), (Object)this.sbMonth.getStringValue()), I18N.loadString("TTL_CIM_ERROR"), 0);
                retVal = false;
            }
        }
        return retVal;
    }

    private String padNumber(String number, int numSize) {
        StringBuffer buf = new StringBuffer(number);
        for (int i = number.length(); i < numSize; ++i) {
            buf.insert(0, 0);
        }
        return buf.toString();
    }

    public void setOKEnabled() {
        if (this.rbDate == null || !this.isEditable) {
            return;
        }
        boolean b = true;
        if (!this.rbNoValue.isSelected()) {
            if (this.rbDate.isSelected()) {
                b &= this.sbYear.getStringValue().trim().length() != 0;
                b &= this.sbMonth.getStringValue().trim().length() != 0;
                b &= this.sbDay.getStringValue().trim().length() != 0;
                b &= this.sbUTC.getStringValue().trim().length() != 0;
            } else {
                b &= this.sbDays.getStringValue().trim().length() != 0;
            }
            b &= this.sbHour.getStringValue().trim().length() != 0;
            b &= this.sbMin.getStringValue().trim().length() != 0;
            b &= this.sbSec.getStringValue().trim().length() != 0;
            b &= this.sbMicroSec.getStringValue().trim().length() != 0;
        }
        this.setOKEnabled(b);
    }

    public void changedUpdate(DocumentEvent evt) {
        this.setOKEnabled();
    }

    public void insertUpdate(DocumentEvent evt) {
        this.setOKEnabled();
    }

    public void removeUpdate(DocumentEvent evt) {
        this.setOKEnabled();
    }

    private void enableEditFields(boolean b) {
        this.sbYear.setEnabled(b);
        this.sbMonth.setEnabled(b);
        this.sbDay.setEnabled(b);
        this.sbDays.setEnabled(b);
        this.sbHour.setEnabled(b);
        this.sbMin.setEnabled(b);
        this.sbSec.setEnabled(b);
        this.sbMicroSec.setEnabled(b);
        this.sbUTC.setEnabled(b);
        this.cbUTC.setEnabled(b);
    }

    class RadioButtonListener
    implements ActionListener {
        RadioButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == DateTimeDialog.this.rbNoValue) {
                DateTimeDialog.this.enableEditFields(false);
            } else {
                DateTimeDialog.this.enableEditFields(true);
                if (e.getSource() == DateTimeDialog.this.rbInterval) {
                    DateTimeDialog.this.sbUTC.setEnabled(false);
                    DateTimeDialog.this.cbUTC.setEnabled(false);
                    DateTimeDialog.this.card.show(DateTimeDialog.this.pDateDays, "days");
                } else {
                    DateTimeDialog.this.card.show(DateTimeDialog.this.pDateDays, "date");
                }
            }
            DateTimeDialog.this.setOKEnabled();
        }
    }
}

