/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.client.CIMClient;
import javax.wbem.client.CIMEvent;
import javax.wbem.client.CIMListener;
import org.wbemservices.wbem.apps.cimworkshop.CIMTableTabbedPane;
import org.wbemservices.wbem.apps.cimworkshop.ClassTreeActionPane;
import org.wbemservices.wbem.apps.common.AboutDialog;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.CIMClientObject;
import org.wbemservices.wbem.apps.common.CIMErrorDialog;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.NameSpaceDialog;
import org.wbemservices.wbem.apps.common.ToolBarPanel;
import org.wbemservices.wbem.apps.common.Util;

public class ObjectTreeFrame
extends JFrame
implements WindowListener,
ItemListener,
ActionListener,
TreeSelectionListener {
    private ClassTreeActionPane treePane;
    private CIMTableTabbedPane tablePane;
    private JSplitPane desktop;
    private JSplitPane fullPanel;
    private JComboBox nameSpaceList;
    private String prevNameSpace = "";
    private NameSpaceDialog nsDlg;
    private DefaultComboBoxModel cbModel = null;
    private boolean repopulating = false;
    private JTextArea eventOutputArea;
    private JMenu mnuWorkshop;
    private JMenu mnuAction;
    private JMenu mnuNamespace;
    private JMenu mnuProperties;
    private JMenu mnuMethods;
    private JMenu mnuHelp;
    private JMenuItem mnuChangeHost;
    private JMenuItem mnuChangeNamespace;
    private JMenuItem mnuExit;
    private JMenuItem mnuAddClass;
    private JMenuItem mnuDeleteClass;
    private JMenuItem mnuExecQuery;
    private JMenuItem mnuFindClass;
    private JMenuItem mnuInstances;
    private JMenuItem mnuClassQualifiers;
    private JMenuItem mnuPropertyQualifiers;
    private JMenuItem mnuMethodQualifiers;
    private JMenuItem mnuQualifierType;
    private JMenuItem mnuRefresh;
    private JMenuItem mnuHelpAbout;
    private JMenuItem mnuAssocTraversal;
    private JMenuItem mnuShowPropertyValue;
    private JButton btnInstances;
    private JButton btnQualifiers;
    private JButton btnAddClass;

    public ObjectTreeFrame() {
        this.setTitle(I18N.loadStringFormat("TTL_CIM_WORKSHOP", I18N.loadString("LBL_NOT_CONNECTED")));
        JPanel pane = (JPanel)this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.addWindowListener(this);
        this.eventOutputArea = new JTextArea();
        this.eventOutputArea.setWrapStyleWord(true);
        this.eventOutputArea.setEditable(false);
        this.fullPanel = new JSplitPane(0, true);
        this.fullPanel.setOneTouchExpandable(true);
        this.desktop = new JSplitPane(1, true);
        this.tablePane = new CIMTableTabbedPane(){

            public Insets getInsets() {
                return new Insets(5, 5, 5, 5);
            }
        };
        this.tablePane.addEventsTab();
        this.treePane = new ClassTreeActionPane(this, this.tablePane){

            public Insets getInsets() {
                return new Insets(5, 5, 5, 5);
            }
        };
        this.treePane.addTreeSelectionListener(this);
        this.desktop.setLeftComponent(this.treePane);
        this.desktop.setRightComponent(this.tablePane);
        this.createMenuBar();
        this.createToolBar(pane);
        this.fullPanel.setTopComponent(this.desktop);
        this.eventOutputArea.setBorder(BorderFactory.createBevelBorder(1));
        JScrollPane spEventOutput = new JScrollPane(this.eventOutputArea);
        ActionString asEventOutput = new ActionString("LBL_EVENT_OUTPUT");
        JLabel lEventOutput = new JLabel(asEventOutput.getString() + ":");
        lEventOutput.setDisplayedMnemonic(asEventOutput.getMnemonic());
        spEventOutput.setColumnHeaderView(lEventOutput);
        lEventOutput.setLabelFor(this.eventOutputArea);
        this.fullPanel.setBottomComponent(spEventOutput);
        pane.add("Center", this.fullPanel);
        this.setSize(750, 550);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Point screenCenter = new Point(d.width / 2, d.height / 2);
        this.setLocation(screenCenter.x - this.getSize().width / 2, screenCenter.y - this.getSize().height / 2);
    }

    public boolean login() {
        boolean b = false;
        Util.waitOn(this);
        if (this.treePane.getHostInfo()) {
            this.show();
            this.desktop.setDividerLocation(0.4);
            b = true;
        }
        Util.waitOff(this);
        return b;
    }

    public void initializeNewHost() {
        boolean userCanWrite = CIMClientObject.userHasWritePermission();
        this.enableWritableMenuItems(userCanWrite);
        this.setTitle(I18N.loadStringFormat("TTL_CONNECTED", CIMClientObject.getHostName()));
        this.populateNameSpaceComboBox();
        this.prevNameSpace = "";
        this.setSelectedNameSpace(Util.cleanNameSpaceString(CIMClientObject.getNameSpace()));
        this.initializeEventListener();
    }

    private void populateNameSpaceComboBox() {
        this.repopulating = true;
        Enumeration e = NameSpaceDialog.getAllNameSpaces();
        this.cbModel.removeAllElements();
        while (e.hasMoreElements()) {
            CIMObjectPath op = (CIMObjectPath)e.nextElement();
            String ns = op.getNameSpace();
            this.cbModel.addElement(ns);
        }
        this.repopulating = false;
    }

    public void enableWritableMenuItems(boolean b) {
        this.mnuAddClass.setEnabled(b);
        this.mnuDeleteClass.setEnabled(b);
        this.btnAddClass.setEnabled(b);
    }

    public void valueChanged(TreeSelectionEvent e) {
        Util.setWaitCursor(this);
        String path = e.getPath().getLastPathComponent().toString();
        boolean enable = true;
        CIMClass cimClass = null;
        if (this.treePane.isRootSelected()) {
            enable = false;
            this.treePane.populateTables(null);
        } else {
            CIMObjectPath op = new CIMObjectPath(path);
            try {
                CIMClient cimClient = CIMClientObject.getClient();
                if (cimClient == null) {
                    return;
                }
                cimClass = cimClient.getClass(op, false, true, true, null);
                this.treePane.populateTables(cimClass);
            }
            catch (CIMException exc) {
                CIMErrorDialog.display(this, exc);
            }
        }
        this.mnuAssocTraversal.setEnabled(enable);
        this.mnuClassQualifiers.setEnabled(enable);
        this.mnuDeleteClass.setEnabled(enable && CIMClientObject.userHasWritePermission());
        this.btnQualifiers.setEnabled(enable);
        this.mnuPropertyQualifiers.setEnabled(enable && this.tablePane.isPropertySelected());
        this.mnuShowPropertyValue.setEnabled(enable && this.tablePane.isPropertySelected());
        this.mnuMethodQualifiers.setEnabled(enable && this.tablePane.isMethodSelected());
        if (cimClass != null) {
            enable = enable && cimClass.isKeyed();
        }
        this.btnInstances.setEnabled(enable);
        this.mnuInstances.setEnabled(enable);
        this.treePane.enableInstanceMenuItem(enable);
        Util.setDefaultCursor(this);
    }

    private void createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        ActionString asWorkshop = new ActionString("MNU_WORKSHOP");
        ActionString asAction = new ActionString("MNU_ACTION", "org.wbemservices.wbem.apps.common.common");
        ActionString asNamespace = new ActionString("MNU_NAMESPACE");
        ActionString asProperties = new ActionString("MNU_PROPERTIES");
        ActionString asMethods = new ActionString("MNU_METHODS");
        ActionString asHelp = new ActionString("MNU_HELP", "org.wbemservices.wbem.apps.common.common");
        ActionString asRefresh = new ActionString("MNU_REFRESH_CLASS");
        ActionString asExit = new ActionString("MNU_EXIT", "org.wbemservices.wbem.apps.common.common");
        ActionString asHost = new ActionString("MNU_CHANGE_HOST");
        ActionString asChangeNamespace = new ActionString("MNU_CHANGE_NAMESPACE");
        ActionString asAdd = new ActionString("MNU_ADD_CLASS");
        ActionString asDelete = new ActionString("MNU_DELETE_CLASS");
        ActionString asFind = new ActionString("MNU_FIND_CLASS");
        ActionString asInstances = new ActionString("MNU_INSTANCES");
        ActionString asClassQualifiers = new ActionString("MNU_CLASS_QUALIFIERS");
        ActionString asQualifiers = new ActionString("MNU_QUALIFIERS");
        ActionString asQualifierType = new ActionString("MNU_ADD_QUALIFIER_TYPE");
        ActionString asAssoc = new ActionString("MNU_ASSOC_TRAVERSAL");
        ActionString asExecQuery = new ActionString("MNU_EXEC_QUERY");
        ActionString asHelpAbout = new ActionString("MNU_ABOUT_CIMWORKSHOP");
        ActionString asClearEventOutput = new ActionString("MNU_CLEAR_EVENT_OUTPUT");
        ActionString asShowValue = new ActionString("MNU_SHOW_VALUE");
        this.mnuWorkshop = new JMenu(asWorkshop.getString());
        this.mnuWorkshop.setMnemonic(asWorkshop.getMnemonic());
        this.mnuAction = new JMenu(asAction.getString());
        this.mnuAction.setMnemonic(asAction.getMnemonic());
        this.mnuNamespace = new JMenu(asNamespace.getString());
        this.mnuNamespace.setMnemonic(asNamespace.getMnemonic());
        this.mnuProperties = new JMenu(asProperties.getString());
        this.mnuProperties.setMnemonic(asProperties.getMnemonic());
        this.mnuMethods = new JMenu(asMethods.getString());
        this.mnuMethods.setMnemonic(asMethods.getMnemonic());
        this.mnuHelp = new JMenu(asHelp.getString());
        this.mnuHelp.setMnemonic(asHelp.getMnemonic());
        menuBar.add(this.mnuWorkshop);
        menuBar.add(this.mnuAction);
        menuBar.add(this.mnuHelp);
        this.mnuChangeHost = new JMenuItem(asHost.getString());
        this.mnuChangeHost.setMnemonic(asHost.getMnemonic());
        this.mnuChangeHost.addActionListener(this.treePane);
        this.mnuChangeHost.setActionCommand("hostDialog");
        this.mnuChangeNamespace = new JMenuItem(asChangeNamespace.getString());
        this.mnuChangeNamespace.setMnemonic(asChangeNamespace.getMnemonic());
        this.mnuChangeNamespace.addActionListener(this);
        this.mnuChangeNamespace.setActionCommand("CHANGE_NAMESPACE");
        this.mnuExit = new JMenuItem(asExit.getString());
        this.mnuExit.setMnemonic(asExit.getMnemonic());
        this.mnuExit.setActionCommand("EXIT");
        this.mnuExit.addActionListener(this);
        this.mnuAddClass = new JMenuItem(asAdd.getString());
        this.mnuAddClass.setMnemonic(asAdd.getMnemonic());
        this.mnuAddClass.setActionCommand("ADD_CLASS");
        this.mnuAddClass.addActionListener(this.treePane);
        this.mnuDeleteClass = new JMenuItem(asDelete.getString());
        this.mnuDeleteClass.setMnemonic(asDelete.getMnemonic());
        this.mnuDeleteClass.setActionCommand("DELETE_CLASS");
        this.mnuDeleteClass.addActionListener(this.treePane);
        this.mnuFindClass = new JMenuItem(asFind.getString());
        this.mnuFindClass.setMnemonic(asFind.getMnemonic());
        this.mnuFindClass.setActionCommand("FIND_CLASS");
        this.mnuFindClass.addActionListener(this.treePane);
        this.mnuInstances = new JMenuItem(asInstances.getString());
        this.mnuInstances.setMnemonic(asInstances.getMnemonic());
        this.mnuInstances.setActionCommand("INSTANCES");
        this.mnuInstances.addActionListener(this.treePane);
        this.mnuClassQualifiers = new JMenuItem(asClassQualifiers.getString());
        this.mnuClassQualifiers.setMnemonic(asClassQualifiers.getMnemonic());
        this.mnuClassQualifiers.setActionCommand("QUALIFIERS");
        this.mnuClassQualifiers.addActionListener(this.treePane);
        this.mnuPropertyQualifiers = new JMenuItem(asQualifiers.getString());
        this.mnuPropertyQualifiers.setMnemonic(asQualifiers.getMnemonic());
        this.mnuPropertyQualifiers.setActionCommand("QUALIFIERS");
        this.mnuPropertyQualifiers.addActionListener(this.tablePane.getPropertiesTable());
        this.mnuShowPropertyValue = new JMenuItem(asShowValue.getString());
        this.mnuShowPropertyValue.setMnemonic(asShowValue.getMnemonic());
        this.mnuShowPropertyValue.setActionCommand("SHOW_VALUE");
        this.mnuShowPropertyValue.addActionListener(this.tablePane.getPropertiesTable());
        this.mnuMethodQualifiers = new JMenuItem(asQualifiers.getString());
        this.mnuMethodQualifiers.setMnemonic(asQualifiers.getMnemonic());
        this.mnuMethodQualifiers.setActionCommand("QUALIFIERS");
        this.mnuMethodQualifiers.addActionListener(this.tablePane.getMethodsTable());
        this.mnuQualifierType = new JMenuItem(asQualifierType.getString());
        this.mnuQualifierType.setMnemonic(asQualifierType.getMnemonic());
        this.mnuQualifierType.setActionCommand("ADD_QUALIFIER_TYPE");
        this.mnuQualifierType.addActionListener(this.treePane);
        this.mnuAssocTraversal = new JMenuItem(asAssoc.getString());
        this.mnuAssocTraversal.setMnemonic(asAssoc.getMnemonic());
        this.mnuAssocTraversal.setActionCommand("ASSOC_TRAVERSAL");
        this.mnuAssocTraversal.addActionListener(this.treePane);
        this.mnuExecQuery = new JMenuItem(asExecQuery.getString());
        this.mnuExecQuery.setMnemonic(asExecQuery.getMnemonic());
        this.mnuExecQuery.setActionCommand("EXEC_QUERY");
        this.mnuExecQuery.addActionListener(this.treePane);
        this.mnuRefresh = new JMenuItem(asRefresh.getString());
        this.mnuRefresh.setMnemonic(asRefresh.getMnemonic());
        this.mnuRefresh.setActionCommand("REFRESH");
        this.mnuRefresh.addActionListener(this.treePane);
        JMenuItem mnuClearEventOutput = new JMenuItem(asClearEventOutput.getString());
        mnuClearEventOutput.setMnemonic(asClearEventOutput.getMnemonic());
        mnuClearEventOutput.setActionCommand("CLEAR_EVENT_OUTPUT");
        mnuClearEventOutput.addActionListener(this);
        this.mnuHelpAbout = new JMenuItem(asHelpAbout.getString());
        this.mnuHelpAbout.setMnemonic(asHelpAbout.getMnemonic());
        this.mnuHelpAbout.setActionCommand("ABOUT_CIMWORKSHOP");
        this.mnuHelpAbout.addActionListener(this);
        this.mnuNamespace.add(this.mnuQualifierType);
        this.mnuProperties.add(this.mnuPropertyQualifiers);
        this.mnuProperties.add(this.mnuShowPropertyValue);
        this.mnuMethods.add(this.mnuMethodQualifiers);
        this.mnuWorkshop.add(this.mnuChangeHost);
        this.mnuWorkshop.addSeparator();
        this.mnuWorkshop.add(this.mnuChangeNamespace);
        this.mnuWorkshop.addSeparator();
        this.mnuWorkshop.add(this.mnuExit);
        this.mnuAction.add(this.mnuAddClass);
        this.mnuAction.add(this.mnuDeleteClass);
        this.mnuAction.add(this.mnuFindClass);
        this.mnuAction.addSeparator();
        this.mnuAction.add(this.mnuInstances);
        this.mnuAction.add(this.mnuClassQualifiers);
        this.mnuAction.add(this.mnuAssocTraversal);
        this.mnuAction.add(this.mnuExecQuery);
        this.mnuAction.addSeparator();
        this.mnuAction.add(this.mnuNamespace);
        this.mnuAction.add(this.mnuProperties);
        this.mnuAction.add(this.mnuMethods);
        this.mnuAction.addSeparator();
        this.mnuAction.add(this.mnuRefresh);
        this.mnuAction.add(mnuClearEventOutput);
        this.mnuHelp.add(this.mnuHelpAbout);
    }

    private void createToolBar(JPanel pane) {
        ToolBarPanel toolbar = new ToolBarPanel();
        toolbar.createButton(Util.loadImageIcon("new_host.gif"), I18N.loadString("TIP_HOSTNAME"), "hostDialog", this.treePane);
        this.cbModel = new DefaultComboBoxModel();
        this.nameSpaceList = new JComboBox(this.cbModel);
        this.nameSpaceList.addItemListener(this);
        this.nameSpaceList.setEditable(false);
        toolbar.addComponent(this.nameSpaceList);
        toolbar.createButton(Util.loadImageIcon("chng_namespace.gif"), I18N.loadString("TIP_NAMESPACE"), "CHANGE_NAMESPACE", this);
        toolbar.createButton(Util.loadImageIcon("find_class.gif"), I18N.loadString("TIP_FIND_CLASS"), "FIND_CLASS", this.treePane);
        this.btnAddClass = toolbar.createButton(Util.loadImageIcon("addclass.gif"), I18N.loadString("TIP_ADD_CLASS"), "ADD_CLASS", this.treePane);
        this.btnInstances = toolbar.createButton(Util.loadImageIcon("instances.gif"), I18N.loadString("TIP_INSTANCES"), "INSTANCES", this.treePane);
        this.btnQualifiers = toolbar.createButton(Util.loadImageIcon("qualifiers.gif"), I18N.loadString("TIP_CLASS_QUALIFIERS"), "QUALIFIERS", this.treePane);
        toolbar.createButton(Util.loadImageIcon("refresh.gif"), I18N.loadString("TIP_REFRESH_CLASS"), "REFRESH", this.treePane);
        pane.add("North", toolbar);
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getItem() == "select name space") {
            this.populateNameSpaceComboBox();
            this.nsDlg.setVisible(false);
            this.setSelectedNameSpace(this.nsDlg.getSelectedNameSpace());
            this.nsDlg.dispose();
            Util.waitOff(this);
        } else if (e.getItem().equals("dialog cancel")) {
            this.populateNameSpaceComboBox();
            Util.waitOff(this);
        } else if (e.getStateChange() == 1) {
            this.setSelectedNameSpace((String)e.getItem());
        }
    }

    public void setSelectedNameSpace(String nSpace) {
        if (this.repopulating) {
            return;
        }
        CIMClient cc = CIMClientObject.changeNameSpace("");
        try {
            cc.enumQualifierTypes(new CIMObjectPath("", "/" + nSpace));
        }
        catch (CIMException exc) {
            if (exc.getID().equals("CIM_ERR_INVALID_NAMESPACE")) {
                JOptionPane.showMessageDialog(this, I18N.loadStringFormat("ERR_INVALID_NAMESPACE", nSpace), I18N.loadString("TTL_CIM_ERROR"), 0);
            }
            this.populateNameSpaceComboBox();
            nSpace = this.prevNameSpace;
        }
        if (!this.prevNameSpace.equals(nSpace) && CIMClientObject.initialize(nSpace)) {
            this.treePane.initializeClassTree();
        }
        this.prevNameSpace = nSpace;
        this.cbModel.setSelectedItem(nSpace);
    }

    public void initializeEventListener() {
        this.tablePane.deleteEventSubscriptions();
        CIMClient cc = CIMClientObject.getClient();
        try {
            CIMClass cimFilter = cc.getClass(new CIMObjectPath("CIM_IndicationFilter"), true, true, true, null);
            cc.addCIMListener(new CIMListener(){

                public void indicationOccured(CIMEvent e) {
                    String event = e.getIndication().toString();
                    ObjectTreeFrame.this.eventOutputArea.append(event + "\n");
                }
            });
            CIMInstance ci = cc.getIndicationListener(null);
            CIMObjectPath iHandler = cc.createInstance(new CIMObjectPath(), ci);
            this.tablePane.initializeEvents(iHandler, cc);
        }
        catch (CIMException e) {
            this.tablePane.initializeEvents(null, cc);
            return;
        }
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("CHANGE_NAMESPACE")) {
            Util.waitOn(this);
            this.nsDlg = new NameSpaceDialog(this);
            this.nsDlg.addItemListener(this);
            this.nsDlg.setVisible(true);
        } else if (action.equals("ABOUT_CIMWORKSHOP")) {
            Util.setWaitCursor(this);
            String versionString = "1.0.0 11/01/04:10:48";
            AboutDialog dlg = new AboutDialog(this, "WBEM Services CIM Workshop", versionString, "Copyright 2002 Sun Microsystems, Inc.\nAll rights reserved.", null);
            Util.setDefaultCursor(this);
        } else if (action.equals("CLEAR_EVENT_OUTPUT")) {
            this.eventOutputArea.setText("");
        } else if (action.equals("EXIT")) {
            this.exitCIMWorkshop();
        }
    }

    public void windowClosing(WindowEvent evt) {
        this.exitCIMWorkshop();
    }

    private void exitCIMWorkshop() {
        if (this.nsDlg != null) {
            this.nsDlg.dispose();
        }
        this.tablePane.deleteEventSubscriptions();
        this.dispose();
        System.exit(0);
    }

    public void windowOpened(WindowEvent evt) {
        this.fullPanel.setDividerLocation(0.8);
    }

    public void windowClosed(WindowEvent evt) {
    }

    public void windowDeiconified(WindowEvent evt) {
    }

    public void windowActivated(WindowEvent evt) {
    }

    public void windowIconified(WindowEvent evt) {
    }

    public void windowDeactivated(WindowEvent evt) {
    }
}

