/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.wbem.cim.CIMElement;
import javax.wbem.client.CIMClient;
import org.wbemservices.wbem.apps.cimworkshop.CIMQualifiersPanel;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.AdminDialog;
import org.wbemservices.wbem.apps.common.ColumnLayout;
import org.wbemservices.wbem.apps.common.ContextHelpListener;
import org.wbemservices.wbem.apps.common.DefaultProperties;
import org.wbemservices.wbem.apps.common.GenInfoPanel;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.Util;

public class QualifierWindow
extends AdminDialog
implements ListSelectionListener,
TableModelListener {
    protected JButton btnOK;
    protected JButton btnCancel;
    protected GenInfoPanel infoPanel = this.getInfoPanel();
    protected CIMQualifiersPanel cimQualifiersPanel;
    protected CIMClient cimClient;
    protected CIMElement parentElement;
    private JButton btnScope;
    private JButton btnFlavor;
    private JButton btnDeleteQualifier;

    public QualifierWindow(Frame parent, CIMClient cc, CIMElement pElement, boolean nElement) {
        super(parent, I18N.loadStringFormat("TTL_QUALIFIERS", pElement.getName()), false);
        this.btnCancel = this.getCancelBtn();
        this.btnCancel.addActionListener(new ButtonListener());
        this.btnOK = this.getOKBtn();
        if (nElement) {
            this.btnOK.addActionListener(new ButtonListener());
        } else {
            this.getbuttonPanel().remove(this.btnOK);
            this.btnCancel.setText(I18N.loadString("LBL_CLOSE", "org.wbemservices.wbem.apps.common.common"));
        }
        JPanel mainPanel = this.getRightPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ActionString asQualifiers = new ActionString("LBL_QUALIFIERS");
        JLabel lQualifiers = new JLabel(asQualifiers.getString() + ":");
        lQualifiers.setDisplayedMnemonic(asQualifiers.getMnemonic());
        this.cimQualifiersPanel = new CIMQualifiersPanel(cc, pElement, nElement);
        lQualifiers.setLabelFor(this.cimQualifiersPanel.getTable());
        lQualifiers.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        centerPanel.add("North", lQualifiers);
        centerPanel.add("Center", this.cimQualifiersPanel);
        ActionString asScope = new ActionString("MNU_SCOPE");
        ActionString asFlavors = new ActionString("MNU_FLAVOR");
        ActionString asAdd = new ActionString("MNU_ADD_QUALIFIER");
        ActionString asDelete = new ActionString("MNU_DELETE_QUALIFIER");
        this.btnScope = new JButton(asScope.getString());
        this.btnScope.setMnemonic(asScope.getMnemonic());
        this.btnScope.addActionListener(this.cimQualifiersPanel);
        this.btnScope.setActionCommand("SCOPE");
        this.btnScope.setEnabled(false);
        this.btnFlavor = new JButton(asFlavors.getString());
        this.btnFlavor.setMnemonic(asFlavors.getMnemonic());
        this.btnFlavor.addActionListener(this.cimQualifiersPanel);
        this.btnFlavor.setActionCommand("FLAVOR");
        this.btnFlavor.setEnabled(false);
        JButton btnAddQualifier = new JButton(asAdd.getString());
        btnAddQualifier.setMnemonic(asAdd.getMnemonic());
        btnAddQualifier.addActionListener(this.cimQualifiersPanel);
        btnAddQualifier.setActionCommand("ADD_QUALIFIER");
        btnAddQualifier.setEnabled(true);
        this.btnDeleteQualifier = new JButton(asDelete.getString());
        this.btnDeleteQualifier.setMnemonic(asDelete.getMnemonic());
        this.btnDeleteQualifier.addActionListener(this.cimQualifiersPanel);
        this.btnDeleteQualifier.setActionCommand("DELETE_QUALIFIER");
        this.btnDeleteQualifier.setEnabled(false);
        JPanel sideButtons = new JPanel();
        sideButtons.setBorder(BorderFactory.createEmptyBorder(25, 10, 5, 5));
        sideButtons.setLayout(new ColumnLayout());
        sideButtons.add(this.btnScope);
        sideButtons.add(this.btnFlavor);
        if (nElement) {
            sideButtons.add(btnAddQualifier);
            sideButtons.add(this.btnDeleteQualifier);
        }
        centerPanel.add("East", sideButtons);
        mainPanel.add("Center", centerPanel);
        if (nElement) {
            this.setDefaultFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "qualifiers_000.htm"), true);
        } else {
            this.setDefaultFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "qualifiers_001.htm"), true);
        }
        this.btnScope.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "qualifiers_010.htm"));
        this.btnFlavor.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "qualifiers_020.htm"));
        btnAddQualifier.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "qualifiers_030.htm"));
        this.btnDeleteQualifier.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "qualifiers_040.htm"));
        this.cimQualifiersPanel.addListSelectionListener(this);
        this.cimQualifiersPanel.addTableListener(this);
        this.setSize(DefaultProperties.qualifierDlgSize);
        this.setLocation(Util.getCenterPoint(parent, this));
        this.setVisible(true);
    }

    public void valueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        int selectedRow = this.cimQualifiersPanel.getSelectedRow();
        boolean bEnable = selectedRow >= 0;
        this.btnDeleteQualifier.setEnabled(bEnable);
        this.btnScope.setEnabled(bEnable);
        this.btnFlavor.setEnabled(bEnable);
    }

    public void tableChanged(TableModelEvent e) {
        if (this.cimQualifiersPanel.getQualifiers().size() == 0) {
            this.btnDeleteQualifier.setEnabled(false);
            this.btnScope.setEnabled(false);
            this.btnFlavor.setEnabled(false);
        }
    }

    public void populateTable(CIMElement pElement) {
        this.cimQualifiersPanel.populateTable(this.cimClient, pElement);
    }

    public void okClicked() {
        this.dispose();
    }

    public void cancelClicked() {
        this.dispose();
    }

    public void windowOpened(WindowEvent evt) {
        super.windowOpened(evt);
        JTable table = this.cimQualifiersPanel.getTable();
        table.requestFocus();
        if (table.getRowCount() > 0) {
            table.setRowSelectionInterval(0, 0);
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == QualifierWindow.this.btnCancel) {
                QualifierWindow.this.cancelClicked();
            } else if (e.getSource() == QualifierWindow.this.btnOK) {
                QualifierWindow.this.okClicked();
            }
        }
    }
}

