/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.wbem.client.CIMClient;
import org.wbemservices.wbem.apps.cimworkshop.CIMTableTabbedPane;
import org.wbemservices.wbem.apps.cimworkshop.QueryActionPanel;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.ToolBarPanel;
import org.wbemservices.wbem.apps.common.Util;

public class QueryFrame
extends JFrame
implements ActionListener,
WindowListener {
    private CIMTableTabbedPane tablePane;
    QueryActionPanel queryPanel;
    JSplitPane desktop;
    private JMenuItem mnuRefresh;
    private JMenuItem mnuExit;

    public QueryFrame(Frame parent, CIMClient cimClient, String query) {
        this.setTitle(I18N.loadString("TTL_EXEC_QUERY"));
        JPanel pane = (JPanel)this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.desktop = new JSplitPane(1);
        this.tablePane = new CIMTableTabbedPane();
        this.queryPanel = new QueryActionPanel(this.tablePane, this, query);
        this.queryPanel.setPreferredSize(new Dimension(300, 200));
        this.tablePane.setPreferredSize(new Dimension(300, 200));
        this.desktop.setLeftComponent(this.queryPanel);
        this.desktop.setRightComponent(this.tablePane);
        pane.add("Center", this.desktop);
        this.createMenuBar();
        this.createToolBar(pane);
        this.queryPanel.refreshInstanceList();
        this.addWindowListener(this);
        this.setBounds(100, 100, 600, 400);
        this.show();
    }

    public void actionPerformed(ActionEvent e) {
        String actionCmd = e.getActionCommand();
        if (actionCmd.equals("EXIT")) {
            this.dispose();
        }
    }

    private void createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        ActionString asAction = new ActionString("MNU_ACTION", "org.wbemservices.wbem.apps.common.common");
        ActionString asRefresh = new ActionString("MNU_REFRESH", "org.wbemservices.wbem.apps.common.common");
        ActionString asExit = new ActionString("MNU_EXIT", "com.sun.wbem.apps.common.common");
        JMenu mnuAction = new JMenu(asAction.getString());
        mnuAction.setMnemonic(asAction.getMnemonic());
        menuBar.add(mnuAction);
        this.mnuRefresh = new JMenuItem(asRefresh.getString());
        this.mnuRefresh.setMnemonic(asRefresh.getMnemonic());
        this.mnuRefresh.setActionCommand("REFRESH");
        this.mnuRefresh.addActionListener(this.queryPanel);
        this.mnuExit = new JMenuItem(asExit.getString());
        this.mnuExit.setMnemonic(asExit.getMnemonic());
        this.mnuExit.setActionCommand("EXIT");
        this.mnuExit.addActionListener(this);
        mnuAction.add(this.mnuRefresh);
        mnuAction.add(this.mnuExit);
    }

    private void createToolBar(JPanel pane) {
        ToolBarPanel toolbar = new ToolBarPanel();
        toolbar.createButton(Util.loadImageIcon("refresh.gif"), I18N.loadString("TIP_REFRESH_INSTANCES"), "REFRESH", this.queryPanel);
        pane.add("North", toolbar);
    }

    public void windowActivated(WindowEvent evt) {
    }

    public void windowClosed(WindowEvent evt) {
    }

    public void windowClosing(WindowEvent evt) {
    }

    public void windowDeactivated(WindowEvent evt) {
    }

    public void windowDeiconified(WindowEvent evt) {
    }

    public void windowIconified(WindowEvent evt) {
    }

    public void windowOpened(WindowEvent evt) {
        this.desktop.setDividerLocation(0.4);
    }
}

