/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.Component;
import java.awt.Cursor;
import java.util.Enumeration;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.client.CIMClient;
import org.wbemservices.wbem.apps.common.Util;

public class ReferenceTree
extends JScrollPane
implements TreeExpansionListener {
    protected JTree tree;
    protected JScrollPane thisPane;
    protected CIMClient cimClient;
    protected ClassNode root;
    private final int CLASS_TREE = 0;
    private final int INSTANCE_TREE = 1;
    private int treeType = 0;

    public ReferenceTree(CIMObjectPath op, CIMClient cc) {
        this.cimClient = cc;
        this.thisPane = this;
        if (op.getKeys() != null && op.getKeys().size() > 0) {
            this.treeType = 1;
        }
        ClassNode rootNode = new ClassNode(op);
        DefaultTreeModel model = new DefaultTreeModel(rootNode);
        this.tree = new JTree(model);
        this.exploreNode(rootNode);
        TreeCellRenderer cellRenderer = this.tree.getCellRenderer();
        if (cellRenderer instanceof DefaultTreeCellRenderer) {
            CustomBasicRenderer cbr = new CustomBasicRenderer();
            this.tree.setCellRenderer(cbr);
        }
        this.tree.addTreeExpansionListener(this);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(true);
        this.setViewportView(this.tree);
    }

    public JTree getTree() {
        return this.tree;
    }

    public void treeExpanded(TreeExpansionEvent e) {
        TreePath path = e.getPath();
        CIMElementNode node = (CIMElementNode)path.getLastPathComponent();
        if (!node.isExplored()) {
            Cursor oldCursor = this.getCursor();
            Util.setWaitCursor(this);
            this.exploreNode(node);
            Util.setCursor(this, oldCursor);
        }
    }

    public void treeCollapsed(TreeExpansionEvent e) {
    }

    public DefaultMutableTreeNode getSelectedNode() {
        if (this.tree.getSelectionPath() == null) {
            return null;
        }
        return (DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent();
    }

    public TreePath getSelectedPath() {
        return this.tree.getSelectionPath();
    }

    private void exploreNode(CIMElementNode node) {
        Enumeration childList = node.getChildList();
        if (!node.isExplored() && childList != null) {
            int i = 0;
            DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
            while (childList.hasMoreElements()) {
                CIMObjectPath op = (CIMObjectPath)childList.nextElement();
                if (node instanceof ClassNode) {
                    ReferenceNode refNode = new ReferenceNode(op, node.getObjectPath());
                    model.insertNodeInto(refNode, node, i++);
                    continue;
                }
                if (!(node instanceof ReferenceNode)) continue;
                ClassNode classNode = new ClassNode(op);
                model.insertNodeInto(classNode, node, i++);
            }
            node.setExplored();
        }
    }

    class ClassNode
    extends CIMElementNode {
        public ClassNode(CIMObjectPath op) {
            super(op);
            this.setChildList();
        }

        private void setChildList() {
            CIMObjectPath op = null;
            if (ReferenceTree.this.treeType == 1) {
                try {
                    CIMInstance ci = ReferenceTree.this.cimClient.getInstance(this.getObjectPath(), true, true, true, null);
                    op = new CIMObjectPath(ci.getClassName());
                }
                catch (CIMException exc) {
                    return;
                }
            } else {
                op = this.getObjectPath();
            }
            this.leaf = true;
            try {
                Enumeration e = ReferenceTree.this.cimClient.referenceNames(op, "", "");
                this.childList = Util.sortEnumeration(e);
                this.leaf = !this.childList.hasMoreElements();
            }
            catch (CIMException exc) {
                if (exc.getID().equals("NOT_ASSOCIATOR_PROVIDER")) {
                    this.leaf = false;
                }
                return;
            }
        }

        public String toString() {
            String ret = this.getObjectPath().toString();
            if (ret.trim().length() < 40) {
                return ret;
            }
            return ret.substring(0, 39);
        }
    }

    class ReferenceNode
    extends CIMElementNode {
        public ReferenceNode(CIMObjectPath op, CIMObjectPath opParent) {
            super(op);
            this.setChildList(opParent);
        }

        private void setChildList(CIMObjectPath opParent) {
            CIMObjectPath op = this.getObjectPath();
            this.leaf = true;
            try {
                Enumeration e = ReferenceTree.this.cimClient.associatorNames(opParent, op.getObjectName(), null, null, null);
                this.childList = Util.sortEnumeration(e);
                this.leaf = !this.childList.hasMoreElements();
            }
            catch (CIMException cIMException) {
                // empty catch block
            }
        }

        public String getReferenceName() {
            return this.getObjectPath().getObjectName();
        }

        public String toString() {
            return this.getReferenceName();
        }
    }

    abstract class CIMElementNode
    extends DefaultMutableTreeNode {
        protected boolean explored = false;
        protected boolean leaf = false;
        Enumeration childList = null;

        public CIMElementNode(CIMObjectPath op) {
            this.setUserObject(op);
        }

        public CIMObjectPath getObjectPath() {
            return (CIMObjectPath)this.getUserObject();
        }

        public String toString() {
            CIMObjectPath op = (CIMObjectPath)this.getUserObject();
            return op.toString();
        }

        public boolean isLeaf() {
            return this.leaf;
        }

        public boolean isExplored() {
            return this.explored;
        }

        public void setExplored() {
            this.explored = true;
        }

        public void setExplored(boolean b) {
            this.explored = b;
        }

        public Enumeration getChildList() {
            return this.childList;
        }
    }

    protected class CustomBasicRenderer
    extends DefaultTreeCellRenderer {
        protected CustomBasicRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree theTree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean focus) {
            CIMElementNode node = (CIMElementNode)value;
            Component c = super.getTreeCellRendererComponent(theTree, value, isSelected, expanded, leaf, row, focus);
            String iconName = "class.gif";
            if (node instanceof ReferenceNode) {
                iconName = "reference.gif";
            }
            if (c instanceof JLabel) {
                JLabel l = (JLabel)c;
                ImageIcon icon = Util.loadImageIcon(iconName);
                l.setIcon(icon);
            }
            return c;
        }
    }
}

