/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.common;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.Constants;
import org.wbemservices.wbem.apps.common.Constraints;
import org.wbemservices.wbem.apps.common.GenInfoPanel;
import org.wbemservices.wbem.apps.common.I18N;

public class AdminDialog
extends JDialog
implements ActionListener,
WindowListener {
    private JButton okBtn;
    private JButton cancelBtn;
    private JButton applyBtn = null;
    private JPanel rootPanel;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private GenInfoPanel infoPanel;
    protected AdminDialog adminDlg = this;
    protected boolean hidden;
    protected JPanel buttonPanel;
    public static final Border emptyBorder5 = new EmptyBorder(5, 5, 5, 5);
    private Dimension dlgSizeHelp;
    private Dimension dlgSizeNoHelp;
    private boolean cancelBtnHasFocus = false;

    public AdminDialog(Frame frame, String title, boolean showApply) {
        super(frame, title, true);
        this.getContentPane().setLayout(new BorderLayout());
        this.rootPanel = new JPanel();
        this.rootPanel.setLayout(new BorderLayout());
        this.infoPanel = new GenInfoPanel(I18N.loadString("LBL_CONTEXT_HELP", "org.wbemservices.wbem.apps.common.common"), 1, this);
        this.leftPanel = new JPanel();
        this.leftPanel.setLayout(new BorderLayout());
        this.leftPanel.add("Center", this.infoPanel);
        this.rightPanel = new JPanel();
        this.rightPanel.setBorder(emptyBorder5);
        this.rightPanel.setLayout(new BorderLayout());
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.okBtn = new JButton(I18N.loadString("LBL_OK", "org.wbemservices.wbem.apps.common.common"));
        this.okBtn.setFocusPainted(true);
        Constraints.constrain(this.buttonPanel, this.okBtn, -1, 0, 1, 1, 0, 0, 0, 0);
        if (showApply) {
            ActionString asApply = new ActionString("LBL_APPLY", "org.wbemservices.wbem.apps.common.common");
            this.applyBtn = new JButton(asApply.getString());
            this.applyBtn.setMnemonic(asApply.getMnemonic());
            this.applyBtn.setFocusPainted(true);
            Constraints.constrain(this.buttonPanel, this.applyBtn, -1, 0, 1, 1, 0, 5, 0, 0);
        }
        this.cancelBtn = new JButton(I18N.loadString("LBL_CANCEL", "org.wbemservices.wbem.apps.common.common"));
        this.cancelBtn.setFocusPainted(true);
        Constraints.constrain(this.buttonPanel, this.cancelBtn, -1, 0, 1, 1, 0, 5, 0, 0);
        this.cancelBtn.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                AdminDialog.this.cancelBtnHasFocus = true;
            }

            public void focusLost(FocusEvent e) {
                AdminDialog.this.cancelBtnHasFocus = false;
            }
        });
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add("West", this.leftPanel);
        topPanel.add("Center", this.rightPanel);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new GridBagLayout());
        bottomPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        Constraints.constrain(bottomPanel, this.buttonPanel, 0, 0, 1, 1, 0, 13, 1.0, 0.0, 5, 0, 5, 10);
        this.rootPanel.add("Center", topPanel);
        this.rootPanel.add("South", bottomPanel);
        EscKeyListener escListener = new EscKeyListener();
        EnterKeyListener enterListener = new EnterKeyListener();
        this.rootPanel.registerKeyboardAction(escListener, KeyStroke.getKeyStroke(27, 0, true), 2);
        this.rootPanel.registerKeyboardAction(enterListener, KeyStroke.getKeyStroke(10, 0, true), 2);
        this.getContentPane().add("Center", this.rootPanel);
        this.dlgSizeNoHelp = Constants.LARGE_NOHELP_DLG;
        this.dlgSizeHelp = Constants.LARGE_HELP_DLG;
        this.setSize(this.getMySize(this.hidden));
        this.addWindowListener(this);
        this.hidden = !this.hidden;
        ActionEvent ev = new ActionEvent(this, 1001, "infopanel");
        this.actionPerformed(ev);
    }

    public GenInfoPanel getInfoPanel() {
        return this.infoPanel;
    }

    public JButton getOKBtn() {
        return this.okBtn;
    }

    public JButton getApplyBtn() {
        return this.applyBtn;
    }

    public JButton getCancelBtn() {
        return this.cancelBtn;
    }

    public JPanel getRightPanel() {
        return this.rightPanel;
    }

    public JPanel getbuttonPanel() {
        return this.buttonPanel;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("infopanel")) {
            this.hidden = !this.hidden;
            this.infoPanel.hideInfoPanel(this.hidden);
            if (this.hidden) {
                this.infoPanel.setPreferredSize(Constants.INFOPANEL_MIN_SIZE);
                this.setSize(this.getMySize(this.hidden));
                this.invalidate();
                this.validate();
            } else {
                this.infoPanel.setPreferredSize(Constants.INFOPANEL_MAX_SIZE);
                this.setSize(this.getMySize(this.hidden));
                this.invalidate();
                this.validate();
            }
        }
    }

    public Dimension getMySize(boolean isHidden) {
        if (isHidden) {
            return this.dlgSizeNoHelp;
        }
        return this.dlgSizeHelp;
    }

    public void setMySize(Dimension newDim) {
        if (this.hidden) {
            this.dlgSizeNoHelp = newDim;
            this.dlgSizeHelp = new Dimension(newDim.width + Constants.INFOPANEL_MAX_SIZE.width, newDim.height);
        } else {
            this.dlgSizeHelp = newDim;
            this.dlgSizeNoHelp = new Dimension(newDim.width - Constants.INFOPANEL_MAX_SIZE.width + Constants.INFOPANEL_MIN_SIZE.width, newDim.height);
        }
    }

    public void addHelpToInfoPanel(String path) {
        try {
            this.infoPanel.setUrl(new URL(path));
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
    }

    public void setDefaultFocusListener(FocusListener l, boolean force) {
        this.infoPanel.setFocusListener(l, force);
        this.okBtn.addFocusListener(l);
        this.cancelBtn.addFocusListener(l);
    }

    public void onEnterKey() {
        this.okBtn.doClick();
    }

    public void windowActivated(WindowEvent evt) {
    }

    public void windowClosed(WindowEvent evt) {
    }

    public void windowClosing(WindowEvent evt) {
        this.cancelClicked();
    }

    public void windowDeactivated(WindowEvent evt) {
    }

    public void windowDeiconified(WindowEvent evt) {
    }

    public void windowIconified(WindowEvent evt) {
    }

    public void windowOpened(WindowEvent evt) {
        this.infoPanel.getHideButton().requestFocus();
    }

    public void cancelClicked() {
        this.adminDlg.dispose();
    }

    protected class EnterKeyListener
    implements ActionListener {
        protected EnterKeyListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (AdminDialog.this.cancelBtnHasFocus) {
                AdminDialog.this.cancelClicked();
            } else {
                AdminDialog.this.adminDlg.onEnterKey();
            }
        }
    }

    protected class EscKeyListener
    implements ActionListener {
        protected EscKeyListener() {
        }

        public void actionPerformed(ActionEvent e) {
            AdminDialog.this.cancelClicked();
        }
    }
}

