/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.common;

import java.security.Principal;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.client.CIMClient;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import org.wbemservices.wbem.apps.common.CIMErrorDialog;

public class CIMClientObject {
    private static String hostName = "";
    private static String nameSpace = "";
    private static String userName = "";
    private static String password = "";
    private static String interopNS = "/interop";
    private static CIMClient cimClient = null;
    private static final int READ = 1;
    private static final int WRITE = 2;
    private static final int READ_WRITE = 3;
    private static int userPermission = 1;
    private static String protocol = null;
    private static String latestNameSpace = "";

    private static CIMClient createClient(String hName, String nSpace, String uName, String pw) {
        return CIMClientObject.createClient(hName, nSpace, uName, pw, null);
    }

    private static CIMClient createClient(String hName, String nSpace, String uName, String pw, String proto) {
        try {
            CIMNameSpace cimNS = nSpace != null && nSpace.trim().length() > 0 ? new CIMNameSpace(hName, nSpace) : new CIMNameSpace(hName);
            latestNameSpace = cimNS.getNameSpace();
            UserPrincipal up = null;
            if (uName != null && uName.trim().length() > 0) {
                up = new UserPrincipal(uName);
            }
            PasswordCredential pc = null;
            if (pw != null && pw.trim().length() > 0) {
                pc = new PasswordCredential(pw);
            }
            CIMClient cc = new CIMClient(cimNS, (Principal)up, pc);
            return cc;
        }
        catch (CIMException e) {
            CIMErrorDialog.display(null, e);
            return null;
        }
    }

    public static CIMClient createInteropClient() {
        CIMClient cc = null;
        if (hostName != null && userName != null && password != null) {
            cc = CIMClientObject.createClient(hostName, interopNS, userName, password, protocol);
        }
        return cc;
    }

    public static String getInteropNameSpace() {
        return interopNS;
    }

    public static void setInteropNameSpace(String ns) {
        if (ns != null) {
            interopNS = ns;
        }
    }

    public static CIMClient changeNameSpace(String nSpace) {
        return CIMClientObject.createClient(hostName, nSpace, userName, password);
    }

    public static boolean initialize(String nSpace, String proto) {
        CIMClient cc = CIMClientObject.createClient(hostName, nSpace, userName, password, proto);
        if (cc != null) {
            protocol = proto;
            cimClient = cc;
            nameSpace = latestNameSpace;
            CIMClientObject.initializeUserPermission(nameSpace, userName);
            return true;
        }
        return false;
    }

    public static boolean initialize(String nSpace) {
        return CIMClientObject.initialize(nSpace, protocol);
    }

    public static boolean initialize(String hName, String nSpace, String uName, String pw, String proto) {
        CIMClient cc = CIMClientObject.createClient(hName, nSpace, uName, pw, proto);
        if (cc != null) {
            cimClient = cc;
            protocol = proto;
            hostName = hName;
            nameSpace = latestNameSpace;
            userName = uName;
            password = pw;
            CIMClientObject.initializeUserPermission(nameSpace, uName);
            return true;
        }
        return false;
    }

    public static boolean initialize(String hName, String nSpace, String uName, String pw) {
        return CIMClientObject.initialize(hName, nSpace, uName, pw, protocol);
    }

    public static boolean isXML() {
        return protocol.equals("cim-xml");
    }

    public static String getUserName() {
        return userName;
    }

    public static String getHostName() {
        return hostName;
    }

    public static String getNameSpace() {
        return nameSpace;
    }

    public static CIMClient getClient() {
        return cimClient;
    }

    public static boolean userHasReadPermission() {
        return (userPermission & 1) > 0;
    }

    public static boolean userHasWritePermission() {
        return (userPermission & 2) > 0;
    }

    private static void initializeUserPermission(String nSpace, String uName) {
        userPermission = CIMClientObject.getUserPermission(nSpace, uName);
    }

    private static int getUserPermission(String nSpace, String uName) {
        return 3;
    }
}

