/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.common;

import java.awt.Dimension;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import org.wbemservices.wbem.apps.common.Util;

public class DefaultProperties {
    private static final String defaultHelpLocale = "C";
    private static String helpLocale = "C";
    public static String loginFont = "sans-14";
    public static String textPanelFont = "serif-12";
    public static String dialogfont = "dialog-bold-12";
    public static Dimension loginWindowSize = new Dimension(550, 330);
    public static Dimension addClassDlgSize = new Dimension(770, 400);
    public static Dimension qualifierDlgSize = new Dimension(770, 400);
    public static String helpLoc = " ";
    public static String installLoc = "";

    public static void setInstallLoc(String loc, String appName) {
        String sep = File.separator;
        if (loc != null) {
            installLoc = loc;
        }
        if (!installLoc.endsWith(sep) && installLoc.length() != 0) {
            installLoc = installLoc + sep;
        }
        DefaultProperties.setHelpLoc(installLoc, appName);
    }

    public static void setHelpLoc(String loc, String appName) {
        String sep = File.separator;
        String helpPath = "help" + sep + appName + sep + "locale";
        String baseDir = loc + helpPath;
        helpLocale = DefaultProperties.getHelpLocaleDirectory(baseDir, "notfound.html", sep);
        if (helpLocale.equals(defaultHelpLocale)) {
            sep = "/";
            baseDir = "org/wbemservices/wbem/apps/help/" + appName + "/locale";
        }
        helpLoc = baseDir + sep + helpLocale + sep;
    }

    private static String getHelpLocaleDirectory(String pathname, String filename, String sep) {
        Locale loc = Locale.getDefault();
        String locPath = "";
        String locValue = "";
        File fd = null;
        if (loc != null) {
            locValue = loc.toString();
            boolean sw = true;
            while (sw) {
                locPath = pathname + sep + locValue + sep + filename;
                try {
                    fd = new File(locPath);
                    if (fd.exists()) {
                        break;
                    }
                }
                catch (NullPointerException ex) {
                    // empty catch block
                }
                fd = null;
                int i = locValue.lastIndexOf(95);
                if (i > 0) {
                    locValue = locValue.substring(0, i);
                    continue;
                }
                sw = false;
            }
        }
        if (fd == null) {
            locValue = defaultHelpLocale;
        }
        return locValue;
    }

    public static URL getHelpUrl(String helpName) throws MalformedURLException {
        URL url = null;
        if (helpLocale.equals(defaultHelpLocale)) {
            URLClassLoader urlCL = Util.getClassLoader();
            if (urlCL != null) {
                url = urlCL.findResource(helpLoc + helpName);
            } else {
                url = new URL("file:" + helpLoc + helpName);
            }
        } else {
            url = new URL("file:" + helpLoc + helpName);
        }
        return url;
    }
}

