/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.common;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.wbemservices.wbem.apps.common.Constants;
import org.wbemservices.wbem.apps.common.Constraints;
import org.wbemservices.wbem.apps.common.FlowArea;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.Util;

public class ErrorDialog {
    private JDialog dialog;
    private String title = I18N.loadString("TTL_ERROR", "org.wbemservices.wbem.apps.common.common");
    private static final ImageIcon errorIcon = Util.loadImageIcon("log-error.gif");
    private static final ImageIcon infoIcon = Util.loadImageIcon("log-info.gif");
    private JButton cancelBtn = new JButton(I18N.loadString("LBL_OK", "org.wbemservices.wbem.apps.common.common"));
    private static final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

    public ErrorDialog(JFrame parent, String errorMessage) {
        this.createErrorDialog(parent, this.title, errorMessage, false);
    }

    public ErrorDialog(JFrame parent, String title, String errorMessage) {
        this.createErrorDialog(parent, title, errorMessage, false);
    }

    public ErrorDialog(JFrame parent, String title, String errorMessage, boolean infoDlg) {
        this.createErrorDialog(parent, title, errorMessage, infoDlg);
    }

    private void createErrorDialog(JFrame parent, String title, String errorMessage, boolean infoDlg) {
        this.dialog = new JDialog(parent, title, true);
        GridBagLayout bag = new GridBagLayout();
        JPanel errorPanel = new JPanel();
        errorPanel.setLayout(bag);
        SpecialKeyListener specialKeyListener = new SpecialKeyListener();
        this.dialog.addKeyListener(specialKeyListener);
        JPanel iconPanel = new JPanel();
        iconPanel.setLayout(bag);
        Constraints.constrain(errorPanel, iconPanel, 0, 0, 1, 2, 3, 17, 0.0, 1.0, 5, 5, 5, 0);
        JLabel iconLbl = this.getIconLabel(infoDlg);
        Constraints.constrain(iconPanel, iconLbl, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 5, 5);
        JPanel invisiblePanel = new JPanel();
        Constraints.constrain(iconPanel, invisiblePanel, 0, 1, 1, 1, 3, 17, 0.0, 1.0, 0, 0, 0, 0);
        JPanel flowPanel = new JPanel();
        flowPanel.setLayout(bag);
        Constraints.constrain(errorPanel, flowPanel, 1, 0, 1, 1, 1, 17, 1.0, 1.0, 0, 0, 0, 0);
        FlowArea flowArea = new FlowArea(errorMessage, 30, Constants.ERROR_DIALOG_FONT);
        flowArea.setSize(flowArea.getPreferredSize());
        Constraints.constrain(flowPanel, flowArea, 0, 0, 1, 1, 1, 17, 1.0, 1.0, 20, 10, 20, 20);
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(bag);
        Constraints.constrain(errorPanel, btnPanel, 1, 1, 1, 1, 2, 17, 1.0, 0.0, 5, 5, 5, 5);
        invisiblePanel = new JPanel();
        Constraints.constrain(btnPanel, invisiblePanel, 0, 0, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
        this.cancelBtn.addActionListener(new CancelBtnListener());
        Constraints.constrain(btnPanel, this.cancelBtn, 1, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 5, 5);
        this.dialog.getContentPane().setLayout(bag);
        Constraints.constrain(this.dialog.getContentPane(), errorPanel, 0, 0, 1, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        this.dialog.pack();
        this.dialog.setResizable(false);
        this.centerDialog();
        this.cancelBtn.requestFocus();
        this.dialog.setVisible(true);
    }

    private JLabel getIconLabel(boolean infoDlg) {
        JLabel iconLbl = infoDlg ? new JLabel(infoIcon) : new JLabel(errorIcon);
        return iconLbl;
    }

    public void centerDialog() {
        this.dialog.setLocation(ErrorDialog.screenSize.width / 2 - this.dialog.getSize().width / 2, ErrorDialog.screenSize.height / 2 - this.dialog.getSize().height / 2);
    }

    protected class SpecialKeyListener
    extends KeyAdapter {
        protected SpecialKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                ErrorDialog.this.cancelBtn.doClick();
            } else if (e.getKeyCode() == 27) {
                ErrorDialog.this.dialog.dispose();
            }
        }
    }

    protected class CancelBtnListener
    implements ActionListener {
        protected CancelBtnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ErrorDialog.this.dialog.dispose();
        }
    }
}

