/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.common;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.LAYOUT_ALIGNMENT;
import org.wbemservices.wbem.apps.common.LinkEvent;
import org.wbemservices.wbem.apps.common.RowLayout;
import org.wbemservices.wbem.apps.common.TwoStateButton;
import org.wbemservices.wbem.apps.common.Util;

public class GenInfoPanel
extends JPanel {
    public static final int MAIN_WINDOW = 0;
    public static final int PROPERTY_DIALOG = 1;
    private InfoBar infoBar;
    private JButton infoButton;
    private JEditorPane editorPane;
    private JScrollPane infoScroller;
    JPanel infoP = this;

    public GenInfoPanel(String title, int type) {
        this(title, type, null);
    }

    public GenInfoPanel(String title, int type, ActionListener hideButtonListener) {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.infoBar = new InfoBar(title, type, hideButtonListener);
        this.add("North", this.infoBar);
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        this.editorPane.addHyperlinkListener(new LinkEvent(this.editorPane));
        this.infoScroller = new JScrollPane(this.editorPane);
        this.add("Center", this.infoScroller);
    }

    public void setUrl(URL url) {
        try {
            this.editorPane.setPage(url);
        }
        catch (MalformedURLException e) {
            System.out.println("Malformed URL: " + e);
        }
        catch (IOException e) {
            System.out.println("IOException: " + e);
        }
    }

    public void setTitle(String s) {
        this.infoBar.setTitleText(s);
    }

    public JButton getInfoButton() {
        return this.infoButton;
    }

    public void hideInfoPanel(boolean hide) {
        this.infoBar.setState(hide);
        if (hide) {
            this.remove(this.infoScroller);
            this.setBackground(new Color(204, 204, 204));
        } else {
            this.add("Center", this.infoScroller);
            this.setBackground(Color.white);
        }
    }

    public void setFocusListener(FocusListener l, boolean force) {
        if (this.infoBar.getHideButton() != null) {
            this.infoBar.getHideButton().addFocusListener(l);
        }
        this.infoBar.getTitleLabel().addMouseListener(new LabelFocusListener(l));
        if (force) {
            if (this.infoBar.getHideButton() != null) {
                this.infoBar.getHideButton().requestFocus();
            } else {
                this.editorPane.requestFocus();
            }
        }
    }

    public JButton getHideButton() {
        return this.infoBar.getHideButton();
    }

    class InfoBar
    extends JPanel {
        private ImageIcon infoIcon;
        private JLabel titleLabel;
        protected TwoStateButton hide = null;

        public InfoBar(String title, int type, ActionListener listener) {
            this.setLayout(new BorderLayout());
            JPanel titleArea = new JPanel();
            titleArea.setLayout(new RowLayout(LAYOUT_ALIGNMENT.EXPAND));
            JLabel icon = null;
            if (type == 1) {
                this.infoIcon = Util.loadImageIcon("i_small.gif", "InfoGif");
                this.hide = new TwoStateButton(this.infoIcon);
                this.hide.setPreferredSize(new Dimension(this.infoIcon.getIconWidth() + 10, this.infoIcon.getIconHeight() + 10));
                this.hide.setState(true);
                this.hide.setActionCommand("infopanel");
                this.hide.setToolTipText(I18N.loadString("TIP_HIDE_HELP", "org.wbemservices.wbem.apps.common.common"));
                if (listener != null) {
                    this.hide.addActionListener(listener);
                }
            } else if (type == 0) {
                icon = new JLabel(this.infoIcon);
                icon.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 0));
            }
            this.titleLabel = new JLabel(title);
            this.titleLabel.setFont(new Font("dialog", 1, 12));
            if (type == 1) {
                Dimension psize = new Dimension(135, this.titleLabel.getPreferredSize().height);
                this.titleLabel.setPreferredSize(psize);
                this.titleLabel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(204, 204, 255)));
            } else if (type == 0) {
                this.titleLabel.setForeground(Color.black);
            }
            if (this.hide != null) {
                titleArea.add(this.hide);
            }
            if (icon != null) {
                titleArea.add(icon);
            }
            titleArea.setBackground(Color.white);
            titleArea.add(this.titleLabel);
            this.add("West", titleArea);
            this.setBackground(Color.white);
            if (type == 0) {
                JButton topics = new JButton(I18N.loadString("LBL_CONTEXT_HELP", "org.wbemservices.wbem.apps.common.common"));
                topics.setMargin(new Insets(0, 0, 0, 0));
                topics.setActionCommand("help topics");
                topics.addActionListener(listener);
                this.add("East", topics);
                MatteBorder outer = BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(204, 204, 255));
                Border inner = BorderFactory.createEmptyBorder(2, 0, 2, 50);
                this.setBorder(BorderFactory.createCompoundBorder(outer, inner));
            } else if (type == 1) {
                this.setBorder(BorderFactory.createEmptyBorder(3, 5, 0, 5));
            }
        }

        public void setState(boolean collapsed) {
            if (collapsed) {
                this.hide.setState(true);
                this.hide.setBorder(BorderFactory.createRaisedBevelBorder());
                this.hide.setBorderPainted(true);
                this.hide.setToolTipText(I18N.loadString("TIP_SHOW_HELP", "org.wbemservices.wbem.apps.common.common"));
                this.remove(this.titleLabel);
                this.setBackground(new Color(204, 204, 204));
            } else {
                this.setBackground(Color.white);
                this.hide.setBorder(BorderFactory.createLoweredBevelBorder());
                this.hide.setState(true);
                this.hide.setToolTipText(I18N.loadString("TIP_HIDE_HELP", "org.wbemservices.wbem.apps.common.common"));
                this.add(this.titleLabel);
            }
        }

        public void setTitleText(String s) {
            this.titleLabel.setText(s);
        }

        public JButton getHideButton() {
            return this.hide;
        }

        public JLabel getTitleLabel() {
            return this.titleLabel;
        }
    }

    class LabelFocusListener
    extends MouseAdapter {
        private FocusListener listener;

        public LabelFocusListener(FocusListener l) {
            this.listener = l;
        }

        public void mousePressed(MouseEvent event) {
            if (GenInfoPanel.this.infoBar.getHideButton() != null) {
                GenInfoPanel.this.infoBar.getHideButton().requestFocus();
            } else {
                GenInfoPanel.this.editorPane.requestFocus();
            }
        }
    }
}

