/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.common;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.wbemservices.wbem.apps.common.JSpinBox;

public class JIntSpinBox
extends JSpinBox {
    private static final Dimension MIN_SIZE = new Dimension(34, 17);
    private JSpinBox spinBox = this;
    public int floor;
    public int ceiling;
    public int increment = 1;
    private boolean bDoubleAught = false;

    public JIntSpinBox(int cols, int floor, int ceiling) {
        this(cols, floor, ceiling, 1);
    }

    public JIntSpinBox(int cols, int floor, int ceiling, int increment) {
        super(cols);
        this.spinBox.setMinimumSize(MIN_SIZE);
        this.setIncrement(increment);
        this.addListeners(floor, ceiling);
    }

    private void addListeners(int f, int c) {
        this.spinBox.getUpButton().addActionListener(new UpBtnListener());
        this.spinBox.getDownButton().addActionListener(new DownBtnListener());
        this.floor = f;
        this.ceiling = c;
        this.spinBox.getTextField().setDocument(new IntOnlyDocument());
    }

    public int getFloor() {
        if (this.floor == 0 && this.getDoubleAught()) {
            Integer i = new Integer(0);
            return i;
        }
        return this.floor;
    }

    public void setFloor(int f) {
        this.floor = f;
    }

    public int getCeiling() {
        if (this.ceiling == 0 && this.getDoubleAught()) {
            Integer i = new Integer(0);
            return i;
        }
        return this.ceiling;
    }

    public void setCeiling(int c) {
        this.ceiling = c;
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setIncrement(int i) {
        this.increment = i;
    }

    public synchronized int getIntValue() {
        Integer integer;
        if (this.getStringValue().equals("")) {
            return 0;
        }
        try {
            integer = new Integer(this.getStringValue());
        }
        catch (NumberFormatException nfe) {
            return this.increment;
        }
        return integer;
    }

    public void setIntValue(int i) {
        int val = i;
        if (this.getDoubleAught() && val == 0) {
            this.spinBox.getTextField().setText("00");
        } else {
            if (val < this.floor) {
                val = this.floor;
            } else if (val > this.ceiling) {
                val = this.ceiling;
            }
            this.spinBox.getTextField().setText(Integer.toString(val));
        }
    }

    public synchronized String getStringValue() {
        return this.spinBox.getTextField().getText();
    }

    public void removeValue() {
        this.spinBox.getTextField().setText("");
    }

    public void setEnabled(boolean enabled) {
        this.spinBox.getUpButton().setEnabled(enabled);
        this.spinBox.getDownButton().setEnabled(enabled);
        this.spinBox.getTextField().setEnabled(enabled);
    }

    public void setDoubleAught(boolean bDoubleAught) {
        this.bDoubleAught = bDoubleAught;
    }

    public boolean getDoubleAught() {
        return this.bDoubleAught;
    }

    private synchronized void doUp() {
        if (this.getStringValue().equals("")) {
            Integer newInteger = new Integer(this.getFloor());
            this.setIntValue(newInteger);
        } else {
            Integer newInteger = new Integer(this.getIntValue() + this.getIncrement());
            if (newInteger <= this.getCeiling()) {
                if (newInteger < this.getFloor()) {
                    this.setIntValue(this.getFloor());
                } else {
                    this.setIntValue(newInteger);
                }
                if (!this.spinBox.isWrapping() && newInteger.intValue() == this.getCeiling()) {
                    this.spinBox.getUpButton().setEnabled(false);
                }
                if (!this.spinBox.getDownButton().isEnabled()) {
                    this.spinBox.getDownButton().setEnabled(true);
                }
            } else if (this.spinBox.isWrapping()) {
                newInteger = new Integer(this.getFloor());
                this.setIntValue(newInteger);
            } else {
                this.spinBox.getUpButton().setEnabled(false);
                this.spinBox.toolkit.beep();
                return;
            }
        }
    }

    private synchronized void doDown() {
        if (this.getStringValue().equals("")) {
            Integer newInteger = new Integer(this.getCeiling());
            this.setIntValue(newInteger);
        } else {
            Integer newInteger = new Integer(this.getIntValue() - this.getIncrement());
            if (newInteger >= this.getFloor()) {
                this.setIntValue(newInteger);
                if (!this.spinBox.isWrapping() && newInteger.intValue() == this.getFloor()) {
                    this.spinBox.getUpButton().setEnabled(false);
                }
                if (!this.spinBox.getUpButton().isEnabled()) {
                    this.spinBox.getUpButton().setEnabled(true);
                }
            } else if (this.spinBox.isWrapping()) {
                newInteger = new Integer(this.getCeiling());
                this.setIntValue(newInteger);
            } else {
                this.spinBox.getDownButton().setEnabled(false);
                this.spinBox.toolkit.beep();
                return;
            }
        }
    }

    public class DownBtnListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            JIntSpinBox.this.doDown();
        }
    }

    public class UpBtnListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            JIntSpinBox.this.doUp();
        }
    }

    public class IntOnlyDocument
    extends PlainDocument {
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            for (int i = 0; i < result.length; ++i) {
                if (!(Character.isDigit(source[i]) || i == 0 && source[i] == '-' && JIntSpinBox.this.floor < 0)) {
                    ((JIntSpinBox)JIntSpinBox.this).spinBox.toolkit.beep();
                    return;
                }
                result[j++] = source[i];
            }
            String newVal = JIntSpinBox.this.getStringValue().substring(0, offs);
            newVal = newVal + new String(result, 0, j);
            if ((newVal = newVal + JIntSpinBox.this.getStringValue().substring(offs)).length() > 0) {
                if (newVal.equals("-") && j == 1) {
                    super.insertString(offs, new String(result, 0, j), a);
                } else {
                    Integer newInteger;
                    try {
                        newInteger = new Integer(newVal);
                    }
                    catch (NumberFormatException nfe) {
                        ((JIntSpinBox)JIntSpinBox.this).spinBox.toolkit.beep();
                        return;
                    }
                    int newInt = newInteger;
                    if (newInt <= JIntSpinBox.this.getCeiling()) {
                        super.insertString(offs, new String(result, 0, j), a);
                        if (!JIntSpinBox.this.spinBox.isWrapping() && JIntSpinBox.this.spinBox.isEditable()) {
                            if (newInt < JIntSpinBox.this.getCeiling() && !JIntSpinBox.this.spinBox.getUpButton().isEnabled()) {
                                JIntSpinBox.this.spinBox.getUpButton().setEnabled(true);
                            } else if (newInt > JIntSpinBox.this.getFloor() && !JIntSpinBox.this.spinBox.getDownButton().isEnabled()) {
                                JIntSpinBox.this.spinBox.getDownButton().setEnabled(true);
                            }
                        }
                    } else {
                        super.insertString(offs, null, a);
                    }
                }
            }
        }
    }
}

