/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.common;

import java.awt.Frame;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.EventListenerList;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.AdminDialog;
import org.wbemservices.wbem.apps.common.ButtonPanel;
import org.wbemservices.wbem.apps.common.CIMClientObject;
import org.wbemservices.wbem.apps.common.CIMErrorDialog;
import org.wbemservices.wbem.apps.common.ColumnLayout;
import org.wbemservices.wbem.apps.common.ContextHelpListener;
import org.wbemservices.wbem.apps.common.GenInfoPanel;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.LAYOUT_ALIGNMENT;
import org.wbemservices.wbem.apps.common.Util;

public class NameSpaceDialog
extends AdminDialog
implements ItemSelectable {
    private JButton btnOK;
    private JButton btnCancel;
    private JButton btnAddNS;
    private JButton btnDeleteNS;
    private String selectedNameSpace;
    private EventListenerList listenerList;
    protected GenInfoPanel infoPanel = this.getInfoPanel();
    protected JList list;
    protected DefaultListModel listModel;
    protected static CIMClient cimClient;
    protected AdminDialog thisDialog = this;
    protected CIMObjectPath currentNameSpace = new CIMObjectPath("", CIMClientObject.getNameSpace());
    protected JScrollPane scrollList;
    protected int cellWidth = 5;
    private static final int NOT_FOUND = -1;
    private static final int CIM_NAMESPACE = 0;
    private static final int __NAMESPACE = 1;
    private static int foundClassName;
    static /* synthetic */ Class class$java$awt$event$ItemListener;

    public NameSpaceDialog(Frame parent) {
        super(parent, I18N.loadString("TTL_CHANGE_NAMESPACE"), false);
        this.listenerList = new EventListenerList();
        this.btnOK = this.getOKBtn();
        this.btnOK.addActionListener(new OKCancelButtonListener());
        this.btnCancel = this.getCancelBtn();
        this.btnCancel.addActionListener(new OKCancelButtonListener());
        JPanel mainPanel = this.getRightPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        JPanel centerPanel = new JPanel(new ColumnLayout(LAYOUT_ALIGNMENT.EXPAND));
        centerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.getSelectionModel().setSelectionMode(0);
        ActionString asNameSpace = new ActionString("LBL_NAMESPACE");
        JLabel lNameSpace = new JLabel(asNameSpace.getString());
        lNameSpace.setDisplayedMnemonic(asNameSpace.getMnemonic());
        lNameSpace.setLabelFor(this.list);
        this.scrollList = new JScrollPane(this.list);
        this.scrollList.setPreferredSize(this.scrollList.getPreferredSize());
        centerPanel.add(lNameSpace);
        centerPanel.add(this.scrollList);
        ActionString asAdd = new ActionString("LBL_ADD");
        ActionString asDelete = new ActionString("LBL_DELETE");
        ButtonPanel bPanel = new ButtonPanel();
        this.btnAddNS = new JButton(asAdd.getString());
        this.btnAddNS.setMnemonic(asAdd.getMnemonic());
        this.btnAddNS.addActionListener(new NSButtonListener());
        this.btnDeleteNS = new JButton(asDelete.getString());
        this.btnDeleteNS.setMnemonic(asDelete.getMnemonic());
        this.btnDeleteNS.addActionListener(new NSButtonListener());
        bPanel.add(this.btnAddNS);
        bPanel.add(this.btnDeleteNS);
        centerPanel.add(bPanel);
        mainPanel.add(centerPanel);
        this.setDefaultFocusListener(new ContextHelpListener(this.infoPanel, "cimadmin", "namsp_000.htm"), true);
        this.pack();
        Util.positionWindow(this, parent);
    }

    public void okClicked() {
        int i = this.list.getSelectedIndex();
        CIMObjectPath opNameSpace = i < 0 ? this.currentNameSpace : (CIMObjectPath)this.listModel.elementAt(this.list.getSelectedIndex());
        this.selectedNameSpace = opNameSpace.getNameSpace();
        this.fireItemEvent(new ItemEvent(this, 0, "select name space", 701));
    }

    public void cancelClicked() {
        this.selectedNameSpace = null;
        this.setVisible(false);
        this.fireItemEvent(new ItemEvent(this, 0, "dialog cancel", 701));
    }

    public String getSelectedNameSpace() {
        return this.selectedNameSpace;
    }

    public Object[] getSelectedObjects() {
        Object[] val = new String[1];
        return val;
    }

    public void addItemListener(ItemListener listener) {
        this.listenerList.add(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = NameSpaceDialog.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, listener);
    }

    public void removeItemListener(ItemListener listener) {
        this.listenerList.remove(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = NameSpaceDialog.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, listener);
    }

    protected void fireItemEvent(ItemEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$java$awt$event$ItemListener == null ? NameSpaceDialog.class$("java.awt.event.ItemListener") : class$java$awt$event$ItemListener)) continue;
            ((ItemListener)listeners[i + 1]).itemStateChanged(evt);
        }
    }

    public void windowOpened(WindowEvent evt) {
        super.windowOpened(evt);
        this.refreshList();
        this.list.setSelectedValue(this.currentNameSpace, true);
        this.list.requestFocus();
    }

    private void refreshList() {
        Util.setWaitCursor(this);
        this.listModel.removeAllElements();
        Enumeration e = NameSpaceDialog.getAllNameSpaces();
        while (e.hasMoreElements()) {
            CIMObjectPath nextNS = (CIMObjectPath)e.nextElement();
            this.cellWidth = Math.max(this.cellWidth, nextNS.toString().length());
            this.listModel.addElement(nextNS);
        }
        this.btnDeleteNS.setEnabled(this.listModel.size() > 0);
        this.setCellWidth();
        Util.setDefaultCursor(this);
    }

    private void setCellWidth() {
        String proto = "";
        for (int i = 0; i < this.cellWidth; ++i) {
            proto = proto + "A";
        }
        this.list.setPrototypeCellValue(proto);
    }

    private void setCellWidth(String s) {
        this.cellWidth = Math.max(this.cellWidth, s.length());
        this.setCellWidth();
    }

    public static Enumeration getAllNameSpaces() {
        Enumeration enumeration = null;
        CIMObjectPath op = new CIMObjectPath();
        if (foundClassName == -1 || foundClassName == 0) {
            CIMClient interopClient = CIMClientObject.createInteropClient();
            op.setObjectName("CIM_Namespace");
            try {
                enumeration = interopClient.enumerateInstanceNames(op);
                foundClassName = enumeration.hasMoreElements() ? 0 : -1;
            }
            catch (CIMException exc) {
                foundClassName = -1;
            }
            if (interopClient != null) {
                try {
                    interopClient.close();
                }
                catch (CIMException exc) {
                    // empty catch block
                }
            }
        }
        if (foundClassName == -1 || foundClassName == 1) {
            op.setObjectName("__Namespace");
            CIMClient rootClient = CIMClientObject.changeNameSpace("root");
            try {
                enumeration = rootClient.enumerateInstanceNames(op);
                foundClassName = enumeration.hasMoreElements() ? 1 : -1;
            }
            catch (CIMException exc) {
                foundClassName = -1;
            }
            if (rootClient != null) {
                try {
                    rootClient.close();
                }
                catch (CIMException exc) {
                    // empty catch block
                }
            }
        }
        Vector<CIMObjectPath> v = new Vector<CIMObjectPath>();
        if (enumeration != null && foundClassName != -1) {
            block8: while (enumeration.hasMoreElements()) {
                CIMObjectPath opNS = (CIMObjectPath)enumeration.nextElement();
                if (foundClassName == 0) {
                    Enumeration keyEnum = opNS.getKeys().elements();
                    while (keyEnum.hasMoreElements()) {
                        CIMProperty keyProp = (CIMProperty)keyEnum.nextElement();
                        if (!keyProp.getName().equalsIgnoreCase("Name") || keyProp.getValue() == null) continue;
                        CIMObjectPath newOP = new CIMObjectPath();
                        newOP.setNameSpace((String)keyProp.getValue().getValue());
                        v.add(newOP);
                        continue block8;
                    }
                    continue;
                }
                CIMObjectPath newOP = new CIMObjectPath();
                newOP.setNameSpace("root\\" + opNS.getNameSpace());
                v.add(newOP);
            }
        }
        return v.elements();
    }

    private boolean createNameSpace(String nameSpace) {
        boolean ret = false;
        CIMClient newCIMClient = null;
        try {
            switch (foundClassName) {
                case 1: {
                    newCIMClient = CIMClientObject.changeNameSpace("root");
                    Vector<CIMProperty> v = new Vector<CIMProperty>();
                    CIMProperty prop = new CIMProperty("NameSpace");
                    prop.setValue(new CIMValue((Object)nameSpace));
                    v.addElement(prop);
                    CIMInstance ci = new CIMInstance();
                    ci.setClassName("__Namespace");
                    ci.setProperties(v);
                    newCIMClient.createInstance(new CIMObjectPath(), ci);
                    ret = true;
                    break;
                }
                default: {
                    newCIMClient = CIMClientObject.createInteropClient();
                    CIMClass cClass = newCIMClient.getClass(new CIMObjectPath("CIM_Namespace"));
                    CIMInstance cInst = cClass.newInstance();
                    cInst.setProperty("Name", new CIMValue((Object)nameSpace));
                    newCIMClient.createInstance(new CIMObjectPath(), cInst);
                    ret = true;
                    break;
                }
            }
        }
        catch (CIMException exc) {
            if (exc.getID().equals("XMLERROR")) {
                ret = true;
            }
            CIMErrorDialog.display(null, exc);
        }
        if (newCIMClient != null) {
            try {
                newCIMClient.close();
            }
            catch (CIMException exc) {
                // empty catch block
            }
        }
        return ret;
    }

    private boolean deleteNameSpace(String namespace) {
        CIMClient newCIMClient = null;
        boolean ret = false;
        try {
            switch (foundClassName) {
                case 1: {
                    newCIMClient = CIMClientObject.changeNameSpace("root");
                    Vector<CIMProperty> v = new Vector<CIMProperty>();
                    CIMProperty prop = new CIMProperty("NameSpace");
                    prop.setValue(new CIMValue((Object)namespace));
                    v.addElement(prop);
                    CIMObjectPath op = new CIMObjectPath("__Namespace", v);
                    newCIMClient.deleteInstance(op);
                    ret = true;
                    break;
                }
                default: {
                    newCIMClient = CIMClientObject.createInteropClient();
                    Enumeration enumeration = newCIMClient.enumerateInstanceNames(new CIMObjectPath("CIM_NameSpace"));
                    while (enumeration.hasMoreElements()) {
                        CIMObjectPath opInst = (CIMObjectPath)enumeration.nextElement();
                        Enumeration keyEnum = opInst.getKeys().elements();
                        while (keyEnum.hasMoreElements()) {
                            CIMProperty keyProp = (CIMProperty)keyEnum.nextElement();
                            if (!keyProp.getName().equalsIgnoreCase("Name") || keyProp.getValue() == null || !namespace.equalsIgnoreCase((String)keyProp.getValue().getValue())) continue;
                            newCIMClient.deleteInstance(opInst);
                            ret = true;
                        }
                    }
                    break;
                }
            }
        }
        catch (CIMException exc) {
            CIMErrorDialog.display(null, exc);
        }
        if (newCIMClient != null) {
            try {
                newCIMClient.close();
            }
            catch (CIMException exc) {
                // empty catch block
            }
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        foundClassName = -1;
    }

    class NSButtonListener
    implements ActionListener {
        NSButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == NameSpaceDialog.this.btnAddNS) {
                String newNS = JOptionPane.showInputDialog(NameSpaceDialog.this.thisDialog, I18N.loadString("ASK_CREATE_NAMESPACE"), I18N.loadString("TTL_NEW_NAMESPACE"), -1);
                if (newNS != null && !newNS.equals("") && NameSpaceDialog.this.createNameSpace(newNS = Util.cleanNameSpaceString(newNS))) {
                    NameSpaceDialog.this.listModel.addElement(new CIMObjectPath("", newNS));
                    NameSpaceDialog.this.setCellWidth(newNS);
                }
            } else if (e.getSource() == NameSpaceDialog.this.btnDeleteNS) {
                int selectedIndex = NameSpaceDialog.this.list.getSelectedIndex();
                if (selectedIndex < 0) {
                    JOptionPane.showMessageDialog(NameSpaceDialog.this.thisDialog, I18N.loadString("ERR_NO_NAMESPACE_SELECTED"), I18N.loadString("TTL_CIM_ERROR"), 0);
                } else {
                    CIMObjectPath op = (CIMObjectPath)NameSpaceDialog.this.listModel.elementAt(selectedIndex);
                    if (op.getNameSpace().equalsIgnoreCase(NameSpaceDialog.this.currentNameSpace.getNameSpace())) {
                        JOptionPane.showMessageDialog(NameSpaceDialog.this.thisDialog, I18N.loadString("ERR_CURRENT_NAMESPACE"), I18N.loadString("TTL_CIM_ERROR"), 1);
                    } else {
                        String selectedNS = op.getNameSpace();
                        int option = JOptionPane.showConfirmDialog(NameSpaceDialog.this.thisDialog, I18N.loadStringFormat("ASK_DELETE_NAMESPACE", selectedNS), I18N.loadString("TTL_DLG_CIM_WORKSHOP"), 2, 3);
                        if (option == 0 && NameSpaceDialog.this.deleteNameSpace(selectedNS)) {
                            NameSpaceDialog.this.listModel.removeElement(op);
                            if (selectedIndex > 0) {
                                --selectedIndex;
                            } else if (selectedIndex >= NameSpaceDialog.this.listModel.size()) {
                                selectedIndex = NameSpaceDialog.this.listModel.size() - 1;
                            }
                            NameSpaceDialog.this.list.setSelectedIndex(selectedIndex);
                        }
                    }
                }
            }
        }
    }

    class OKCancelButtonListener
    implements ActionListener {
        OKCancelButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == NameSpaceDialog.this.btnCancel) {
                NameSpaceDialog.this.cancelClicked();
            } else if (e.getSource() == NameSpaceDialog.this.btnOK) {
                NameSpaceDialog.this.okClicked();
            }
        }
    }
}

